/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.ptis.web.controller.rest.RevisionPetitionAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/rv")
public class RevisionPetitionRestService {
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    String USER_NAME = "mahesh";
    String PASSWORD = "demo";
    String LOGIN_USERID = "16";

    @RequestMapping(value={"/restrevisionPetition/{applicationNumber}"}, method={RequestMethod.GET}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public String getRevisionPetitionDetails(@PathVariable(value="applicationNumber") String appNumber) throws IOException {
        RevisionPetition revisionPetition = this.revisionPetitionService.getRevisionPetitionByApplicationNumber(appNumber);
        if (revisionPetition != null) {
            return this.convertRevisionPetitionObjectToJson((Object)revisionPetition);
        }
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-21");
        errorDetails.setErrorMessage("Invalid Revision petition number.");
        return this.getJSONResponse((Object)errorDetails);
    }

    @RequestMapping(value={"/restrevisionPetition/createRevisionPetition"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createRevisionPetitionFromRest(@RequestParam String accessmentnumber, @RequestParam String username, @RequestParam String password, @RequestParam String details, @RequestParam String receivedon, @RequestParam String recievedBy) throws IOException {
        String responseJson = new String();
        Boolean isAuthenticatedUser = this.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            ApplicationThreadLocals.setUserId((Long)Long.valueOf(this.LOGIN_USERID));
            ErrorDetails errorDetails = this.validateRevisionPetitionForm(accessmentnumber, details, receivedon, recievedBy);
            if (null != errorDetails) {
                responseJson = this.getJSONResponse((Object)errorDetails);
            } else {
                try {
                    BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(accessmentnumber);
                    if (basicProperty != null && basicProperty.isUnderWorkflow()) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("PTIS-REST-20");
                        errorDetails.setErrorMessage("Selected property can not be objected,the property is in objected state or the property is in a different workflow");
                        return this.getJSONResponse((Object)errorDetails);
                    }
                    RevisionPetition revPetition = new RevisionPetition();
                    revPetition.setBasicProperty(basicProperty);
                    revPetition.setRecievedBy(recievedBy);
                    revPetition.setDetails(details);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                    revPetition.setRecievedOn(sdf.parse(receivedon));
                    responseJson = this.convertRevisionPetitionObjectToJson((Object)this.revisionPetitionService.createRevisionPetitionForRest(revPetition));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return responseJson;
    }

    private ErrorDetails validateRevisionPetitionForm(String accessmentnumber, String details, String receivedon, String recievedBy) {
        ErrorDetails errorDetails = null;
        if (accessmentnumber == null || accessmentnumber.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (accessmentnumber.trim().length() > 0 && accessmentnumber.trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(accessmentnumber).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
        }
        if (receivedon == null || receivedon.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-17");
            errorDetails.setErrorMessage("Revision petition received date required");
        } else if (recievedBy == null || recievedBy.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-18");
            errorDetails.setErrorMessage("Revision petition received user details required");
        } else if (details == null || details.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-19");
            errorDetails.setErrorMessage("Revision petition details are required");
        }
        return errorDetails;
    }

    private String convertRevisionPetitionObjectToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(RevisionPetition.class, (Object)new RevisionPetitionAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private String getJSONResponse(Object obj) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username != null && password != null && username.equals(this.USER_NAME) && password.equals(this.PASSWORD)) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }
}

