/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.rest;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.DrainageEnum;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.LocalityDetails;
import org.egov.ptis.domain.model.MasterCodeNamePairDetails;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AssessmentServiceController {
    @Autowired
    private PropertyExternalService propertyExternalService;

    @RequestMapping(value={"/rest/property/{assessmentNumber}"}, produces={"application/json"})
    public AssessmentDetails getAssessmentDetails(@PathVariable String assessmentNumber) throws IOException {
        return this.propertyExternalService.loadAssessmentDetails(assessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
    }

    @RequestMapping(value={"/property/propertyTaxDetails"}, method={RequestMethod.POST}, produces={"application/json"})
    public String getPropertyTaxDetails(@RequestParam String assessmentNo, @RequestParam String username, @RequestParam String password) throws IOException {
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNo, null);
        } else {
            ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
            propertyTaxDetails.setErrorDetails(errorDetails);
        }
        return this.getJSONResponse((Object)propertyTaxDetails);
    }

    @RequestMapping(value={"/property/propertyTaxDetailsByBoundary"}, method={RequestMethod.POST}, produces={"application/json"})
    public String getPropertyTaxDetails(@RequestParam String circleName, @RequestParam String zoneName, @RequestParam String wardName, @RequestParam String blockName, @RequestParam String ownerName, @RequestParam String doorNo, @RequestParam String aadhaarNumber, @RequestParam String mobileNumber, @RequestParam String username, @RequestParam String password) throws IOException {
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            return this.getJSONResponse((Object)this.propertyExternalService.getPropertyTaxDetails(circleName, zoneName, wardName, blockName, ownerName, doorNo, aadhaarNumber, mobileNumber));
        }
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
        propertyTaxDetails.setErrorDetails(errorDetails);
        return this.getJSONResponse((Object)propertyTaxDetails);
    }

    @RequestMapping(value={"/property/payPropertyTax"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public String payPropertyTax(@RequestParam String assessmentNo, @RequestParam String paymentMode, @RequestParam BigDecimal totalAmount, @RequestParam String paidBy, @RequestParam String username, @RequestParam String password) throws IOException {
        String responseJson = new String();
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            ErrorDetails errorDetails = this.propertyExternalService.validatePaymentDetails(assessmentNo, paymentMode, totalAmount, paidBy);
            if (null != errorDetails) {
                responseJson = this.getJSONResponse((Object)errorDetails);
            } else {
                PayPropertyTaxDetails pt = new PayPropertyTaxDetails();
                pt.setAssessmentNo(assessmentNo);
                pt.setPaymentMode(paymentMode);
                pt.setPaymentAmount(totalAmount);
                pt.setPaidBy(paidBy);
                ReceiptDetails receiptDetails = this.propertyExternalService.payPropertyTax(pt, "");
                responseJson = this.getJSONResponse((Object)receiptDetails);
            }
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/payWaterTax"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public String payWateTax(@RequestParam String consumerNo, @RequestParam String paymentMode, @RequestParam BigDecimal totalAmount, @RequestParam String paidBy) throws IOException {
        ErrorDetails errorDetails = this.propertyExternalService.validatePaymentDetails(consumerNo, paymentMode, totalAmount, paidBy);
        if (null != errorDetails) {
            return this.getJSONResponse((Object)errorDetails);
        }
        errorDetails = this.propertyExternalService.payWaterTax(consumerNo, paymentMode, totalAmount, paidBy);
        return this.getJSONResponse((Object)errorDetails);
    }

    @RequestMapping(value={"/property/ownershipCategories"}, produces={"application/json"})
    public String getOwnershipCategories() throws IOException {
        List propTypeMasterDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            propTypeMasterDetailsList = this.propertyExternalService.getPropertyTypeMasterDetails();
            responseJson = this.getJSONResponse((Object)propTypeMasterDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/ownershipCategoryByCode/{ownershipCategoryCode}"}, produces={"application/json"})
    public String getOwnershipCategoryByCode(@PathVariable String ownershipCategoryCode) throws IOException {
        PropertyTypeMaster propertyTypeMaster = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            propertyTypeMaster = this.propertyExternalService.getPropertyTypeMasterByCode(ownershipCategoryCode);
            responseJson = this.getJSONResponse((Object)propertyTypeMaster);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/propertyTypes/{ownershipCategoryCode}"}, produces={"application/json"})
    public String getPropertyTypeCategoryDetails(@PathVariable String ownershipCategoryCode) throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getPropertyTypeCategoryDetails(ownershipCategoryCode);
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/propertyTypes"}, produces={"application/json"})
    public String getPropertyTypes() throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getPropertyTypes();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/apartments"}, produces={"application/json"})
    public String getApartmentsAndComplexes() throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getApartmentsAndComplexes();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/createPropertyReasons"}, produces={"application/json"})
    public String getCreatePropertyReasons() throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getReasonsForChangeProperty("CREATE");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/localities"}, produces={"application/json"})
    public String getLocalities() throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("locality", "LOCATION");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/zones"}, produces={"application/json"})
    public String getZones() throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("Zone", "REVENUE");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/electionWards"}, produces={"application/json"})
    public String getElectionWards() throws IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("Ward", "ADMINISTRATION");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/boundaryByLocalityCode"}, method={RequestMethod.POST}, produces={"application/json"})
    public String getBoundaryByLocalityCode(@RequestParam String localityCode, @RequestParam String username, @RequestParam String password) throws IOException {
        LocalityDetails localityDetails = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            localityDetails = this.propertyExternalService.getLocalityDetailsByLocalityCode(localityCode);
            responseJson = this.getJSONResponse((Object)localityDetails);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/enumerationBlocks"}, produces={"application/json"})
    public String getEnumerationBlocks() throws IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getEnumerationBlocks();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/floorTypes"}, produces={"application/json"})
    public String getFloorTypes() throws IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getFloorTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/roofTypes"}, produces={"application/json"})
    public String getRoofTypes() throws IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getRoofTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/wallTypes"}, produces={"application/json"})
    public String getWallTypes() throws IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getWallTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/woodTypes"}, produces={"application/json"})
    public String getWoodTypes() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getWoodTypes();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/floors"}, produces={"application/json"})
    public String getFloors() throws IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            TreeMap floorMap = PropertyTaxConstants.FLOOR_MAP;
            Set keys = floorMap.keySet();
            for (Integer key : keys) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(key.toString());
                mstrCodeNamePairDetails.setName((String)floorMap.get(key));
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/propertyClassifications"}, produces={"application/json"})
    public String getPropertyClassifications() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getBuildingClassifications();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/propertyUsages"}, produces={"application/json"})
    public String getPropertUsages() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getNatureOfUsages();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/occupancyTypes"}, produces={"application/json"})
    public String getOccupancyTypes() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getOccupancies();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/exemptionCategories"}, produces={"application/json"})
    public String getTaxExemptionCategories() throws IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getExemptionCategories();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/drainages"}, produces={"application/json"})
    public String getDrainages() throws IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            for (DrainageEnum drngEnum : DrainageEnum.values()) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(drngEnum.getCode());
                mstrCodeNamePairDetails.setName(drngEnum.name());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/documentTypes"}, produces={"application/json"})
    public String getDocumentTypes() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getDocumentTypes();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/mutationReasons"}, produces={"application/json"})
    public String getMutationReasons() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getReasonsForChangeProperty("TRANSFER");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/approverDepartments"}, produces={"application/json"})
    public String getApproverDepartments() throws IOException {
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List mstrCodeNamePairDetailsList = this.propertyExternalService.getApproverDepartments();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/wardBlockLocalityMapping"}, produces={"application/json"})
    public String getWardBlockLocalityMappings() throws IOException {
        String responseJson = "";
        ErrorDetails errorDetails = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List boundaryDetailsList = this.propertyExternalService.getWardBlockLocalityMapping();
            ArrayList<JSONObject> boundaryJsonObjs = new ArrayList<JSONObject>();
            if (!boundaryDetailsList.isEmpty()) {
                for (Object[] obj : boundaryDetailsList) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("wardNum", obj[0]);
                    jsonObject.put("wardName", obj[1]);
                    jsonObject.put("blockNum", obj[2]);
                    jsonObject.put("blockName", obj[3]);
                    jsonObject.put("localityNum", obj[4]);
                    jsonObject.put("localityName", obj[5]);
                    boundaryJsonObjs.add(jsonObject);
                }
                responseJson = this.getJSONResponse(boundaryJsonObjs);
            }
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    private String getJSONResponse(Object obj) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    private ErrorDetails getInvalidCredentialsErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-1");
        errorDetails.setErrorMessage("Invaild Credentials");
        return errorDetails;
    }
}

