/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import org.egov.demand.model.EgBill;
import org.egov.ptis.domain.service.intgdemandbill.IntgDemandBillService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/integratedDemandBill"})
public class IntegratedDemandBillController {
    @Autowired
    private IntgDemandBillService intgDemandBillService;
    private static final String INTEGRATEDDEMANDBILL_FORM = "integrateddemandbill-form";

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("egBill", (Object)new EgBill());
        return INTEGRATEDDEMANDBILL_FORM;
    }

    @RequestMapping(value={"/searchform"}, method={RequestMethod.POST})
    public String inventoryNotice(@ModelAttribute(value="egBill") EgBill egBill, Model model, BindingResult errors) {
        this.intgDemandBillService.validate(egBill, errors);
        if (errors.hasErrors()) {
            model.addAttribute("integrateddemandbill", (Object)new EgBill());
            return INTEGRATEDDEMANDBILL_FORM;
        }
        return "redirect:/integratedDemandBill/generateDemandBill/" + egBill.getConsumerId();
    }

    @RequestMapping(value={"/generateDemandBill/{assessment}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateDemandBill(Model model, @PathVariable String assessment) {
        return this.intgDemandBillService.generateIntgDemandBill(assessment);
    }
}

