/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.Iterator;
import java.util.List;
import org.egov.demand.model.EgBill;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.service.notice.RecoveryNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/distressnotice"})
public class DistressWarrantNoticeController {
    private static final String DISTRESSNOTICE_FORM = "distressnotice-form";
    @Autowired
    private RecoveryNoticeService recoveryNoticeService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("egBill", (Object)new EgBill());
        return DISTRESSNOTICE_FORM;
    }

    @RequestMapping(value={"/searchform"}, method={RequestMethod.POST})
    public String search(@ModelAttribute(value="egBill") EgBill egBill, Model model, BindingResult errors) {
        List hasErrors = this.recoveryNoticeService.validateRecoveryNotices(egBill.getConsumerId(), "Distress Notice");
        Iterator iterator = hasErrors.iterator();
        if (iterator.hasNext()) {
            String error = (String)iterator.next();
            if (error == "invalid.exempted") {
                BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(egBill.getConsumerId());
                errors.reject(error, (Object[])new String[]{basicProperty.getProperty().getTaxExemptedReason().getName()}, error);
            } else {
                errors.reject(error, error);
            }
            return DISTRESSNOTICE_FORM;
        }
        return "redirect:/distressnotice/generatenotice/" + egBill.getConsumerId();
    }

    @RequestMapping(value={"/generatenotice/{assessmentNo}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateNotice(Model model, @PathVariable String assessmentNo) {
        return this.recoveryNoticeService.generateNotice(assessmentNo, "Distress Notice");
    }
}

