/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.ptis.actions.reports.DefaultersReportHelperAdaptor;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.DefaultersInfo;
import org.egov.ptis.domain.service.report.ReportService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class DefaultersReportController {
    private static final String ONE_YEAR = "1 Year";
    private static final String TWO_YEARS = "2 Years";
    private static final String THREE_YEARS = "3 Years";
    private static final String FOUR_YEARS = "4 Years";
    private static final String FIVE_YEARS = "5 Years";
    private static final String ABOVE_FIVE_YEARS = "Above 5 Years";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    public PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private ReportService reportService;

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="limits")
    public List<Integer> limitList() {
        ArrayList<Integer> limitList = new ArrayList<Integer>();
        limitList.add(10);
        limitList.add(50);
        limitList.add(100);
        limitList.add(500);
        limitList.add(1000);
        return limitList;
    }

    @ModelAttribute(value="noofyrs")
    public List<String> noofyrsList() {
        ArrayList<String> noofyrsList = new ArrayList<String>();
        noofyrsList.add(ONE_YEAR);
        noofyrsList.add(TWO_YEARS);
        noofyrsList.add(THREE_YEARS);
        noofyrsList.add(FOUR_YEARS);
        noofyrsList.add(FIVE_YEARS);
        noofyrsList.add(ABOVE_FIVE_YEARS);
        return noofyrsList;
    }

    @ModelAttribute(value="categories")
    public Map<String, String> ownershipCategories() {
        return PropertyTaxConstants.OWNERSHIP_OF_PROPERTY_FOR_DEFAULTERS_REPORT;
    }

    @RequestMapping(value={"/defaultersReportVLT"}, method={RequestMethod.GET})
    public String searchVLTDefaultersForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("mode", (Object)"VLT");
        model.addAttribute("DefaultersReport", (Object)new DefaultersInfo());
        return "defaultersVLT-form";
    }

    @RequestMapping(value={"/defaultersReportPT"}, method={RequestMethod.GET})
    public String searchPTDefaultersForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("mode", (Object)"PT");
        model.addAttribute("DefaultersReport", (Object)new DefaultersInfo());
        return "defaultersPT-form";
    }

    @RequestMapping(value={"/defaultersReport/result"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String defaultersReportSearchResult(@RequestParam String wardId, @RequestParam String fromAmount, @RequestParam String toAmount, @RequestParam String limit, @RequestParam String category, @RequestParam String noofyr, @RequestParam String proptype, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Query query = this.propertyTaxUtil.prepareQueryforDefaultersReport(Long.valueOf(wardId), fromAmount, toAmount, StringUtils.isBlank((CharSequence)limit) ? null : Integer.valueOf(limit), category, proptype);
        List properties = query.list();
        List defaultersList = this.reportService.getDefaultersInformation(properties, noofyr, StringUtils.isBlank((CharSequence)limit) ? null : Integer.valueOf(limit));
        return "{ \"data\":" + JsonUtils.toJSON((Collection)defaultersList, DefaultersInfo.class, DefaultersReportHelperAdaptor.class) + "}";
    }
}

