/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.usage;

import javax.validation.Valid;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.master.service.PropertyUsageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/usage/create"})
public class CreateUsageController {
    private final PropertyUsageService propertyUsageService;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public CreateUsageController(PropertyUsageService propertyUsageService) {
        this.propertyUsageService = propertyUsageService;
    }

    @ModelAttribute
    public PropertyUsage propertyUsageModel() {
        return new PropertyUsage();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(Model model) {
        String roleName = this.propertyUsageService.getRolesForUserId(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("roleName", (Object)roleName);
        return "usage-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute PropertyUsage propertyUsage, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return "usage-form";
        }
        this.propertyUsageService.create(propertyUsage);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.usage.create.success");
        return "redirect:/usage/create";
    }
}

