/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.rebatePeriod;

import javax.validation.Valid;
import org.egov.commons.Installment;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.RebatePeriod;
import org.egov.ptis.domain.service.property.RebatePeriodService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/rebatePeriod/create"})
public class CreateRebatePeriodController {
    private RebatePeriodService rebatePeriodService;
    private PropertyTaxUtil propertyTaxUtil;
    private Installment currentInstallment;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @Autowired
    public CreateRebatePeriodController(RebatePeriodService rebatePeriodService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.rebatePeriodService = rebatePeriodService;
    }

    @ModelAttribute
    public RebatePeriod rebatePeriodModel() {
        this.currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        RebatePeriod rebatePeriod = null;
        if (this.currentInstallment != null && (rebatePeriod = this.rebatePeriodService.getRebateForCurrInstallment(this.currentInstallment.getId())) == null) {
            rebatePeriod = new RebatePeriod();
        }
        return rebatePeriod;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(Model model) {
        return "rebatePeriod-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute RebatePeriod rebatePeriod, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "rebatePeriod-form";
        }
        if (rebatePeriod.getId() == null) {
            rebatePeriod.setInstallment(this.currentInstallment);
        }
        this.rebatePeriodService.saveRebatePeriod(rebatePeriod);
        model.addAttribute("message", (Object)"Rebate period saved successfully !");
        return "rebatePeriod-success";
    }
}

