/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.apartment;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.ApartmentHouse;
import org.egov.ptis.master.service.ApartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/apartment"})
public class ApartmentController {
    private static final String APARTMENT_SEARCH = "apartment-search";
    private final ApartmentService apartmentService;
    @Autowired
    public UserService userService;

    @Autowired
    public ApartmentController(ApartmentService apartmentService) {
        this.apartmentService = apartmentService;
    }

    @ModelAttribute
    public Apartment apartmentModel() {
        return new Apartment();
    }

    @ModelAttribute(value="apartmenttype")
    public List<Apartment> listApartment() {
        return this.apartmentService.getAllApartments();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        return APARTMENT_SEARCH;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("apartment", (Object)this.apartmentModel());
        return "apartment-create";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable Long id, Model model) {
        model.addAttribute("apartment", (Object)this.apartmentService.getApartmentById(id));
        return "apartment-view";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Apartment apartment, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "apartment-create";
        }
        for (ApartmentHouse apartmentHouse : apartment.getApartmentHouseProxy()) {
            if (apartmentHouse.getFloorNo() == null) continue;
            apartmentHouse.setApartment(apartment);
            apartment.getApartmentHouse().add(apartmentHouse);
        }
        this.apartmentService.create(apartment);
        model.addAttribute("successMessage", (Object)"Apartment/Complex Details Added successfully!");
        return "apartment-success";
    }
}

