/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.bean;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.UnitCalculationDetail;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertyFloorDetailsInfo
implements Comparable<PropertyFloorDetailsInfo> {
    private static final Logger LOGGER = Logger.getLogger(PropertyFloorDetailsInfo.class);
    private static final String HYPEN = "-";
    private UnitCalculationDetail unitCalcDetail;
    private BigDecimal fireServiceTax = BigDecimal.ZERO;
    private BigDecimal lightTax = BigDecimal.ZERO;
    private BigDecimal sewerageTax = BigDecimal.ZERO;
    private BigDecimal genTax = BigDecimal.ZERO;
    private BigDecimal waterTax = BigDecimal.ZERO;
    private BigDecimal eduCessResd = BigDecimal.ZERO;
    private BigDecimal eduCessNonResd = BigDecimal.ZERO;
    private BigDecimal bigResBldgTax = BigDecimal.ZERO;
    private BigDecimal empGrnteTax = BigDecimal.ZERO;
    private Boolean hasFireTaxChanged = Boolean.FALSE;
    private Boolean hasLightTaxChanged = Boolean.FALSE;
    private Boolean hasSewerageTaxChanged = Boolean.FALSE;
    private Boolean hasGenTaxChanged = Boolean.FALSE;
    private Boolean hasWaterTaxChanged = Boolean.TRUE;
    private Boolean hasResdEduCessChanged = Boolean.FALSE;
    private Boolean hasNonResdEduCessChanged = Boolean.FALSE;
    private Boolean hasEgCessChanged = Boolean.FALSE;
    private Boolean hasBigResdTaxtChanged = Boolean.FALSE;
    private Boolean hasALVChanged = Boolean.FALSE;
    private String totalTax = "";
    private String totalServChrg = "";
    private String NOTAVAIL = "N/A";
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public PropertyFloorDetailsInfo(UnitCalculationDetail unitCalcDetail, String propType, Installment installment) {
        this.unitCalcDetail = unitCalcDetail;
        this.fireServiceTax = unitCalcDetail.getFireTax();
        this.lightTax = unitCalcDetail.getLightTax();
        this.sewerageTax = unitCalcDetail.getSewerageTax();
        this.genTax = unitCalcDetail.getGeneralTax();
        this.waterTax = unitCalcDetail.getWaterTax();
        this.eduCessResd = unitCalcDetail.getEduCessResd();
        this.eduCessNonResd = unitCalcDetail.getEduCessNonResd();
        this.bigResBldgTax = unitCalcDetail.getBigBuildingTax();
        this.empGrnteTax = unitCalcDetail.getEmpGrntCess();
        BigDecimal total = this.genTax.add(this.fireServiceTax).add(this.lightTax).add(this.waterTax).add(this.sewerageTax);
        this.totalTax = total.toString();
        this.findTaxChange();
    }

    private void findTaxChange() {
        LOGGER.debug((Object)("Entered into findTaxChange unitCalcDetail=" + this.unitCalcDetail));
        if (PropertyTaxUtil.isNotNull((Object)this.unitCalcDetail.getFromDate())) {
            this.hasSewerageTaxChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getSewerageTaxFromDate());
            this.hasGenTaxChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getGeneralTaxFromDate());
            this.hasWaterTaxChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getWaterTaxFromDate());
            this.hasFireTaxChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getFireTaxFromDate());
            this.hasLightTaxChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getLightTaxFromDate());
            if (this.eduCessResd.compareTo(BigDecimal.ZERO) > 0) {
                this.hasResdEduCessChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getEduCessResdFromDate());
            } else if (this.eduCessNonResd.compareTo(BigDecimal.ZERO) > 0) {
                this.hasNonResdEduCessChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getEduCessNonResdFromDate());
            }
            if (this.empGrnteTax.compareTo(BigDecimal.ZERO) > 0) {
                this.hasEgCessChanged = this.unitCalcDetail.getFromDate().equals(this.unitCalcDetail.getEmpGrntCessFromDate());
            }
        } else {
            this.hasNonResdEduCessChanged = this.hasEgCessChanged = Boolean.valueOf(false);
            this.hasResdEduCessChanged = this.hasEgCessChanged;
            this.hasLightTaxChanged = this.hasEgCessChanged;
            this.hasFireTaxChanged = this.hasEgCessChanged;
            this.hasWaterTaxChanged = this.hasEgCessChanged;
            this.hasGenTaxChanged = this.hasEgCessChanged;
            this.hasSewerageTaxChanged = this.hasEgCessChanged;
            this.hasALVChanged = true;
        }
        LOGGER.debug((Object)"Exiting from findTaxChange");
    }

    public Integer getUnitNum() {
        return this.unitCalcDetail.getUnitNumber();
    }

    public String getOccupantName() {
        return "N/A";
    }

    public String getOccupant() {
        return this.unitCalcDetail.getUnitOccupation();
    }

    public String getLightTax() {
        StringBuilder sb = new StringBuilder(100);
        if (this.lightTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.lightTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.hasLightTaxChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.lightTax, (int)2, (boolean)false)).append("</style>");
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.lightTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getFireServiceTax() {
        StringBuilder sb = new StringBuilder(100);
        if (this.fireServiceTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.fireServiceTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.hasFireTaxChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.fireServiceTax, (int)2, (boolean)false)).append("</style>");
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.fireServiceTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getSewerageTax() {
        StringBuilder sb = new StringBuilder(100);
        if (this.sewerageTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.sewerageTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.hasSewerageTaxChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.sewerageTax, (int)2, (boolean)false)).append("</style>");
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.sewerageTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getAlv() {
        StringBuilder sb = new StringBuilder();
        String ALV = ReportUtil.formatNumber((BigDecimal)this.unitCalcDetail.getAlv(), (int)2, (boolean)false);
        if (this.hasALVChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ALV).append("</style>");
        } else {
            sb.append(ALV);
        }
        if (this.unitCalcDetail.getResidentialALV().compareTo(BigDecimal.ZERO) > 0 && this.unitCalcDetail.getNonResidentialALV().compareTo(BigDecimal.ZERO) > 0) {
            sb.append("\nR-").append(this.unitCalcDetail.getResidentialALV()).append("\nNR-").append(this.unitCalcDetail.getNonResidentialALV());
        }
        return sb.toString();
    }

    public String getGenTax() {
        StringBuilder sb = new StringBuilder(100);
        if (this.genTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.genTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.hasGenTaxChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.genTax, (int)2, (boolean)false)).append("</style>");
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.genTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getWaterTax() {
        StringBuilder sb = new StringBuilder(100);
        if (this.waterTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.waterTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.hasWaterTaxChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.waterTax, (int)2, (boolean)false)).append("</style>");
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.waterTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getEduCess() {
        StringBuilder sb = new StringBuilder(100);
        StringBuilder eduCessChanged = new StringBuilder(100);
        StringBuilder nrEduCessChanged = new StringBuilder(100);
        if (this.hasResdEduCessChanged.booleanValue()) {
            eduCessChanged.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.eduCessResd, (int)2, (boolean)false)).append("</style>");
        }
        if (this.hasNonResdEduCessChanged.booleanValue()) {
            nrEduCessChanged.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.eduCessNonResd, (int)2, (boolean)false)).append("</style>");
        }
        if (this.eduCessResd.compareTo(BigDecimal.ZERO) == 0 && this.eduCessNonResd.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.eduCessResd.compareTo(new BigDecimal("-1")) == 0 || this.eduCessNonResd.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.unitCalcDetail.getResidentialALV().compareTo(BigDecimal.ZERO) > 0 && this.unitCalcDetail.getNonResidentialALV().compareTo(BigDecimal.ZERO) > 0) {
            sb.append("\n");
            if (this.hasResdEduCessChanged.booleanValue()) {
                sb.append((CharSequence)eduCessChanged);
            } else {
                sb.append(ReportUtil.formatNumber((BigDecimal)this.eduCessResd, (int)2, (boolean)false));
            }
            sb.append("\n");
            if (this.hasNonResdEduCessChanged.booleanValue()) {
                sb.append((CharSequence)nrEduCessChanged);
            } else {
                sb.append(ReportUtil.formatNumber((BigDecimal)this.eduCessNonResd, (int)2, (boolean)false));
            }
        } else if (this.eduCessNonResd.compareTo(BigDecimal.ZERO) > 0) {
            if (this.hasNonResdEduCessChanged.booleanValue()) {
                sb.append((CharSequence)eduCessChanged);
            } else {
                sb.append(ReportUtil.formatNumber((BigDecimal)this.eduCessNonResd, (int)2, (boolean)false));
            }
        } else if (this.eduCessResd.compareTo(BigDecimal.ZERO) > 0) {
            if (this.hasResdEduCessChanged.booleanValue()) {
                sb.append((CharSequence)nrEduCessChanged);
            } else {
                sb.append(ReportUtil.formatNumber((BigDecimal)this.eduCessResd, (int)2, (boolean)false));
            }
        }
        return sb.toString();
    }

    public String getBigResBldgTax() {
        StringBuilder sb = new StringBuilder(100);
        if (this.bigResBldgTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.bigResBldgTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.hasBigResdTaxtChanged.booleanValue()) {
            sb.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.bigResBldgTax, (int)2, (boolean)false)).append("</style>");
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.bigResBldgTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getEmpGrnteTax() {
        StringBuilder sb = new StringBuilder(100);
        StringBuilder stringWithBoldStyle = new StringBuilder(100);
        stringWithBoldStyle.append("<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"Times-Bold\" pdfEncoding=\"Cp1252\" isPdfEmbedded=\"true\">").append(ReportUtil.formatNumber((BigDecimal)this.empGrnteTax, (int)2, (boolean)false)).append("</style>");
        if (this.empGrnteTax.compareTo(BigDecimal.ZERO) == 0) {
            return this.NOTAVAIL;
        }
        if (this.empGrnteTax.compareTo(new BigDecimal("-1")) == 0) {
            return HYPEN;
        }
        if (this.unitCalcDetail.getResidentialALV().compareTo(BigDecimal.ZERO) > 0 && this.unitCalcDetail.getNonResidentialALV().compareTo(BigDecimal.ZERO) > 0) {
            sb.append("\n").append(this.NOTAVAIL).append("\n");
            if (this.hasEgCessChanged.booleanValue()) {
                sb.append((CharSequence)stringWithBoldStyle);
            } else {
                sb.append(ReportUtil.formatNumber((BigDecimal)this.empGrnteTax, (int)2, (boolean)false));
            }
        } else if (this.hasEgCessChanged.booleanValue()) {
            sb.append((CharSequence)stringWithBoldStyle);
        } else {
            sb.append(ReportUtil.formatNumber((BigDecimal)this.empGrnteTax, (int)2, (boolean)false));
        }
        return sb.toString();
    }

    public String getTotalTax() {
        return this.totalTax;
    }

    public String getTotalServChrg() {
        return this.unitCalcDetail.getServiceCharge().compareTo(BigDecimal.ZERO) == 0 ? this.NOTAVAIL : this.unitCalcDetail.getServiceCharge().toString();
    }

    public String getInstDate() {
        if (PropertyTaxUtil.isNotNull((Object)this.unitCalcDetail.getFromDate())) {
            return this.dateFormat.format(this.unitCalcDetail.getFromDate());
        }
        Installment installment = this.propertyTaxUtil.getPTInstallmentForDate(this.unitCalcDetail.getInstallmentFromDate());
        String dateString = this.dateFormat.format(this.unitCalcDetail.getInstallmentFromDate());
        if (this.propertyTaxUtil.between(this.unitCalcDetail.getOccupancyDate(), installment.getFromDate(), installment.getToDate()).booleanValue()) {
            dateString = this.unitCalcDetail.getOccupancyDate().after(this.unitCalcDetail.getGuidValEffectiveDate()) ? this.dateFormat.format(this.unitCalcDetail.getOccupancyDate()) : this.dateFormat.format(this.unitCalcDetail.getGuidValEffectiveDate());
        } else if (this.propertyTaxUtil.between(this.unitCalcDetail.getGuidValEffectiveDate(), installment.getFromDate(), installment.getToDate()).booleanValue()) {
            dateString = this.dateFormat.format(this.unitCalcDetail.getGuidValEffectiveDate());
        }
        return dateString;
    }

    public String getUnitOccupation() {
        return this.unitCalcDetail.getUnitOccupation();
    }

    public BigDecimal getFireTaxValue() {
        return this.fireServiceTax;
    }

    public BigDecimal getLightTaxValue() {
        return this.lightTax;
    }

    public BigDecimal getSewerageTaxValue() {
        return this.sewerageTax;
    }

    public BigDecimal getGeneralTaxValue() {
        return this.genTax;
    }

    public BigDecimal getWaterTaxValue() {
        return this.waterTax;
    }

    public BigDecimal getEduCessResdValue() {
        return this.eduCessResd;
    }

    public BigDecimal getEduCessNonResdValue() {
        return this.eduCessNonResd;
    }

    public BigDecimal getBigResBldgTaxValue() {
        return this.bigResBldgTax;
    }

    public BigDecimal getEmpGrnteTaxValue() {
        return this.empGrnteTax;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("PropertyFloorDetailsInfo[").append("UnitNo=").append(this.getUnitNum()).append(", unitOccupation=").append(this.getUnitOccupation()).append(", bigResBldgTax=").append(this.bigResBldgTax).append(", eduCessonResd=").append(this.eduCessNonResd).append(", eduCessResd=").append(this.eduCessResd).append(", empGrnteTax=").append(this.empGrnteTax).append(", fireServiceTax=").append(this.fireServiceTax).append(", genTax=").append(this.genTax).append(", lightTax=").append(this.lightTax).append(", sewerageTax=").append(this.sewerageTax).append(", waterTax=").append(this.waterTax).append(", instDate=").append(this.getInstDate()).append("]");
        return str.toString();
    }

    @Override
    public int compareTo(PropertyFloorDetailsInfo o) {
        int result = 0;
        Date thisDate = null;
        Date otherDate = null;
        try {
            thisDate = this.dateFormat.parse(this.getInstDate());
            otherDate = this.dateFormat.parse(o.getInstDate());
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Error while parsing property floor details inst date", (Throwable)e);
            throw new ApplicationRuntimeException("Error while parsing property floor details inst date", (Throwable)e);
        }
        result = thisDate.compareTo(otherDate);
        if (result == 0) {
            result = this.getUnitNum().compareTo(o.getUnitNum());
        }
        return result;
    }
}

