/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.commons.Installment;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.ptis.bean.ReportInfo;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
public class HeadWiseDmdNdRecReportAction
extends BaseFormAction {
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private final String RESULT_GENERATE = "generate";
    private ReportService reportService;
    private String reportId;
    private BigDecimal arrDmdTotal = BigDecimal.ZERO;
    private BigDecimal currDmdTotal = BigDecimal.ZERO;
    private BigDecimal arrCollTotal = BigDecimal.ZERO;
    private BigDecimal currCollTotal = BigDecimal.ZERO;
    private BigDecimal arrDmdGrandTotal = BigDecimal.ZERO;
    private BigDecimal currDmdGrandTotal = BigDecimal.ZERO;
    private BigDecimal arrCollGrandTotal = BigDecimal.ZERO;
    private BigDecimal currCollGrandTotal = BigDecimal.ZERO;
    private Map<String, BigDecimal> dmdCollMap = new HashMap();
    private List arrInstDmdCollList = new ArrayList();
    private List currInstDmdCollList = new ArrayList();
    private Installment currentInstallment;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public String generateHeadWiseDmdColl() {
        ReportRequest reportRequest = null;
        ReportInfo reportInfo = new ReportInfo();
        this.currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        this.prepareReasonWiseCurrDmdColl();
        this.prepareReasonWiseArrDmdColl();
        Calendar installmentFromDate = Calendar.getInstance();
        installmentFromDate.setTime(this.currentInstallment.getFromDate());
        Calendar installmentToDate = Calendar.getInstance();
        installmentToDate.setTime(this.currentInstallment.getToDate());
        reportInfo.setCurrInstallment("Year " + installmentFromDate.get(1) + "-" + installmentToDate.get(1));
        reportInfo.setDemandCollMap(this.dmdCollMap);
        reportRequest = new ReportRequest("HeadWiseDmdNdRec", (Object)reportInfo, new HashMap());
        reportRequest.setPrintDialogOnOpenReport(true);
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(reportRequest));
        return "generate";
    }

    private void prepareReasonWiseCurrDmdColl() {
        this.LOGGER.debug((Object)"Enter prepareReasonWiseCurrDmdColl");
        StringBuilder currDmdCollBuilder = new StringBuilder(1500);
        currDmdCollBuilder.append("select").append(" dcb.installment.id, sum(dcb.generalTax), sum(dcb.generalTaxColl),").append(" sum(dcb.egsTax), sum(dcb.egsTaxColl),").append(" sum(dcb.eduCessResdTax) + sum(dcb.eduCessNonResdTax),").append(" sum(dcb.eduCessResdTaxColl) + sum(dcb.eduCessNonResdTaxColl),").append(" sum(dcb.waterTax), sum(dcb.waterTaxColl),").append(" sum(dcb.fireTax), sum(dcb.fireTaxColl),").append(" sum(dcb.sewerageTax), sum(dcb.sewerageTaxColl),").append(" sum(dcb.lightTax), sum(dcb.lightTaxColl),").append(" sum(dcb.bigBldgTax), sum(dcb.bigBldgTaxColl),").append(" sum(dcb.chqBouncePenalty), sum(dcb.chqBuncPnltyColl),").append(" sum(dcb.penaltyFine), sum(dcb.penaltyFineColl)").append(" from InstDmdCollMaterializeView dcb, Installment inst, Module module").append(" where").append(" inst.module.id = module.id").append(" and module.moduleName = 'Property Tax'").append(" and inst.fromDate <= sysdate").append(" and inst.toDate >= sysdate").append(" and dcb.installment.id = inst.id").append(" group by dcb.installment.id");
        Query qry = this.getPersistenceService().getSession().createQuery(currDmdCollBuilder.toString());
        this.currInstDmdCollList = qry.list();
        Object[] currInst = (Object[])this.currInstDmdCollList.get(0);
        this.dmdCollMap.put("currSewerageTax", (BigDecimal)currInst[11]);
        this.dmdCollMap.put("currWaterTax", (BigDecimal)currInst[7]);
        this.dmdCollMap.put("currGenTax", (BigDecimal)currInst[1]);
        this.dmdCollMap.put("currFireTax", (BigDecimal)currInst[9]);
        this.dmdCollMap.put("currLightTax", (BigDecimal)currInst[13]);
        this.dmdCollMap.put("currEduTax", (BigDecimal)currInst[5]);
        this.dmdCollMap.put("currEgsTax", (BigDecimal)currInst[3]);
        this.dmdCollMap.put("currBigBldgTax", (BigDecimal)currInst[15]);
        this.dmdCollMap.put("currSewerageTaxColl", (BigDecimal)currInst[12]);
        this.dmdCollMap.put("currWaterTaxColl", (BigDecimal)currInst[8]);
        this.dmdCollMap.put("currGenTaxColl", (BigDecimal)currInst[2]);
        this.dmdCollMap.put("currFireTaxColl", (BigDecimal)currInst[10]);
        this.dmdCollMap.put("currLightTaxColl", (BigDecimal)currInst[14]);
        this.dmdCollMap.put("currEduTaxColl", (BigDecimal)currInst[6]);
        this.dmdCollMap.put("currEgsTaxColl", (BigDecimal)currInst[4]);
        this.dmdCollMap.put("currBigBldgTaxColl", (BigDecimal)currInst[16]);
        this.dmdCollMap.put("currChqBuncPenalty", (BigDecimal)currInst[17]);
        this.dmdCollMap.put("currPenaltyFine", (BigDecimal)currInst[19]);
        this.dmdCollMap.put("currChqBncPntyColl", (BigDecimal)currInst[18]);
        this.dmdCollMap.put("currPnltyFineColl", (BigDecimal)currInst[20]);
        this.currDmdTotal = this.currDmdTotal.add((BigDecimal)currInst[11]).add((BigDecimal)currInst[7]).add((BigDecimal)currInst[1]).add((BigDecimal)currInst[9]).add((BigDecimal)currInst[13]).add((BigDecimal)currInst[5]).add((BigDecimal)currInst[3]).add((BigDecimal)currInst[15]).add((BigDecimal)currInst[17]).add((BigDecimal)currInst[19]);
        this.currCollTotal = this.currCollTotal.add((BigDecimal)currInst[12]).add((BigDecimal)currInst[8]).add((BigDecimal)currInst[2]).add((BigDecimal)currInst[10]).add((BigDecimal)currInst[14]).add((BigDecimal)currInst[6]).add((BigDecimal)currInst[4]).add((BigDecimal)currInst[16]).add((BigDecimal)currInst[18]).add((BigDecimal)currInst[20]);
        this.currDmdGrandTotal = this.currDmdGrandTotal.add(this.currDmdTotal);
        this.currCollGrandTotal = this.currCollGrandTotal.add(this.currCollTotal);
        this.dmdCollMap.put("currDmdTotal", this.currDmdTotal);
        this.dmdCollMap.put("currCollTotal", this.currCollTotal);
        this.dmdCollMap.put("currDmdGrandTotal", this.currDmdGrandTotal);
        this.dmdCollMap.put("currCollGrandTotal", this.currCollGrandTotal);
        this.LOGGER.debug((Object)"Exit prepareReasonWiseCurrDmdColl");
    }

    private void prepareReasonWiseArrDmdColl() {
        this.LOGGER.debug((Object)"Enter prepareReasonWiseArrDmdColl");
        StringBuilder arrDmdCollBuilder = new StringBuilder(1500);
        arrDmdCollBuilder.append("select").append(" sum(dcb.generalTax), sum(dcb.generalTaxColl),").append(" sum(dcb.egsTax), sum(dcb.egsTaxColl), ").append(" sum(dcb.eduCessResdTax) + sum(dcb.eduCessNonResdTax),").append(" sum(dcb.eduCessResdTaxColl) + sum(dcb.eduCessNonResdTaxColl),").append(" sum(dcb.waterTax), sum(dcb.waterTaxColl), sum(dcb.fireTax),").append(" sum(dcb.fireTaxColl), sum(dcb.sewerageTax), sum(dcb.sewerageTaxColl),").append(" sum(dcb.lightTax), sum(dcb.lightTaxColl), sum(dcb.bigBldgTax),").append(" sum(dcb.bigBldgTaxColl), sum(dcb.chqBouncePenalty),").append(" sum(dcb.chqBuncPnltyColl), sum(dcb.penaltyFine),").append(" sum(dcb.penaltyFineColl)").append(" from InstDmdCollMaterializeView dcb, Installment inst, Module module").append(" where").append(" inst.module.id = module.id").append(" and module.moduleName = 'Property Tax'").append(" and inst.toDate < :currInstFromDate").append(" and dcb.installment.id = inst.id");
        Query qry = this.getPersistenceService().getSession().createQuery(arrDmdCollBuilder.toString());
        qry.setDate("currInstFromDate", this.currentInstallment.getFromDate());
        this.arrInstDmdCollList = qry.list();
        Object[] arrearTaxes = (Object[])this.arrInstDmdCollList.get(0);
        this.dmdCollMap.put("arrSewerageTax", (BigDecimal)arrearTaxes[10]);
        this.dmdCollMap.put("arrWaterTax", (BigDecimal)arrearTaxes[6]);
        this.dmdCollMap.put("arrGenTax", (BigDecimal)arrearTaxes[0]);
        this.dmdCollMap.put("arrFireTax", (BigDecimal)arrearTaxes[8]);
        this.dmdCollMap.put("arrLightTax", (BigDecimal)arrearTaxes[12]);
        this.dmdCollMap.put("arrEduTax", (BigDecimal)arrearTaxes[4]);
        this.dmdCollMap.put("arrEgsTax", (BigDecimal)arrearTaxes[2]);
        this.dmdCollMap.put("arrBigBldgTax", (BigDecimal)arrearTaxes[14]);
        this.dmdCollMap.put("arrSewerageTaxColl", (BigDecimal)arrearTaxes[11]);
        this.dmdCollMap.put("arrWaterTaxColl", (BigDecimal)arrearTaxes[7]);
        this.dmdCollMap.put("arrGenTaxColl", (BigDecimal)arrearTaxes[1]);
        this.dmdCollMap.put("arrFireTaxColl", (BigDecimal)arrearTaxes[9]);
        this.dmdCollMap.put("arrLightTaxColl", (BigDecimal)arrearTaxes[13]);
        this.dmdCollMap.put("arrEduTaxColl", (BigDecimal)arrearTaxes[5]);
        this.dmdCollMap.put("arrEgsTaxColl", (BigDecimal)arrearTaxes[3]);
        this.dmdCollMap.put("arrBigBldgTaxColl", (BigDecimal)arrearTaxes[15]);
        this.dmdCollMap.put("arrChqBuncPenalty", (BigDecimal)arrearTaxes[16]);
        this.dmdCollMap.put("arrPenaltyFine", (BigDecimal)arrearTaxes[18]);
        this.dmdCollMap.put("arrChqBuncPnltyColl", (BigDecimal)arrearTaxes[17]);
        this.dmdCollMap.put("arrPenaltyFineColl", (BigDecimal)arrearTaxes[19]);
        for (Map.Entry mapEntry : this.dmdCollMap.entrySet()) {
            if (!((String)mapEntry.getKey()).startsWith("arr")) continue;
            if (((String)mapEntry.getKey()).endsWith("Tax")) {
                this.arrDmdTotal = this.arrDmdTotal.add((BigDecimal)mapEntry.getValue());
                continue;
            }
            if (!((String)mapEntry.getKey()).endsWith("Coll")) continue;
            this.arrCollTotal = this.arrCollTotal.add((BigDecimal)mapEntry.getValue());
        }
        this.arrDmdTotal = this.arrDmdTotal.add((BigDecimal)this.dmdCollMap.get("arrChqBuncPenalty")).add((BigDecimal)this.dmdCollMap.get("arrPenaltyFine"));
        this.arrDmdGrandTotal = this.arrDmdGrandTotal.add(this.arrDmdTotal);
        this.arrCollGrandTotal = this.arrCollGrandTotal.add(this.arrCollTotal);
        this.dmdCollMap.put("arrDmdTotal", this.arrDmdTotal);
        this.dmdCollMap.put("arrCollTotal", this.arrCollTotal);
        this.dmdCollMap.put("arrDmdGrandTotal", this.arrDmdGrandTotal);
        this.dmdCollMap.put("arrCollGrandTotal", this.arrCollGrandTotal);
        this.LOGGER.debug((Object)"Exit from prepareReasonWiseArrDmdColl");
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public Object getModel() {
        return null;
    }
}

