/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.bean.DemandCollInfo;
import org.egov.ptis.bean.ReportInfo;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class EgsEduCessCollectionReportAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(EgsEduCessCollectionReportAction.class);
    private ReportService reportService;
    private static final String SRCH_FORM = "searchForm";
    private static final String REPORT = "report";
    private String reportId;
    private Map<Integer, String> monthsMap;
    private Date day;
    private Integer month;
    private String year;
    ReportInfo reportInfo = new ReportInfo();
    private Date fromDate = new Date();
    private Date toDate = new Date();
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private List<Object[]> list;
    private Boolean recordsExist = Boolean.TRUE;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public void validate() {
        LOGGER.debug((Object)("Inside Validate Method, Day : " + this.day + "-Month : " + this.month + "-Year : " + this.year));
        if (!(this.day != null && !this.day.equals("") || this.month != null && this.month != -1 || this.year != null && !this.year.equals("-1"))) {
            this.addActionError("Please select anyone of the search criteria");
        }
        if (this.month != null && this.month != -1 && (this.year == null || this.year.equals("-1"))) {
            this.addActionError("Please select year for month");
        }
        LOGGER.debug((Object)"Exit from validate method");
    }

    public Object getModel() {
        return null;
    }

    public void prepare() {
        this.setMonthsMap(PropertyTaxConstants.MONTHS_MAP);
        this.addDropdownData("yearsList", this.prepareYearsList());
    }

    @ValidationErrorPage(value="searchForm")
    public String generateReport() {
        LOGGER.debug((Object)"Inside generateReport method");
        HashMap<String, String> srchParams = new HashMap<String, String>();
        StringTokenizer yearTokenizer = new StringTokenizer(this.year, "-");
        String[] years = new String[2];
        int i = 0;
        while (yearTokenizer.hasMoreTokens()) {
            years[i++] = yearTokenizer.nextToken();
        }
        StringBuffer qryStr = new StringBuffer("select ca.glcode, sum(ch.totalamount) from EGCL_COLLECTIONDETAILS cd, egcl_collectionheader ch, chartofaccounts ca where cd.id_collectionheader = ch.id and ca.glcode in (:glcodeList) and cd.id_accounthead = ca.id ");
        if (this.day != null && !this.day.equals("")) {
            String dateStr = new SimpleDateFormat("dd/MM/yyyy").format(this.day);
            qryStr.append("and to_char(ch.created_date, 'dd/MM/yyyy') = :day ");
            srchParams.put("day", dateStr);
            this.reportInfo.setDateString("Dated : " + dateStr);
        } else if (this.month != null && this.month != -1) {
            StringBuffer dateStr = new StringBuffer();
            String yearStr = this.month < 3 ? String.valueOf(Integer.valueOf(years[0]) + 1) : years[0];
            String monthStr = StringUtils.leftPad((String)String.valueOf(this.month + 1), (int)2, (String)"0");
            dateStr.append(monthStr).append("/");
            dateStr.append(yearStr);
            qryStr.append("and to_char(ch.created_date, 'MM') || '/' || to_char(ch.created_date, 'yyyy') = :month ");
            srchParams.put("month", dateStr.toString());
            Calendar calendar = Calendar.getInstance();
            calendar.set(Integer.valueOf(yearStr), this.month, 1);
            int maxDay = calendar.getActualMaximum(5);
            int minDay = calendar.getActualMinimum(5);
            StringBuffer fromDate = new StringBuffer();
            StringBuffer toDate = new StringBuffer();
            fromDate.append(minDay).append("/").append(monthStr).append("/").append(yearStr);
            toDate.append(maxDay).append("/").append(monthStr).append("/").append(yearStr);
            this.reportInfo.setDateString("From : " + fromDate.toString() + "  To : " + toDate.toString());
        } else {
            this.fromDate.setYear(Integer.valueOf(years[0]));
            this.fromDate.setMonth(3);
            this.fromDate.setDate(1);
            this.toDate.setYear(Integer.valueOf(years[0]) + 1);
            this.toDate.setMonth(2);
            this.toDate.setDate(31);
            qryStr.append("and to_date(to_char(ch.created_date,'dd/MM/yy'),'dd/MM/yy') >= to_date(:fromDate,'dd/MM/yy') ");
            qryStr.append("and to_date(to_char(ch.created_date,'dd/MM/yy'),'dd/MM/yy') <= to_date(:toDate,'dd/MM/yy') ");
            srchParams.put("fromDate", this.dateFormat.format(this.fromDate));
            srchParams.put("toDate", this.dateFormat.format(this.toDate));
            this.reportInfo.setDateString("From : " + this.dateFormat.format(this.fromDate) + " To : " + this.dateFormat.format(this.toDate));
        }
        qryStr.append("group by ca.glcode");
        SQLQuery qry = this.getPersistenceService().getSession().createSQLQuery(qryStr.toString());
        qry.setParameterList("glcodeList", (Collection)PropertyTaxConstants.EDU_EGS_CESS_GLCODE_LIST);
        for (String srchParam : srchParams.keySet()) {
            qry.setParameter(srchParam, srchParams.get(srchParam));
        }
        this.list = qry.list();
        if (this.list == null || this.list.isEmpty()) {
            this.recordsExist = Boolean.FALSE;
            return SRCH_FORM;
        }
        ReportRequest reportInput = this.prepareReportData();
        reportInput.setPrintDialogOnOpenReport(true);
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(reportInput));
        LOGGER.debug((Object)"Exit from generateReport method");
        return REPORT;
    }

    private ReportRequest prepareReportData() {
        LOGGER.debug((Object)"Inside prepareReportData method");
        ArrayList<DemandCollInfo> dmdCollInfoList = new ArrayList<DemandCollInfo>();
        DemandCollInfo dmdCollInfoEgs = new DemandCollInfo();
        dmdCollInfoEgs.setTaxType("EGS Cess");
        DemandCollInfo dmdCollInfoEdu = new DemandCollInfo();
        dmdCollInfoEdu.setTaxType("Education Cess");
        for (Object[] obj : this.list) {
            if (obj[0].equals("4312003")) {
                dmdCollInfoEgs.setArrColl(new BigDecimal(obj[1].toString()));
                continue;
            }
            if (obj[0].equals("4312004")) {
                dmdCollInfoEgs.setCurColl(new BigDecimal(obj[1].toString()));
                continue;
            }
            if (obj[0].equals("4312001")) {
                dmdCollInfoEdu.setArrColl(new BigDecimal(obj[1].toString()));
                continue;
            }
            if (!obj[0].equals("4312002")) continue;
            dmdCollInfoEdu.setCurColl(new BigDecimal(obj[1].toString()));
        }
        dmdCollInfoList.add(dmdCollInfoEdu);
        dmdCollInfoList.add(dmdCollInfoEgs);
        if (dmdCollInfoList != null && !dmdCollInfoList.isEmpty()) {
            this.reportInfo.setDemandCollInfoList(dmdCollInfoList);
        }
        LOGGER.debug((Object)"Exit from prepareReportData method");
        return new ReportRequest("Egs_EduCess_CollectionInfo", (Object)this.reportInfo, null);
    }

    private List<String> prepareYearsList() {
        StringBuffer qryStr = new StringBuffer("select * from eg_installment_master where id_module = (select id_module from eg_module where module_name = 'Property Tax') and start_date >= to_date('01/04/2012','dd/MM/yyyy') and start_date <= sysdate");
        SQLQuery qry = this.getPersistenceService().getSession().createSQLQuery(qryStr.toString()).addEntity(Installment.class);
        return qry.list();
    }

    @SkipValidation
    public String searchForm() {
        return SRCH_FORM;
    }

    public Map<Integer, String> getMonthsMap() {
        return this.monthsMap;
    }

    public void setMonthsMap(Map<Integer, String> monthsMap) {
        this.monthsMap = monthsMap;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Boolean getRecordsExist() {
        return this.recordsExist;
    }

    public void setRecordsExist(Boolean recordsExist) {
        this.recordsExist = recordsExist;
    }
}

