/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.bean.AssesseeInfo;
import org.egov.ptis.bean.ReportInfo;
import org.egov.ptis.bean.TaxInfo;
import org.egov.ptis.domain.entity.property.InstDmdCollMaterializeView;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
public class BakayaFeristReportAction
extends ReportFormAction {
    private static final String RESULT_NEW = "new";
    private static final Logger LOGGER = Logger.getLogger(BakayaFeristReportAction.class);
    private Integer zoneId;
    private Integer wardId;
    private String partNo;
    private Map<Long, String> ZoneBndryMap;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    public void prepare() {
        List zoneList = this.persistenceService.findAllBy("from BoundaryImpl BI where BI.boundaryType.name=? and BI.boundaryType.heirarchyType.name=? and BI.isHistory='N' order by BI.id", new Object[]{"Revenue Zone", "ELECTION"});
        this.setZoneBndryMap(CommonServices.getFormattedBndryMap((List)zoneList));
        this.prepareWardDropDownData(this.zoneId != null && !this.zoneId.equals(-1), this.wardId != null && !this.wardId.equals(-1));
        if (this.wardId == null || this.wardId.equals(-1)) {
            this.addDropdownData("partNumbers", Collections.EMPTY_LIST);
        }
    }

    public void prepareReport() {
        LOGGER.debug((Object)"Entered into prepareReport method");
        this.setDataSourceType(ReportDataSourceType.JAVABEAN);
        ReportInfo reportInfo = this.prepareReportInfo();
        this.setReportData((Object)reportInfo);
        LOGGER.debug((Object)"Exit from prepareReport method");
    }

    private ReportInfo prepareReportInfo() {
        LOGGER.debug((Object)"Entered into prepareReportInfo method");
        ReportInfo reportInfo = new ReportInfo();
        Boundary zone = (Boundary)this.persistenceService.find("from BoundaryImpl BI where BI.id = ? and BI.boundaryType.name=? and BI.boundaryType.heirarchyType.name=? and BI.isHistory='N' order by BI.id", new Object[]{this.getZoneId(), "Revenue Zone", "ELECTION"});
        Boundary ward = (Boundary)this.persistenceService.find("from BoundaryImpl BI where BI.id = ? and BI.boundaryType.name=? and BI.boundaryType.heirarchyType.name=? and BI.isHistory='N' order by BI.id", new Object[]{this.getWardId(), "Revenue Ward", "ELECTION"});
        reportInfo.setZoneNo(zone.getBoundaryNum().toString());
        reportInfo.setWardNo(ward.getBoundaryNum().toString());
        reportInfo.setPartNo(this.partNo != null && !this.partNo.equals("-1") ? this.partNo : "N/A");
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        Calendar installmentFromDate = Calendar.getInstance();
        installmentFromDate.setTime(currentInstallment.getFromDate());
        Calendar installmentToDate = Calendar.getInstance();
        installmentToDate.setTime(currentInstallment.getToDate());
        reportInfo.setCurrInstallment(installmentFromDate.get(1) + "-" + installmentToDate.get(1));
        List assesseeInfoList = this.prepareAssessees();
        List emptyDemandCollInfoList = Collections.emptyList();
        List emptyPMVList = Collections.emptyList();
        reportInfo.setAssesseeInfoList(assesseeInfoList);
        reportInfo.setDemandCollInfoList(emptyDemandCollInfoList);
        LOGGER.debug((Object)"Exit from prepareReportInfo method");
        return reportInfo;
    }

    private List<AssesseeInfo> prepareAssessees() {
        LOGGER.debug((Object)"Entered into prepareAssesseeInformation method");
        ArrayList<AssesseeInfo> assessees = new ArrayList<AssesseeInfo>();
        StringBuilder queryBuilder = new StringBuilder(500);
        queryBuilder.append("from PropertyMaterlizeView pmv left join fetch pmv.instDmdColl instDmdColl ").append("left join fetch instDmdColl.installment").append(" where pmv.ward.id = ? and pmv.propTypeMstrID.code not in ('").append("CENTRAL_GOVT_50").append("', '").append("STATE_GOVT").append("' ) ");
        if (this.partNo != null && !this.partNo.equals("-1")) {
            queryBuilder.append("and pmv.partNo = ?");
        }
        queryBuilder.append("order by to_number(regexp_substr(pmv.houseNo, '^[1-9][0-9]*')), pmv.houseNo");
        Query qry = this.getPersistenceService().getSession().createQuery(queryBuilder.toString());
        qry.setParameter(0, (Object)this.getWardId());
        if (this.partNo != null && !this.partNo.equals("-1")) {
            qry.setParameter(1, (Object)this.partNo);
        }
        List properties = qry.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        BigDecimal grandTotal = BigDecimal.ZERO;
        for (PropertyMaterlizeView property : properties) {
            AssesseeInfo assessee = new AssesseeInfo();
            assessee.setIndexNo(property.getPropertyId());
            assessee.setHouseNo(property.getHouseNo());
            assessee.setOwnerName(property.getOwnerName());
            TreeSet<TaxInfo> taxInfos = new TreeSet<TaxInfo>((Comparator<TaxInfo>)new /* Unavailable Anonymous Inner Class!! */);
            TreeSet demandDetailsAndInstallments = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
            demandDetailsAndInstallments.addAll(property.getInstDmdColl());
            grandTotal = BigDecimal.ZERO;
            for (InstDmdCollMaterializeView demandDetailsAndInstallment : demandDetailsAndInstallments) {
                TaxInfo taxInfo = new TaxInfo();
                if (currentInstallment.equals((Object)demandDetailsAndInstallment.getInstallment())) {
                    taxInfo.setGrandTotal(grandTotal.setScale(2, 4));
                }
                if (taxInfo.getTotal().equals(BigDecimal.ZERO.setScale(2))) continue;
                taxInfos.add(taxInfo);
            }
            assessee.setTaxInfoList(new ArrayList(taxInfos));
            assessees.add(assessee);
        }
        LOGGER.debug((Object)"Exit from prepareReportInfo method");
        return assessees;
    }

    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
        LOGGER.debug((Object)("Zone Exists ? : " + zoneExists + ", Ward Exists ? : " + wardExists));
        if (zoneExists && wardExists) {
            List wardNewList = new ArrayList();
            wardNewList = this.getPersistenceService().findAllBy("from BoundaryImpl BI where BI.boundaryType.name=? and BI.parent.id = ? and BI.isHistory='N' order by BI.name ", new Object[]{"Revenue Ward", this.getZoneId()});
            this.addDropdownData("wardList", wardNewList);
        } else {
            this.addDropdownData("Wards", Collections.EMPTY_LIST);
        }
        LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
    }

    @SkipValidation
    public String newForm() {
        return RESULT_NEW;
    }

    @ValidationErrorPage(value="new")
    public String report() {
        return super.report();
    }

    public String criteria() {
        return null;
    }

    protected String getReportTemplateName() {
        return "Bakaya_Ferist";
    }

    public void validateReport() {
        LOGGER.debug((Object)"Entered into validateReport method");
        if (this.getZoneId() == null || this.getZoneId() == -1) {
            this.addActionError(this.getText("mandatory.zone"));
        }
        if (this.getWardId() == null || this.getWardId() == -1) {
            this.addActionError(this.getText("mandatory.ward"));
        }
        LOGGER.debug((Object)"Exiting from validateReport method");
    }

    public Integer getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Integer zoneId) {
        this.zoneId = zoneId;
    }

    public Integer getWardId() {
        return this.wardId;
    }

    public void setWardId(Integer wardId) {
        this.wardId = wardId;
    }

    public Map<Long, String> getZoneBndryMap() {
        return this.ZoneBndryMap;
    }

    public void setZoneBndryMap(Map<Long, String> zoneBndryMap) {
        this.ZoneBndryMap = zoneBndryMap;
    }

    public String getPartNo() {
        return this.partNo;
    }

    public void setPartNo(String partNo) {
        this.partNo = partNo;
    }
}

