/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.bean.ActiveDemandInfo;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.hibernate.SQLQuery;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;

@ParentPackage(value="egov")
public class ActiveDemandReportAction
extends BaseFormAction {
    private static final String WARD = "Ward";
    private static final String PART_NO = "PartNo";
    private static final String TOTAL = "Total";
    private static final long serialVersionUID = 1L;
    private Date asOnDate;
    private Boolean objPropsIncluded = Boolean.FALSE;
    private List propertyTypes;
    private Map<String, Object> params = new HashMap();
    private List<ActiveDemandInfo> resultList;
    private Boolean resultPage = Boolean.FALSE;
    private Integer boundaryId;
    private String reportType;
    private String selectedPropertyTypes = new String();

    public void prepare() {
        List propTypes = this.persistenceService.findAllBy("from PropertyTypeMaster order by orderNo", new Object[0]);
        this.addDropdownData("propTypes", propTypes);
        int i = 0;
        if (this.propertyTypes != null) {
            block0: for (Object typeId : this.propertyTypes) {
                for (PropertyTypeMaster type : propTypes) {
                    if (!type.getId().equals(Long.valueOf(String.valueOf(typeId)))) continue;
                    this.selectedPropertyTypes = i == 0 ? type.getType() : this.selectedPropertyTypes + ", " + type.getType();
                    ++i;
                    continue block0;
                }
            }
        }
    }

    public Object getModel() {
        return null;
    }

    @SkipValidation
    public String newForm() {
        return "new";
    }

    public SQLQuery prepareQuery() {
        StringBuffer queryStr = new StringBuffer("");
        String groupBy = null;
        String orderBy = null;
        if (this.reportType != null && this.reportType.equalsIgnoreCase(WARD)) {
            queryStr.append("SELECT WARDBNDRY.ID_BNDRY \"boundaryId\", WARDBNDRY.NAME \"boundaryName\", \"count\", \"arrDmd\", \"currDmd\", \"arrDmd\" + \"currDmd\" \"totDmd\" FROM (SELECT ACTDMD.WARDID \"wardId\", COUNT(*) \"count\", SUM(ACTDMD.ARREAR_DEMAND) \"arrDmd\", SUM(ACTDMD.CURR_DEMAND) \"currDmd\" ");
            groupBy = new String(" GROUP BY ACTDMD.WARDID), EG_BOUNDARY WARDBNDRY WHERE \"wardId\" = WARDBNDRY.ID_BNDRY");
            orderBy = new String(" order by \"wardId\"");
        } else if (this.reportType != null && this.reportType.equalsIgnoreCase(PART_NO)) {
            queryStr.append("SELECT ACTDMD.PARTNO \"partNo\", COUNT(*) \"count\", SUM(ACTDMD.ARREAR_DEMAND) \"arrDmd\", SUM(ACTDMD.CURR_DEMAND) \"currDmd\", SUM(ACTDMD.ARREAR_DEMAND) + SUM(ACTDMD.CURR_DEMAND) \"totDmd\"  ");
            groupBy = new String(" GROUP BY ACTDMD.PARTNO");
            orderBy = new String(" order by \"partNo\"");
        } else {
            queryStr.append("SELECT ZONEBNDRY.ID_BNDRY \"boundaryId\", ZONEBNDRY.NAME \"boundaryName\", \"count\", \"arrDmd\", \"currDmd\", \"arrDmd\" + \"currDmd\" \"totDmd\" FROM (SELECT ACTDMD.ZONEID \"ZONEID\", COUNT(*) \"count\", NVL(SUM(ACTDMD.ARREAR_DEMAND), 0) \"arrDmd\", NVL(SUM(ACTDMD.CURR_DEMAND), 0) \"currDmd\" ");
            groupBy = new String(" GROUP BY ACTDMD.ZONEID), EG_BOUNDARY ZONEBNDRY WHERE \"ZONEID\" = ZONEBNDRY.ID_BNDRY");
            orderBy = new String(" order by \"ZONEID\"");
        }
        String fromClause = new String(" FROM EGPT_MV_ACTIVE_DEMAND ACTDMD, (SELECT UPICNO,MAX(DMD_ACTIVATION_DATE) AS MXDATE FROM EGPT_MV_ACTIVE_DEMAND");
        StringBuffer whereClause = new StringBuffer("");
        whereClause = this.prepareSearchCriteria(whereClause);
        whereClause.append(" GROUP BY UPICNO) M where ACTDMD.UPICNO = M.UPICNO AND ACTDMD.DMD_ACTIVATION_DATE = M.MXDATE ");
        queryStr.append(fromClause).append(whereClause).append(groupBy).append(orderBy);
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(queryStr.toString());
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(ActiveDemandInfo.class));
        return query;
    }

    private StringBuffer prepareSearchCriteria(StringBuffer whereClause) {
        if (this.propertyTypes != null && !this.propertyTypes.isEmpty()) {
            whereClause.append(" WHERE PROPTYMASTER in (:propTypes)");
            this.params.put("propTypes", this.propertyTypes);
        }
        if (this.asOnDate != null) {
            whereClause.append(" AND DMD_ACTIVATION_DATE <= (:asOnDate)");
            this.params.put("asOnDate", this.asOnDate);
        }
        if (this.objPropsIncluded == null || this.objPropsIncluded.equals(Boolean.FALSE)) {
            whereClause.append(" AND STATUS <> 'O'");
        }
        if (this.reportType != null && this.reportType.equalsIgnoreCase(WARD)) {
            whereClause.append(" and ZONEID = :zoneId");
            this.params.put("zoneId", this.boundaryId);
        } else if (this.reportType != null && this.reportType.equalsIgnoreCase(PART_NO)) {
            whereClause.append(" and WARDID = :wardId");
            this.params.put("wardId", this.boundaryId);
        }
        return whereClause;
    }

    @ValidationErrorPage(value="new")
    public String search() {
        this.resultPage = Boolean.TRUE;
        SQLQuery query = this.prepareQuery();
        for (String key : this.params.keySet()) {
            Object value = this.params.get(key);
            if (value instanceof Collection) {
                query.setParameterList(key, (Collection)value);
                continue;
            }
            query.setParameter(key, value);
        }
        this.resultList = query.list();
        this.prepareTotals();
        return "new";
    }

    private void prepareTotals() {
        ActiveDemandInfo totals = new ActiveDemandInfo();
        if (this.resultList != null && !this.resultList.isEmpty()) {
            if (this.reportType != null && this.reportType.equalsIgnoreCase(PART_NO)) {
                totals.setPartNo(TOTAL);
            } else {
                totals.setBoundaryName(TOTAL);
            }
            totals.setArrDmd(BigDecimal.ZERO);
            totals.setCurrDmd(BigDecimal.ZERO);
            totals.setCount(BigDecimal.ZERO);
            totals.setTotDmd(BigDecimal.ZERO);
        }
        for (ActiveDemandInfo activeDemandInfo : this.resultList) {
            totals.setArrDmd(totals.getArrDmd().add(activeDemandInfo.getArrDmd()));
            totals.setCurrDmd(totals.getCurrDmd().add(activeDemandInfo.getCurrDmd()));
            totals.setCount(new BigDecimal(totals.getCount() + activeDemandInfo.getCount()));
            totals.setTotDmd(totals.getTotDmd().add(activeDemandInfo.getTotDmd()));
        }
        if (this.resultList != null && !this.resultList.isEmpty()) {
            this.resultList.add(totals);
        }
    }

    public void validate() {
        if (this.propertyTypes == null || this.propertyTypes.isEmpty()) {
            this.addActionError(this.getText("mandatory.propTypes"));
        }
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public Boolean getObjPropsIncluded() {
        return this.objPropsIncluded;
    }

    public void setObjPropsIncluded(Boolean objPropsIncluded) {
        this.objPropsIncluded = objPropsIncluded;
    }

    public List getPropertyTypes() {
        return this.propertyTypes;
    }

    public void setPropertyTypes(List propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public List<ActiveDemandInfo> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<ActiveDemandInfo> resultList) {
        this.resultList = resultList;
    }

    public Boolean getResultPage() {
        return this.resultPage;
    }

    public void setResultPage(Boolean resultPage) {
        this.resultPage = resultPage;
    }

    public Integer getBoundaryId() {
        return this.boundaryId;
    }

    public void setBoundaryId(Integer boundaryId) {
        this.boundaryId = boundaryId;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getSelectedPropertyTypes() {
        return this.selectedPropertyTypes;
    }

    public void setSelectedPropertyTypes(String selectedPropertyTypes) {
        this.selectedPropertyTypes = selectedPropertyTypes;
    }
}

