/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.objection;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
public class RejectionLetterAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(RejectionLetterAction.class);
    private RevisionPetition objection = new RevisionPetition();
    private static final String REJECTIONLETTERTEMPLATE = "objectionRejectionLetter";
    private PersistenceService<RevisionPetition, Long> objectionService;
    protected ReportService reportService;
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private String reportId;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public Object getModel() {
        return this.objection;
    }

    public void prepare() {
        if (null != this.objection.getId()) {
            this.objection = (RevisionPetition)this.objectionService.findById((Serializable)this.objection.getId(), false);
        }
    }

    @SkipValidation
    public String print() {
        ReportRequest reportRequest = new ReportRequest(REJECTIONLETTERTEMPLATE, (Object)this.objection, this.getParamMap());
        reportRequest.setPrintDialogOnOpenReport(true);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        this.reportId = this.addingReportToSession(reportOutput);
        return "print";
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("date", DDMMYYYYFORMATS.format(new Date()));
        paramMap.put("objectionNo", this.objection.getObjectionNumber());
        paramMap.put("description", this.objection.getDetails());
        paramMap.put("objectionDate", DDMMYYYYFORMATS.format(this.objection.getRecievedOn()));
        Boundary zone = this.objection.getBasicProperty().getBoundary().getParent();
        paramMap.put("zoneNo", zone != null ? zone.getBoundaryNum().toString() : "");
        paramMap.put("slNo", this.propertyTaxNumberGenerator.getRejectionLetterSerialNum());
        paramMap.put("owner", this.objection.getBasicProperty().getFullOwnerName());
        paramMap.put("address", this.objection.getBasicProperty().getAddress().toString());
        return paramMap;
    }

    protected String addingReportToSession(ReportOutput reportOutput) {
        return this.reportViewerUtil.addReportToTempCache(reportOutput);
    }

    public RevisionPetition getObjection() {
        return this.objection;
    }

    public void setObjection(RevisionPetition objection) {
        this.objection = objection;
    }

    public void setObjectionService(PersistenceService<RevisionPetition, Long> objectionService) {
        this.objectionService = objectionService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }
}

