/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.editOwner;

import javax.servlet.http.HttpServletRequest;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/editowner/{assessmentNo}"})
public class EditOwnerDetailsController {
    protected static final String OWNERDETAILS_FROM = "ownerdetails-form";
    protected static final String OWNERDETAILS_SUCCESS = "ownerdetails-success";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyPersistenceService basicPropertyService;

    @ModelAttribute
    public Property propertyModel(@PathVariable String assessmentNo) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        PropertyImpl property = null;
        if (null != basicProperty) {
            property = (PropertyImpl)basicProperty.getProperty();
        }
        return property;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String assessmentNo) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        model.addAttribute("guardianRelationMap", (Object)PropertyTaxConstants.GUARDIAN_RELATION);
        model.addAttribute("gender", (Object)Gender.values());
        for (PropertyOwnerInfo ownerInfo : basicProperty.getPropertyOwnerInfo()) {
            for (Address address : ownerInfo.getOwner().getAddress()) {
                model.addAttribute("doorNumber", (Object)address.getHouseNoBldgApt());
                model.addAttribute("pinCode", (Object)address.getPinCode());
            }
        }
        return OWNERDETAILS_FROM;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateOwnerDetails(@ModelAttribute Property property, RedirectAttributes redirectAttrs, BindingResult errors, Model model, HttpServletRequest request, @RequestParam String doorNumber) {
        model.addAttribute("doorNumber", (Object)doorNumber);
        model.addAttribute("guardianRelationMap", (Object)PropertyTaxConstants.GUARDIAN_RELATION);
        String errMsg = this.basicPropertyService.updateOwners(property, property.getBasicProperty(), doorNumber, errors);
        if (!errMsg.isEmpty()) {
            model.addAttribute("errorMsg", (Object)errMsg);
            return OWNERDETAILS_FROM;
        }
        return OWNERDETAILS_SUCCESS;
    }
}

