/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.ptis.domain.entity.property.CurrentInstDCBReportResult;
import org.egov.ptis.domain.service.report.ReportService;
import org.egov.ptis.web.controller.reports.CurrentInstDCBResultAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/currentInstDCB"})
public class CurrentInstDCBReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ReportService reportService;

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("currInstDCBReport", (Object)new CurrentInstDCBReportResult());
        return "curretInstDCB-form";
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String ward, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List propertyList = this.reportService.getCurrentInstallmentDCB(ward);
        String result = "{ \"data\":" + this.toJSON((Object)propertyList) + "}";
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CurrentInstDCBReportResult.class, (Object)new CurrentInstDCBResultAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

