/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.demolition;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.demolition.PropertyDemolitionService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/demolition/update/{id}"})
public class UpdatePropertyDemolitionController
extends GenericWorkFlowController {
    protected static final String DEMOLITION_FORM = "demolition-form";
    protected static final String DEMOLITION_VIEW = "demolition-view";
    protected static final String DEMOLITION_SUCCESS = "demolition-success";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    PropertyDemolitionService propertyDemolitionService;
    @Autowired
    private PersistenceService<Property, Long> persistenceService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SecurityUtils securityUtils;
    private PropertyImpl property;

    @Autowired
    public UpdatePropertyDemolitionController(PropertyDemolitionService propertyDemolitionService) {
        this.propertyDemolitionService = propertyDemolitionService;
    }

    @ModelAttribute
    public Property propertyModel(@PathVariable String id) {
        this.property = (PropertyImpl)this.propertyDemolitionService.findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        if (null == this.property) {
            this.property = (PropertyImpl)this.propertyDemolitionService.findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        }
        return this.property;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        String userDesgn = "";
        String currState = this.property.getState().getValue();
        String nextAction = this.property.getState().getNextAction();
        Designation designation = this.propertyTaxUtil.getDesignationForUser(this.securityUtils.getCurrentUser().getId());
        if (null != designation) {
            userDesgn = designation.getName();
        }
        model.addAttribute("stateType", (Object)this.property.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)this.property.getCurrentState().getValue());
        model.addAttribute("userDesgn", (Object)userDesgn);
        this.prepareWorkflow(model, (StateAware)this.property, new WorkflowContainer());
        this.propertyDemolitionService.addModelAttributes(model, this.property.getBasicProperty());
        model.addAttribute("userDesgn", (Object)userDesgn);
        model.addAttribute("designation", (Object)"Commissioner");
        if (currState.endsWith("Rejected") || nextAction.equalsIgnoreCase("UD Revenue Inspector Approval Pending") || currState.endsWith("NEW")) {
            model.addAttribute("mode", (Object)EDIT);
            return DEMOLITION_FORM;
        }
        model.addAttribute("mode", (Object)VIEW);
        return DEMOLITION_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Property property, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        this.propertyDemolitionService.validateProperty(property, errors, request);
        if (errors.hasErrors()) {
            this.prepareWorkflow(model, (StateAware)((PropertyImpl)property), new WorkflowContainer());
            model.addAttribute("stateType", (Object)property.getClass().getSimpleName());
            return DEMOLITION_FORM;
        }
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        Long approvalPosition = 0L;
        String approvalComent = "";
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ("Sign".equalsIgnoreCase(workFlowAction) && property.getStatus().equals(PropertyTaxConstants.STATUS_WORKFLOW)) {
            if (oldProperty.getStatus().equals(PropertyTaxConstants.STATUS_ISACTIVE)) {
                oldProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
                this.persistenceService.persist((Object)oldProperty);
            }
            if (property.getStatus().equals(PropertyTaxConstants.STATUS_WORKFLOW)) {
                property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
                this.persistenceService.persist((Object)property);
            }
        }
        if (workFlowAction.equalsIgnoreCase("Generate Notice") || "Preview".equalsIgnoreCase(workFlowAction) || "Sign".equalsIgnoreCase(workFlowAction)) {
            return "redirect:/notice/propertyTaxNotice-generateNotice.action?basicPropId=" + property.getBasicProperty().getId() + "&noticeType=" + "Special Notice" + "&noticeMode=" + "Demolition" + "&actionType=" + workFlowAction;
        }
        if (request.getParameter("mode").equalsIgnoreCase(VIEW)) {
            this.propertyDemolitionService.updateProperty(property, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
        } else {
            try {
                this.propertyDemolitionService.saveProperty((Property)oldProperty, property, status, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
            }
            catch (TaxCalculatorExeption e) {
                e.printStackTrace();
            }
        }
        Assignment assignment = new Assignment();
        if (workFlowAction.equalsIgnoreCase("Approve")) {
            assignment = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
            model.addAttribute("successMessage", (Object)("Property Demolition approved successfully and forwarded to  " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName()) + " with assessment number " + property.getBasicProperty().getUpicNo()));
        } else if (workFlowAction.equalsIgnoreCase("Reject")) {
            assignment = this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId());
            model.addAttribute("successMessage", (Object)("Property Demolition rejected successfully and forwared to initiator " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName()) + " with application number " + property.getApplicationNo()));
        } else {
            model.addAttribute("successMessage", (Object)("Successfully forwarded to " + this.propertyTaxUtil.getApproverUserName(approvalPosition) + " with application number " + property.getApplicationNo()));
        }
        return DEMOLITION_SUCCESS;
    }
}

