/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.demolition;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.Installment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.demolition.PropertyDemolitionService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/property/demolition/{assessmentNo}"})
public class PropertyDemolitionController
extends GenericWorkFlowController {
    protected static final String COMMON_FORM = "commonForm";
    protected static final String DEMOLITION_FORM = "demolition-form";
    protected static final String DEMOLITION_SUCCESS = "demolition-success";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyDemolitionService propertyDemolitionService;
    BasicProperty basicProperty;
    PropertyImpl propertyImpl = new PropertyImpl();
    PropertyImpl oldProperty;

    @ModelAttribute
    public Property propertyModel(@PathVariable String assessmentNo) {
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (null != this.basicProperty) {
            this.oldProperty = this.basicProperty.getActiveProperty();
            this.propertyImpl = (PropertyImpl)this.basicProperty.getActiveProperty().createPropertyclone();
        }
        return this.propertyImpl;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String assessmentNo) {
        if (null != this.basicProperty && this.basicProperty.isUnderWorkflow()) {
            model.addAttribute("wfPendingMsg", (Object)"Could not do Demolition now, property is undergoing some work flow.");
            return "workFlowError";
        }
        boolean hasChildPropertyUnderWorkflow = this.propertyTaxUtil.checkForParentUsedInBifurcation(this.basicProperty.getUpicNo());
        if (hasChildPropertyUnderWorkflow) {
            model.addAttribute("errorMsg", (Object)"Cannot proceed as this property is used in Bifurcation, which is under workflow");
            return "propertyValidation";
        }
        Map propertyTaxDetails = this.ptDemandDAO.getDemandCollMap((Property)this.basicProperty.getActiveProperty());
        Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
        BigDecimal currentPropertyTax = BigDecimal.ZERO;
        BigDecimal currentPropertyTaxDue = BigDecimal.ZERO;
        BigDecimal arrearPropertyTaxDue = BigDecimal.ZERO;
        if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
            currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
            currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
            arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
        } else {
            currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
            currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
            arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
        }
        model.addAttribute("currentPropertyTax", (Object)currentPropertyTax);
        model.addAttribute("currentPropertyTaxDue", (Object)currentPropertyTaxDue);
        model.addAttribute("arrearPropertyTaxDue", (Object)arrearPropertyTaxDue);
        if (currentPropertyTaxDue.add(arrearPropertyTaxDue).longValue() > 0L) {
            model.addAttribute("taxDuesErrorMsg", (Object)"Please clear property tax due for property demolition ");
            return "taxdues";
        }
        this.propertyDemolitionService.addModelAttributes(model, this.basicProperty);
        model.addAttribute("stateType", (Object)this.propertyImpl.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)this.propertyImpl, new WorkflowContainer());
        return DEMOLITION_FORM;
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST})
    public String demoltionFormSubmit(@ModelAttribute Property property, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request, @RequestParam String workFlowAction) {
        this.propertyDemolitionService.validateProperty(property, errors, request);
        if (errors.hasErrors()) {
            this.prepareWorkflow(model, (StateAware)((PropertyImpl)property), new WorkflowContainer());
            model.addAttribute("stateType", (Object)property.getClass().getSimpleName());
            this.propertyDemolitionService.addModelAttributes(model, this.basicProperty);
            return DEMOLITION_FORM;
        }
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        try {
            this.propertyDemolitionService.saveProperty((Property)this.oldProperty, property, status, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
        }
        catch (TaxCalculatorExeption e) {
            e.printStackTrace();
        }
        model.addAttribute("successMessage", (Object)("Property demolition data saved successfully in the system and forwarded to " + this.propertyTaxUtil.getApproverUserName(approvalPosition)));
        return DEMOLITION_SUCCESS;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }
}

