/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.modify;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@ParentPackage(value="egov")
@Results(value={@Result(name="workFlowError", location="workflow", params={"namespace", "/workflow", "method", "workFlowError"})})
@Transactional(readOnly=true)
@Namespace(value="/modify")
public class ChangePropertyAddressAction
extends PropertyTaxBaseAction {
    private BasicProperty basicProperty;
    private PropertyAddress address = new PropertyAddress();
    private Integer area;
    private String ackMessage;
    private PropertyImpl property;
    private PropertyAddress addr = new PropertyAddress();
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private PersistenceService<Property, Long> propertyImplService;
    public static final String NEW = "new";
    public static final String VIEW = "view";
    public static final String ACK = "ack";
    public static final String FORWARD_ACK = "forwardAck";
    private static final String WORKFLOW_END = "END";
    private static final String MSG_REJECT_SUCCESS = " Change Property Rejected Successfully ";
    private String docNumber;
    @Autowired
    private UserService userService;
    @Autowired
    private EisCommonService eisCommonService;
    private final Logger LOGGER = Logger.getLogger(this.getClass());

    @SkipValidation
    @Action(value="/changePropertyAddress-newForm", results={@Result(name="new", location="/changePropertyAddress-new.jsp")})
    public String newForm() {
        this.LOGGER.debug((Object)("Entered into the newForm method, Index Number " + this.indexNumber + ", BasicProperty: " + this.basicProperty));
        String target = "";
        Map wfMap = this.basicProperty.getPropertyWfStatus();
        String wfStatus = (String)wfMap.get("WFSTATUS");
        if (wfStatus.equalsIgnoreCase("TRUE")) {
            this.getSession().put("WFOWNER", wfMap.get("WFOWNER"));
            target = "workFlowError";
        } else {
            if (this.getDocNumber() != null && this.getDocNumber() != "") {
                this.setDocNumber(this.getDocNumber());
            } else {
                this.setDocNumber(this.basicProperty.getProperty().getDocNumber());
            }
            target = NEW;
        }
        this.LOGGER.debug((Object)"Exit from newForm method");
        return target;
    }

    @SkipValidation
    @Action(value="/changePropertyAddress-view", results={@Result(name="view", location="/changePropertyAddress-view.jsp")})
    public String view() {
        this.LOGGER.debug((Object)("Entered into view method, ModelId: " + this.getModelId() + ", Address: " + this.address));
        this.LOGGER.debug((Object)("view: Property by ModelId: " + this.property));
        this.basicProperty = this.property.getBasicProperty();
        this.LOGGER.debug((Object)("view: BasicProperty on property: " + this.basicProperty));
        String[] addFields = this.property.getBasicProperty().getExtraField2().split("\\|");
        this.address.setLandmark(addFields[0]);
        this.address.setHouseNoBldgApt(addFields[1]);
        if (this.userDesgn.equalsIgnoreCase("RO")) {
            this.setIsApprPageReq(Boolean.FALSE);
        }
        this.setDocNumber(this.property.getDocNumber());
        this.LOGGER.debug((Object)("Address: " + this.address + "\nExit from view method"));
        return VIEW;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/changePropertyAddress-save", results={@Result(name="ack", location="/changePropertyAddress-ack.jsp")})
    public String save() {
        this.LOGGER.debug((Object)("Entered into the newForm method, Index Number : " + this.indexNumber + ", Address : " + this.address + "BasicProperty: " + this.basicProperty));
        String addrStr1 = this.address.getLandmark();
        addrStr1 = this.propertyTaxUtil.antisamyHackReplace(addrStr1);
        this.address.setLandmark(addrStr1);
        this.basicProperty.setAddress(this.address);
        this.processAndStoreDocumentsWithReason(this.basicProperty, "PROPERTY ADDRESS CHANGE");
        this.basicProperty = (BasicProperty)this.basicPropertyService.update((Object)this.basicProperty);
        this.getWorkflowBean().setActionName("Create");
        this.LOGGER.debug((Object)"Exit from save method");
        return ACK;
    }

    @SkipValidation
    @Action(value="/changePropertyAddress-forward", results={@Result(name="forwardAck", location="/changePropertyAddress-forwardAck.jsp")})
    public String forward() {
        this.LOGGER.debug((Object)("Entered into forward, BasicProperty: " + this.basicProperty + ", Address: " + this.address));
        String propDocNum = "";
        if (this.userRole.equalsIgnoreCase("ASSISTANT") && StringUtils.isBlank((String)this.getModelId())) {
            this.validate();
            if (this.hasErrors()) {
                return NEW;
            }
            if (this.getModelId() == null || this.getModelId().equals("")) {
                this.property = (PropertyImpl)this.basicProperty.getProperty().createPropertyclone();
                this.property.getBasicProperty().setExtraField2(PropertyTaxUtil.buildAddress((Address)this.address));
                this.property.setStatus(PropertyTaxConstants.STATUS_WORKFLOW);
                propDocNum = this.getDocNumber() != null && this.getDocNumber() != "" ? this.getDocNumber() : this.property.getDocNumber();
                this.property.setDocNumber(propDocNum);
                this.LOGGER.debug((Object)("Property is getting added to BasicProperty: " + this.property));
                this.basicProperty.addProperty((Property)this.property);
                this.basicProperty = (BasicProperty)this.basicPropertyService.update((Object)this.basicProperty);
            } else {
                this.property.getBasicProperty().setExtraField2(PropertyTaxUtil.buildAddress((Address)this.address));
                this.propertyImplService.update((Object)this.property);
                this.basicProperty = (BasicProperty)this.basicPropertyService.update((Object)this.basicProperty);
            }
        } else {
            super.validate();
            if (this.hasErrors()) {
                return this.view();
            }
        }
        this.transitionWorkFlow();
        User approverUser = this.userService.getUserById(Long.valueOf(this.getWorkflowBean().getApproverUserId()));
        this.setAckMessage("Property " + this.basicProperty.getUpicNo() + " Successfully Forwarded to " + approverUser.getUsername());
        this.LOGGER.debug((Object)("forward: AckMessage: " + this.getAckMessage()));
        this.LOGGER.debug((Object)"Exit from forward");
        return FORWARD_ACK;
    }

    @SkipValidation
    @Action(value="/changePropertyAddress-approve", results={@Result(name="ack", location="/changePropertyAddress-ack.jsp")})
    public String approve() {
        this.LOGGER.debug((Object)("Enetered into approve, BasicProperty: " + this.basicProperty + ", Address : " + this.address.getLandmark() + " HouseNo" + this.address.getHouseNoBldgApt() + "DoorNumOld " + " PinCode" + this.address.getPinCode()));
        try {
            PropertyImpl nonHistProperty = (PropertyImpl)this.getPersistenceService().findByNamedQuery("getPropertyByUpicNoAndStatus", new Object[]{this.property.getBasicProperty().getUpicNo(), PropertyTaxConstants.STATUS_ISACTIVE});
            nonHistProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            this.property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.transitionWorkFlow();
            this.basicProperty.setAddress(this.address);
            this.processAndStoreDocumentsWithReason(this.basicProperty, "PROPERTY ADDRESS CHANGE");
            this.propertyTaxUtil.makeTheEgBillAsHistory(this.basicProperty);
            this.basicProperty = (BasicProperty)this.basicPropertyService.update((Object)this.basicProperty);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception : " + e);
        }
        this.LOGGER.debug((Object)"Exit from approve");
        return ACK;
    }

    @SkipValidation
    @Action(value="/changePropertyAddress-reject", results={@Result(name="forwardAck", location="/changePropertyAddress-forwardAck.jsp")})
    public String reject() {
        this.LOGGER.debug((Object)"reject: Change Property rejection started");
        this.LOGGER.debug((Object)("reject: Property: " + this.property));
        BasicProperty basicProperty = this.property.getBasicProperty();
        this.LOGGER.debug((Object)("reject: BasicProperty: " + basicProperty));
        this.transitionWorkFlow();
        if (WORKFLOW_END.equalsIgnoreCase(this.property.getState().getValue())) {
            basicProperty.getProperty().setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            this.property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.setAckMessage(MSG_REJECT_SUCCESS);
            this.propertyImplService.update((Object)this.property);
            this.basicPropertyService.update((Object)basicProperty);
        } else {
            this.setAckMessage(" Change Property Rejected Successfully  and forwarded to initiator : " + this.property.getCreatedBy().getUsername());
        }
        this.LOGGER.debug((Object)("reject: BasicProperty: " + basicProperty + "AckMessage: " + this.getAckMessage()));
        this.LOGGER.debug((Object)"reject: Change Property rejection ended");
        return FORWARD_ACK;
    }

    public void prepare() {
        this.LOGGER.debug((Object)("Entered into prepare, ModelId: " + this.getModelId() + ", IndexNumber: " + this.indexNumber));
        if (this.getModelId() != null && !this.getModelId().isEmpty()) {
            this.property = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            this.LOGGER.debug((Object)("prepare: Property by model id: " + this.property));
        }
        if (this.indexNumber != null && !this.indexNumber.equals("")) {
            this.basicProperty = (BasicProperty)this.basicPropertyService.findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.indexNumber});
            this.LOGGER.debug((Object)("prepare: BasicProperty by index number : " + this.basicProperty));
        }
        this.setupWorkflowDetails();
        this.setUserInfo();
        this.LOGGER.debug((Object)"Exit from prepare");
    }

    public void validate() {
        String mobNo;
        String pincode;
        this.LOGGER.debug((Object)("Entered into the validate method Address : " + this.address.getLandmark() + " HouseNo" + this.address.getHouseNoBldgApt() + "DoorNumOld " + " PinCode" + this.address.getPinCode()));
        if (this.address.getLandmark() == null || StringUtils.equals((String)this.address.getLandmark(), (String)"") || StringUtils.isEmpty((String)this.address.getLandmark())) {
            this.addActionError(this.getText("mandatory.addr"));
        }
        if (this.address.getHouseNoBldgApt() == null || StringUtils.equals((String)this.address.getHouseNoBldgApt(), (String)"")) {
            this.addActionError(this.getText("mandatory.houseNo"));
        } else {
            this.validateHouseNumber(this.basicProperty.getPropertyID().getWard().getId(), this.address.getHouseNoBldgApt(), this.basicProperty);
        }
        if (this.address.getPinCode() != null && !(pincode = StringUtils.trim((String)this.address.getPinCode().toString())).equals("") && pincode.length() < 6) {
            this.addActionError(this.getText("mandatory.pincode.size"));
        }
        if ((mobNo = StringUtils.trim((String)this.address.getUser().getMobileNumber())) != null && !mobNo.equals("") && mobNo.length() < 10) {
            this.addActionError(this.getText("mandatory.mobileNo.size"));
        }
        super.validate();
        this.newForm();
        this.LOGGER.debug((Object)"Exit from validate method");
    }

    private void transitionWorkFlow() {
        this.LOGGER.debug((Object)"Entered method : transitionWorkFlow");
        if (this.workflowBean == null) {
            this.LOGGER.debug((Object)"transitionWorkFlow: workflowBean is NULL");
        } else {
            this.LOGGER.debug((Object)("transitionWorkFlow - action : " + this.workflowBean.getActionName() + "property: " + this.property));
        }
        this.LOGGER.debug((Object)("transitionWorkFlow: Property transitioned to " + this.property.getState().getValue()));
        this.propertyImplService.persist((Object)this.property);
        this.LOGGER.debug((Object)"Exiting method : transitionWorkFlow");
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public PropertyAddress getAddress() {
        return this.address;
    }

    public void setAddress(PropertyAddress address) {
        this.address = address;
    }

    public Integer getArea() {
        return this.area;
    }

    public void setArea(Integer area) {
        this.area = area;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public PersistenceService<BasicProperty, Long> getBasicPropertyService() {
        return this.basicPropertyService;
    }

    public void setPropertyImplService(PersistenceService<Property, Long> propertyImplService) {
        this.propertyImplService = propertyImplService;
    }

    public PropertyAddress getAddr() {
        return this.addr;
    }

    public void setAddr(PropertyAddress addr) {
        this.addr = addr;
    }

    public void setProperty(PropertyImpl property) {
        this.property = property;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public StateAware getModel() {
        return null;
    }
}

