/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.common;

import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.actions.common.AjaxCommonAction;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyDocs;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.WorkflowBean;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.SMSEmailService;
import org.egov.ptis.master.service.PropertyUsageService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class PropertyTaxBaseAction
extends GenericWorkFlowAction {
    private static Logger LOGGER = Logger.getLogger(PropertyTaxBaseAction.class);
    private static final long serialVersionUID = 1L;
    protected Boolean isApprPageReq = Boolean.TRUE;
    protected String indexNumber;
    protected String modelId;
    protected String userRole;
    protected String ackMessage;
    protected String userDesgn;
    protected String wfErrorMsg;
    final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;
    @Autowired
    protected EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private EmployeeService employeeService;
    private SMSEmailService sMSEmailService;
    protected PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionMasterService positionMasterService;
    private PropertyImpl propertyModel;
    protected WorkflowBean workflowBean;
    @Autowired
    private PropertyUsageService propertyUsageService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    private List<File> uploads = new ArrayList();
    private List<String> uploadFileNames = new ArrayList();
    private List<String> uploadContentTypes = new ArrayList();
    protected Map<String, BigDecimal> propertyTaxDetailsMap = new HashMap(0);
    protected List<Hashtable<String, Object>> historyMap = new ArrayList();
    protected Boolean propertyByEmployee = Boolean.TRUE;

    public List<File> getUpload() {
        return this.uploads;
    }

    public void setUpload(List<File> uploads) {
        this.uploads = uploads;
    }

    public List<String> getUploadFileName() {
        return this.uploadFileNames;
    }

    public void setUploadFileName(List<String> uploadFileNames) {
        this.uploadFileNames = uploadFileNames;
    }

    public List<String> getUploadContentType() {
        return this.uploadContentTypes;
    }

    public void setUploadContentType(List<String> contentTypes) {
        this.uploadContentTypes = contentTypes;
    }

    protected void processAndStoreDocumentsWithReason(BasicProperty basicProperty, String reason) {
        if (!this.uploads.isEmpty()) {
            int fileCount = 0;
            for (File file : this.uploads) {
                FileStoreMapper fileStore = this.fileStoreService.store(file, (String)this.uploadFileNames.get(fileCount), (String)this.uploadContentTypes.get(fileCount++), "PTIS");
                PropertyDocs propertyDoc = new PropertyDocs();
                propertyDoc.setSupportDoc(fileStore);
                propertyDoc.setBasicProperty(basicProperty);
                propertyDoc.setReason(reason);
                basicProperty.addDocs(propertyDoc);
            }
        }
    }

    public void validate() {
    }

    protected List<StateHistory> setUpWorkFlowHistory(Long stateId) {
        List workflowHisObj = this.inboxRenderServiceDeligate.getWorkflowHistory(stateId);
        this.workflowBean.setWorkFlowHistoryItems(workflowHisObj);
        return workflowHisObj;
    }

    protected void setupWorkflowDetails() {
        LOGGER.debug((Object)"Entered into setupWorkflowDetails | Start");
        if (this.workflowBean != null) {
            LOGGER.debug((Object)("setupWorkflowDetails: Department: " + this.workflowBean.getDepartmentId() + " Designation: " + this.workflowBean.getDesignationId()));
        }
        AjaxCommonAction ajaxCommonAction = new AjaxCommonAction();
        ajaxCommonAction.setPersistenceService(this.persistenceService);
        ajaxCommonAction.setDesignationService(new DesignationService());
        ajaxCommonAction.setAssignmentService(this.getAssignmentService());
        List departmentsForLoggedInUser = Collections.EMPTY_LIST;
        departmentsForLoggedInUser = this.propertyTaxUtil.getDepartmentsForLoggedInUser(this.securityUtils.getCurrentUser());
        this.workflowBean.setDepartmentList(departmentsForLoggedInUser);
        this.workflowBean.setDesignationList(Collections.EMPTY_LIST);
        this.workflowBean.setAppoverUserList(Collections.EMPTY_LIST);
        LOGGER.debug((Object)"Exiting from setupWorkflowDetails | End");
    }

    protected void validateProperty(Property property, String areaOfPlot, String dateOfCompletion, String eastBoundary, String westBoundary, String southBoundary, String northBoundary, String propTypeId, String zoneId, String propOccId, Long floorTypeId, Long roofTypeId, Long wallTypeId, Long woodTypeId, String modifyRsn, Date propCompletionDate) {
        PropertyTypeMaster propTypeMstr;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into validateProperty");
        }
        if (propTypeId == null || propTypeId.equals("-1")) {
            this.addActionError(this.getText("mandatory.propType"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)property.getPropertyDetail().getCategoryType()) || property.getPropertyDetail().getCategoryType().equals("-1")) {
            this.addActionError(this.getText("mandatory.propcatType"));
        }
        if (propTypeId != null && !propTypeId.equals("-1") && (propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(propTypeId)})) != null) {
            PropertyDetail propertyDetail = property.getPropertyDetail();
            Date regDocDate = property.getBasicProperty().getRegdDocDate();
            if (propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                if (null != propertyDetail) {
                    this.validateVacantProperty(propertyDetail, eastBoundary, westBoundary, southBoundary, northBoundary, modifyRsn, propCompletionDate);
                }
            } else if (null != propertyDetail.isAppurtenantLandChecked()) {
                this.validateVacantProperty(propertyDetail, eastBoundary, westBoundary, southBoundary, northBoundary, modifyRsn, propCompletionDate);
                this.validateBuiltUpProperty(propertyDetail, floorTypeId, roofTypeId, areaOfPlot, regDocDate, modifyRsn);
            } else {
                this.validateBuiltUpProperty(propertyDetail, floorTypeId, roofTypeId, areaOfPlot, regDocDate, modifyRsn);
            }
            this.validateFloor(propTypeMstr, property.getPropertyDetail().getFloorDetailsProxy(), property, areaOfPlot, regDocDate, modifyRsn, propCompletionDate);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from validateProperty");
        }
    }

    private void validateVacantProperty(PropertyDetail propertyDetail, String eastBoundary, String westBoundary, String southBoundary, String northBoundary, String modifyRsn, Date propCompletionDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into validateVacantProperty");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propertyDetail.getSurveyNumber())) {
            this.addActionError(this.getText("mandatory.surveyNo"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propertyDetail.getPattaNumber())) {
            this.addActionError(this.getText("mandatory.pattaNum"));
        }
        if (null == propertyDetail.getSitalArea().getArea()) {
            this.addActionError(this.getText("mandatory.vacantLandArea"));
        }
        if (null == propertyDetail.getDateOfCompletion()) {
            this.addActionError(this.getText("mandatory.dtOfCmpln"));
        }
        if (null == propertyDetail.getCurrentCapitalValue()) {
            this.addActionError(this.getText("mandatory.capitalValue"));
        }
        if (null == propertyDetail.getMarketValue()) {
            this.addActionError(this.getText("mandatory.marketValue"));
        }
        if (propertyDetail.getCurrentCapitalValue() != null && propertyDetail.getCurrentCapitalValue() < Double.parseDouble("500")) {
            this.addActionError(this.getText("minvalue.capitalValue"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)eastBoundary)) {
            this.addActionError(this.getText("mandatory.eastBoundary"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)westBoundary)) {
            this.addActionError(this.getText("mandatory.westBoundary"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)southBoundary)) {
            this.addActionError(this.getText("mandatory.southBoundary"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)northBoundary)) {
            this.addActionError(this.getText("mandatory.northBoundary"));
        }
        if (null != modifyRsn && null != propCompletionDate && null != propCompletionDate && propertyDetail.getDateOfCompletion() != null && !DateUtils.compareDates((Date)propertyDetail.getDateOfCompletion(), (Date)propCompletionDate)) {
            this.addActionError(this.getText("modify.vacant.completiondate.validate"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from validateVacantProperty");
        }
    }

    private void validateBuiltUpProperty(PropertyDetail propertyDetail, Long floorTypeId, Long roofTypeId, String areaOfPlot, Date regDocDate, String modifyRsn) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Eneterd into validateBuiltUpProperty");
        }
        if (propertyDetail.isStructure() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propertyDetail.getSiteOwner())) {
            this.addActionError(this.getText("mandatory.siteowner"));
        }
        if (null != propertyDetail.isAppurtenantLandChecked() && null == propertyDetail.getExtentAppartenauntLand()) {
            this.addActionError(this.getText("mandatory.extentAppartnant"));
        } else if (null == propertyDetail.isAppurtenantLandChecked() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)areaOfPlot)) {
            this.addActionError(this.getText("mandatory.extentsite"));
        } else if (null == propertyDetail.isAppurtenantLandChecked() && ("".equals(areaOfPlot) || Double.valueOf(areaOfPlot) == 0.0)) {
            this.addActionError(this.getText("mandatory.extentsite.greaterthanzero"));
        }
        if (floorTypeId == null || floorTypeId == -1L) {
            this.addActionError(this.getText("mandatory.floorType"));
        }
        if (roofTypeId == null || roofTypeId == -1L) {
            this.addActionError(this.getText("mandatory.roofType"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from validateBuiltUpProperty");
        }
    }

    private void validateFloor(PropertyTypeMaster propTypeMstr, List<Floor> floorList, Property property, String areaOfPlot, Date regDocDate, String modifyRsn, Date propCompletionDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into validateFloor \nPropertyTypeMaster:" + propTypeMstr + ", No of floors: " + (floorList != null ? floorList : BigDecimal.ZERO)));
        }
        if (!propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND") && floorList != null && floorList.size() > 0) {
            for (Floor floor : floorList) {
                PropertyUsage pu;
                ArrayList<String> msgParams = null;
                if (floor == null) continue;
                boolean buildingPlanNoValidationAdded = false;
                boolean buildingPlanDateValidationAdded = false;
                boolean buildingPlanPlinthAreaValidationAdded = false;
                msgParams = new ArrayList<String>();
                if (floor.getFloorNo() == null || floor.getFloorNo().equals(-10)) {
                    this.addActionError(this.getText("mandatory.floorNO"));
                }
                msgParams.add(floor.getFloorNo() != null ? (String)PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()) : "N/A");
                if (floor.getStructureClassification() == null || floor.getStructureClassification().getId() == null || floor.getStructureClassification().getId().toString().equals("-1")) {
                    this.addActionError(this.getText("mandatory.constType", msgParams));
                }
                if (floor.getUnstructuredLand().booleanValue()) {
                    if (floor.getBuiltUpArea() == null || floor.getBuiltUpArea().getLength() == null || floor.getBuiltUpArea().getLength().equals("")) {
                        this.addActionError(this.getText("mandatory.assbleLength", msgParams));
                    }
                    if (floor.getBuiltUpArea() == null || floor.getBuiltUpArea().getBreadth() == null || floor.getBuiltUpArea().getBreadth().equals("")) {
                        this.addActionError(this.getText("mandatory.assbleWidth", msgParams));
                    }
                }
                if (floor.getPropertyUsage() == null || null == floor.getPropertyUsage().getId() || floor.getPropertyUsage().getId().toString().equals("-1")) {
                    this.addActionError(this.getText("mandatory.floor.usage", msgParams));
                }
                if (StringUtils.isNotBlank((String)floor.getBuildingPermissionNo())) {
                    if (floor.getBuildingPermissionDate() == null) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.date", msgParams));
                        buildingPlanDateValidationAdded = true;
                    }
                    if (floor.getBuildingPlanPlinthArea().getArea() == null) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.plintharea", msgParams));
                        buildingPlanPlinthAreaValidationAdded = true;
                    }
                }
                if (floor.getBuildingPermissionDate() != null) {
                    if (StringUtils.isBlank((String)floor.getBuildingPermissionNo())) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.number", msgParams));
                        buildingPlanNoValidationAdded = true;
                    }
                    if (floor.getBuildingPlanPlinthArea().getArea() == null && !buildingPlanPlinthAreaValidationAdded) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.plintharea", msgParams));
                    }
                }
                if (floor.getBuildingPlanPlinthArea().getArea() != null) {
                    if (floor.getBuildingPermissionDate() == null && !buildingPlanDateValidationAdded) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.date", msgParams));
                    }
                    if (StringUtils.isBlank((String)floor.getBuildingPermissionNo()) && !buildingPlanNoValidationAdded) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.number", msgParams));
                    }
                }
                if ((floor.getFirmName() == null || floor.getFirmName().isEmpty() || floor.getFirmName().equals("")) && floor.getPropertyUsage() != null && null != floor.getPropertyUsage().getId() && !floor.getPropertyUsage().getId().toString().equals("-1") && (pu = this.propertyUsageService.findById(Long.valueOf(floor.getPropertyUsage().getId()))) != null && !pu.getUsageName().equalsIgnoreCase("Residence")) {
                    this.addActionError(this.getText("mandatory.floor.firmName", msgParams));
                }
                if (floor.getPropertyOccupation() == null || null == floor.getPropertyOccupation().getId() || floor.getPropertyOccupation().getId().toString().equals("-1")) {
                    this.addActionError(this.getText("mandatory.floor.occ"));
                }
                Date effDate = this.propertyTaxUtil.getEffectiveDateForProperty();
                if (floor.getOccupancyDate() == null || floor.getOccupancyDate().equals("")) {
                    this.addActionError(this.getText("mandatory.floor.docOcc"));
                }
                if (floor.getOccupancyDate() != null && !floor.getOccupancyDate().equals("")) {
                    if (floor.getOccupancyDate().after(new Date())) {
                        this.addActionError(this.getText("mandatory.dtFlrBeforeCurr"));
                    }
                    if (floor.getOccupancyDate().before(effDate)) {
                        this.addActionError(this.getText("constrDate.before.6inst", msgParams));
                    }
                }
                if (floor.getBuiltUpArea() == null || floor.getBuiltUpArea().getArea() == null || floor.getBuiltUpArea().getArea().equals("")) {
                    this.addActionError(this.getText("mandatory.assbleArea"));
                } else if (StringUtils.isNotBlank((String)areaOfPlot) && (double)floor.getBuiltUpArea().getArea().floatValue() > Double.valueOf(areaOfPlot)) {
                    this.addActionError(this.getText("assbleArea.notgreaterthan.extentsite"));
                }
                if ((modifyRsn == null || modifyRsn != null && !modifyRsn.equals("ADD_OR_ALTER") && !modifyRsn.equals("BIFURCATE")) && null != regDocDate && null != floor.getOccupancyDate() && !floor.getOccupancyDate().equals("") && DateUtils.compareDates((Date)regDocDate, (Date)floor.getOccupancyDate())) {
                    this.addActionError(this.getText("regDate.notgreaterthan.occDate", msgParams));
                }
                if (null == modifyRsn || null == propCompletionDate || null == propCompletionDate || floor.getOccupancyDate() == null || floor.getOccupancyDate().equals("") || DateUtils.compareDates((Date)floor.getOccupancyDate(), (Date)propCompletionDate)) continue;
                this.addActionError(this.getText("modify.builtup.occDate.validate", msgParams));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from validate");
        }
    }

    protected void validateHouseNumber(Long wardId, String houseNo, BasicProperty basicProperty) {
        Query qry = this.getPersistenceService().getSession().createQuery("from BasicPropertyImpl bp where bp.address.houseNoBldgApt = :houseNo and bp.boundary.id = :wardId and bp.active = 'Y'");
        qry.setParameter("houseNo", (Object)houseNo);
        qry.setParameter("wardId", (Object)wardId);
        if (!qry.list().isEmpty() && (basicProperty == null || basicProperty != null && !basicProperty.getAddress().getHouseNoBldgApt().equals(houseNo))) {
            this.addActionError(this.getText("houseNo.unique"));
        }
    }

    public void setUserInfo() {
        Designation designation;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into setUserInfo");
        }
        Long userId = this.securityUtils.getCurrentUser().getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("setUserInfo: Logged in userId" + userId));
        }
        if ((designation = this.propertyTaxUtil.getDesignationForUser(userId)) != null) {
            this.setUserDesgn(designation.getName());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from setUserInfo");
        }
    }

    public void transitionWorkFlow(PropertyImpl property) {
        String approvalmesg;
        Assignment assignment;
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        String nature = this.getNatureOfTask();
        if (!this.propertyByEmployee.booleanValue()) {
            this.currentState = "Created";
            assignment = this.propertyService.getUserPositionByZone(property.getBasicProperty());
            if (null != assignment) {
                this.approverPositionId = assignment.getPosition().getId();
                this.approverName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
            }
        } else {
            this.currentState = null;
            if (null != this.approverPositionId && this.approverPositionId != -1L) {
                assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(this.approverPositionId, new Date()).get(0);
                this.approverName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
            }
        }
        if (null != property.getId()) {
            wfInitiator = this.propertyService.getWorkflowInitiator(property);
        }
        if ("Reject".equalsIgnoreCase(this.workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                property.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withDateInfo(currentDate.toDate());
                property.setStatus(PropertyTaxConstants.STATUS_CANCELLED);
                property.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
            } else {
                String stateValue = property.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                property.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Assistant Approval Pending");
            }
        } else {
            WorkFlowMatrix wfmatrix;
            pos = null != this.approverPositionId && this.approverPositionId != -1L ? (Position)this.persistenceService.find("from Position where id=?", new Object[]{this.approverPositionId}) : ("Approve".equalsIgnoreCase(this.workFlowAction) ? this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId()) : wfInitiator.getPosition());
            if (null == property.getState()) {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(nature);
            } else if (property.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                property.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withDateInfo(currentDate.toDate());
            } else {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, this.getAdditionalRule(), property.getCurrentState().getValue(), null);
                property.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
        if (this.approverName != null && !this.approverName.isEmpty() && !this.approverName.equalsIgnoreCase("----Choose----")) {
            approvalmesg = " Succesfully Forwarded to : ";
            this.ackMessage = this.ackMessage == null ? " Succesfully Forwarded to : " : this.ackMessage + " Succesfully Forwarded to : ";
        } else if (this.workFlowAction != null && this.workFlowAction.equalsIgnoreCase("cancel")) {
            approvalmesg = " Succesfully Cancelled.";
            this.ackMessage = this.ackMessage == null ? " Succesfully Cancelled." : this.ackMessage + " Succesfully Cancelled.";
        }
        LOGGER.debug((Object)"Exiting method : transitionWorkFlow");
    }

    private String getNatureOfTask() {
        String nature = "NEW ASSESSMENT".equalsIgnoreCase(this.getAdditionalRule()) ? "New Assessment" : ("ALTER ASSESSMENT".equalsIgnoreCase(this.getAdditionalRule()) ? "Addition/Alteration" : ("BIFURCATE ASSESSMENT".equalsIgnoreCase(this.getAdditionalRule()) ? "Bifurcation" : ("DEMOLITION".equalsIgnoreCase(this.getAdditionalRule()) ? "Demolition" : ("EXEMPTION".equalsIgnoreCase(this.getAdditionalRule()) ? "Tax Exemption" : ("GENERAL REVISION PETITION".equalsIgnoreCase(this.getAdditionalRule()) ? "General Revision Petition" : "PropertyImpl")))));
        return nature;
    }

    public void validateApproverDetails() {
        if (("Forward".equals(this.workFlowAction) || "Save".equals(this.workFlowAction)) && null != this.approverPositionId && this.approverPositionId == -1L) {
            this.addActionError(this.getText("property.workflow.approver.errormessage"));
        }
        if ("Reject".equals(this.workFlowAction) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.approverComments)) {
            this.addActionError(this.getText("property.workflow.remarks"));
        }
    }

    public void buildEmailandSms(PropertyImpl property, String applicationType) {
        User user = property.getBasicProperty().getPrimaryOwner();
        String mobileNumber = user.getMobileNumber();
        String emailid = user.getEmailId();
        String applicantName = user.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(applicantName);
        String smsMsg = "";
        String emailSubject = "";
        String emailBody = "";
        Map demandCollMap = this.ptDemandDAO.getDemandCollMap((Property)property);
        if (null != property && null != property.getState()) {
            State propertyState = property.getState();
            if (propertyState.getValue().endsWith("Assistant Approved")) {
                args.add(property.getApplicationNo());
                if ("New_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.newpropertycreate.sms", args);
                    }
                    if (emailid != null) {
                        args.add(ApplicationThreadLocals.getMunicipalityName());
                        emailSubject = this.getText("msg.newpropertycreate.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.newpropertycreate.email", args);
                    }
                } else if ("Alter_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.alterAssessmentForward.sms", args);
                    }
                    if (emailid != null) {
                        args.add(ApplicationThreadLocals.getMunicipalityName());
                        emailSubject = this.getText("msg.alterAssessmentForward.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.alterAssessmentForward.email", args);
                    }
                } else if ("General_Revision_Petition".equals(applicationType)) {
                    smsMsg = this.getText("msg.grpcreate.sms", args);
                    args.add(ApplicationThreadLocals.getMunicipalityName());
                    emailSubject = this.getText("msg.grpcreate.email.subject", new String[]{property.getApplicationNo()});
                    emailBody = this.getText("msg.grpcreate.email", args);
                }
            } else if (propertyState.getValue().endsWith("Rejected")) {
                args.add(property.getApplicationNo());
                args.add(ApplicationThreadLocals.getMunicipalityName());
                if ("New_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.newpropertyreject.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.newpropertyreject.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.newpropertyreject.email", args);
                    }
                } else if ("Alter_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.alterAssessmentReject.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.alterAssessmentReject.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.alterAssessmentReject.email", args);
                    }
                } else if ("General_Revision_Petition".equals(applicationType)) {
                    smsMsg = this.getText("msg.grpreject.sms", args);
                    emailSubject = this.getText("msg.grpreject.email.subject", new String[]{property.getApplicationNo()});
                    emailBody = this.getText("msg.grpreject.email", args);
                }
            } else if (propertyState.getValue().endsWith("Commissioner Approved")) {
                args.add(property.getBasicProperty().getUpicNo());
                args.add(((BigDecimal)demandCollMap.get("CURR_FIRSTHALF_DMD")).add((BigDecimal)demandCollMap.get("ARR_DMD")).toString());
                args.add(DateUtils.getFormattedDate((Date)property.getBasicProperty().getPropOccupationDate(), (String)"dd/MM/yyyy"));
                args.add(ApplicationThreadLocals.getMunicipalityName());
                if ("New_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.newpropertyapprove.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.newpropertyapprove.email.subject", new String[]{property.getBasicProperty().getUpicNo()});
                        emailBody = this.getText("msg.newpropertyapprove.email", args);
                    }
                } else if ("Alter_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.alterAssessmentApprove.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.alterAssessmentApprove.email.subject");
                        emailBody = this.getText("msg.alterAssessmentApprove.email", args);
                    }
                } else if ("General_Revision_Petition".equals(applicationType)) {
                    smsMsg = this.getText("msg.grpapprove.sms", args);
                    emailSubject = this.getText("msg.grpapprove.email.subject", new String[]{property.getApplicationNo()});
                    emailBody = this.getText("msg.grpapprove.email", args);
                }
            }
        }
        if (mobileNumber != null) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
        if (emailid != null) {
            this.messagingService.sendEmail(emailid, emailSubject, emailBody);
        }
    }

    public void preparePropertyTaxDetails(Property property) {
        Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
        Installment installmentSecondHalf = (Installment)installmentMap.get("Current 2nd Half");
        Map demandCollMap = null;
        if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForWorkflowProperty(property, installmentFirstHalf, installmentFirstHalf);
        } else if (DateUtils.between((Date)new Date(), (Date)installmentSecondHalf.getFromDate(), (Date)installmentSecondHalf.getToDate())) {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForWorkflowProperty(property, installmentFirstHalf, installmentSecondHalf);
        }
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (null != ptDemand && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            this.propertyTaxDetailsMap.put("ARV", ptDemand.getDmdCalculations().getAlv());
        } else {
            this.propertyTaxDetailsMap.put("ARV", BigDecimal.ZERO);
        }
        this.propertyTaxDetailsMap.put("eduCess", demandCollMap.get("Education Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Education Cess"));
        this.propertyTaxDetailsMap.put("libraryCess", demandCollMap.get("Library Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Library Cess"));
        BigDecimal totalTax = BigDecimal.ZERO;
        if (!property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.propertyTaxDetailsMap.put("generalTax", demandCollMap.get("General Tax"));
            totalTax = ((BigDecimal)demandCollMap.get("General Tax")).add(demandCollMap.get("Education Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Education Cess")).add(demandCollMap.get("Library Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Library Cess"));
            if (demandCollMap.get("Unauthorized Penalty") != null) {
                this.propertyTaxDetailsMap.put("unauthorisedPenalty", demandCollMap.get("Unauthorized Penalty"));
                this.propertyTaxDetailsMap.put("totalTax", totalTax.add((BigDecimal)demandCollMap.get("Unauthorized Penalty")));
            } else {
                this.propertyTaxDetailsMap.put("totalTax", totalTax);
            }
        } else {
            this.propertyTaxDetailsMap.put("vacantLandTax", demandCollMap.get("Vacant Land Tax") != null ? (BigDecimal)demandCollMap.get("Vacant Land Tax") : (BigDecimal)demandCollMap.get("General Tax"));
            totalTax = (demandCollMap.get("Vacant Land Tax") != null ? (BigDecimal)demandCollMap.get("Vacant Land Tax") : (BigDecimal)demandCollMap.get("General Tax")).add(demandCollMap.get("Education Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Education Cess")).add(demandCollMap.get("Library Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Library Cess"));
            if (demandCollMap.get("Unauthorized Penalty") != null) {
                this.propertyTaxDetailsMap.put("unauthorisedPenalty", demandCollMap.get("Unauthorized Penalty"));
                this.propertyTaxDetailsMap.put("totalTax", totalTax.add((BigDecimal)demandCollMap.get("Unauthorized Penalty")));
            } else {
                this.propertyTaxDetailsMap.put("totalTax", totalTax);
            }
            this.propertyTaxDetailsMap.put("totalTax", totalTax);
        }
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public String getUserDesgn() {
        return this.userDesgn;
    }

    public void setUserDesgn(String userDesgn) {
        this.userDesgn = userDesgn;
    }

    public Boolean getIsApprPageReq() {
        return this.isApprPageReq;
    }

    public void setIsApprPageReq(Boolean isApprPageReq) {
        this.isApprPageReq = isApprPageReq;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public void setIndexNumber(String indexNumber) {
        this.indexNumber = indexNumber;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public AssignmentService getAssignmentService() {
        return this.assignmentService;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public String getApproverName() {
        return this.approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public SimpleWorkflowService<PropertyImpl> getPropertyWorkflowService() {
        return this.propertyWorkflowService;
    }

    public void setPropertyWorkflowService(SimpleWorkflowService<PropertyImpl> propertyWorkflowService) {
        this.propertyWorkflowService = propertyWorkflowService;
    }

    public SMSEmailService getsMSEmailService() {
        return this.sMSEmailService;
    }

    public void setsMSEmailService(SMSEmailService sMSEmailService) {
        this.sMSEmailService = sMSEmailService;
    }

    public Boolean getPropertyByEmployee() {
        return this.propertyByEmployee;
    }

    public void setPropertyByEmployee(Boolean propertyByEmployee) {
        this.propertyByEmployee = propertyByEmployee;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public PropertyImpl getProperty() {
        return this.propertyModel;
    }

    public void setProperty(PropertyImpl property) {
        this.propertyModel = property;
    }

    public String getWfErrorMsg() {
        return this.wfErrorMsg;
    }

    public void setWfErrorMsg(String wfErrorMsg) {
        this.wfErrorMsg = wfErrorMsg;
    }

    public List<Hashtable<String, Object>> getHistoryMap() {
        return this.historyMap;
    }

    public void setHistoryMap(List<Hashtable<String, Object>> historyMap) {
        this.historyMap = historyMap;
    }
}

