/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.collection;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.service.collection.PropertyTaxCollection;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Namespace(value="/collection")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name="view", location="collection/collectPropertyTax-view.jsp"), @Result(name="error", location="collection/collectPropertyTax-error.jsp")})
@ParentPackage(value="egov")
public class CollectPropertyTaxAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CollectPropertyTaxAction.class);
    public static final String RESULT_VIEW = "view";
    public static final String RESULT_ERROR = "error";
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private PropertyTaxCollection propertyTaxCollection;
    private PTBillServiceImpl ptBillServiceImpl;
    private PropertyTaxUtil propertyTaxUtil;
    private String propertyId;
    private String collectXML = "";
    private Boolean levyPenalty = false;
    private String errorMsg;
    private Boolean isAssessmentNoValid = Boolean.FALSE;
    private String infoMessage;
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final List<String> args = new ArrayList();
    @Autowired
    private PropertyTaxBillable propertyTaxBillable;
    @Qualifier(value="entityQueryService")
    @Autowired
    private PersistenceService entityQueryService;

    public Object getModel() {
        return null;
    }

    @Action(value="/collectPropertyTax-generateBill")
    public String generateBill() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered method generatePropertyTaxBill, Generating bill for index no : " + this.propertyId));
        }
        if (this.propertyId == null || this.propertyId.isEmpty()) {
            this.setErrorMsg(this.getText("mandatory.assessmentNo"));
            return RESULT_ERROR;
        }
        BasicProperty basicProperty = (BasicProperty)this.basicPropertyService.findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.propertyId});
        if (basicProperty == null) {
            this.setErrorMsg(this.getText("validation.property.doesnot.exists"));
            return RESULT_ERROR;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("generatePropertyTaxBill : BasicProperty :" + basicProperty));
        }
        if (basicProperty.getProperty().getIsExemptedFromTax().booleanValue()) {
            this.args.add(this.propertyId);
            this.setErrorMsg(this.getText("msg.collection.tax.exempted", this.args));
            return RESULT_ERROR;
        }
        Map demandCollMap = this.propertyTaxUtil.getDemandAndCollection(basicProperty.getProperty());
        BigDecimal currDue = ((BigDecimal)demandCollMap.get("CURR_DMD")).subtract((BigDecimal)demandCollMap.get("CURR_COLL"));
        BigDecimal arrDue = ((BigDecimal)demandCollMap.get("ARR_DMD")).subtract((BigDecimal)demandCollMap.get("ARR_COLL"));
        BigDecimal advanceCollected = (BigDecimal)demandCollMap.get("ADVANCECOLLECTION");
        BigDecimal secondHalfTax = (BigDecimal)demandCollMap.get("CURR_SECONDHALF_DMD");
        BigDecimal actualAdvanceToBeCollected = secondHalfTax.multiply(new BigDecimal(PropertyTaxConstants.MAX_ADVANCES_ALLOWED));
        BigDecimal advanceBalance = actualAdvanceToBeCollected.subtract(advanceCollected);
        SQLQuery qry = this.entityQueryService.getSession().createSQLQuery("select i_asmtno, ts_dttm, (coalesce(d_crnpt,0) + coalesce(d_crned,0) + coalesce(d_crnlcs,0) + coalesce(d_crnuauthcnstplty,0)) from pt_extnasmtbal_tbl where (coalesce(d_crnpt,0)>0 or coalesce(d_crned,0)>0 or coalesce(d_crnlcs,0)>0 or coalesce(d_crnuauthcnstplty,0)>0) and i_asmtno =:propertyid");
        qry.setInteger("propertyid", Integer.valueOf(this.propertyId).intValue());
        List list = qry.list();
        if (list != null && list.size() > 0) {
            Object[] alters = (Object[])list.get(0);
            this.infoMessage = "This property undergone Adition/Alteration on " + this.dateFormat.format((Date)alters[1]) + " and the excess amount " + (BigDecimal)alters[2] + " was pending so, there might be difference in tax due compared to demand notice.";
        }
        if (currDue.compareTo(BigDecimal.ZERO) <= 0 && arrDue.compareTo(BigDecimal.ZERO) <= 0 && advanceBalance.compareTo(BigDecimal.ZERO) <= 0) {
            this.args.add(this.propertyId);
            this.isAssessmentNoValid = Boolean.TRUE;
            this.setErrorMsg(this.getText("msg.collection.fully.paid", this.args));
            return RESULT_ERROR;
        }
        this.propertyTaxBillable.setLevyPenalty(Boolean.valueOf(true));
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        this.propertyTaxBillable.setUserId(Long.valueOf(this.getSession().get("userid").toString()));
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateBillNumber(basicProperty.getPropertyID().getWard().getBoundaryNum().toString()));
        this.propertyTaxBillable.setBillType(this.propertyTaxUtil.getBillTypeByCode("AUTO"));
        String billXml = this.ptBillServiceImpl.getBillXML((Billable)this.propertyTaxBillable);
        try {
            this.collectXML = URLEncoder.encode(billXml, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Exiting method generatePropertyTaxBill, collectXML (before decode): " + billXml));
        }
        return RESULT_VIEW;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public void setCollectXML(String collectXML) {
        this.collectXML = collectXML;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public PropertyTaxNumberGenerator getPropertyTaxNumberGenerator() {
        return this.propertyTaxNumberGenerator;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public Boolean getLevyPenalty() {
        return this.levyPenalty;
    }

    public void setLevyPenalty(Boolean levyPenalty) {
        this.levyPenalty = levyPenalty;
    }

    public PropertyTaxCollection getPropertyTaxCollection() {
        return this.propertyTaxCollection;
    }

    public void setPropertyTaxCollection(PropertyTaxCollection propertyTaxCollection) {
        this.propertyTaxCollection = propertyTaxCollection;
    }

    public void setPtBillServiceImpl(PTBillServiceImpl ptBillServiceImpl) {
        this.ptBillServiceImpl = ptBillServiceImpl;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Boolean getIsAssessmentNoValid() {
        return this.isAssessmentNoValid;
    }

    public void setIsAssessmentNoValid(Boolean isAssessmentNoValid) {
        this.isAssessmentNoValid = isAssessmentNoValid;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public void setInfoMessage(String infoMessage) {
        this.infoMessage = infoMessage;
    }
}

