/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.admin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.domain.dao.property.BoundaryCategoryDao;
import org.egov.ptis.domain.entity.property.BoundaryCategory;
import org.egov.ptis.domain.entity.property.Category;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@ParentPackage(value="egov")
@Transactional(readOnly=true)
@Namespace(value="/admin")
@ResultPath(value="/WEB-INF/jsp/")
public class ChangeStreetRateAction
extends BaseFormAction {
    private Integer zoneId;
    private Integer wardId;
    private Integer areaId;
    private List<Map<String, String>> readOnlyFields = new ArrayList();
    private String usageFactor;
    private String structFactor;
    private Float currentRate;
    private String currLocFactor;
    private Float revisedRate;
    private String revisedLocFactor;
    private String searchValue;
    private String saveAction;
    private Boundary boundary;
    @Autowired
    private BoundaryCategoryDao boundaryCategoryDAO;
    @Autowired
    private BoundaryService boundaryService;
    private static final String SEARCH = "search";
    private static final String RESULTS = "results";
    private static final String ACK = "ack";
    private final Logger LOGGER = Logger.getLogger(this.getClass());

    public Object getModel() {
        return null;
    }

    @SkipValidation
    public void prepare() {
        this.LOGGER.debug((Object)"Entered into the prepare method");
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        this.LOGGER.debug((Object)("prepare : wards: " + (wardList != null ? wardList : BigDecimal.ZERO)));
        this.addDropdownData("Zone", zoneList);
        this.addDropdownData("wardList", wardList);
        this.prepareStreetDropDownData(this.wardId != null);
        this.addDropdownData("categoryList", Collections.EMPTY_LIST);
        this.LOGGER.debug((Object)"Exit from prepare method");
    }

    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        this.LOGGER.debug((Object)"Entered into the prepareWardDropDownData");
        if (zoneExists && wardExists) {
            List wardNewList = new ArrayList();
            wardNewList = this.getPersistenceService().findAllBy("from Boundary BI where BI.boundaryType.name=? and BI.parent.id = ? and BI.isHistory='N' order by BI.name ", new Object[]{"Ward", this.getZoneId().longValue()});
            this.LOGGER.debug((Object)("prepareWardDropDownData : No of wards in zone: " + this.getZoneId() + " are: " + (wardNewList != null ? Integer.valueOf(wardNewList.size()) : BigDecimal.ZERO)));
            this.addDropdownData("wardList", wardNewList);
        } else {
            this.addDropdownData("wardList", Collections.EMPTY_LIST);
        }
        this.LOGGER.debug((Object)"Exit from prepareWardDropDownData");
    }

    private void prepareAreaDropDownData(boolean wardExists, boolean areaExists) {
        this.LOGGER.debug((Object)"Entered into the prepareAreaDropDownData");
        if (wardExists && areaExists) {
            List areaNewList = new ArrayList();
            areaNewList = this.getPersistenceService().findAllBy("from Boundary BI where BI.boundaryType.name=? and BI.parent.id = ? and BI.isHistory='N' order by BI.name ", new Object[]{"Revenue Area", this.getWardId().longValue()});
            this.LOGGER.debug((Object)("prepareAreaDropDownData : No of areas in ward: " + this.getWardId() + " are: " + (areaNewList != null ? Integer.valueOf(areaNewList.size()) : BigDecimal.ZERO)));
            this.addDropdownData("areaList", areaNewList);
        } else {
            this.addDropdownData("areaList", Collections.EMPTY_LIST);
        }
        this.LOGGER.debug((Object)"Exit from prepareAreaDropDownData");
    }

    private void prepareStreetDropDownData(boolean wardExists) {
        this.LOGGER.debug((Object)"Entered into the prepareAreaDropDownData");
        if (wardExists) {
            List streetList = new ArrayList();
            streetList = this.getPersistenceService().findAllBy("select CH.child from CrossHierarchy CH where CH.parent.id = ? ", new Object[]{this.getWardId().longValue()});
            this.LOGGER.debug((Object)("prepareStreetDropDownData : No of areas in ward: " + this.getWardId() + " are: " + (streetList != null ? Integer.valueOf(streetList.size()) : BigDecimal.ZERO)));
            this.addDropdownData("streetList", streetList);
        } else {
            this.addDropdownData("streetList", Collections.EMPTY_LIST);
        }
        this.LOGGER.debug((Object)"Exit from prepareStreetDropDownData");
    }

    @Action(value="/changeStreetRate-searchForm", results={@Result(name="search", location="admin/changeStreetRate-search.jsp")})
    public String searchForm() {
        this.LOGGER.debug((Object)"Entered into searchForm");
        this.LOGGER.debug((Object)"Exit from searchForm");
        return SEARCH;
    }

    @ValidationErrorPage(value="search")
    @Action(value="/changeStreetRate-search", results={@Result(name="results", location="admin/changeStreetRate-results.jsp")})
    public String search() {
        this.LOGGER.debug((Object)"Enered into search");
        this.LOGGER.debug((Object)"Exit from search");
        return this.searchForCategories();
    }

    @SkipValidation
    @ValidationErrorPage(value="search")
    @Action(value="/changeStreetRate-showSearchResults", results={@Result(name="results", location="admin/changeStreetRate-results.jsp")})
    public String showSearchResults() {
        return this.searchForCategories();
    }

    private String searchForCategories() {
        this.LOGGER.debug((Object)("searchForCategories, areaId:" + this.areaId));
        if (this.areaId != null) {
            this.boundary = this.boundaryService.getBoundaryById(Long.valueOf(this.areaId.longValue()));
        }
        try {
            List list = this.boundaryCategoryDAO.getCategoriesByBoundry(this.boundary);
            HashMap<String, String> fields = null;
            for (Category cat : list) {
                if (cat != null) {
                    fields = new HashMap<String, String>();
                    if (cat.getPropUsage() != null) {
                        fields.put("usageFactor", cat.getPropUsage().getUsageName());
                    }
                    if (cat.getStructureClass() != null) {
                        fields.put("structFactor", cat.getStructureClass().getTypeName());
                    }
                    fields.put("currentRate", cat.getCategoryAmount().toString());
                    fields.put("currLocFactor", cat.getCategoryName());
                }
                this.readOnlyFields.add(fields);
            }
            if (this.boundary != null) {
                this.LOGGER.debug((Object)(this.readOnlyFields.size() + " Categories for " + this.boundary.getName()));
            } else {
                this.LOGGER.debug((Object)"boundary is NULL");
            }
            this.setSearchValue(this.boundary.getName());
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ApplicationRuntimeException("Exception : " + e);
        }
        this.LOGGER.debug((Object)"Exit from search method");
        return RESULTS;
    }

    @Action(value="/changeStreetRate-editPage", results={@Result(name="edit", location="admin/changeStreetRate-edit.jsp")})
    public String editPage() {
        this.LOGGER.debug((Object)"ChangeStreetRateAction-editPage");
        this.LOGGER.debug((Object)"Exit from editPage");
        return "edit";
    }

    @ValidationErrorPage(value="edit")
    @Transactional
    @Action(value="/changeStreetRate-saveData", results={@Result(name="ack", location="admin/changeStreetRate-ack.jsp")})
    public String saveData() {
        this.LOGGER.debug((Object)("saveData : areaId:" + this.areaId + ", Current Location Factor:" + this.currLocFactor + ", Current Rate :" + this.currentRate + "Revised Location Factor: " + this.revisedLocFactor + "Revised Rate : " + this.revisedRate));
        if (this.areaId != null) {
            this.boundary = this.boundaryService.getBoundaryById(Long.valueOf(this.areaId.longValue()));
        }
        Category catOld = (Category)this.getPersistenceService().find("from Category c where c.categoryName=? and c.categoryAmount=?", new Object[]{this.currLocFactor, this.currentRate});
        this.LOGGER.debug((Object)("saveData : Category for CurrentLocationFactor: " + this.currLocFactor + "&" + "CurrentRate : " + catOld));
        Category catLocFactor = (Category)this.getPersistenceService().find("from Category c where c.id=?", new Object[]{Long.parseLong(this.revisedLocFactor)});
        this.LOGGER.debug((Object)("saveData : Category for RevisedLocationFactor: " + this.revisedLocFactor + ": " + catLocFactor));
        Category catRevised = null;
        if (catLocFactor != null) {
            catRevised = (Category)this.getPersistenceService().find("from Category c where c.categoryName=? and c.categoryAmount=?", new Object[]{catLocFactor.getCategoryName(), this.revisedRate});
            this.LOGGER.debug((Object)("saveData : Revised Category: " + catRevised));
        }
        BoundaryCategory bc = null;
        if (catOld != null && this.boundary != null) {
            bc = (BoundaryCategory)this.getPersistenceService().find("from BoundaryCategory bc where bc.bndry=? and bc.category=?", new Object[]{this.boundary, catOld});
            this.LOGGER.debug((Object)("saveData : BoundaryCategory for Category: " + catOld + " is " + bc));
        }
        if (bc != null) {
            bc.setCategory(catRevised);
            this.getPersistenceService().setType(BoundaryCategory.class);
            this.getPersistenceService().update(bc);
        }
        this.LOGGER.debug((Object)("saveData : BoundaryCategory after changing Category: " + bc));
        this.LOGGER.debug((Object)"Exit from saveData");
        return ACK;
    }

    public void validate() {
        this.LOGGER.debug((Object)("Entered into validate \n zoneId: " + this.zoneId + "wardId: " + this.wardId + " areaId: " + this.areaId + "revisedRate:" + this.revisedRate));
        if (this.zoneId != null && this.zoneId == -1) {
            this.addActionError(this.getText("mandatory.zone"));
        }
        if (this.wardId != null && this.wardId == -1) {
            this.addActionError(this.getText("mandatory.ward"));
        }
        if (this.areaId != null && this.areaId == -1) {
            this.addActionError(this.getText("mandatory.area"));
        }
        if (this.saveAction != null && StringUtils.equals((String)this.saveAction, (String)"saveData")) {
            if (this.revisedRate == null || (double)this.revisedRate.floatValue() == 0.0) {
                this.addActionError(this.getText("mandatory.revisedRate"));
            } else {
                Pattern p = Pattern.compile("[^0-9.]");
                Matcher m = p.matcher(this.revisedRate.toString());
                if (m.find()) {
                    this.addActionError(this.getText("mandatory.validRevisedRate"));
                }
            }
            if (this.revisedRate != null && this.revisedRate.floatValue() > 0.0f && (this.revisedLocFactor == null || StringUtils.isEmpty((String)this.revisedLocFactor) || StringUtils.equals((String)this.revisedLocFactor, (String)"-1"))) {
                this.addActionError(this.getText("mandatory.revisedLocFactor"));
            }
        }
        this.LOGGER.debug((Object)"Exit from validate");
    }

    public Integer getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Integer zoneId) {
        this.zoneId = zoneId;
    }

    public Integer getWardId() {
        return this.wardId;
    }

    public void setWardId(Integer wardId) {
        this.wardId = wardId;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public String getUsageFactor() {
        return this.usageFactor;
    }

    public void setUsageFactor(String usageFactor) {
        this.usageFactor = usageFactor;
    }

    public String getStructFactor() {
        return this.structFactor;
    }

    public void setStructFactor(String structFactor) {
        this.structFactor = structFactor;
    }

    public Float getCurrentRate() {
        return this.currentRate;
    }

    public void setCurrentRate(Float currentRate) {
        this.currentRate = currentRate;
    }

    public String getCurrLocFactor() {
        return this.currLocFactor;
    }

    public void setCurrLocFactor(String currLocFactor) {
        this.currLocFactor = currLocFactor;
    }

    public Float getRevisedRate() {
        return this.revisedRate;
    }

    public void setRevisedRate(Float revisedRate) {
        this.revisedRate = revisedRate;
    }

    public String getRevisedLocFactor() {
        return this.revisedLocFactor;
    }

    public void setRevisedLocFactor(String revisedLocFactor) {
        this.revisedLocFactor = revisedLocFactor;
    }

    public List<Map<String, String>> getReadOnlyFields() {
        return this.readOnlyFields;
    }

    public void setReadOnlyFields(List<Map<String, String>> readOnlyFields) {
        this.readOnlyFields = readOnlyFields;
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }

    public String getSaveAction() {
        return this.saveAction;
    }

    public void setSaveAction(String saveAction) {
        this.saveAction = saveAction;
    }
}

