/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.ptis.web.rest.RevisionPetitionAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/rv")
public class RevisionPetitionRestService {
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    String USER_NAME = "mahesh";
    String PASSWORD = "demo";
    String LOGIN_USERID = "16";

    @GET
    @Path(value="/restrevisionPetition/{applicationNumber}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String getRevisionPetitionDetails(@PathParam(value="applicationNumber") String appNumber) throws JsonGenerationException, JsonMappingException, IOException {
        RevisionPetition revisionPetition = this.revisionPetitionService.getRevisionPetitionByApplicationNumber(appNumber);
        if (revisionPetition != null) {
            return this.convertRevisionPetitionObjectToJson((Object)revisionPetition);
        }
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-21");
        errorDetails.setErrorMessage("Invalid Revision petition number.");
        return this.getJSONResponse((Object)errorDetails);
    }

    @POST
    @Path(value="/restrevisionPetition/createRevisionPetition")
    @Produces(value={"application/json"})
    public String createRevisionPetitionFromRest(@FormParam(value="accessmentnumber") String accessmentnumber, @FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="details") String details, @FormParam(value="receivedon") String receivedon, @FormParam(value="recievedBy") String recievedBy) throws JsonGenerationException, JsonMappingException, IOException {
        String responseJson = new String();
        Boolean isAuthenticatedUser = this.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            ApplicationThreadLocals.setUserId((Long)Long.valueOf(this.LOGIN_USERID));
            ErrorDetails errorDetails = this.validateRevisionPetitionForm(accessmentnumber, details, receivedon, recievedBy);
            if (null != errorDetails) {
                responseJson = this.getJSONResponse((Object)errorDetails);
            } else {
                try {
                    BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(accessmentnumber);
                    if (basicProperty != null && basicProperty.isUnderWorkflow()) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("PTIS-REST-20");
                        errorDetails.setErrorMessage("Selected property can not be objected,the property is in objected state or the property is in a different workflow");
                        return this.getJSONResponse((Object)errorDetails);
                    }
                    RevisionPetition revPetition = new RevisionPetition();
                    revPetition.setBasicProperty(basicProperty);
                    revPetition.setRecievedBy(recievedBy);
                    revPetition.setDetails(details);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                    revPetition.setRecievedOn(sdf.parse(receivedon));
                    responseJson = this.convertRevisionPetitionObjectToJson((Object)this.revisionPetitionService.createRevisionPetitionForRest(revPetition));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return responseJson;
    }

    private ErrorDetails validateRevisionPetitionForm(String accessmentnumber, String details, String receivedon, String recievedBy) {
        ErrorDetails errorDetails = null;
        if (accessmentnumber == null || accessmentnumber.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (accessmentnumber.trim().length() > 0 && accessmentnumber.trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(accessmentnumber).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
        }
        if (receivedon == null || receivedon.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-17");
            errorDetails.setErrorMessage("Revision petition received date required");
        } else if (recievedBy == null || recievedBy.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-18");
            errorDetails.setErrorMessage("Revision petition received user details required");
        } else if (details == null || details.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-19");
            errorDetails.setErrorMessage("Revision petition details are required");
        }
        return errorDetails;
    }

    private String convertRevisionPetitionObjectToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(RevisionPetition.class, (Object)new RevisionPetitionAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    private ErrorDetails getInvalidCredentialsErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-1");
        errorDetails.setErrorMessage("Invaild Credentials");
        return errorDetails;
    }

    public RevisionPetitionService getRevisionPetitionService() {
        return this.revisionPetitionService;
    }

    public void setRevisionPetitionService(RevisionPetitionService revisionPetitionService) {
        this.revisionPetitionService = revisionPetitionService;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username != null && password != null && username.equals(this.USER_NAME) && password.equals(this.PASSWORD)) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }
}

