/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.aadhaar.webservice.client.AadhaarInfoServiceClient;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyMutationTransferee;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.MasterCodeNamePairDetails;
import org.egov.ptis.domain.model.OwnerDetails;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.ptis.web.rest.PropertyMutationAdaptor;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Path(value="/transfer")
public class PropertyTransferRestService {
    private static final String DOCUMENT_TYPE_ADDRESSPROOF = "Address Proof Of Parties";
    private static final String DOCUMENT_TYPE_PROPERTYDOCUMENT = "Attested Copies Of Property Documents";
    private static final String DOCUMENT_TYPE_DEEDISSUEDBYREVENUEDEPT = "Title Deeds Issued By Revenue Department";
    @Autowired
    private PropertyTransferService propertyTransferService;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyMutation> transferWorkflowService;
    @Autowired
    private AadhaarInfoServiceClient aadhaarInfoServiceClient;
    @Autowired
    private EisCommonService eisCommonService;
    @Context
    HttpServletRequest context;
    String USER_NAME = "mahesh";
    String PASSWORD = "demo";
    String LOGIN_USERID = "16";

    @POST
    @Path(value="/propertyTransfer/createPropertyTransfer")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public String createRevisionPetitionFromRest(@FormDataParam(value="accessmentnumber") String accessmentnumber, @FormDataParam(value="username") String username, @FormDataParam(value="password") String password, @FormDataParam(value="ownerDetails") String ownerDetails, @FormDataParam(value="mutationReasonCode") String mutationReason, @FormDataParam(value="saleDetail") String saleDetail, @FormDataParam(value="deedNo") String deedNo, @FormDataParam(value="deedDate") String deedDate, FormDataMultiPart formTransferDocument) throws JsonGenerationException, JsonMappingException, IOException {
        List documentTypes = new ArrayList();
        String responseJson = new String();
        PropertyMutationMaster mutationMaster = null;
        BasicPropertyImpl basicProperty = null;
        Boolean isAuthenticatedUser = this.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            ErrorDetails errorDetails;
            ApplicationThreadLocals.setUserId((Long)Long.valueOf(this.LOGIN_USERID));
            List ownerDetailsList = null;
            if (ownerDetails != null && ownerDetails.trim().length() > 0) {
                ownerDetailsList = (List)new ObjectMapper().readValue(ownerDetails.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            documentTypes = this.propertyTransferService.getPropertyTransferDocumentTypes();
            if (accessmentnumber != null) {
                basicProperty = this.propertyTransferService.getBasicPropertyByUpicNo(accessmentnumber);
            }
            if (mutationReason != null) {
                mutationMaster = this.propertyTransferService.getPropertyTransferReasonsByCode(mutationReason);
            }
            if (null != (errorDetails = this.validateTransferPropertyParams(formTransferDocument, documentTypes, mutationMaster, accessmentnumber, (BasicProperty)basicProperty, ownerDetailsList, mutationReason, saleDetail, deedNo, deedDate))) {
                responseJson = this.getJSONResponse((Object)errorDetails);
            } else {
                List documents = this.getDocumentList(formTransferDocument, documentTypes);
                PropertyMutation propertyMutation = this.buildPropertyMutationObject(mutationReason, saleDetail, deedNo, deedDate, ownerDetailsList, (BasicProperty)basicProperty);
                if (documents != null && documents.size() > 0) {
                    propertyMutation.setDocuments(documents);
                }
                this.transitionWorkFlow(propertyMutation, (BasicProperty)basicProperty);
                this.propertyTransferService.initiatePropertyTransfer((BasicProperty)basicProperty, propertyMutation);
                responseJson = this.convertPropertyMutationToJson((Object)propertyMutation);
            }
        } else {
            ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @POST
    @Path(value="/propertyTransfer/getMutationReasons")
    @Produces(value={"application/json"})
    public String getMutationReasons(@FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = this.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            List mutationMasterList = this.propertyTransferService.getPropertyTransferReasons();
            for (PropertyMutationMaster mutationMaster : mutationMasterList) {
                MasterCodeNamePairDetails masterCodeObj = new MasterCodeNamePairDetails();
                masterCodeObj.setCode(mutationMaster.getCode());
                masterCodeObj.setName(mutationMaster.getMutationName());
                mstrCodeNamePairDetailsList.add(masterCodeObj);
            }
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @POST
    @Path(value="/propertyTransfer/getTransferDocumentType")
    @Produces(value={"application/json"})
    public String getPropertyTransferDocumentType(@FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = this.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            List documentTypeList = this.propertyTransferService.getPropertyTransferDocumentTypes();
            for (DocumentType documentType : documentTypeList) {
                MasterCodeNamePairDetails masterCodeObj = new MasterCodeNamePairDetails();
                masterCodeObj.setCode(documentType.getName());
                masterCodeObj.setName(documentType.getName());
                mstrCodeNamePairDetailsList.add(masterCodeObj);
            }
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    private String convertPropertyMutationToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(PropertyMutation.class, (Object)new PropertyMutationAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private List<Document> getDocumentList(FormDataMultiPart formTransferDocument, List<DocumentType> documentTypes) {
        ContentDisposition headerOfFilePart;
        InputStream fileInputStream;
        ArrayList<Document> documents = new ArrayList<Document>();
        DocumentType documentType = null;
        Document document = null;
        List fields = formTransferDocument.getFields("addressProofOfParties");
        if (fields != null) {
            for (FormDataBodyPart field : fields) {
                fileInputStream = (InputStream)field.getValueAs(InputStream.class);
                headerOfFilePart = field.getContentDisposition();
                if (fileInputStream == null || headerOfFilePart == null) continue;
                documentType = this.getDocumentTypeByCode(DOCUMENT_TYPE_ADDRESSPROOF, documentTypes);
                document = this.createDocument(fileInputStream, headerOfFilePart);
                document.setType(documentType);
                documents.add(document);
            }
        }
        if ((fields = formTransferDocument.getFields("attestedPropertyDocument")) != null) {
            for (FormDataBodyPart field : fields) {
                fileInputStream = (InputStream)field.getValueAs(InputStream.class);
                headerOfFilePart = field.getContentDisposition();
                if (fileInputStream == null || headerOfFilePart == null) continue;
                documentType = this.getDocumentTypeByCode(DOCUMENT_TYPE_PROPERTYDOCUMENT, documentTypes);
                document = this.createDocument(fileInputStream, headerOfFilePart);
                document.setType(documentType);
                documents.add(document);
            }
        }
        if ((fields = formTransferDocument.getFields("titleDeedDocument")) != null) {
            for (FormDataBodyPart field : fields) {
                fileInputStream = (InputStream)field.getValueAs(InputStream.class);
                headerOfFilePart = field.getContentDisposition();
                if (fileInputStream == null || headerOfFilePart == null) continue;
                documentType = this.getDocumentTypeByCode(DOCUMENT_TYPE_DEEDISSUEDBYREVENUEDEPT, documentTypes);
                document = this.createDocument(fileInputStream, headerOfFilePart);
                document.setType(documentType);
                documents.add(document);
            }
        }
        return documents;
    }

    private Document createDocument(InputStream fileInputStream, ContentDisposition headerOfFilePart) {
        Document document = new Document();
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> contentTypes = new ArrayList<String>();
        ArrayList<String> fileNames = new ArrayList<String>();
        File file = null;
        if (fileInputStream != null && headerOfFilePart != null) {
            fileNames.add(headerOfFilePart.getFileName());
            document.setUploadsFileName(fileNames);
            file = this.writeToFile(fileInputStream, headerOfFilePart.getFileName());
            files.add(file);
            document.setUploads(files);
            contentTypes.add(MessageFormat.format("application/{0}", FilenameUtils.getExtension((String)file.getPath())));
            document.setUploadsContentType(contentTypes);
        }
        return document;
    }

    private File writeToFile(InputStream uploadedInputStream, String fileName) {
        File file = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(new File(fileName));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private DocumentType getDocumentTypeByCode(String thirdPartyPhotoOfAssessmentCode, List<DocumentType> documentTypes) {
        for (DocumentType docType : documentTypes) {
            if (!docType.getName().equalsIgnoreCase(thirdPartyPhotoOfAssessmentCode)) continue;
            return docType;
        }
        return null;
    }

    private PropertyMutation buildPropertyMutationObject(String mutationReason, String saleDetail, String deedNo, String deedDate, List<OwnerDetails> ownerDetailsList, BasicProperty basicProperty) {
        PropertyMutation propertyMutation = new PropertyMutation();
        propertyMutation.setBasicProperty(basicProperty);
        SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy");
        try {
            propertyMutation.setDeedDate(dateformat.parse(deedDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        propertyMutation.setDeedNo(deedNo);
        propertyMutation.setSaleDetail(saleDetail);
        propertyMutation.setMutationReason(this.propertyTransferService.getPropertyTransferReasonsByCode(mutationReason));
        propertyMutation.setTransfereeInfos(this.getPropertyOwnerInfoList(ownerDetailsList, propertyMutation));
        return propertyMutation;
    }

    private void transitionWorkFlow(PropertyMutation propertyMutation, BasicProperty basicProperty) {
        String currentState = "Created";
        Position pos = null;
        DateTime currentDate = new DateTime();
        User user = this.propertyTransferService.getLoggedInUser();
        Assignment assignment = this.propertyService.getUserPositionByZone(basicProperty, basicProperty.getSource());
        pos = assignment.getPosition();
        if (null == propertyMutation.getState()) {
            WorkFlowMatrix wfmatrix = this.transferWorkflowService.getWfMatrix(propertyMutation.getStateType(), null, null, null, currentState, null);
            if (pos != null) {
                user = this.eisCommonService.getUserForPosition(pos.getId(), new Date());
            }
            propertyMutation.transition().start().withSenderName(user.getName()).withComments("").withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withSenderName(user != null && user.getName() != null ? user.getName() : "").withOwner(user).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Title Transfer");
        }
    }

    private List<PropertyMutationTransferee> getPropertyOwnerInfoList(List<OwnerDetails> ownerDetailsList, PropertyMutation propertyMutation) {
        ArrayList<PropertyMutationTransferee> proeprtyOwnerInfoList = new ArrayList<PropertyMutationTransferee>();
        for (OwnerDetails ownerDetais : ownerDetailsList) {
            PropertyMutationTransferee pmt = new PropertyMutationTransferee();
            User owner = new User();
            owner.setAadhaarNumber(ownerDetais.getAadhaarNo());
            owner.setSalutation(ownerDetais.getSalutationCode());
            owner.setType(UserType.CITIZEN);
            owner.setName(ownerDetais.getName());
            owner.setGender(Gender.valueOf((String)ownerDetais.getGender()));
            owner.setMobileNumber(ownerDetais.getMobileNumber());
            owner.setEmailId(ownerDetais.getEmailId());
            owner.setGuardianRelation(ownerDetais.getGuardianRelation());
            owner.setGuardian(ownerDetais.getGuardian());
            pmt.setTransferee(owner);
            pmt.setPropertyMutation(propertyMutation);
            proeprtyOwnerInfoList.add(pmt);
        }
        return proeprtyOwnerInfoList;
    }

    private ErrorDetails validateTransferPropertyParams(FormDataMultiPart formTransferDocument, List<DocumentType> documentTypes, PropertyMutationMaster mutationMaster, String accessmentnumber, BasicProperty basicProperty, List<OwnerDetails> ownerDetailsList, String mutationReason, String saleDetail, String deedNo, String deedDate) {
        ErrorDetails errorDetails = null;
        if (accessmentnumber == null || accessmentnumber.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (basicProperty == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            } else if (accessmentnumber.trim().length() > 0 && accessmentnumber.trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            } else if (basicProperty != null && basicProperty.isUnderWorkflow()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-29");
                errorDetails.setErrorMessage("Transfer of Ownership not possible as the selected property is in a different workflow");
            }
            BigDecimal currentWaterTaxDue = this.propertyService.getWaterTaxDues(accessmentnumber);
            Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)basicProperty.getActiveProperty());
            BigDecimal currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_COLL"));
            BigDecimal arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
            if (currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-30");
                errorDetails.setErrorMessage("Transfer of Ownership not possible.Tax due for the selected property");
            }
        }
        if (documentTypes != null) {
            for (DocumentType docTypes : documentTypes) {
                if (!docTypes.isMandatory()) continue;
                if (docTypes.getName().equalsIgnoreCase(DOCUMENT_TYPE_ADDRESSPROOF)) {
                    if (!this.checkDocumentDetailsAvailable(DOCUMENT_TYPE_ADDRESSPROOF, formTransferDocument)) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("PTIS-REST-32");
                        errorDetails.setErrorMessage("Please attach relevant documents for property transfer. Type: Address Proof Of Parties");
                        break;
                    }
                } else if (docTypes.getName().equalsIgnoreCase(DOCUMENT_TYPE_PROPERTYDOCUMENT) && !this.checkDocumentDetailsAvailable(DOCUMENT_TYPE_PROPERTYDOCUMENT, formTransferDocument)) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("PTIS-REST-32");
                    errorDetails.setErrorMessage("Please attach relevant documents for property transfer. Type: Address Proof Of Parties");
                    break;
                }
                if (!docTypes.getName().equalsIgnoreCase(DOCUMENT_TYPE_DEEDISSUEDBYREVENUEDEPT) || this.checkDocumentDetailsAvailable(DOCUMENT_TYPE_DEEDISSUEDBYREVENUEDEPT, formTransferDocument)) continue;
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-32");
                errorDetails.setErrorMessage("Please attach relevant documents for property transfer. Type: Address Proof Of Parties");
                break;
            }
        }
        if (mutationMaster == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-23");
            errorDetails.setErrorMessage("Please enter valid mutation reason code");
        } else if (ownerDetailsList == null || ownerDetailsList.size() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-22");
            errorDetails.setErrorMessage("Owner details are mandatory, add atleast one transferee information. ");
        } else if (ownerDetailsList != null && ownerDetailsList.size() > 0) {
            for (OwnerDetails owner : ownerDetailsList) {
                if (!StringUtils.isBlank((String)owner.getAadhaarNo())) {
                    try {
                        if (this.aadhaarInfoServiceClient.getAadhaarInfo(owner.getAadhaarNo()) == null) continue;
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("PTIS-REST-31");
                        errorDetails.setErrorMessage("Adhaar Detail not found in uidai server for the given aadhaar number " + owner.getAadhaarNo());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("PTIS-REST-31");
                        errorDetails.setErrorMessage("Adhaar Detail not found in uidai server for the given aadhaar number " + owner.getAadhaarNo());
                    }
                    continue;
                }
                if (StringUtils.isBlank((String)owner.getName())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("PTIS-REST-28");
                    errorDetails.setErrorMessage("Please Enter Owner Name");
                    continue;
                }
                if (StringUtils.isBlank((String)owner.getMobileNumber())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("PTIS-REST-27");
                    errorDetails.setErrorMessage("Please enter mobile number. ");
                    continue;
                }
                if (!StringUtils.isBlank((String)owner.getGender())) continue;
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-33");
                errorDetails.setErrorMessage("Please mention gender of transferee ");
            }
        } else if (mutationReason == null || mutationReason.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-23");
            errorDetails.setErrorMessage("Please enter valid mutation reason code");
        } else if (mutationReason != null && mutationReason.equalsIgnoreCase("SALE") && (saleDetail == null || saleDetail.trim().length() == 0)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-24");
            errorDetails.setErrorMessage("Please Enter Sale Details");
        } else if (deedNo == null || deedNo.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Registration Document Number should not be empty");
        } else if (deedDate == null || deedDate.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Registration Document Date should not be empty");
        }
        return errorDetails;
    }

    private boolean checkDocumentDetailsAvailable(String documentTypeAddressproof, FormDataMultiPart formTransferDocument) {
        if (formTransferDocument != null) {
            if (documentTypeAddressproof != null && documentTypeAddressproof.equals(DOCUMENT_TYPE_ADDRESSPROOF) && (formTransferDocument.getFields("addressProofOfParties") == null || formTransferDocument.getFields("addressProofOfParties").size() == 0)) {
                return false;
            }
            if (documentTypeAddressproof != null && documentTypeAddressproof.equals(DOCUMENT_TYPE_PROPERTYDOCUMENT) && (formTransferDocument.getFields("attestedPropertyDocument") == null || formTransferDocument.getFields("attestedPropertyDocument").size() == 0)) {
                return false;
            }
            if (documentTypeAddressproof != null && documentTypeAddressproof.equals(DOCUMENT_TYPE_DEEDISSUEDBYREVENUEDEPT) && (formTransferDocument.getFields("titleDeedDocument") == null || formTransferDocument.getFields("titleDeedDocument").size() == 0)) {
                return false;
            }
        }
        return true;
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    private ErrorDetails getInvalidCredentialsErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-1");
        errorDetails.setErrorMessage("Invaild Credentials");
        return errorDetails;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username != null && password != null && username.equals(this.USER_NAME) && password.equals(this.PASSWORD)) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }
}

