/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.rest;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import net.sf.json.JSONObject;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.DrainageEnum;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.LocalityDetails;
import org.egov.ptis.domain.model.MasterCodeNamePairDetails;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/")
public class AssessmentService {
    @Autowired
    private PropertyExternalService propertyExternalService;

    @GET
    @Path(value="/property/{assessmentNumber}")
    @Produces(value={"application/json"})
    public String getAssessmentDetails(@PathParam(value="assessmentNumber") String assessmentNumber) throws JsonGenerationException, JsonMappingException, IOException {
        AssessmentDetails assessmentDetail = this.propertyExternalService.loadAssessmentDetails(assessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        return this.getJSONResponse((Object)assessmentDetail);
    }

    @POST
    @Path(value="/property/propertyTaxDetails")
    @Produces(value={"application/json"})
    public String getPropertyTaxDetails(@FormParam(value="assessmentNo") String assessmentNo, @FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNo, null);
        } else {
            ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
            propertyTaxDetails.setErrorDetails(errorDetails);
        }
        return this.getJSONResponse((Object)propertyTaxDetails);
    }

    @POST
    @Path(value="/property/propertyTaxDetailsByBoundary")
    @Produces(value={"application/json"})
    public String getPropertyTaxDetails(@FormParam(value="circleName") String circleName, @FormParam(value="zoneName") String zoneName, @FormParam(value="wardName") String wardName, @FormParam(value="blockName") String blockName, @FormParam(value="ownerName") String ownerName, @FormParam(value="doorNo") String doorNo, @FormParam(value="aadhaarNumber") String aadhaarNumber, @FormParam(value="mobileNumber") String mobileNumber, @FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        List propertyTaxDetailsList = new ArrayList();
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            propertyTaxDetailsList = this.propertyExternalService.getPropertyTaxDetails(circleName, zoneName, wardName, blockName, ownerName, doorNo, aadhaarNumber, mobileNumber);
            return this.getJSONResponse(propertyTaxDetailsList);
        }
        ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
        propertyTaxDetails.setErrorDetails(errorDetails);
        return this.getJSONResponse((Object)propertyTaxDetails);
    }

    @POST
    @Path(value="/property/payPropertyTax")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String payPropertyTax(@FormParam(value="assessmentNo") String assessmentNo, @FormParam(value="paymentMode") String paymentMode, @FormParam(value="totalAmount") BigDecimal totalAmount, @FormParam(value="paidBy") String paidBy, @FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        String responseJson = new String();
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            ErrorDetails errorDetails = this.propertyExternalService.validatePaymentDetails(assessmentNo, paymentMode, totalAmount, paidBy);
            if (null != errorDetails) {
                responseJson = this.getJSONResponse((Object)errorDetails);
            } else {
                PayPropertyTaxDetails pt = new PayPropertyTaxDetails();
                pt.setAssessmentNo(assessmentNo);
                pt.setPaymentMode(paymentMode);
                pt.setPaymentAmount(totalAmount);
                pt.setPaidBy(paidBy);
                ReceiptDetails receiptDetails = this.propertyExternalService.payPropertyTax(pt);
                responseJson = this.getJSONResponse((Object)receiptDetails);
            }
        }
        return responseJson;
    }

    @POST
    @Path(value="/property/payWaterTax")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String payWateTax(@FormParam(value="consumerNo") String consumerNo, @FormParam(value="paymentMode") String paymentMode, @FormParam(value="totalAmount") BigDecimal totalAmount, @FormParam(value="paidBy") String paidBy, @FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        ErrorDetails errorDetails = this.propertyExternalService.validatePaymentDetails(consumerNo, paymentMode, totalAmount, paidBy);
        if (null != errorDetails) {
            return this.getJSONResponse((Object)errorDetails);
        }
        errorDetails = this.propertyExternalService.payWaterTax(consumerNo, paymentMode, totalAmount, paidBy);
        return this.getJSONResponse((Object)errorDetails);
    }

    @GET
    @Path(value="/property/ownershipCategories")
    @Produces(value={"application/json"})
    public String getOwnershipCategories() throws JsonGenerationException, JsonMappingException, IOException {
        List propTypeMasterDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            propTypeMasterDetailsList = this.propertyExternalService.getPropertyTypeMasterDetails();
            responseJson = this.getJSONResponse((Object)propTypeMasterDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/ownershipCategoryByCode/{ownershipCategoryCode}")
    @Produces(value={"application/json"})
    public String getOwnershipCategoryByCode(@PathParam(value="ownershipCategoryCode") String ownershipCategoryCode) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyTypeMaster propertyTypeMaster = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            propertyTypeMaster = this.propertyExternalService.getPropertyTypeMasterByCode(ownershipCategoryCode);
            responseJson = this.getJSONResponse((Object)propertyTypeMaster);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/propertyTypes/{ownershipCategoryCode}")
    @Produces(value={"application/json"})
    public String getPropertyTypeCategoryDetails(@PathParam(value="ownershipCategoryCode") String ownershipCategoryCode) throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getPropertyTypeCategoryDetails(ownershipCategoryCode);
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/propertyTypes")
    @Produces(value={"application/json"})
    public String getPropertyTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getPropertyTypes();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/apartments")
    @Produces(value={"application/json"})
    public String getApartmentsAndComplexes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getApartmentsAndComplexes();
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/createPropertyReasons")
    @Produces(value={"application/json"})
    public String getCreatePropertyReasons() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getReasonsForChangeProperty("CREATE");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/localities")
    @Produces(value={"application/json"})
    public String getLocalities() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("locality", "LOCATION");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/zones")
    @Produces(value={"application/json"})
    public String getZones() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("Zone", "REVENUE");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/electionWards")
    @Produces(value={"application/json"})
    public String getElectionWards() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("Ward", "ADMINISTRATION");
            responseJson = this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @POST
    @Path(value="/property/boundaryByLocalityCode")
    @Produces(value={"application/json"})
    public String getBoundaryByLocalityCode(@FormParam(value="localityCode") String localityCode, @FormParam(value="username") String username, @FormParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException {
        LocalityDetails localityDetails = null;
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = this.propertyExternalService.authenticateUser(username, password);
        if (isAuthenticatedUser.booleanValue()) {
            localityDetails = this.propertyExternalService.getLocalityDetailsByLocalityCode(localityCode);
            responseJson = this.getJSONResponse((Object)localityDetails);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/enumerationBlocks")
    @Produces(value={"application/json"})
    public String getEnumerationBlocks() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getEnumerationBlocks();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/floorTypes")
    @Produces(value={"application/json"})
    public String getFloorTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getFloorTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/roofTypes")
    @Produces(value={"application/json"})
    public String getRoofTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getRoofTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/wallTypes")
    @Produces(value={"application/json"})
    public String getWallTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getWallTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/woodTypes")
    @Produces(value={"application/json"})
    public String getWoodTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getWoodTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/floors")
    @Produces(value={"application/json"})
    public String getFloors() throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            TreeMap floorMap = PropertyTaxConstants.FLOOR_MAP;
            Set keys = floorMap.keySet();
            for (Integer key : keys) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(key.toString());
                mstrCodeNamePairDetails.setName((String)floorMap.get(key));
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/propertyClassifications")
    @Produces(value={"application/json"})
    public String getPropertyClassifications() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getBuildingClassifications();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/propertyUsages")
    @Produces(value={"application/json"})
    public String getPropertUsages() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getNatureOfUsages();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/occupancyTypes")
    @Produces(value={"application/json"})
    public String getOccupancyTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getOccupancies();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/exemptionCategories")
    @Produces(value={"application/json"})
    public String getTaxExemptionCategories() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getExemptionCategories();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/drainages")
    @Produces(value={"application/json"})
    public String getDrainages() throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            for (DrainageEnum drngEnum : DrainageEnum.values()) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(drngEnum.getCode());
                mstrCodeNamePairDetails.setName(drngEnum.name());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/documentTypes")
    @Produces(value={"application/json"})
    public String getDocumentTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getDocumentTypes();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/mutationReasons")
    @Produces(value={"application/json"})
    public String getMutationReasons() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getReasonsForChangeProperty("TRANSFER");
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @GET
    @Path(value="/property/approverDepartments")
    @Produces(value={"application/json"})
    public String getApproverDepartments() throws JsonGenerationException, JsonMappingException, IOException {
        List mstrCodeNamePairDetailsList = new ArrayList();
        ErrorDetails errorDetails = null;
        String responseJson = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            mstrCodeNamePairDetailsList = this.propertyExternalService.getApproverDepartments();
            responseJson = this.getJSONResponse(mstrCodeNamePairDetailsList);
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    @POST
    @Path(value="/property/createProperty")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String createProperty(@FormDataParam(value="propertyTypeMasterCode") String propertyTypeMasterCode, @FormDataParam(value="propertyCategoryCode") String propertyCategoryCode, @FormDataParam(value="apartmentCmplxCode") String apartmentCmplxCode, @FormDataParam(value="ownerDetails") String ownerDetails, @FormDataParam(value="mutationReasonCode") String mutationReasonCode, @FormDataParam(value="extentOfSite") String extentOfSite, @FormDataParam(value="isExtentAppurtenantLand") String isExtentAppurtenantLand, @FormDataParam(value="occupancyCertificationNo") String occupancyCertificationNo, @FormDataParam(value="isSuperStructure") Boolean isSuperStructure, @FormDataParam(value="isBuildingPlanDetails") Boolean isBuildingPlanDetails, @FormDataParam(value="regdDocNo") String regdDocNo, @FormDataParam(value="regdDocDate") String regdDocDate, @FormDataParam(value="localityCode") String localityCode, @FormDataParam(value="street") String street, @FormDataParam(value="electionWardCode") String electionWardCode, @FormDataParam(value="doorNo") String doorNo, @FormDataParam(value="enumerationBlockCode") String enumerationBlockCode, @FormDataParam(value="pinCode") String pinCode, @FormDataParam(value="isCorrAddrDiff") Boolean isCorrAddrDiff, @FormDataParam(value="corrAddr1") String corrAddr1, @FormDataParam(value="corrAddr2") String corrAddr2, @FormDataParam(value="corrPinCode") String corrPinCode, @FormDataParam(value="hasLift") Boolean hasLift, @FormDataParam(value="hasToilet") Boolean hasToilet, @FormDataParam(value="hasWaterTap") Boolean hasWaterTap, @FormDataParam(value="hasElectricity") Boolean hasElectricity, @FormDataParam(value="hasAttachedBathroom") String hasAttachedBathroom, @FormDataParam(value="hasWaterHarvesting") String hasWaterHarvesting, @FormDataParam(value="floorTypeCode") String floorTypeCode, @FormDataParam(value="roofTypeCode") String roofTypeCode, @FormDataParam(value="wallTypeCode") String wallTypeCode, @FormDataParam(value="woodTypeCode") String woodTypeCode, @FormDataParam(value="floorDetails") String floorDetails, @FormDataParam(value="surveyNumber") String surveyNumber, @FormDataParam(value="pattaNumber") String pattaNumber, @FormDataParam(value="vacantLandArea") Double vacantLandArea, @FormDataParam(value="marketValue") Double marketValue, @FormDataParam(value="currentCapitalValue") Double currentCapitalValue, @FormDataParam(value="completionDate") String completionDate, @FormDataParam(value="northBoundary") String northBoundary, @FormDataParam(value="southBoundary") String southBoundary, @FormDataParam(value="eastBoundary") String eastBoundary, @FormDataParam(value="westBoundary") String westBoundary, @FormDataParam(value="photoAsmnt") InputStream photoAsmntStream, @FormDataParam(value="photoAsmnt") FormDataContentDisposition photoAsmntDisp, @FormDataParam(value="bldgPermCopy") InputStream bldgPermCopyStream, @FormDataParam(value="bldgPermCopy") FormDataContentDisposition bldgPermCopyDisp, @FormDataParam(value="atstdCopyPropDoc") InputStream atstdCopyPropDocStream, @FormDataParam(value="atstdCopyPropDoc") FormDataContentDisposition atstdCopyPropDocDisp, @FormDataParam(value="nonJudcStamp") InputStream nonJudcStampStream, @FormDataParam(value="nonJudcStamp") FormDataContentDisposition nonJudcStampDisp, @FormDataParam(value="afdvtBond") InputStream afdvtBondStream, @FormDataParam(value="afdvtBond") FormDataContentDisposition afdvtBondDisp, @FormDataParam(value="deathCertCopy") InputStream deathCertCopyStream, @FormDataParam(value="deathCertCopy") FormDataContentDisposition deathCertCopyDisp, @FormDataParam(value="username") String username, @FormDataParam(value="password") String password) throws JsonGenerationException, JsonMappingException, IOException, ParseException {
        return null;
    }

    @GET
    @Path(value="/wardBlockLocalityMapping")
    @Produces(value={"application/json"})
    public String getWardBlockLocalityMappings() throws JsonGenerationException, JsonMappingException, IOException {
        String responseJson = "";
        ErrorDetails errorDetails = null;
        Boolean isAuthenticatedUser = true;
        if (isAuthenticatedUser.booleanValue()) {
            List boundaryDetailsList = this.propertyExternalService.getWardBlockLocalityMapping();
            ArrayList<JSONObject> boundaryJsonObjs = new ArrayList<JSONObject>();
            if (!boundaryDetailsList.isEmpty()) {
                for (Object[] obj : boundaryDetailsList) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"wardNum", obj[0]);
                    jsonObject.put((Object)"wardName", obj[1]);
                    jsonObject.put((Object)"blockNum", obj[2]);
                    jsonObject.put((Object)"blockName", obj[3]);
                    jsonObject.put((Object)"localityNum", obj[4]);
                    jsonObject.put((Object)"localityName", obj[5]);
                    boundaryJsonObjs.add(jsonObject);
                }
                responseJson = this.getJSONResponse(boundaryJsonObjs);
            }
        } else {
            errorDetails = this.getInvalidCredentialsErrorDetails();
            responseJson = this.getJSONResponse((Object)errorDetails);
        }
        return responseJson;
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    private ErrorDetails getInvalidCredentialsErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-1");
        errorDetails.setErrorMessage("Invaild Credentials");
        return errorDetails;
    }

    private ErrorDetails getRequestFailedErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-3");
        errorDetails.setErrorMessage("Communication Failure or Server may be down");
        return errorDetails;
    }
}

