/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Installment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/vacancyremission"})
public class VacanyRemissionController
extends GenericWorkFlowController {
    private static final String VACANCYREMISSION_FORM = "vacancyRemission-form";
    private static final String VACANCYREMISSION_SUCCESS = "vacancyRemission-success";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    private final PropertyTaxUtil propertyTaxUtil;
    private BasicProperty basicProperty;
    private VacancyRemission vacancyRemission;
    private final VacancyRemissionService vacancyRemissionService;
    private Boolean loggedUserIsMeesevaUser = Boolean.FALSE;
    @Autowired
    private PropertyService propertyService;

    @Autowired
    public VacanyRemissionController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemission vacancyRemissionModel(@PathVariable String assessmentNo) {
        this.vacancyRemission = new VacancyRemission();
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (this.basicProperty != null) {
            this.vacancyRemission.setBasicProperty((BasicPropertyImpl)this.basicProperty);
        }
        return this.vacancyRemission;
    }

    @RequestMapping(value={"/create/{assessmentNo},{mode}"}, method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String assessmentNo, @PathVariable String mode, @RequestParam(required=false) String meesevaApplicationNumber, HttpServletRequest request) {
        PropertyImpl property;
        if (this.basicProperty != null && (property = this.basicProperty.getActiveProperty()) != null) {
            if (mode.equalsIgnoreCase("commonSearch")) {
                VacancyRemission vacancyRemission;
                Boolean enableVacancyRemission = Boolean.FALSE;
                if (property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
                    model.addAttribute("errorMsg", (Object)"Vacancy Remission cannot be done for Vacant Land ");
                    return "propertyValidation";
                }
                if (property.getIsExemptedFromTax().booleanValue()) {
                    model.addAttribute("errorMsg", (Object)"This property is exempted from taxes");
                    return "propertyValidation";
                }
                if (this.basicProperty.isUnderWorkflow()) {
                    model.addAttribute("errorMsg", (Object)"Could not do Vacancy Remission now, as this property is undergoing some work flow.");
                    return "propertyValidation";
                }
                List remissionList = this.vacancyRemissionService.getAllVacancyRemissionByUpicNo(this.basicProperty.getUpicNo());
                if (!remissionList.isEmpty() && (vacancyRemission = (VacancyRemission)remissionList.get(remissionList.size() - 1)) != null) {
                    if (vacancyRemission.getStatus().equalsIgnoreCase("APPROVED")) {
                        if (org.apache.commons.lang.time.DateUtils.isSameDay((Date)vacancyRemission.getVacancyToDate(), (Date)new Date())) {
                            enableVacancyRemission = true;
                        } else if (vacancyRemission.getVacancyToDate().compareTo(new Date()) < 0) {
                            enableVacancyRemission = true;
                        }
                    } else if (vacancyRemission.getStatus().equalsIgnoreCase("Rejection Acknowledgement Generated")) {
                        enableVacancyRemission = true;
                    } else if (vacancyRemission.getStatus().equalsIgnoreCase("IN_WORKFLOW")) {
                        model.addAttribute("errorMsg", (Object)"This property is under workflow");
                        return "propertyValidation";
                    }
                }
                if (remissionList.isEmpty() || enableVacancyRemission.booleanValue()) {
                    Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicProperty.getActiveProperty());
                    BigDecimal currentPropertyTax = BigDecimal.ZERO;
                    BigDecimal currentPropertyTaxDue = BigDecimal.ZERO;
                    BigDecimal arrearPropertyTaxDue = BigDecimal.ZERO;
                    Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                    Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
                    if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                        currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
                        currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
                    } else {
                        currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
                        currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
                    }
                    arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
                    BigDecimal currentWaterTaxDue = this.propertyService.getWaterTaxDues(this.basicProperty.getUpicNo(), request);
                    model.addAttribute("currentPropertyTax", (Object)currentPropertyTax);
                    model.addAttribute("currentPropertyTaxDue", (Object)currentPropertyTaxDue);
                    model.addAttribute("arrearPropertyTaxDue", (Object)arrearPropertyTaxDue);
                    model.addAttribute("currentWaterTaxDue", (Object)currentWaterTaxDue);
                    if (currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L) {
                        model.addAttribute("taxDuesErrorMsg", (Object)"Please clear property tax due for availing vacancy remission for your property ");
                        return "taxdues";
                    }
                    this.prepareWorkflow(model, (StateAware)this.vacancyRemission, new WorkflowContainer());
                    model.addAttribute("stateType", (Object)this.vacancyRemission.getClass().getSimpleName());
                    this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
                }
                this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.vacancyRemissionService.getLoggedInUser());
                if (this.loggedUserIsMeesevaUser.booleanValue()) {
                    if (meesevaApplicationNumber == null) {
                        throw new ApplicationRuntimeException("MEESEVA.005");
                    }
                    this.vacancyRemission.setMeesevaApplicationNumber(meesevaApplicationNumber);
                }
            } else {
                boolean hasChildPropertyUnderWorkflow = this.propertyTaxUtil.checkForParentUsedInBifurcation(this.basicProperty.getUpicNo());
                if (hasChildPropertyUnderWorkflow) {
                    model.addAttribute("errorMsg", (Object)"Cannot proceed as this property is used in Bifurcation, which is under workflow");
                    return "propertyValidation";
                }
                Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicProperty.getActiveProperty());
                BigDecimal currentPropertyTax = BigDecimal.ZERO;
                BigDecimal currentPropertyTaxDue = BigDecimal.ZERO;
                BigDecimal arrearPropertyTaxDue = BigDecimal.ZERO;
                Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
                if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                    currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
                    currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
                } else {
                    currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
                    currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
                }
                arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
                BigDecimal currentWaterTaxDue = this.propertyService.getWaterTaxDues(this.basicProperty.getUpicNo(), request);
                model.addAttribute("currentPropertyTax", (Object)currentPropertyTax);
                model.addAttribute("currentPropertyTaxDue", (Object)currentPropertyTaxDue);
                model.addAttribute("arrearPropertyTaxDue", (Object)arrearPropertyTaxDue);
                model.addAttribute("currentWaterTaxDue", (Object)currentWaterTaxDue);
                if (currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L) {
                    model.addAttribute("taxDuesErrorMsg", (Object)"Please clear property tax due for availing vacancy remission for your property ");
                    return "taxdues";
                }
                this.prepareWorkflow(model, (StateAware)this.vacancyRemission, new WorkflowContainer());
                model.addAttribute("stateType", (Object)this.vacancyRemission.getClass().getSimpleName());
                this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
            }
        }
        return VACANCYREMISSION_FORM;
    }

    @RequestMapping(value={"/create/{assessmentNo},{mode}"}, method={RequestMethod.POST})
    public String saveVacancyRemission(@Valid @ModelAttribute VacancyRemission vacancyRemission, BindingResult resultBinder, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String workFlowAction) {
        Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.vacancyRemissionService.getLoggedInUser());
        this.validateDates(vacancyRemission, resultBinder, request);
        if (resultBinder.hasErrors()) {
            if (this.basicProperty != null) {
                this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
                model.addAttribute("stateType", (Object)vacancyRemission.getClass().getSimpleName());
                this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
            }
            return VACANCYREMISSION_FORM;
        }
        if ((!propertyByEmployee.booleanValue() || this.loggedUserIsMeesevaUser.booleanValue()) && null != this.basicProperty && null == this.propertyService.getUserPositionByZone(this.basicProperty, this.basicProperty.getSource())) {
            this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
            model.addAttribute("stateType", (Object)vacancyRemission.getClass().getSimpleName());
            model.addAttribute("errorMsg", (Object)"No Senior or Junior assistants exists,Please check");
            this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
            return VACANCYREMISSION_FORM;
        }
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("APPLICATIONNUMBER", vacancyRemission.getMeesevaApplicationNumber());
            if (StringUtils.isBlank((String)vacancyRemission.getApplicationNumber())) {
                vacancyRemission.setApplicationNumber(vacancyRemission.getMeesevaApplicationNumber());
                vacancyRemission.setSource(PropertyTaxConstants.SOURCEOFDATA_MEESEWA);
            }
            this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, "", workFlowAction, propertyByEmployee, meesevaParams);
        } else {
            this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, null, workFlowAction, propertyByEmployee);
        }
        String successMsg = "Vacancy Remission Saved Successfully in the System and forwarded to : " + this.propertyTaxUtil.getApproverUserName(vacancyRemission.getState().getOwnerPosition().getId()) + " with application number : " + vacancyRemission.getApplicationNumber();
        model.addAttribute("successMessage", (Object)successMsg);
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            return "redirect:/vacancyremission/generate-meesevareceipt/" + vacancyRemission.getBasicProperty().getUpicNo() + "?transactionServiceNumber=" + vacancyRemission.getApplicationNumber();
        }
        return VACANCYREMISSION_SUCCESS;
    }

    @RequestMapping(value={"/generate-meesevareceipt/{assessmentNo}"}, method={RequestMethod.GET})
    public RedirectView generateMeesevaReceipt(HttpServletRequest request, Model model) {
        String keyNameArray = request.getParameter("transactionServiceNumber");
        RedirectView redirect = new RedirectView("/meeseva/generatereceipt?transactionServiceNumber=" + keyNameArray, false);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
        }
        return redirect;
    }

    private void validateDates(VacancyRemission vacancyRemission, BindingResult errors, HttpServletRequest request) {
        int noOfMonths = DateUtils.noOfMonths((Date)vacancyRemission.getVacancyFromDate(), (Date)vacancyRemission.getVacancyToDate());
        if (noOfMonths < 6) {
            errors.rejectValue("vacancyToDate", "vacancyToDate.incorrect");
        }
    }
}

