/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacancyremission"})
public class UpdateVacancyRemissionController
extends GenericWorkFlowController {
    private static final String VACANCYREMISSION_EDIT = "vacancyRemission-edit";
    private static final String VACANCYREMISSION_SUCCESS = "vacancyRemission-success";
    private VacancyRemissionService vacancyRemissionService;
    private PropertyTaxUtil propertyTaxUtil;

    @Autowired
    public UpdateVacancyRemissionController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemission vacancyRemissionModel(@PathVariable Long id) {
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getVacancyRemissionById(id);
        return vacancyRemission;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getVacancyRemissionById(id);
        if (vacancyRemission != null) {
            model.addAttribute("stateType", (Object)vacancyRemission.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)vacancyRemission.getCurrentState().getValue());
            this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
            BasicPropertyImpl basicProperty = vacancyRemission.getBasicProperty();
            this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)basicProperty);
        }
        return VACANCYREMISSION_EDIT;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute VacancyRemission vacancyRemission, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        String senderName = vacancyRemission.getCurrentState().getSenderName();
        senderName = senderName.substring(senderName.lastIndexOf(":") + 1);
        if (!resultBinder.hasErrors()) {
            String workFlowAction = "";
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            Long approvalPosition = 0L;
            String approvalComent = "";
            String successMsg = "";
            if (request.getParameter("approvalComent") != null) {
                approvalComent = request.getParameter("approvalComent");
            }
            if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
            }
            Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
            this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, null, workFlowAction, propertyByEmployee);
            if (StringUtils.isNotBlank((String)workFlowAction) && !workFlowAction.equalsIgnoreCase("Generate Notice")) {
                successMsg = workFlowAction.equalsIgnoreCase("Approve") ? "Vacancy Remission Approved Successfully in the System" : (workFlowAction.equalsIgnoreCase("Reject") ? "Vacancy Remission rejected successfully and forwarded to : " + this.vacancyRemissionService.getInitiatorName(vacancyRemission) : "Vacancy Remission Saved Successfully in the System and forwarded to : " + this.propertyTaxUtil.getApproverUserName(approvalPosition) + " with application number : " + vacancyRemission.getApplicationNumber());
            }
            model.addAttribute("successMessage", (Object)successMsg);
            if (StringUtils.isNotBlank((String)workFlowAction) && workFlowAction.equalsIgnoreCase("Generate Notice")) {
                String pathVars = vacancyRemission.getBasicProperty().getUpicNo() + "," + senderName;
                return "redirect:/vacancyremission/rejectionacknowledgement?pathVar=" + pathVars;
            }
        }
        return VACANCYREMISSION_SUCCESS;
    }
}

