/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Designation;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacancyremissionapproval/update/{id}"})
public class UpdateVRApprovalController
extends GenericWorkFlowController {
    protected static final String VRAPPROVAL_EDIT = "vacancyRemissionApproval-edit";
    private VacancyRemissionService vacancyRemissionService;
    private PropertyTaxUtil propertyTaxUtil;
    private Designation designation;
    @Autowired
    private AssignmentService assignmentService;

    @Autowired
    public UpdateVRApprovalController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemissionApproval vacancyRemissionApprovalModel(@PathVariable Long id) {
        VacancyRemissionApproval vacancyRemissionApproval = this.vacancyRemissionService.getVacancyRemissionApprovalById(id);
        this.designation = this.propertyTaxUtil.getDesignationForUser(this.vacancyRemissionService.getLoggedInUser().getId());
        return vacancyRemissionApproval;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        VacancyRemissionApproval vacancyRemissionApproval = this.vacancyRemissionService.getVacancyRemissionApprovalById(id);
        String userDesgn = "";
        if (null != this.designation) {
            userDesgn = this.designation.getName();
        }
        if (vacancyRemissionApproval != null) {
            model.addAttribute("stateType", (Object)vacancyRemissionApproval.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)vacancyRemissionApproval.getCurrentState().getValue());
            this.prepareWorkflow(model, (StateAware)vacancyRemissionApproval, new WorkflowContainer());
            BasicPropertyImpl basicProperty = vacancyRemissionApproval.getVacancyRemission().getBasicProperty();
            this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)basicProperty);
            model.addAttribute("detailsHistory", (Object)this.vacancyRemissionService.getMonthlyDetailsHistory(vacancyRemissionApproval.getVacancyRemission()));
            model.addAttribute("workflowHistory", (Object)vacancyRemissionApproval.getStateHistory());
            model.addAttribute("userDesgn", (Object)userDesgn);
            model.addAttribute("designation", (Object)"Commissioner");
        }
        return VRAPPROVAL_EDIT;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute VacancyRemissionApproval vacancyRemissionApproval, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        String senderName = vacancyRemissionApproval.getCurrentState().getSenderName();
        if (!resultBinder.hasErrors()) {
            String workFlowAction = "";
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            Long approvalPosition = 0L;
            String approvalComent = "";
            String successMsg = "";
            if (request.getParameter("approvalComent") != null) {
                approvalComent = request.getParameter("approvalComent");
            }
            if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
            }
            this.vacancyRemissionService.saveVacancyRemissionApproval(vacancyRemissionApproval, approvalPosition, approvalComent, null, workFlowAction);
            if (StringUtils.isNotBlank((String)workFlowAction)) {
                Assignment assignment = new Assignment();
                assignment = this.assignmentService.getPrimaryAssignmentForUser(vacancyRemissionApproval.getVacancyRemission().getCreatedBy().getId());
                if (workFlowAction.equalsIgnoreCase("Approve")) {
                    successMsg = "Vacancy Remission Approved Successfully in the System and forwarded to " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                } else if (workFlowAction.equalsIgnoreCase("Reject")) {
                    if (this.designation.getName().equalsIgnoreCase("UD Revenue Inspector")) {
                        successMsg = "Vacancy Remission rejected successfully and forwarded to : " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                    } else {
                        assignment = this.assignmentService.getPrimaryAssignmentForUser(vacancyRemissionApproval.getCreatedBy().getId());
                        successMsg = "Vacancy Remission rejected successfully and forwarded to : " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                    }
                } else {
                    successMsg = "Vacancy Remission Saved Successfully in the System and forwarded to : " + this.propertyTaxUtil.getApproverUserName(approvalPosition);
                }
            }
            model.addAttribute("successMessage", (Object)successMsg);
            if (StringUtils.isNotBlank((String)workFlowAction) && workFlowAction.equalsIgnoreCase("Generate Notice")) {
                String pathVars = vacancyRemissionApproval.getVacancyRemission().getBasicProperty().getUpicNo() + "," + senderName;
                return "redirect:/vacancyremission/rejectionacknowledgement?pathVar=" + pathVars;
            }
        }
        return "vacancyRemission-success";
    }
}

