/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.exemption;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.TaxExeptionReason;
import org.egov.ptis.domain.service.exemption.TaxExemptionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/exemption/update/{id}"})
public class UpdateTaxExemptionController
extends GenericWorkFlowController {
    protected static final String TAX_EXEMPTION_FORM = "taxExemption-form";
    protected static final String TAX_EXEMPTION_SUCCESS = "taxExemption-success";
    protected static final String TAX_EXEMPTION_VIEW = "taxExemption-view";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    private TaxExemptionService taxExemptionService;
    private PropertyImpl property;
    private Boolean isExempted = Boolean.FALSE;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @Autowired
    public UpdateTaxExemptionController(TaxExemptionService taxExemptionService) {
        this.taxExemptionService = taxExemptionService;
    }

    @ModelAttribute
    public Property propertyModel(@PathVariable String id) {
        this.property = (PropertyImpl)this.taxExemptionService.findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        if (this.property == null) {
            this.property = (PropertyImpl)this.taxExemptionService.findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        }
        return this.property;
    }

    @ModelAttribute(value="taxExemptionReasons")
    public List<TaxExeptionReason> getTaxExemptionReasons() {
        return this.taxExemptionService.getSession().createQuery("from TaxExeptionReason order by name").list();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        this.isExempted = this.property.getBasicProperty().getActiveProperty().getIsExemptedFromTax();
        String userDesignationList = "";
        String currState = this.property.getState().getValue();
        String nextAction = this.property.getState().getNextAction();
        userDesignationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("stateType", (Object)this.property.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)this.property.getCurrentState().getValue());
        this.prepareWorkflow(model, (StateAware)this.property, new WorkflowContainer());
        model.addAttribute("userDesignationList", (Object)userDesignationList);
        model.addAttribute("designation", (Object)"Commissioner");
        model.addAttribute("isExempted", (Object)this.isExempted);
        this.taxExemptionService.addModelAttributes(model, this.property.getBasicProperty());
        if (currState.endsWith("Rejected") || nextAction.equalsIgnoreCase("UD Revenue Inspector Approval Pending") || currState.endsWith("NEW")) {
            model.addAttribute("mode", (Object)EDIT);
            return TAX_EXEMPTION_FORM;
        }
        model.addAttribute("mode", (Object)VIEW);
        return TAX_EXEMPTION_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Property property, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        Long approvalPosition = 0L;
        String approvalComent = "";
        String taxExemptedReason = "";
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
        if (workFlowAction.equalsIgnoreCase("Approve")) {
            property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            oldProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
        }
        if (workFlowAction.equalsIgnoreCase("Generate Notice")) {
            return "redirect:/notice/propertyTaxNotice-generateSpecialNotice.action?basicPropId=" + property.getBasicProperty().getId() + "&noticeType=" + "Special Notice" + "&noticeMode=" + "Tax_Exemption";
        }
        if (request.getParameter("mode").equalsIgnoreCase(VIEW)) {
            this.taxExemptionService.updateProperty(property, approvalComent, workFlowAction, approvalPosition, propertyByEmployee, "EXEMPTION");
        } else {
            if (request.getParameter("taxExemptedReason") != null) {
                taxExemptedReason = request.getParameter("taxExemptedReason");
            }
            this.taxExemptionService.saveProperty(property, (Property)oldProperty, status, approvalComent, workFlowAction, approvalPosition, taxExemptedReason, propertyByEmployee, "EXEMPTION");
        }
        String successMessage = "";
        Assignment assignment = new Assignment();
        if (property != null && property.getCreatedBy() != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId());
        }
        successMessage = workFlowAction.equalsIgnoreCase("Approve") ? (this.taxExemptionService.isPropertyByEmployee(property).booleanValue() ? "Property Exemption approved successfully and forwarded to  " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName()) + " with assessment number " + property.getBasicProperty().getUpicNo() : "Property Exemption approved successfully and forwarded to  " + this.propertyTaxUtil.getApproverUserName(((StateHistory)((PropertyImpl)property).getStateHistory().get(0)).getOwnerPosition().getId()) + " with assessment number " + property.getBasicProperty().getUpicNo()) : (workFlowAction.equalsIgnoreCase("Reject") ? (this.taxExemptionService.isPropertyByEmployee(property).booleanValue() ? "Property Exemption rejected successfully and forwared to initiator " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName()) + " with application number " + property.getApplicationNo() : "Property Exemption rejected successfully and forwared to initiator " + this.propertyTaxUtil.getApproverUserName(((StateHistory)((PropertyImpl)property).getStateHistory().get(0)).getOwnerPosition().getId()) + " with application number " + property.getApplicationNo()) : "Successfully forwarded to " + this.propertyTaxUtil.getApproverUserName(approvalPosition) + " with application number " + property.getApplicationNo());
        model.addAttribute("successMessage", (Object)successMessage);
        return TAX_EXEMPTION_SUCCESS;
    }
}

