/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.wall;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.master.service.WallTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/walltype"})
public class CreateAndViewWallTypeController {
    private final WallTypeService wallTypeService;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public CreateAndViewWallTypeController(WallTypeService wallTypeService) {
        this.wallTypeService = wallTypeService;
    }

    @ModelAttribute
    public WallType wallTypeModel() {
        return new WallType();
    }

    @ModelAttribute(value="wallTypes")
    public List<WallType> listWallTypes() {
        return this.wallTypeService.getAllWalls();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String showWallTypes(Model model) {
        String roleName = this.wallTypeService.getRolesForUserId(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("roleName", (Object)roleName);
        return "wallType-main";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create() {
        return "wallType-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute WallType wallType, BindingResult errors, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return "wallType-main";
        }
        this.wallTypeService.create(wallType);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.walltype.create.success");
        return "redirect:/walltype/create";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable Long id, Model model) {
        WallType wallType = this.wallTypeService.getWallTypeById(id);
        model.addAttribute("wallType", (Object)wallType);
        return "wallType-view";
    }
}

