/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import com.opensymphony.xwork2.ActionSupport;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.springframework.beans.factory.annotation.Autowired;

public class ZoneWiseDemandAction
extends ActionSupport {
    private static final Logger LOGGER = Logger.getLogger(ZoneWiseDemandAction.class);
    @Autowired
    private PropertyDAO propertyDAO;

    public String execute() {
        LOGGER.debug((Object)"Entered into execute method");
        String target = "failure";
        try {
            HttpServletRequest request = ServletActionContext.getRequest();
            Criterion criterion = null;
            ProjectionList projection = Projections.projectionList().add((Projection)Projections.property((String)"zone.id")).add((Projection)Projections.sum((String)"aggrArrDmd")).add((Projection)Projections.sum((String)"aggrCurrDmd")).add((Projection)Projections.groupProperty((String)"zone.id"));
            Order order = Order.asc((String)"zone.id");
            List zoneDemandList = this.propertyDAO.getPropMaterlizeViewList((Projection)projection, criterion, order);
            LOGGER.debug((Object)("Zone wise demand list : " + (zoneDemandList != null ? zoneDemandList : BigDecimal.ZERO)));
            LinkedList links = this.prepareDispTagList(zoneDemandList);
            request.setAttribute("links", (Object)links);
            target = "success";
        }
        catch (Exception e) {
            target = "failure";
            LOGGER.error((Object)("Error in ZoneWiseDemandAction : " + e.getMessage()));
            throw new ApplicationRuntimeException("error in ZoneWiseDemandAction---------------", (Throwable)e);
        }
        LOGGER.debug((Object)"Exit from execute method");
        return target;
    }

    public LinkedList<Map<String, Object>> prepareDispTagList(List zoneDemandList) {
        LOGGER.debug((Object)"Entered into prepareDispTagList method");
        LOGGER.debug((Object)("Zone wise demand list : " + (zoneDemandList != null ? zoneDemandList : BigDecimal.ZERO)));
        String zoneNumber = "";
        BigDecimal arrearDemand = BigDecimal.ZERO;
        BigDecimal currentDemand = BigDecimal.ZERO;
        BigDecimal totalCurrDemand = BigDecimal.ZERO;
        BigDecimal totalArrearDemand = BigDecimal.ZERO;
        BigDecimal totalDemand = BigDecimal.ZERO;
        BigDecimal grandTotalDemand = BigDecimal.ZERO;
        LinkedList<Map<String, Object>> links = new LinkedList<Map<String, Object>>();
        Hashtable<String, Object> totalsMap = new Hashtable<String, Object>();
        if (zoneDemandList != null && !zoneDemandList.isEmpty()) {
            for (Object object : zoneDemandList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                zoneNumber = "";
                arrearDemand = BigDecimal.ZERO;
                currentDemand = BigDecimal.ZERO;
                Object[] arrayObject = (Object[])object;
                if (arrayObject[0] != null) {
                    zoneNumber = arrayObject[0].toString();
                    LOGGER.debug((Object)("Zone number : " + zoneNumber));
                }
                if (arrayObject[1] != null) {
                    arrearDemand = (BigDecimal)arrayObject[1];
                    LOGGER.debug((Object)("Arrear Demand : " + arrearDemand));
                    totalArrearDemand = totalArrearDemand.add(arrearDemand);
                }
                if (arrayObject[2] != null) {
                    currentDemand = (BigDecimal)arrayObject[2];
                    LOGGER.debug((Object)("Current Demand : " + currentDemand));
                    totalCurrDemand = totalCurrDemand.add(currentDemand);
                }
                totalDemand = arrearDemand.add(currentDemand);
                LOGGER.debug((Object)("Total Demand : " + totalDemand));
                grandTotalDemand = grandTotalDemand.add(totalDemand);
                map.put("zoneNumber", zoneNumber);
                map.put("totalArrearsDemand(Rs.)", arrearDemand);
                map.put("totalCurrentDemand(Rs.)", currentDemand);
                map.put("totalDemand(Rs.)", totalDemand);
                links.add(map);
            }
            totalsMap.put("zoneNumber", "Total(Rs.)");
            totalsMap.put("totalArrearsDemand(Rs.)", totalArrearDemand);
            LOGGER.debug((Object)("Total Arrear Demand : " + totalArrearDemand));
            totalsMap.put("totalCurrentDemand(Rs.)", totalCurrDemand);
            LOGGER.debug((Object)("Total Current Demand : " + totalCurrDemand));
            totalsMap.put("totalDemand(Rs.)", grandTotalDemand);
            LOGGER.debug((Object)("Grand Total Demand : " + grandTotalDemand));
            links.add(totalsMap);
        }
        LOGGER.debug((Object)"Exit from prepareDispTagList method");
        return links;
    }
}

