/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.actions.reports.TitleTransferReportHelperAdaptor;
import org.egov.ptis.actions.reports.TitleTransferReportResult;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationTransferee;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"search"}, location="titleTransferRegister-search.jsp")})
public class TitleTransferRegisterAction
extends BaseFormAction {
    private static final long serialVersionUID = 1456869850164051736L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    public static final String SEARCH = "search";
    private Long zoneId;
    private Long wardId;
    private Long areaId;
    private String fromDate;
    private String toDate;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    public FinancialYearDAO financialYearDAO;
    @Autowired
    public PropertyTaxUtil propertyTaxUtil;
    private String finYearStartDate;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

    public Object getModel() {
        return null;
    }

    public void prepare() {
        CFinancialYear finyear;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepare method");
        }
        super.prepare();
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        this.addDropdownData("zoneList", zoneList);
        this.addDropdownData("wardList", wardList);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Zone id : " + this.zoneId + ", Ward id : " + this.wardId));
        }
        if (this.wardId == null || this.wardId.equals(-1)) {
            this.addDropdownData("blockList", Collections.EMPTY_LIST);
        }
        this.prepareBlockDropDownData(this.wardId != null, this.areaId != null);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepare method");
        }
        if ((finyear = this.financialYearDAO.getFinancialYearByDate(new Date())) != null) {
            this.finYearStartDate = this.sdf.format(finyear.getStartingDate());
        }
    }

    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
            this.LOGGER.debug((Object)("Zone Exists ? : " + zoneExists + ", Ward Exists ? : " + wardExists));
        }
        if (zoneExists && wardExists) {
            List wardList = new ArrayList();
            wardList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getZoneId());
            this.addDropdownData("wardList", wardList);
        } else {
            this.addDropdownData("wardList", Collections.EMPTY_LIST);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    private void prepareBlockDropDownData(boolean wardExists, boolean blockExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareBlockDropDownData method");
            this.LOGGER.debug((Object)("Ward Exists ? : " + wardExists + ", Block Exists ? : " + blockExists));
        }
        if (wardExists && blockExists) {
            List blockList = new ArrayList();
            blockList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getWardId());
            this.addDropdownData("blockList", blockList);
        } else {
            this.addDropdownData("blockList", Collections.EMPTY_LIST);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    @SkipValidation
    @Action(value="/reports/titleTransferRegister-search")
    public String search() {
        this.fromDate = this.finYearStartDate;
        this.toDate = this.sdf.format(new Date());
        return SEARCH;
    }

    @Action(value="/titleTransferRegister-getPropertyList")
    public void getPropertyList() throws IOException {
        List resultList = new ArrayList();
        String result = null;
        Query query = this.propertyTaxUtil.prepareQueryforTitleTransferReport(this.zoneId, this.wardId, this.areaId, this.fromDate, this.toDate);
        resultList = this.prepareOutput(query.list());
        result = "{ \"data\":" + WebUtils.toJSON(resultList, TitleTransferReportResult.class, TitleTransferReportHelperAdaptor.class) + "}";
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private List<TitleTransferReportResult> prepareOutput(List<PropertyMutation> propertyMutationList) {
        LinkedList<TitleTransferReportResult> ttrFinalList = new LinkedList<TitleTransferReportResult>();
        CFinancialYear finyear = this.financialYearDAO.getFinancialYearByDate(new Date());
        ArrayList<Long> basicPropList = new ArrayList<Long>();
        TitleTransferReportResult ttrInfoTotal = null;
        TitleTransferReportResult titleTransferReportInfo = new TitleTransferReportResult();
        for (PropertyMutation propMutation : propertyMutationList) {
            if (basicPropList.size() == 0) {
                titleTransferReportInfo = this.PreparePropertyWiseInfo(propMutation, finyear);
                basicPropList.add(propMutation.getBasicProperty().getId());
                ttrInfoTotal = titleTransferReportInfo;
                ttrFinalList.add(ttrInfoTotal);
                continue;
            }
            if (basicPropList.contains(propMutation.getBasicProperty().getId())) {
                ttrInfoTotal = titleTransferReportInfo = this.addPropertyWiseInfo(propMutation, finyear);
                ttrFinalList.add(ttrInfoTotal);
                continue;
            }
            if (basicPropList.contains(propMutation.getBasicProperty().getId())) continue;
            titleTransferReportInfo = this.PreparePropertyWiseInfo(propMutation, finyear);
            basicPropList.add(propMutation.getBasicProperty().getId());
            ttrInfoTotal = titleTransferReportInfo;
            ttrFinalList.add(ttrInfoTotal);
        }
        return ttrFinalList;
    }

    private TitleTransferReportResult PreparePropertyWiseInfo(PropertyMutation propertyMutation, CFinancialYear finyear) {
        TitleTransferReportResult ttrObj = new TitleTransferReportResult();
        String ownerName = "";
        ttrObj.setAssessmentNo(propertyMutation.getBasicProperty().getUpicNo());
        if (propertyMutation.getTransfereeInfos() != null && propertyMutation.getTransfereeInfos().size() > 0) {
            String newOwnerName = "";
            for (PropertyMutationTransferee usr : propertyMutation.getTransfereeInfos()) {
                newOwnerName = newOwnerName + usr.getTransferee().getName() + ",";
            }
            ttrObj.setOwnerName(newOwnerName.substring(0, newOwnerName.length() - 1));
        }
        ttrObj.setDoorNo(propertyMutation.getBasicProperty().getAddress().getHouseNoBldgApt());
        ttrObj.setLocation(propertyMutation.getBasicProperty().getPropertyID().getLocality().getName());
        BigDecimal taxAmount = this.propertyTaxUtil.getPropertyTaxDetails(propertyMutation.getBasicProperty().getId(), finyear);
        if (null != taxAmount) {
            ttrObj.setPropertyTax(taxAmount.toString());
        }
        if (propertyMutation.getTransferorInfos() != null && propertyMutation.getTransferorInfos().size() > 0) {
            for (PropertyMutationTransferee usr : propertyMutation.getTransferorInfos()) {
                ownerName = ownerName + usr.getName() + ",";
            }
            ttrObj.setOldTitle(ownerName.substring(0, ownerName.length() - 1));
        }
        if (propertyMutation.getTransfereeInfos() != null && propertyMutation.getTransfereeInfos().size() > 0) {
            ownerName = "";
            for (PropertyMutationTransferee usr : propertyMutation.getTransfereeInfos()) {
                ownerName = ownerName + usr.getTransferee().getName() + ",";
            }
            ttrObj.setChangedTitle(ownerName.substring(0, ownerName.length() - 1));
        }
        ttrObj.setDateOfTransfer(this.sdf.format(propertyMutation.getLastModifiedDate()));
        ttrObj.setCommissionerOrder("APPROVED");
        ttrObj.setMutationFee(propertyMutation.getMutationFee());
        return ttrObj;
    }

    private TitleTransferReportResult addPropertyWiseInfo(PropertyMutation propertyMutation, CFinancialYear finyear) {
        TitleTransferReportResult ttrObj = new TitleTransferReportResult();
        String ownerName = "";
        ttrObj.setAssessmentNo("");
        ttrObj.setOwnerName("");
        ttrObj.setDoorNo("");
        ttrObj.setLocation("");
        ttrObj.setPropertyTax("");
        if (propertyMutation.getTransferorInfos() != null && propertyMutation.getTransferorInfos().size() > 0) {
            for (User usr : propertyMutation.getTransferorInfos()) {
                ownerName = ownerName + usr.getName() + ",";
            }
            ttrObj.setOldTitle(ownerName.substring(0, ownerName.length() - 1));
        }
        if (propertyMutation.getTransfereeInfos() != null && propertyMutation.getTransfereeInfos().size() > 0) {
            ownerName = "";
            for (User usr : propertyMutation.getTransfereeInfos()) {
                ownerName = ownerName + usr.getTransferee().getName() + ",";
            }
            ttrObj.setChangedTitle(ownerName.substring(0, ownerName.length() - 1));
        }
        ttrObj.setDateOfTransfer(this.sdf.format(propertyMutation.getLastModifiedDate()));
        ttrObj.setCommissionerOrder("APPROVED");
        ttrObj.setMutationFee(propertyMutation.getMutationFee());
        return ttrObj;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public String getFinYearStartDate() {
        return this.finYearStartDate;
    }

    public void setFinYearStartDate(String finYearStartDate) {
        this.finYearStartDate = finYearStartDate;
    }
}

