/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.actions.reports.CollectionSummaryReportHelperAdaptor;
import org.egov.ptis.actions.reports.CollectionSummaryReportResult;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.PropertyUsageDAO;
import org.egov.ptis.domain.entity.property.CollectionSummary;
import org.egov.ptis.domain.entity.property.CollectionSummaryDetails;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"view"}, location="collectionSummaryReport-view.jsp")})
public class CollectionSummaryReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -3560529685172919434L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private Map<Long, String> zoneBndryMap;
    private Map<Long, String> wardBndryMap;
    private Map<Long, String> blockBndryMap;
    private Map<Long, String> localityBndryMap;
    private Map<Character, String> collectionModesMap;
    private List<Map<String, Object>> resultList;
    private List<PropertyUsage> propUsageList;
    @Autowired
    public PropertyTaxUtil propertyTaxUtil;
    @Autowired
    public FinancialYearDAO financialYearDAO;
    @Autowired
    public PropertyUsageDAO propertyUsageDAO;
    @Autowired
    private BoundaryService boundaryService;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    public static final String ZONEWISE = "zoneWise";
    public static final String WARDWISE = "wardWise";
    public static final String BLOCKWISE = "blockWise";
    public static final String LOCALITYWISE = "localityWise";
    public static final String USAGEWISE = "usageWise";
    private static final String CURR_DATE = "currentDate";
    private Long zoneId;
    private Long wardId;
    private Long blockId;
    private String propTypeCategoryId;
    private String finYearStartDate;
    private String dateSelected;
    private String fromDate;
    private String toDate;
    private String boundaryId;
    private String collMode;
    private String transMode;
    private String mode;
    BigDecimal taxAmount = BigDecimal.ZERO;
    BigDecimal totTaxAmt = BigDecimal.ZERO;
    BigDecimal arrearTaxAmount = BigDecimal.ZERO;
    BigDecimal totArrearTaxAmt = BigDecimal.ZERO;
    BigDecimal penaltyAmount = BigDecimal.ZERO;
    BigDecimal totPenaltyAmt = BigDecimal.ZERO;
    BigDecimal arrearPenaltyAmount = BigDecimal.ZERO;
    BigDecimal totArrearPenaltyAmt = BigDecimal.ZERO;
    BigDecimal libCessAmount = BigDecimal.ZERO;
    BigDecimal totLibCessAmt = BigDecimal.ZERO;
    BigDecimal arrearLibCessAmount = BigDecimal.ZERO;
    BigDecimal totArrearLibCessAmt = BigDecimal.ZERO;
    BigDecimal grandTotal = BigDecimal.ZERO;
    Long prevZone = null;
    Long prevWard = null;
    Long prevBlock = null;
    Long prevLocality = null;
    String prevPropertyType = null;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepare method");
        }
        super.prepare();
        this.setZoneBndryMap(CommonServices.getFormattedBndryMap((List)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE")));
        this.setWardBndryMap(CommonServices.getFormattedBndryMap((List)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE")));
        this.setBlockBndryMap(CommonServices.getFormattedBndryMap((List)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Block", "REVENUE")));
        this.setLocalityBndryMap(CommonServices.getFormattedBndryMap((List)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION")));
        this.addDropdownData("instrumentTypeList", this.propertyTaxUtil.prepareInstrumentTypeList());
        this.setCollectionModesMap(PropertyTaxConstants.COLL_MODES_MAP);
        CFinancialYear finyear = this.financialYearDAO.getFinancialYearByDate(new Date());
        if (finyear != null) {
            this.finYearStartDate = this.sdf.format(finyear.getStartingDate());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepare method");
        }
        super.prepare();
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        this.addDropdownData("zoneList", zoneList);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Zone id : " + this.zoneId + ", Ward id : " + this.wardId));
        }
        if (this.wardId == null || this.wardId.equals(-1)) {
            this.addDropdownData("blockList", Collections.EMPTY_LIST);
        }
        this.prepareBlockDropDownData(this.wardId != null, this.blockId != null);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepare method");
        }
        this.propUsageList = this.propertyUsageDAO.getPropUsageAscOrder();
        this.addDropdownData("propUsageList", this.propUsageList);
    }

    private void prepareBlockDropDownData(boolean wardExists, boolean blockExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareBlockDropDownData method");
            this.LOGGER.debug((Object)("Ward Exists ? : " + wardExists + ", Block Exists ? : " + blockExists));
        }
        if (wardExists && blockExists) {
            List blockList = new ArrayList();
            blockList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getWardId());
            this.addDropdownData("blockList", blockList);
        } else {
            this.addDropdownData("blockList", Collections.EMPTY_LIST);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    @SkipValidation
    @Action(value="/reports/collectionSummaryReport-zoneWise")
    public String zoneWise() {
        this.fromDate = this.finYearStartDate;
        this.toDate = this.sdf.format(new Date());
        this.setMode(ZONEWISE);
        return "view";
    }

    @SkipValidation
    @Action(value="/reports/collectionSummaryReport-wardWise")
    public String wardWise() {
        this.fromDate = this.finYearStartDate;
        this.toDate = this.sdf.format(new Date());
        this.setMode(WARDWISE);
        return "view";
    }

    @SkipValidation
    @Action(value="/reports/collectionSummaryReport-blockWise")
    public String blockWise() {
        this.fromDate = this.finYearStartDate;
        this.toDate = this.sdf.format(new Date());
        this.setMode(BLOCKWISE);
        return "view";
    }

    @SkipValidation
    @Action(value="/reports/collectionSummaryReport-localityWise")
    public String localityWise() {
        this.fromDate = this.finYearStartDate;
        this.toDate = this.sdf.format(new Date());
        this.setMode(LOCALITYWISE);
        return "view";
    }

    @SkipValidation
    @Action(value="/reports/collectionSummaryReport-usageWise")
    public String usageWise() {
        this.fromDate = this.finYearStartDate;
        this.toDate = this.sdf.format(new Date());
        this.setMode(USAGEWISE);
        return "view";
    }

    @ValidationErrorPage(value="view")
    @Action(value="/reports/collectionSummaryReport-list")
    public void list() throws ParseException, IOException {
        List resultList = new ArrayList();
        String result = null;
        Query query = this.prepareQuery();
        resultList = this.prepareOutput(query.list());
        result = "{ \"data\":" + WebUtils.toJSON(resultList, CollectionSummaryReportResult.class, CollectionSummaryReportHelperAdaptor.class) + "}";
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    public Query prepareQuery() {
        try {
            String currDate = this.sdf.format(new Date());
            if (currDate.equals(this.fromDate) || currDate.equals(this.toDate)) {
                this.dateSelected = CURR_DATE;
            }
            return this.propertyTaxUtil.prepareQueryforCollectionSummaryReport(this.fromDate, this.toDate, this.collMode, this.transMode, this.mode, this.boundaryId, this.propTypeCategoryId, this.zoneId, this.wardId, this.blockId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.LOGGER.error((Object)"Error occured in Class : CollectionSummaryReportAction  Method : list", (Throwable)e);
            throw new ApplicationRuntimeException("Error occured in Class : CollectionSummaryReportAction  Method : list " + e.getMessage());
        }
    }

    private List<CollectionSummaryReportResult> prepareOutput(List<CollectionSummary> collectionSummaryList) throws ParseException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareResultList method");
        }
        LinkedList<CollectionSummaryReportResult> csrFinalList = new LinkedList<CollectionSummaryReportResult>();
        try {
            if (collectionSummaryList != null && !collectionSummaryList.isEmpty()) {
                for (CollectionSummary collSummary : collectionSummaryList) {
                    ArrayList collDetails = new ArrayList(collSummary.getCollectionDetails());
                    CollectionSummaryDetails summaryDetails = (CollectionSummaryDetails)collDetails.get(0);
                    if (this.prevZone == null && this.prevWard == null && this.prevBlock == null && this.prevLocality == null && this.prevPropertyType == null) {
                        this.initializeReasonAmount(collSummary, summaryDetails);
                        continue;
                    }
                    if (this.prevZone != null && this.prevZone.equals(collSummary.getZoneId().getId()) || this.prevWard != null && this.prevWard.equals(collSummary.getWardId().getId()) || this.prevBlock != null && this.prevBlock.equals(collSummary.getAreaId().getId()) || this.prevLocality != null && this.prevLocality.equals(collSummary.getLocalityId().getId()) || this.prevPropertyType != null && this.prevPropertyType.equalsIgnoreCase(collSummary.getProperty().getPropertyDetail().getCategoryType())) {
                        this.taxAmount = this.taxAmount != null ? (summaryDetails.getCurrentTaxColl() != null ? this.taxAmount.add(summaryDetails.getCurrentTaxColl()) : this.taxAmount) : summaryDetails.getCurrentTaxColl();
                        this.arrearTaxAmount = this.arrearTaxAmount != null ? (summaryDetails.getArrearTaxColl() != null ? this.arrearTaxAmount.add(summaryDetails.getArrearTaxColl()) : this.arrearTaxAmount) : summaryDetails.getArrearTaxColl();
                        this.penaltyAmount = this.penaltyAmount != null ? (summaryDetails.getPenaltyColl() != null ? this.penaltyAmount.add(summaryDetails.getPenaltyColl()) : this.penaltyAmount) : summaryDetails.getPenaltyColl();
                        this.arrearPenaltyAmount = this.arrearPenaltyAmount != null ? (summaryDetails.getArrearPenaltyColl() != null ? this.arrearPenaltyAmount.add(summaryDetails.getArrearPenaltyColl()) : this.arrearPenaltyAmount) : summaryDetails.getArrearPenaltyColl();
                        this.libCessAmount = this.libCessAmount != null ? (summaryDetails.getLibCessColl() != null ? this.libCessAmount.add(summaryDetails.getLibCessColl()) : this.libCessAmount) : summaryDetails.getLibCessColl();
                        if (this.arrearLibCessAmount != null) {
                            this.arrearLibCessAmount = summaryDetails.getArrearLibCessColl() != null ? this.arrearLibCessAmount.add(summaryDetails.getArrearLibCessColl()) : this.arrearLibCessAmount;
                            continue;
                        }
                        this.arrearLibCessAmount = summaryDetails.getArrearLibCessColl();
                        continue;
                    }
                    csrFinalList.add(this.getCalculatedResultMap());
                    this.initializeReasonAmount(collSummary, summaryDetails);
                }
                csrFinalList.add(this.getCalculatedResultMap());
            }
        }
        catch (Exception e) {
            this.LOGGER.error((Object)("Exception in prepareBndryWiseResultList method : " + e.getMessage()));
            e.printStackTrace();
            throw new ApplicationRuntimeException("Exception in prepareBndryWiseResultList method : ", (Throwable)e);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareResultList method");
        }
        return csrFinalList;
    }

    private void initializeReasonAmount(CollectionSummary collSummary, CollectionSummaryDetails details) {
        if (this.mode.equals(ZONEWISE)) {
            this.prevZone = collSummary.getZoneId().getId();
        } else if (this.mode.equals(WARDWISE)) {
            this.prevWard = collSummary.getWardId().getId();
        } else if (this.mode.equals(BLOCKWISE)) {
            this.prevBlock = collSummary.getAreaId().getId();
        } else if (this.mode.equals(LOCALITYWISE)) {
            this.prevLocality = collSummary.getLocalityId().getId();
        } else if (this.mode.equals(USAGEWISE)) {
            this.prevPropertyType = collSummary.getProperty().getPropertyDetail().getCategoryType();
        }
        this.taxAmount = details.getCurrentTaxColl();
        this.arrearTaxAmount = details.getArrearTaxColl();
        this.penaltyAmount = details.getPenaltyColl();
        this.arrearPenaltyAmount = details.getArrearPenaltyColl();
        this.libCessAmount = details.getLibCessColl();
        this.arrearLibCessAmount = details.getArrearLibCessColl();
    }

    private CollectionSummaryReportResult getCalculatedResultMap() {
        CollectionSummaryReportResult result = new CollectionSummaryReportResult();
        if (this.mode.equals(ZONEWISE)) {
            result.setBoundaryName(this.boundaryService.getBoundaryById(this.prevZone).getName());
        } else if (this.mode.equals(WARDWISE)) {
            result.setBoundaryName(this.boundaryService.getBoundaryById(this.prevWard).getName());
        } else if (this.mode.equals(BLOCKWISE)) {
            result.setBoundaryName(this.boundaryService.getBoundaryById(this.prevBlock).getName());
        } else if (this.mode.equals(LOCALITYWISE)) {
            result.setBoundaryName(this.boundaryService.getBoundaryById(this.prevLocality).getName());
        } else if (this.mode.equals(USAGEWISE)) {
            result.setPropertyType(this.prevPropertyType);
        }
        result.setArrearTaxAmount(this.arrearTaxAmount != null ? this.arrearTaxAmount : BigDecimal.ZERO);
        this.totArrearTaxAmt = this.arrearTaxAmount != null ? this.totArrearTaxAmt.add(this.arrearTaxAmount) : this.totArrearTaxAmt.add(BigDecimal.ZERO);
        result.setArrearLibraryCess(this.arrearLibCessAmount != null ? this.arrearLibCessAmount : BigDecimal.ZERO);
        this.totArrearLibCessAmt = this.arrearLibCessAmount != null ? this.totArrearLibCessAmt.add(this.arrearLibCessAmount) : this.totArrearLibCessAmt.add(BigDecimal.ZERO);
        result.setArrearTotal(this.totArrearTaxAmt.add(this.totArrearLibCessAmt));
        result.setTaxAmount(this.taxAmount);
        this.totTaxAmt = this.taxAmount != null ? this.totTaxAmt.add(this.taxAmount) : this.totTaxAmt.add(BigDecimal.ZERO);
        result.setLibraryCess(this.libCessAmount != null ? this.libCessAmount : BigDecimal.ZERO);
        this.totLibCessAmt = this.libCessAmount != null ? this.totLibCessAmt.add(this.libCessAmount) : this.totLibCessAmt.add(BigDecimal.ZERO);
        result.setCurrentTotal(this.totTaxAmt.add(this.totLibCessAmt));
        result.setPenalty(this.penaltyAmount != null ? this.penaltyAmount : BigDecimal.ZERO);
        this.totPenaltyAmt = this.penaltyAmount != null ? this.totPenaltyAmt.add(this.penaltyAmount) : this.totPenaltyAmt.add(BigDecimal.ZERO);
        result.setArrearPenalty(this.arrearPenaltyAmount != null ? this.arrearPenaltyAmount : BigDecimal.ZERO);
        this.totArrearPenaltyAmt = this.arrearPenaltyAmount != null ? this.totArrearPenaltyAmt.add(this.arrearPenaltyAmount) : this.totArrearPenaltyAmt.add(BigDecimal.ZERO);
        result.setPenaltyTotal(this.totPenaltyAmt.add(this.totArrearPenaltyAmt));
        BigDecimal bigDecimal = this.taxAmount = this.taxAmount != null ? this.taxAmount : BigDecimal.ZERO;
        if (this.arrearTaxAmount != null) {
            this.taxAmount = this.taxAmount.add(this.arrearTaxAmount);
        }
        if (this.penaltyAmount != null) {
            this.taxAmount = this.taxAmount.add(this.penaltyAmount);
        }
        if (this.arrearPenaltyAmount != null) {
            this.taxAmount = this.taxAmount.add(this.arrearPenaltyAmount);
        }
        if (this.libCessAmount != null) {
            this.taxAmount = this.taxAmount.add(this.libCessAmount);
        }
        if (this.arrearLibCessAmount != null) {
            this.taxAmount = this.taxAmount.add(this.arrearLibCessAmount);
        }
        result.setTotal(this.taxAmount);
        return result;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Map<Character, String> getCollectionModesMap() {
        return this.collectionModesMap;
    }

    public void setCollectionModesMap(Map<Character, String> collectionModesMap) {
        this.collectionModesMap = collectionModesMap;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public String getCollMode() {
        return this.collMode;
    }

    public void setCollMode(String collMode) {
        this.collMode = collMode;
    }

    public String getTransMode() {
        return this.transMode;
    }

    public void setTransMode(String transMode) {
        this.transMode = transMode;
    }

    public List<Map<String, Object>> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<Map<String, Object>> resultList) {
        this.resultList = resultList;
    }

    public String getDateSelected() {
        return this.dateSelected;
    }

    public void setDateSelected(String dateSelected) {
        this.dateSelected = dateSelected;
    }

    public String getBoundaryId() {
        return this.boundaryId;
    }

    public void setBoundaryId(String boundaryId) {
        this.boundaryId = boundaryId;
    }

    public Map<Long, String> getWardBndryMap() {
        return this.wardBndryMap;
    }

    public void setWardBndryMap(Map<Long, String> wardBndryMap) {
        this.wardBndryMap = wardBndryMap;
    }

    public Map<Long, String> getBlockBndryMap() {
        return this.blockBndryMap;
    }

    public void setBlockBndryMap(Map<Long, String> blockBndryMap) {
        this.blockBndryMap = blockBndryMap;
    }

    public Map<Long, String> getLocalityBndryMap() {
        return this.localityBndryMap;
    }

    public void setLocalityBndryMap(Map<Long, String> localityBndryMap) {
        this.localityBndryMap = localityBndryMap;
    }

    public Map<Long, String> getZoneBndryMap() {
        return this.zoneBndryMap;
    }

    public void setZoneBndryMap(Map<Long, String> zoneBndryMap) {
        this.zoneBndryMap = zoneBndryMap;
    }

    public List<PropertyUsage> getPropUsageList() {
        return this.propUsageList;
    }

    public void setPropUsageList(List<PropertyUsage> propUsageList) {
        this.propUsageList = propUsageList;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getPropTypeCategoryId() {
        return this.propTypeCategoryId;
    }

    public void setPropTypeCategoryId(String propTypeCategoryId) {
        this.propTypeCategoryId = propTypeCategoryId;
    }

    public String getFinYearStartDate() {
        return this.finYearStartDate;
    }

    public void setFinYearStartDate(String finYearStartDate) {
        this.finYearStartDate = finYearStartDate;
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(Long blockId) {
        this.blockId = blockId;
    }
}

