/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.notice;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.bean.PropertyNoticeInfo;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"notice"}, location="propertyTaxNotice-notice.jsp"), @Result(name={"digitalSignatureRedirection"}, location="propertyTaxNotice-digitalSignatureRedirection.jsp")})
public class PropertyTaxNoticeAction
extends PropertyTaxBaseAction {
    private static final String ALTER = "Alter";
    private static final String BIFURCATE = "Bifurcate";
    private static final String DEMOLITION = "Demolition";
    private static final String REVISION_PETITION = "Revision Petition";
    private static final String MODIFY = "modify";
    private static final String CREATE = "create";
    protected static final String DIGITAL_SIGNATURE_REDIRECTION = "digitalSignatureRedirection";
    private static final String PREVIEW = "Preview";
    private static final long serialVersionUID = -396864022983903198L;
    private static final Logger LOGGER = Logger.getLogger(PropertyTaxNoticeAction.class);
    public static final String NOTICE = "notice";
    private static final String VACANT_LAND = "Vacant Land";
    private static final String TAXEXEMPT = "Tax_Exemption";
    private PropertyImpl property;
    private ReportService reportService;
    private NoticeService noticeService;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private String reportId;
    private String noticeType;
    private InputStream NoticePDF;
    private Long basicPropId;
    private String noticeMode;
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private PropertyService propService;
    final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private String actionType;
    private String basicPropertyIds;
    private String fileStoreIds;
    private String ulbCode;
    private RevisionPetitionService revisionPetitionService;
    private String signedFileStoreId;
    private boolean digitalSignEnabled;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    @Qualifier(value="transferOwnerService")
    private PropertyTransferService transferOwnerService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public StateAware getModel() {
        return null;
    }

    public void prepare() {
        this.digitalSignEnabled = this.propertyTaxCommonUtils.isDigitalSignatureEnabled();
    }

    @Action(value="/notice/propertyTaxNotice-generateBulkNotice")
    public String generateBulkNotice() {
        this.setUlbCode(ApplicationThreadLocals.getCityCode());
        this.noticeType = "Special Notice";
        this.actionType = "Sign";
        String[] entries = this.basicPropertyIds.split(",");
        StringBuffer fileStoreId = new StringBuffer();
        for (String entry : entries) {
            String[] id;
            if (!fileStoreId.toString().equals("")) {
                fileStoreId.append(",");
            }
            if (CREATE.equalsIgnoreCase((id = entry.split("~"))[1]) || ALTER.equalsIgnoreCase(id[1]) || BIFURCATE.equalsIgnoreCase(id[1])) {
                this.noticeMode = CREATE.equalsIgnoreCase(id[1]) ? CREATE : MODIFY;
                fileStoreId.append(this.generatePropertyNotice(Long.valueOf(id[0]), id[1]));
                continue;
            }
            if (REVISION_PETITION.equalsIgnoreCase(id[1])) {
                fileStoreId.append(this.generatePropertyNotice(Long.valueOf(id[0]), id[1]));
                continue;
            }
            if (DEMOLITION.equalsIgnoreCase(id[1])) {
                this.noticeMode = DEMOLITION;
                BasicPropertyImpl basicProperty = (BasicPropertyImpl)this.getPersistenceService().findByNamedQuery("getBasicPropertyByBasicPropId", new Object[]{Long.valueOf(id[0])});
                if (basicProperty.getWFProperty() != null) {
                    basicProperty.getProperty().setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
                    basicProperty.getWFProperty().setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
                    this.basicPropertyService.update((Object)basicProperty);
                }
                fileStoreId.append(this.generatePropertyNotice(Long.valueOf(id[0]), id[1]));
                continue;
            }
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            Boolean isCorporation = cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            PropertyMutation propertyMutation = (PropertyMutation)this.persistenceService.find("From PropertyMutation where id = ? ", new Object[]{Long.valueOf(id[0])});
            BasicProperty basicProperty = propertyMutation.getBasicProperty();
            this.transferOwnerService.generateTransferNotice(basicProperty, propertyMutation, cityName, cityLogo, "Sign", isCorporation.booleanValue());
            PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("Mutation Certificate", propertyMutation.getApplicationNo());
            fileStoreId.append(notice.getFileStore().getFileStoreId());
        }
        this.setFileStoreIds(fileStoreId.toString());
        return DIGITAL_SIGNATURE_REDIRECTION;
    }

    private String generatePropertyNotice(Long basicPropertyId, String type) {
        BasicPropertyImpl basicProperty = null;
        PtNotice notice = null;
        RevisionPetition revisionPetition = null;
        if (REVISION_PETITION.equalsIgnoreCase(type)) {
            revisionPetition = (RevisionPetition)this.revisionPetitionService.findById((Serializable)basicPropertyId, false);
            basicProperty = (BasicPropertyImpl)revisionPetition.getBasicProperty();
            this.property = (PropertyImpl)basicProperty.getProperty();
            if (this.property == null) {
                this.property = (PropertyImpl)basicProperty.getWFProperty();
            }
            notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("Special Notice", revisionPetition.getObjectionNumber());
        } else {
            basicProperty = (BasicPropertyImpl)this.getPersistenceService().findByNamedQuery("getBasicPropertyByBasicPropId", new Object[]{basicPropertyId});
            this.property = (PropertyImpl)basicProperty.getProperty();
            if (this.property == null) {
                this.property = (PropertyImpl)basicProperty.getWFProperty();
            }
            notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber(this.noticeType, this.property.getApplicationNo());
        }
        ReportOutput reportOutput = new ReportOutput();
        PropertyNoticeInfo propertyNotice = null;
        String noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber(this.noticeType);
        propertyNotice = new PropertyNoticeInfo(this.property, noticeNo);
        ReportRequest reportInput = this.generateNoticeReportRequest(basicProperty, propertyNotice);
        reportOutput = this.reportService.createReport(reportInput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.NoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        PtNotice savedNotice = null;
        savedNotice = notice == null ? (REVISION_PETITION.equalsIgnoreCase(type) ? this.noticeService.saveNotice(revisionPetition.getObjectionNumber(), revisionPetition.getObjectionNumber().concat("SPECIALNOTICE"), "Special Notice", revisionPetition.getBasicProperty(), this.NoticePDF) : this.noticeService.saveNotice(basicProperty.getPropertyForBasicProperty().getApplicationNo(), noticeNo, this.noticeType, (BasicProperty)basicProperty, this.NoticePDF)) : this.noticeService.updateNotice(notice, this.NoticePDF);
        this.noticeService.getSession().flush();
        return savedNotice.getFileStore().getFileStoreId();
    }

    @Action(value="/notice/propertyTaxNotice-generateNotice")
    public String generateNotice() {
        this.setUlbCode(ApplicationThreadLocals.getCityCode());
        BasicPropertyImpl basicProperty = (BasicPropertyImpl)this.getPersistenceService().findByNamedQuery("getBasicPropertyByBasicPropId", new Object[]{this.basicPropId});
        this.property = (PropertyImpl)basicProperty.getProperty();
        if (this.property == null) {
            this.property = (PropertyImpl)basicProperty.getWFProperty();
        }
        PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber(this.noticeType, this.property.getApplicationNo());
        ReportOutput reportOutput = new ReportOutput();
        if ("Generate Notice".equalsIgnoreCase(this.actionType)) {
            byte[] bFile;
            FileStoreMapper fsm = notice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating Special Notcie : " + e);
            }
            reportOutput.setReportOutputData(bFile);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
            this.endWorkFlow(basicProperty);
        } else {
            ReportRequest reportInput;
            PropertyNoticeInfo propertyNotice = null;
            String noticeNo = null;
            if ("Sign".equals(this.actionType) && notice == null) {
                noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber(this.noticeType);
            }
            if ((reportOutput = this.reportService.createReport(reportInput = this.generateNoticeReportRequest(basicProperty, propertyNotice = new PropertyNoticeInfo(this.property, noticeNo)))) != null && reportOutput.getReportOutputData() != null) {
                this.NoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            }
            if ("Sign".equals(this.actionType)) {
                if (notice == null) {
                    PtNotice savedNotice = this.noticeService.saveNotice(basicProperty.getPropertyForBasicProperty().getApplicationNo(), noticeNo, this.noticeType, (BasicProperty)basicProperty, this.NoticePDF);
                    this.setFileStoreIds(savedNotice.getFileStore().getFileStoreId());
                } else {
                    PtNotice savedNotice = this.noticeService.updateNotice(notice, this.NoticePDF);
                    this.setFileStoreIds(savedNotice.getFileStore().getFileStoreId());
                }
                this.noticeService.getSession().flush();
                return DIGITAL_SIGNATURE_REDIRECTION;
            }
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        }
        if (!PREVIEW.equals(this.actionType)) {
            this.propService.updateIndexes((StateAware)this.property, "Alter_Assessment");
            this.basicPropertyService.update((Object)basicProperty);
        }
        return NOTICE;
    }

    @Action(value="/notice/propertyTaxNotice-generateSpecialNotice")
    public String generateSpecialNotice() {
        HashMap reportParams = new HashMap();
        ReportRequest reportInput = null;
        BasicPropertyImpl basicProperty = (BasicPropertyImpl)this.getPersistenceService().findByNamedQuery("getBasicPropertyByBasicPropId", new Object[]{this.basicPropId});
        this.property = (PropertyImpl)basicProperty.getProperty();
        if (this.property == null) {
            this.property = (PropertyImpl)basicProperty.getWFProperty();
        }
        ReportOutput reportOutput = new ReportOutput();
        PropertyNoticeInfo propertyNotice = null;
        String noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber(this.noticeType);
        propertyNotice = new PropertyNoticeInfo(this.property, noticeNo);
        reportInput = this.generateNoticeReportRequest(basicProperty, propertyNotice);
        reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.NoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        this.noticeService.saveNotice(basicProperty.getPropertyForBasicProperty().getApplicationNo(), noticeNo, this.noticeType, (BasicProperty)basicProperty, this.NoticePDF);
        this.endWorkFlow(basicProperty);
        this.propService.updateIndexes((StateAware)this.property, TAXEXEMPT);
        this.basicPropertyService.update((Object)basicProperty);
        return NOTICE;
    }

    @Action(value="/notice/previewSignedNotice")
    public String previewSignedNotice() {
        byte[] bFile;
        File file = this.fileStoreService.fetch(this.signedFileStoreId, "PTIS");
        try {
            bFile = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Exception while generating Special Notcie : " + e);
        }
        ReportOutput reportOutput = new ReportOutput();
        reportOutput.setReportOutputData(bFile);
        reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return NOTICE;
    }

    private ReportRequest generateNoticeReportRequest(BasicPropertyImpl basicProperty, PropertyNoticeInfo propertyNotice) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        List users = this.eisCommonService.getAllActiveUsersByGivenDesig(this.designationService.getDesignationByName("Commissioner").getId());
        reportParams.put("userSignature", !users.isEmpty() && ((User)users.get(0)).getSignature() != null ? new ByteArrayInputStream(((User)users.get(0)).getSignature()) : null);
        if ("Special Notice".equals(this.noticeType)) {
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            String imagePath = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            reportParams.put("logoPath", imagePath);
            reportParams.put("cityName", cityName);
            Boolean isCorporation = cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            reportParams.put("isCorporation", isCorporation);
            if (CREATE.equalsIgnoreCase(this.noticeMode)) {
                reportParams.put("mode", CREATE);
            } else if (MODIFY.equalsIgnoreCase(this.noticeMode)) {
                reportParams.put("mode", MODIFY);
            } else {
                reportParams.put("mode", DEMOLITION);
            }
            reportParams.put("actionType", this.actionType);
            this.setNoticeInfo(propertyNotice, basicProperty, this.noticeMode);
            List floorDetails = this.getFloorDetailsForNotice();
            propertyNotice.setFloorDetailsForNotice(floorDetails);
            reportInput = new ReportRequest("mainSpecialNotice", (Object)propertyNotice, reportParams);
            reportInput.setPrintDialogOnOpenReport(true);
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        }
        return reportInput;
    }

    private void setNoticeInfo(PropertyNoticeInfo propertyNotice, BasicPropertyImpl basicProperty, String noticeMode) {
        PropertyImpl historyProperty;
        String ownerType = null;
        String owner = "";
        PropertyAckNoticeInfo infoBean = new PropertyAckNoticeInfo();
        PropertyAddress ownerAddress = basicProperty.getAddress();
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal propertyTax = BigDecimal.ZERO;
        if (basicProperty.getPropertyOwnerInfo().size() > 1) {
            infoBean.setOwnerName(basicProperty.getFullOwnerName().concat(" and others"));
        } else {
            infoBean.setOwnerName(basicProperty.getFullOwnerName());
        }
        infoBean.setOwnerAddress(basicProperty.getAddress().toString());
        infoBean.setApplicationNo(this.property.getApplicationNo());
        infoBean.setDoorNo(ownerAddress.getHouseNoBldgApt());
        if (StringUtils.isNotBlank((String)ownerAddress.getLandmark())) {
            infoBean.setStreetName(ownerAddress.getLandmark());
        } else {
            infoBean.setStreetName("N/A");
        }
        SimpleDateFormat formatNowYear = new SimpleDateFormat("MMMM yyyy");
        Module module = this.moduleDao.getModuleByName("Property Tax");
        infoBean.setAssessmentNo(basicProperty.getUpicNo());
        infoBean.setAssessmentDate(this.sdf.format(basicProperty.getAssessmentdate()).toString());
        Ptdemand currDemand = null;
        Installment installment = null;
        String occupancyYear = "";
        if (noticeMode.equalsIgnoreCase(CREATE)) {
            currDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)this.property);
            this.prepareTaxInfoForActiveProperty(infoBean, totalTax, propertyTax, currDemand, noticeMode);
            if (currDemand.getDmdCalculations() != null && currDemand.getDmdCalculations().getAlv() != null) {
                infoBean.setNew_rev_ARV(currDemand.getDmdCalculations().getAlv());
            }
            installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, basicProperty.getPropOccupationDate());
            occupancyYear = formatNowYear.format(installment.getFromDate());
            infoBean.setInstallmentYear(occupancyYear);
        } else {
            installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, this.property.getEffectiveDate());
        }
        if (noticeMode.equalsIgnoreCase(MODIFY) || noticeMode.equalsIgnoreCase(DEMOLITION)) {
            currDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)this.property);
            this.prepareTaxInfoForActiveProperty(infoBean, totalTax, propertyTax, currDemand, noticeMode);
            if (currDemand.getDmdCalculations() != null && currDemand.getDmdCalculations().getAlv() != null) {
                infoBean.setNew_rev_ARV(currDemand.getDmdCalculations().getAlv());
            }
            historyProperty = this.propService.getLatestHistoryProperty(basicProperty.getUpicNo());
            Ptdemand historyDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)historyProperty);
            if (historyProperty != null && historyDemand != null) {
                totalTax = BigDecimal.ZERO;
                propertyTax = BigDecimal.ZERO;
                this.prepareTaxInfoForHistoryProperty(infoBean, totalTax, propertyTax, historyDemand);
                if (historyDemand.getDmdCalculations() != null && historyDemand.getDmdCalculations().getAlv() != null) {
                    infoBean.setExistingARV(historyDemand.getDmdCalculations().getAlv());
                }
            }
        } else if (noticeMode.equalsIgnoreCase(TAXEXEMPT)) {
            if (this.property.getIsExemptedFromTax().booleanValue()) {
                currDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)this.property);
                this.prepareTaxInfoForHistoryProperty(infoBean, totalTax, propertyTax, currDemand);
                infoBean.setExistingARV(currDemand.getDmdCalculations().getAlv() != null ? currDemand.getDmdCalculations().getAlv() : BigDecimal.ZERO);
            } else if (!this.property.getIsExemptedFromTax().booleanValue()) {
                historyProperty = this.propService.getLatestHistoryProperty(basicProperty.getUpicNo());
                Ptdemand historyDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)historyProperty);
                if (historyProperty != null && historyDemand != null) {
                    totalTax = BigDecimal.ZERO;
                    propertyTax = BigDecimal.ZERO;
                    this.prepareTaxInfoForActiveProperty(infoBean, totalTax, propertyTax, historyDemand, noticeMode);
                }
            }
        }
        occupancyYear = formatNowYear.format(installment.getFromDate());
        infoBean.setInstallmentYear(occupancyYear);
        PropertyID propertyId = basicProperty.getPropertyID();
        infoBean.setZoneName(propertyId.getZone().getName());
        infoBean.setWardName(propertyId.getWard().getName());
        infoBean.setAreaName(propertyId.getArea().getName());
        infoBean.setLocalityName(propertyId.getLocality().getName());
        if (this.property.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_MEESEWA)) {
            infoBean.setMeesevaNo(this.property.getApplicationNo());
        }
        infoBean.setNoticeDate(new Date());
        ownerType = this.property.getPropertyDetail().getPropertyTypeMaster().getType();
        if (ownerType.equalsIgnoreCase(VACANT_LAND) || noticeMode != null && noticeMode.equalsIgnoreCase(DEMOLITION)) {
            owner = "(On Land)";
        }
        infoBean.setOwnerTypeForReport(owner);
        propertyNotice.setOwnerInfo(infoBean);
    }

    private void prepareTaxInfoForActiveProperty(PropertyAckNoticeInfo infoBean, BigDecimal totalTax, BigDecimal propertyTax, Ptdemand currDemand, String noticeMode) {
        for (EgDemandDetails demandDetail : currDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgInstallmentMaster().equals((Object)this.propertyTaxCommonUtils.getCurrentInstallment())) continue;
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES")) {
                totalTax = totalTax.add(demandDetail.getAmount());
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("EDU_CESS")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("LIB_CESS")) {
                if (noticeMode.equalsIgnoreCase(CREATE)) {
                    infoBean.setNewLibraryCess(demandDetail.getAmount());
                }
                if (noticeMode.equalsIgnoreCase(MODIFY) || noticeMode.equalsIgnoreCase(TAXEXEMPT) || noticeMode.equalsIgnoreCase(DEMOLITION)) {
                    infoBean.setRevLibraryCess(demandDetail.getAmount());
                }
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("GEN_TAX") || demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("VAC_LAND_TAX")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("UNAUTH_PENALTY")) continue;
            if (noticeMode.equalsIgnoreCase(CREATE)) {
                infoBean.setNewUCPenalty(demandDetail.getAmount());
            }
            if (!noticeMode.equalsIgnoreCase(MODIFY) && !noticeMode.equalsIgnoreCase(TAXEXEMPT) && !noticeMode.equalsIgnoreCase(DEMOLITION)) continue;
            infoBean.setRevUCPenalty(demandDetail.getAmount());
        }
        if (noticeMode.equalsIgnoreCase(CREATE)) {
            infoBean.setNewTotalTax(totalTax);
            infoBean.setNewPropertyTax(propertyTax);
        }
        if (noticeMode.equalsIgnoreCase(MODIFY) || noticeMode.equalsIgnoreCase(TAXEXEMPT) || noticeMode.equalsIgnoreCase(DEMOLITION)) {
            infoBean.setRevTotalTax(totalTax);
            infoBean.setRevPropertyTax(propertyTax);
        }
    }

    private void prepareTaxInfoForHistoryProperty(PropertyAckNoticeInfo infoBean, BigDecimal totalTax, BigDecimal propertyTax, Ptdemand currDemand) {
        for (EgDemandDetails demandDetail : currDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgInstallmentMaster().equals((Object)this.propertyTaxCommonUtils.getCurrentInstallment())) continue;
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES")) {
                totalTax = totalTax.add(demandDetail.getAmount());
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("EDU_CESS")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("LIB_CESS")) {
                infoBean.setExistingLibraryCess(demandDetail.getAmount());
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("GEN_TAX") || demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("VAC_LAND_TAX")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("UNAUTH_PENALTY")) continue;
            infoBean.setExistingUCPenalty(demandDetail.getAmount());
        }
        infoBean.setExistingTotalTax(totalTax);
        infoBean.setExistingPropertyTax(propertyTax);
    }

    private List<PropertyAckNoticeInfo> getFloorDetailsForNotice() {
        ArrayList<PropertyAckNoticeInfo> floorDetailsList = new ArrayList<PropertyAckNoticeInfo>();
        PropertyDetail detail = this.property.getPropertyDetail();
        PropertyAckNoticeInfo floorInfo = null;
        for (Floor floor : detail.getFloorDetails()) {
            floorInfo = new PropertyAckNoticeInfo();
            floorInfo.setBuildingClassification(floor.getStructureClassification().getTypeName());
            floorInfo.setNatureOfUsage(floor.getPropertyUsage().getUsageName());
            floorInfo.setPlinthArea(new BigDecimal(floor.getBuiltUpArea().getArea().floatValue()));
            floorInfo.setBuildingAge(floor.getDepreciationMaster() != null ? floor.getDepreciationMaster().getDepreciationName() : "N/A");
            floorInfo.setMonthlyRentalValue(floor.getFloorDmdCalc() != null ? floor.getFloorDmdCalc().getMrv() : BigDecimal.ZERO);
            floorInfo.setYearlyRentalValue(floor.getFloorDmdCalc() != null ? floor.getFloorDmdCalc().getAlv() : BigDecimal.ZERO);
            floorInfo.setTaxPayableForCurrYear(floor.getFloorDmdCalc() != null ? floor.getFloorDmdCalc().getTotalTaxPayble() : BigDecimal.ZERO);
            floorInfo.setRate(floor.getFloorDmdCalc() != null ? floor.getFloorDmdCalc().getCategoryAmt() : BigDecimal.ZERO);
            floorInfo.setBldngFloorNo((String)PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()));
            floorDetailsList.add(floorInfo);
        }
        return floorDetailsList;
    }

    private void endWorkFlow(BasicPropertyImpl basicProperty) {
        LOGGER.debug((Object)("endWorkFlow: Workflow will end for Property: " + this.property));
        this.property.transition().end();
        basicProperty.setUnderWorkflow(false);
        LOGGER.debug((Object)"Exit method endWorkFlow, Workflow ended");
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public PropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(PropertyImpl property) {
        this.property = property;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public String getNoticeType() {
        return this.noticeType;
    }

    public void setNoticeType(String noticeType) {
        this.noticeType = noticeType;
    }

    public NoticeService getNoticeService() {
        return this.noticeService;
    }

    public void setNoticeService(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    public Long getBasicPropId() {
        return this.basicPropId;
    }

    public void setBasicPropId(Long basicPropId) {
        this.basicPropId = basicPropId;
    }

    public String getNoticeMode() {
        return this.noticeMode;
    }

    public void setNoticeMode(String noticeMode) {
        this.noticeMode = noticeMode;
    }

    public void setBasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public void setPtDemandDAO(PtDemandDao ptDemandDAO) {
        this.ptDemandDAO = ptDemandDAO;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getBasicPropertyIds() {
        return this.basicPropertyIds;
    }

    public void setBasicPropertyIds(String basicPropertyIds) {
        this.basicPropertyIds = basicPropertyIds;
    }

    public String getFileStoreIds() {
        return this.fileStoreIds;
    }

    public void setFileStoreIds(String fileStoreIds) {
        this.fileStoreIds = fileStoreIds;
    }

    public String getUlbCode() {
        return this.ulbCode;
    }

    public void setUlbCode(String ulbCode) {
        this.ulbCode = ulbCode;
    }

    public RevisionPetitionService getRevisionPetitionService() {
        return this.revisionPetitionService;
    }

    public void setRevisionPetitionService(RevisionPetitionService revisionPetitionService) {
        this.revisionPetitionService = revisionPetitionService;
    }

    public String getSignedFileStoreId() {
        return this.signedFileStoreId;
    }

    public void setSignedFileStoreId(String signedFileStoreId) {
        this.signedFileStoreId = signedFileStoreId;
    }

    public boolean isDigitalSignEnabled() {
        return this.digitalSignEnabled;
    }

    public void setDigitalSignEnabled(boolean digitalSignEnabled) {
        this.digitalSignEnabled = digitalSignEnabled;
    }
}

