/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.citizen.search;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.domain.service.property.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"new"}, location="search-new.jsp"), @Result(name={"result"}, location="search-result.jsp"), @Result(name={"newForm"}, location="onlinesearch-new.jsp"), @Result(name={"targetForm"}, type="redirectAction", location="viewDCBProperty-displayPropInfo", params={"namespace", "/view", "propertyId", "${assessmentNum}", "searchUrl", "${searchUrl}"})})
public class SearchAction
extends BaseFormAction
implements ServletRequestAware {
    private static final long serialVersionUID = -7506891911359323204L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private String assessmentNum;
    private String doorNo;
    private String ownerName;
    private String mode;
    private List<Map<String, String>> searchResultList;
    private HttpServletRequest request;
    private String searchUri;
    private String searchCreteria;
    private String searchValue;
    private String searchUrl;
    private boolean isDemandActive;
    List<Map<String, String>> searchList = new ArrayList();
    public static final String TARGET = "result";
    public static final String NEWFORM = "newForm";
    public static final String TARGETFORM = "targetForm";
    @Autowired
    private UserService userService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public Object getModel() {
        return null;
    }

    @SkipValidation
    @Action(value="/citizen/search/search-searchForm")
    public String searchForm() {
        this.setAssessmentNum("");
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/citizen/search/search-srchByAssessmentAndOwnerDetail")
    public String srchByAssessmentAndOwnerDetail() {
        try {
            List propertyList = this.propertyService.getPropertyByAssessmentAndOwnerDetails(this.assessmentNum, this.ownerName, this.doorNo);
            for (PropertyMaterlizeView propMatview : propertyList) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Object)("srchByAssessmentAndOwner : Property : " + propMatview));
                }
                this.setSearchResultList(this.getResultsFromMv(propMatview));
            }
            if (this.assessmentNum != null && !this.assessmentNum.equals("")) {
                this.setSearchValue("Assessment Number : " + this.assessmentNum);
            }
            this.setSearchCreteria("Search By Assessment and Owner detail");
            if (this.ownerName != null && !this.ownerName.equals("")) {
                this.setSearchValue("Owner name :" + this.ownerName);
            }
            if (this.doorNo != null && !this.doorNo.equals("")) {
                this.setSearchValue("Door number :" + this.doorNo);
            }
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Exception in Search Property By Door number ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception : ", (Throwable)e);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByAssessmentAndOwenrDetails method ");
        }
        return TARGET;
    }

    @SkipValidation
    @Action(value="/citizen/search/search-searchByAssessmentForm")
    public String searchByAssessmentForm() {
        this.setAssessmentNum("");
        return NEWFORM;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/citizen/search/search-searchByAssessment")
    public String srchByAssessmentNo() {
        block5: {
            try {
                BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.assessmentNum);
                if (basicProperty != null) {
                    this.setSearchUrl("onlineSearch");
                    this.checkIsDemandActive(basicProperty.getProperty());
                    if (!this.isDemandActive) {
                        this.addActionError(this.getText("dmd.inactive"));
                        return NEWFORM;
                    }
                    break block5;
                }
                this.addActionError(this.getText("record.not.found"));
                return NEWFORM;
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Door number ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : ", (Throwable)e);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByAssessment method ");
        }
        return TARGETFORM;
    }

    private List<Map<String, String>> getResultsFromMv(PropertyMaterlizeView pmv) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into getSearchResults method");
            this.LOGGER.debug((Object)("Assessment Number : " + pmv.getPropertyId()));
        }
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(pmv.getPropertyId());
        Property property = basicProperty.getProperty();
        if (basicProperty != null) {
            this.checkIsDemandActive(basicProperty.getProperty());
        }
        if ((pmv.getPropertyId() != null || StringUtils.isNotEmpty((String)pmv.getPropertyId())) && pmv != null) {
            HashMap<String, String> searchResultMap = new HashMap<String, String>();
            searchResultMap.put("assessmentNum", pmv.getPropertyId());
            searchResultMap.put("ownerName", pmv.getOwnerName());
            searchResultMap.put("parcelId", pmv.getGisRefNo());
            searchResultMap.put("address", pmv.getPropertyAddress());
            searchResultMap.put("source", pmv.getSource().toString());
            searchResultMap.put("isDemandActive", String.valueOf(this.isDemandActive));
            searchResultMap.put("propType", property.getPropertyDetail().getPropertyTypeMaster().getCode());
            searchResultMap.put("isTaxExempted", String.valueOf(property.getIsExemptedFromTax()));
            searchResultMap.put("isUnderWorkflow", String.valueOf(basicProperty.isUnderWorkflow()));
            searchResultMap.put("enableVacancyRemission", String.valueOf(this.propertyTaxUtil.enableVacancyRemission(basicProperty.getUpicNo())));
            searchResultMap.put("enableMonthlyUpdate", String.valueOf(this.propertyTaxUtil.enableMonthlyUpdate(basicProperty.getUpicNo())));
            searchResultMap.put("enableVRApproval", String.valueOf(this.propertyTaxUtil.enableVRApproval(basicProperty.getUpicNo())));
            if (pmv.getIsExempted().booleanValue()) {
                searchResultMap.put("currFirstHalfDemand", "0");
                searchResultMap.put("currFirstHalfDemandDue", "0");
                searchResultMap.put("currSecondHalfDemand", "0");
                searchResultMap.put("currSecondHalfDemandDue", "0");
                searchResultMap.put("arrDemandDue", "0");
            } else {
                searchResultMap.put("currFirstHalfDemand", pmv.getAggrCurrFirstHalfDmd() == null ? "0" : pmv.getAggrCurrFirstHalfDmd().toString());
                searchResultMap.put("currFirstHalfDemandDue", (pmv.getAggrCurrFirstHalfDmd() == null ? BigDecimal.ZERO : pmv.getAggrCurrFirstHalfDmd()).subtract(pmv.getAggrCurrFirstHalfColl() == null ? BigDecimal.ZERO : pmv.getAggrCurrFirstHalfColl()).toString());
                searchResultMap.put("currSecondHalfDemand", pmv.getAggrCurrSecondHalfDmd() == null ? "0" : pmv.getAggrCurrSecondHalfDmd().toString());
                searchResultMap.put("currSecondHalfDemandDue", (pmv.getAggrCurrSecondHalfDmd() == null ? BigDecimal.ZERO : pmv.getAggrCurrSecondHalfDmd()).subtract(pmv.getAggrCurrSecondHalfColl() == null ? BigDecimal.ZERO : pmv.getAggrCurrSecondHalfColl()).toString());
                searchResultMap.put("arrDemandDue", (pmv.getAggrArrDmd() == null ? BigDecimal.ZERO : pmv.getAggrArrDmd()).subtract(pmv.getAggrArrColl() == null ? BigDecimal.ZERO : pmv.getAggrArrColl()).toString());
            }
            this.searchList.add(searchResultMap);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Search list : " + (this.searchList != null ? this.searchList : BigDecimal.ZERO)));
            this.LOGGER.debug((Object)"Exit from getSearchResults method");
        }
        return this.searchList;
    }

    private void checkIsDemandActive(Property property) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into checkIsDemandActive");
        }
        this.isDemandActive = !property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("checkIsDemandActive - Is demand active? : " + this.isDemandActive));
            this.LOGGER.debug((Object)"Exiting from checkIsDemandActive");
        }
    }

    public List<Map<String, String>> getSearchResultList() {
        return this.searchResultList;
    }

    public void setSearchResultList(List<Map<String, String>> searchResultList) {
        this.searchResultList = searchResultList;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getSearchUri() {
        return this.searchUri;
    }

    public void setSearchUri(String searchUri) {
        this.searchUri = searchUri;
    }

    public String getSearchCreteria() {
        return this.searchCreteria;
    }

    public void setSearchCreteria(String searchCreteria) {
        this.searchCreteria = searchCreteria;
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    @SkipValidation
    public void setServletRequest(HttpServletRequest arg0) {
        this.request = arg0;
    }

    public String getAssessmentNum() {
        return this.assessmentNum;
    }

    public void setAssessmentNum(String assessmentNum) {
        this.assessmentNum = assessmentNum;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    public String getSearchUrl() {
        return this.searchUrl;
    }

    public void setSearchUrl(String searchUrl) {
        this.searchUrl = searchUrl;
    }
}

