/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.citizen.create;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Area;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.CorrespondenceAddress;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.entity.property.TaxExeptionReason;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Namespace(value="/citizen/create")
@Validations
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name={"new"}, location="citizen/create/create-new.jsp"), @Result(name={"ack"}, location="citizen/create/create-ack.jsp"), @Result(name={"printAck"}, location="citizen/create/create-printAck.jsp")})
public class CreateAction
extends PropertyTaxBaseAction {
    private static final long serialVersionUID = -2329719786287615452L;
    public static final String RESULT_ACK = "ack";
    public static final String PRINTACK = "printAck";
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private PropertyImpl property = new PropertyImpl();
    private Long zoneId;
    private Long wardId;
    private Long blockId;
    private Long streetId;
    private Long locality;
    private Long floorTypeId;
    private Long roofTypeId;
    private Long wallTypeId;
    private Long woodTypeId;
    private Long ownershipType;
    private Long electionWardId;
    protected String ackMessage;
    private String wardName;
    private String zoneName;
    private String blockName;
    private String houseNumber;
    private String addressStr;
    private String pinCode;
    private String areaOfPlot;
    private String dateOfCompletion;
    private String applicationNo;
    private String corrAddress1;
    private String corrAddress2;
    private String corrPinCode;
    private String upicNo;
    private String taxExemptionId;
    private String parentIndex;
    private String amenities;
    private String[] floorNoStr = new String[100];
    private String propTypeId;
    private String propUsageId;
    private String propOccId;
    private String propertyCategory;
    private String docNumber;
    private String nonResPlotArea;
    private String applicationNoMessage;
    private String assessmentNoMessage;
    private String propertyInitiatedBy;
    private String northBoundary;
    private String southBoundary;
    private String eastBoundary;
    private String westBoundary;
    private String applicationSource;
    private Long mutationId;
    private Map<String, String> propTypeCategoryMap;
    private TreeMap<Integer, String> floorNoMap;
    private Map<String, String> deviationPercentageMap;
    private Map<String, String> guardianRelationMap;
    private List<DocumentType> documentTypes = new ArrayList();
    private String reportId;
    private boolean approved;
    private BasicProperty basicProp;
    private PropertyTypeMaster propTypeMstr;
    private PropertyImpl newProperty = new PropertyImpl();
    private Address ownerAddress = new CorrespondenceAddress();
    Date propCompletionDate = null;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private PropertyService propService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public CreateAction() {
        this.property.setPropertyDetail((PropertyDetail)new BuiltUpProperty());
        this.property.setBasicProperty((BasicProperty)new BasicPropertyImpl());
        this.addRelatedEntity("property", PropertyImpl.class);
        this.addRelatedEntity("property.propertyDetail.propertyTypeMaster", PropertyTypeMaster.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.unitType", PropertyTypeMaster.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.propertyUsage", PropertyUsage.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.propertyOccupation", PropertyOccupation.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.structureClassification", StructureClassification.class);
        this.addRelatedEntity("property.basicProperty.propertyOwnerInfo.owner", Citizen.class);
        this.addRelatedEntity("propertyDetail.apartment", Apartment.class);
        this.addRelatedEntity("property.propertyDetail.floorType", FloorType.class);
        this.addRelatedEntity("property.propertyDetail.roofType", RoofType.class);
        this.addRelatedEntity("property.propertyDetail.wallType", WallType.class);
        this.addRelatedEntity("property.propertyDetail.woodType", WoodType.class);
        this.addRelatedEntity("property.taxExemptedReason", TaxExeptionReason.class);
    }

    public StateAware getModel() {
        return this.property;
    }

    @SkipValidation
    public void prepare() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into prepare, ModelId: " + this.getModelId() + ", PropTypeId: " + this.propTypeId + ", ZoneId: " + this.zoneId + ", WardId: " + this.wardId));
        }
        ApplicationThreadLocals.setUserId((Long)2L);
        this.setUserInfo();
        this.setUserDesignations();
        this.propertyByEmployee = false;
        if (StringUtils.isNotBlank((String)this.getModelId())) {
            this.property = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            this.basicProp = this.property.getBasicProperty();
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("prepare: Property by ModelId: " + this.property + "BasicProperty on property: " + this.basicProp));
            }
        }
        this.documentTypes = this.propService.getDocumentTypesForTransactionType(TransactionType.CREATE);
        List floorTypeList = this.getPersistenceService().findAllBy("from FloorType order by name", new Object[0]);
        List roofTypeList = this.getPersistenceService().findAllBy("from RoofType order by name", new Object[0]);
        List wallTypeList = this.getPersistenceService().findAllBy("from WallType order by name", new Object[0]);
        List woodTypeList = this.getPersistenceService().findAllBy("from WoodType order by name", new Object[0]);
        List propTypeList = this.getPersistenceService().findAllBy("from PropertyTypeMaster where type != 'EWSHS' order by orderNo", new Object[0]);
        List propOccList = this.getPersistenceService().findAllBy("from PropertyOccupation", new Object[0]);
        List mutationList = this.getPersistenceService().findAllBy("from PropertyMutationMaster pmm where pmm.type=?", new Object[]{"CREATE"});
        List usageList = this.getPersistenceService().findAllBy("from PropertyUsage where isActive = true order by usageName", new Object[0]);
        List ageFacList = this.getPersistenceService().findAllBy("from DepreciationMaster", new Object[0]);
        List StructureList = this.getPersistenceService().findAllBy("from StructureClassification where isActive = true order by typeName ", new Object[0]);
        List apartmentsList = this.getPersistenceService().findAllBy("from Apartment order by name", new Object[0]);
        List taxExemptionReasonList = this.getPersistenceService().findAllBy("from TaxExeptionReason order by name", new Object[0]);
        List localityList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        List zones = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List electionWardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
        List enumerationBlockList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Election Ward", "ELECTION");
        this.addDropdownData("zones", zones);
        this.addDropdownData("wards", Collections.EMPTY_LIST);
        this.addDropdownData("blocks", Collections.EMPTY_LIST);
        this.addDropdownData("streets", Collections.EMPTY_LIST);
        this.setDeviationPercentageMap((Map)PropertyTaxConstants.DEVIATION_PERCENTAGE);
        this.setGuardianRelationMap((Map)PropertyTaxConstants.GUARDIAN_RELATION);
        this.addDropdownData("PropTypeMaster", propTypeList);
        this.addDropdownData("floorType", floorTypeList);
        this.addDropdownData("roofType", roofTypeList);
        this.addDropdownData("wallType", wallTypeList);
        this.addDropdownData("woodType", woodTypeList);
        this.addDropdownData("apartments", apartmentsList);
        this.addDropdownData("OccupancyList", propOccList);
        this.addDropdownData("StructureList", StructureList);
        this.addDropdownData("AgeFactorList", ageFacList);
        this.addDropdownData("MutationList", mutationList);
        this.addDropdownData("LocationFactorList", Collections.EMPTY_LIST);
        this.setFloorNoMap(PropertyTaxConstants.FLOOR_MAP);
        this.addDropdownData("localityList", localityList);
        this.addDropdownData("electionWardList", electionWardList);
        this.addDropdownData("enumerationBlockList", enumerationBlockList);
        this.addDropdownData("taxExemptionReasonList", taxExemptionReasonList);
        if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !this.propTypeId.equals("-1")) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(this.propTypeId)});
            if (this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
        } else {
            this.setPropTypeCategoryMap(Collections.EMPTY_MAP);
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.propertyCategory})) {
            if (this.propertyCategory.equals("MIXED")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage order by usageName", new Object[0]);
            } else if (this.propertyCategory.equals("RESIDENTIAl")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = true order by usageName", new Object[0]);
            } else if (this.propertyCategory.equals("NON_RESIDENTIAL")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = false order by usageName", new Object[0]);
            }
        }
        this.addDropdownData("UsageList", usageList);
        this.addDropdownData("taxExemptedList", CommonServices.getTaxExemptedList());
        super.prepare();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("prepare: PropTypeList: " + (propTypeList != null ? propTypeList : "NULL") + ", PropOccuList: " + (propOccList != null ? propOccList : "NLL") + ", MutationList: " + (mutationList != null ? mutationList : "NULL") + ", AgeFactList: " + (ageFacList != null ? ageFacList : "NULL") + "UsageList: " + (this.getDropdownData().get("UsageList") != null ? this.getDropdownData().get("UsageList") : "List is NULL") + ", TaxExemptedReasonList: " + (this.getDropdownData().get("taxExemptedList") != null ? this.getDropdownData().get("taxExemptedList") : "List is NULL")));
        }
        this.LOGGER.debug((Object)"Exiting from prepare");
    }

    public void validate() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into validate\nZoneId: " + this.zoneId + ", WardId: " + this.wardId + ", AreadId: " + this.blockId + ", HouseNumber: " + this.houseNumber + ", PinCode: " + this.pinCode + ", MutationId: " + this.mutationId));
        }
        if (this.locality == null || this.locality == -1L) {
            this.addActionError(this.getText("mandatory.localityId"));
        }
        if (null != this.propTypeId && !this.propTypeId.equals("-1")) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(this.propTypeId)});
        }
        if (this.zoneId == null || this.zoneId == -1L) {
            this.addActionError(this.getText("mandatory.zone"));
        }
        if (this.wardId == null || this.wardId == -1L) {
            this.addActionError(this.getText("mandatory.ward"));
        }
        if (this.blockId == null || this.blockId == -1L) {
            this.addActionError(this.getText("mandatory.block"));
        } else if (null != this.propTypeMstr && !this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.houseNumber)) {
                this.validateHouseNumber(this.wardId, this.houseNumber, this.basicProp);
            } else if (this.property != null && this.property.getState() != null && this.property.getState().getNextAction() != null && this.property.getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending")) {
                this.addActionError(this.getText("mandatory.doorNo"));
            }
        }
        if (null == this.property.getBasicProperty().getRegdDocDate()) {
            this.addActionError(this.getText("mandatory.regdocdate"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.property.getBasicProperty().getRegdDocNo())) {
            this.addActionError(this.getText("mandatory.regdocno"));
        }
        if (this.electionWardId == null || this.electionWardId == -1L) {
            this.addActionError(this.getText("mandatory.election.ward"));
        }
        for (PropertyOwnerInfo owner : this.property.getBasicProperty().getPropertyOwnerInfoProxy()) {
            if (owner == null) continue;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getName())) {
                this.addActionError(this.getText("mandatory.ownerName"));
            }
            if (null == owner.getOwner().getGender()) {
                this.addActionError(this.getText("mandatory.gender"));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getMobileNumber())) {
                this.addActionError(this.getText("mandatory.mobilenumber"));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getGuardianRelation())) {
                this.addActionError(this.getText("mandatory.guardianrelation"));
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getGuardian())) continue;
            this.addActionError(this.getText("mandatory.guardian"));
        }
        int count = this.property.getBasicProperty().getPropertyOwnerInfoProxy().size();
        for (int i = 0; i < count; ++i) {
            PropertyOwnerInfo owner = (PropertyOwnerInfo)this.property.getBasicProperty().getPropertyOwnerInfoProxy().get(i);
            if (owner == null) continue;
            for (int j = i + 1; j <= count - 1; ++j) {
                PropertyOwnerInfo owner1 = (PropertyOwnerInfo)this.property.getBasicProperty().getPropertyOwnerInfoProxy().get(j);
                if (owner1 == null || !owner.getOwner().getMobileNumber().equalsIgnoreCase(owner1.getOwner().getMobileNumber()) || !owner.getOwner().getName().equalsIgnoreCase(owner1.getOwner().getName())) continue;
                this.addActionError(this.getText("error.owner.duplicateMobileNo", "", owner.getOwner().getMobileNumber().concat(",").concat(owner.getOwner().getName())));
            }
        }
        this.validateProperty((Property)this.property, this.areaOfPlot, this.dateOfCompletion, this.eastBoundary, this.westBoundary, this.southBoundary, this.northBoundary, this.propTypeId, null != this.zoneId && this.zoneId != -1L ? String.valueOf(this.zoneId) : "", this.propOccId, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, null, null);
        if (StringUtils.isBlank((String)this.pinCode)) {
            this.addActionError(this.getText("mandatory.pincode"));
        }
        if (this.property.getPropertyDetail().isCorrAddressDiff() != null && this.property.getPropertyDetail().isCorrAddressDiff().booleanValue()) {
            if (StringUtils.isBlank((String)this.corrAddress1)) {
                this.addActionError(this.getText("mandatory.corr.addr1"));
            }
            if (StringUtils.isBlank((String)this.corrPinCode) && this.corrPinCode.length() < 6) {
                this.addActionError(this.getText("mandatory.corr.pincode.size"));
            }
        }
        if (null != this.mutationId && this.mutationId != -1L) {
            PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find("from PropertyMutationMaster pmm where pmm.id=?", new Object[]{this.mutationId});
            if (propertyMutationMaster.getCode().equals("BIFUR")) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.parentIndex)) {
                    BasicProperty basicProperty = (BasicProperty)this.basicPropertyService.find("From BasicPropertyImpl where upicNo = ? ", new Object[]{this.parentIndex});
                    if (this.areaOfPlot != null && !this.areaOfPlot.isEmpty()) {
                        Area area = new Area();
                        area.setArea(new Float(this.areaOfPlot));
                        this.property.getPropertyDetail().setSitalArea(area);
                        if (null != basicProperty && !basicProperty.isUnderWorkflow()) {
                            if (null != basicProperty.getActiveProperty()) {
                                this.property.getPropertyDetail().setPropertyTypeMaster(this.propTypeMstr);
                                String errorKey = this.propService.validationForBifurcation(this.property, basicProperty, propertyMutationMaster.getCode());
                                if (!StringUtils.isBlank((String)errorKey)) {
                                    this.addActionError(this.getText(errorKey));
                                }
                            } else {
                                this.addActionError(this.getText("error.parent"));
                            }
                        } else {
                            this.addActionError(this.getText("error.parent.underworkflow"));
                        }
                    }
                } else {
                    this.addActionError(this.getText("error.parent.index"));
                }
            }
        } else {
            this.addActionError(this.getText("mandatory.createRsn"));
        }
        PropertyID propertyid = new PropertyID();
        propertyid.setElectionBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        this.property.getBasicProperty().setPropertyID(propertyid);
        if (null != this.getElectionWardId() && this.getElectionWardId() != -1L && null != this.property.getBasicProperty() && null == this.propService.getUserPositionByZone(this.property.getBasicProperty(), PropertyTaxConstants.SOURCEOFDATA_ONLINE)) {
            this.addActionError(this.getText("notexists.position"));
        }
        super.validate();
    }

    @SkipValidation
    @Action(value="/create-newForm")
    public String newForm() {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.applicationSource) || !this.applicationSource.equalsIgnoreCase("online")) {
            this.addActionError(this.getText("citizen.unAuthorized.user.error"));
        }
        return "new";
    }

    @Action(value="/create-create")
    public String create() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("create: Property creation started, Property: " + this.property + ", zoneId: " + this.zoneId + ", wardId: " + this.wardId + ", blockId: " + this.blockId + ", areaOfPlot: " + this.areaOfPlot + ", dateOfCompletion: " + this.dateOfCompletion + ", propTypeId: " + this.propTypeId + ", propUsageId: " + this.propUsageId + ", propOccId: " + this.propOccId));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.applicationSource) || !this.applicationSource.equalsIgnoreCase("online")) {
            throw new ValidationException(new ValidationError[]{new ValidationError("authenticationError", this.getText("citizen.unAuthorized.user.error"))});
        }
        long startTimeMillis = System.currentTimeMillis();
        BasicProperty basicProperty = this.createBasicProp(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        try {
            this.addDemandAndCompleteDate(PropertyTaxConstants.STATUS_DEMAND_INACTIVE, basicProperty, basicProperty.getPropertyMutationMaster());
        }
        catch (TaxCalculatorExeption e) {
            basicProperty.setPropertyOwnerInfoProxy(basicProperty.getPropertyOwnerInfo());
            this.addActionError(this.getText("unitrate.error"));
            this.LOGGER.error((Object)"create : There are no Unit rates defined for chosen combinations", (Throwable)e);
            return "new";
        }
        basicProperty.setUnderWorkflow(Boolean.TRUE.booleanValue());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("create: BasicProperty after creation: " + basicProperty));
        }
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        this.transitionWorkFlow(this.property);
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.property.getState());
        this.propService.updateIndexes((StateAware)this.property, "New_Assessment");
        this.basicPropertyService.persist((Object)basicProperty);
        this.buildEmailandSms(this.property, "New_Assessment");
        this.setBasicProp(basicProperty);
        this.setAckMessage("Property Data Saved Successfully in the System and forwarded to the official ");
        this.setApplicationNoMessage(" with application number : ");
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.info((Object)("create: Property created successfully in system; Time taken(ms) = " + elapsedTimeMillis));
            this.LOGGER.debug((Object)"create: Property creation ended");
        }
        return RESULT_ACK;
    }

    private BasicProperty createBasicProp(Character status) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into createBasicProp, Property: " + this.property + ", status: " + status + ", wardId: " + this.wardId));
        }
        BasicPropertyImpl basicProperty = new BasicPropertyImpl();
        PropertyStatus propStatus = (PropertyStatus)this.getPersistenceService().find("from PropertyStatus where statusCode=?", new Object[]{"WORKFLOW"});
        basicProperty.setRegdDocDate(this.property.getBasicProperty().getRegdDocDate());
        basicProperty.setRegdDocNo(this.property.getBasicProperty().getRegdDocNo());
        basicProperty.setActive(Boolean.TRUE);
        basicProperty.setAddress(this.createPropAddress());
        basicProperty.setPropertyID(this.createPropertyID((BasicProperty)basicProperty));
        basicProperty.setStatus(propStatus);
        basicProperty.setUnderWorkflow(true);
        PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find("from PropertyMutationMaster pmm where pmm.type=? AND pmm.id=?", new Object[]{"CREATE", this.mutationId});
        basicProperty.setPropertyMutationMaster(propertyMutationMaster);
        basicProperty.setBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_NOTCREATED);
        basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_ONLINE);
        this.basicPropertyService.createOwners((Property)this.property, (BasicProperty)basicProperty, this.ownerAddress);
        this.property.setBasicProperty((BasicProperty)basicProperty);
        this.property.setPropertyModifyReason("CREATE");
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("BasicProperty: " + basicProperty + "\nExiting from createBasicProp"));
        }
        return basicProperty;
    }

    private void addDemandAndCompleteDate(Character status, BasicProperty basicProperty, PropertyMutationMaster propertyMutationMaster) throws TaxCalculatorExeption {
        this.taxExemptionId = this.taxExemptionId == null || this.taxExemptionId.isEmpty() ? "-1" : this.taxExemptionId;
        this.property = this.propService.createProperty(this.property, this.getAreaOfPlot(), propertyMutationMaster.getCode(), this.propTypeId, this.propUsageId, this.propOccId, status, this.getDocNumber(), this.getNonResPlotArea(), this.getFloorTypeId(), this.getRoofTypeId(), this.getWallTypeId(), this.getWoodTypeId(), Long.valueOf(this.taxExemptionId));
        this.property.setStatus(status);
        this.LOGGER.debug((Object)("createBasicProp: Property after call to PropertyService.createProperty: " + this.property));
        this.propCompletionDate = !this.property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.property.getPropertyDetail().getFloorDetails()) : this.property.getPropertyDetail().getDateOfCompletion();
        basicProperty.setPropOccupationDate(this.propCompletionDate);
        basicProperty.addProperty((Property)this.property);
        try {
            if (this.property != null && !this.property.getDocuments().isEmpty()) {
                this.propService.processAndStoreDocument(this.property.getDocuments());
            }
            this.propService.createDemand(this.property, this.propCompletionDate);
        }
        catch (TaxCalculatorExeption e) {
            throw new TaxCalculatorExeption();
        }
    }

    private PropertyAddress createPropAddress() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into createPropAddress, \nAreaId: " + this.getBlockId() + ", House Number: " + this.getHouseNumber() + ", OldHouseNo: , AddressStr: " + this.getAddressStr() + ", PinCode: " + this.getPinCode()));
        }
        PropertyAddress propAddr = new PropertyAddress();
        propAddr.setHouseNoBldgApt(this.getHouseNumber());
        propAddr.setAreaLocalitySector(this.boundaryService.getBoundaryById(this.getLocality()).getName());
        String cityName = ApplicationThreadLocals.getCityName();
        propAddr.setStreetRoadLine(this.boundaryService.getBoundaryById(this.getWardId()).getName());
        propAddr.setCityTownVillage(cityName);
        if (this.getPinCode() != null && !this.getPinCode().isEmpty()) {
            propAddr.setPinCode(this.getPinCode());
        }
        if (this.property.getPropertyDetail().isCorrAddressDiff() == null || !this.property.getPropertyDetail().isCorrAddressDiff().booleanValue()) {
            this.ownerAddress = new CorrespondenceAddress();
            this.ownerAddress.setAreaLocalitySector(propAddr.getAreaLocalitySector());
            this.ownerAddress.setHouseNoBldgApt(propAddr.getHouseNoBldgApt());
            this.ownerAddress.setStreetRoadLine(propAddr.getStreetRoadLine());
            this.ownerAddress.setCityTownVillage(cityName);
            this.ownerAddress.setPinCode(propAddr.getPinCode());
        } else {
            this.ownerAddress = new CorrespondenceAddress();
            this.ownerAddress.setHouseNoBldgApt(this.getHouseNumber());
            this.ownerAddress.setAreaLocalitySector(this.getCorrAddress1());
            this.ownerAddress.setStreetRoadLine(this.getCorrAddress2());
            this.ownerAddress.setCityTownVillage(cityName);
            this.ownerAddress.setPinCode(this.getCorrPinCode());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("PropertyAddress: " + propAddr + "\nExiting from createPropAddress"));
        }
        return propAddr;
    }

    private PropertyID createPropertyID(BasicProperty basicProperty) {
        PropertyID propertyId = new PropertyID();
        propertyId.setZone(this.boundaryService.getBoundaryById(this.getZoneId()));
        propertyId.setWard(this.boundaryService.getBoundaryById(this.getWardId()));
        propertyId.setElectionBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        propertyId.setCreatedDate(new Date());
        propertyId.setModifiedDate(new Date());
        propertyId.setModifiedDate(new Date());
        propertyId.setArea(this.boundaryService.getBoundaryById(this.getBlockId()));
        propertyId.setLocality(this.boundaryService.getBoundaryById(this.getLocality()));
        if (this.getStreetId() != null && this.getStreetId() != -1L) {
            propertyId.setStreet(this.boundaryService.getBoundaryById(this.getStreetId()));
        }
        propertyId.setEastBoundary(this.getEastBoundary());
        propertyId.setWestBoundary(this.getWestBoundary());
        propertyId.setNorthBoundary(this.getNorthBoundary());
        propertyId.setSouthBoundary(this.getSouthBoundary());
        propertyId.setBasicProperty(basicProperty);
        this.LOGGER.debug((Object)("PropertyID: " + propertyId + "\nExiting from createPropertyID"));
        return propertyId;
    }

    @SkipValidation
    @Action(value="/create-printAck")
    public String printAck() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.basicPropertyService.propertyAcknowledgement(this.property, cityLogo, cityName));
        return PRINTACK;
    }

    public PropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(PropertyImpl property) {
        this.property = property;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(Long blockId) {
        this.blockId = blockId;
    }

    public Long getStreetId() {
        return this.streetId;
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
    }

    public Long getLocality() {
        return this.locality;
    }

    public void setLocality(Long locality) {
        this.locality = locality;
    }

    public Long getFloorTypeId() {
        return this.floorTypeId;
    }

    public void setFloorTypeId(Long floorTypeId) {
        this.floorTypeId = floorTypeId;
    }

    public Long getRoofTypeId() {
        return this.roofTypeId;
    }

    public void setRoofTypeId(Long roofTypeId) {
        this.roofTypeId = roofTypeId;
    }

    public Long getWallTypeId() {
        return this.wallTypeId;
    }

    public void setWallTypeId(Long wallTypeId) {
        this.wallTypeId = wallTypeId;
    }

    public Long getWoodTypeId() {
        return this.woodTypeId;
    }

    public void setWoodTypeId(Long woodTypeId) {
        this.woodTypeId = woodTypeId;
    }

    public Long getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(Long ownershipType) {
        this.ownershipType = ownershipType;
    }

    public Long getElectionWardId() {
        return this.electionWardId;
    }

    public void setElectionWardId(Long electionWardId) {
        this.electionWardId = electionWardId;
    }

    public String getWardName() {
        return this.wardName;
    }

    public void setWardName(String wardName) {
        this.wardName = wardName;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public String getAddressStr() {
        return this.addressStr;
    }

    public void setAddressStr(String addressStr) {
        this.addressStr = addressStr;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public String getAreaOfPlot() {
        return this.areaOfPlot;
    }

    public void setAreaOfPlot(String areaOfPlot) {
        this.areaOfPlot = areaOfPlot;
    }

    public String getDateOfCompletion() {
        return this.dateOfCompletion;
    }

    public void setDateOfCompletion(String dateOfCompletion) {
        this.dateOfCompletion = dateOfCompletion;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getCorrAddress1() {
        return this.corrAddress1;
    }

    public void setCorrAddress1(String corrAddress1) {
        this.corrAddress1 = corrAddress1;
    }

    public String getCorrAddress2() {
        return this.corrAddress2;
    }

    public void setCorrAddress2(String corrAddress2) {
        this.corrAddress2 = corrAddress2;
    }

    public String getCorrPinCode() {
        return this.corrPinCode;
    }

    public void setCorrPinCode(String corrPinCode) {
        this.corrPinCode = corrPinCode;
    }

    public String getUpicNo() {
        return this.upicNo;
    }

    public void setUpicNo(String upicNo) {
        this.upicNo = upicNo;
    }

    public String getTaxExemptionId() {
        return this.taxExemptionId;
    }

    public void setTaxExemptionId(String taxExemptionId) {
        this.taxExemptionId = taxExemptionId;
    }

    public String getParentIndex() {
        return this.parentIndex;
    }

    public void setParentIndex(String parentIndex) {
        this.parentIndex = parentIndex;
    }

    public String getAmenities() {
        return this.amenities;
    }

    public void setAmenities(String amenities) {
        this.amenities = amenities;
    }

    public String[] getFloorNoStr() {
        return this.floorNoStr;
    }

    public void setFloorNoStr(String[] floorNoStr) {
        this.floorNoStr = floorNoStr;
    }

    public String getPropTypeId() {
        return this.propTypeId;
    }

    public void setPropTypeId(String propTypeId) {
        this.propTypeId = propTypeId;
    }

    public String getPropUsageId() {
        return this.propUsageId;
    }

    public void setPropUsageId(String propUsageId) {
        this.propUsageId = propUsageId;
    }

    public String getPropOccId() {
        return this.propOccId;
    }

    public void setPropOccId(String propOccId) {
        this.propOccId = propOccId;
    }

    public String getPropertyCategory() {
        return this.propertyCategory;
    }

    public void setPropertyCategory(String propertyCategory) {
        this.propertyCategory = propertyCategory;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String getNonResPlotArea() {
        return this.nonResPlotArea;
    }

    public void setNonResPlotArea(String nonResPlotArea) {
        this.nonResPlotArea = nonResPlotArea;
    }

    public String getApplicationNoMessage() {
        return this.applicationNoMessage;
    }

    public void setApplicationNoMessage(String applicationNoMessage) {
        this.applicationNoMessage = applicationNoMessage;
    }

    public String getAssessmentNoMessage() {
        return this.assessmentNoMessage;
    }

    public void setAssessmentNoMessage(String assessmentNoMessage) {
        this.assessmentNoMessage = assessmentNoMessage;
    }

    public String getPropertyInitiatedBy() {
        return this.propertyInitiatedBy;
    }

    public void setPropertyInitiatedBy(String propertyInitiatedBy) {
        this.propertyInitiatedBy = propertyInitiatedBy;
    }

    public String getNorthBoundary() {
        return this.northBoundary;
    }

    public void setNorthBoundary(String northBoundary) {
        this.northBoundary = northBoundary;
    }

    public String getSouthBoundary() {
        return this.southBoundary;
    }

    public void setSouthBoundary(String southBoundary) {
        this.southBoundary = southBoundary;
    }

    public String getEastBoundary() {
        return this.eastBoundary;
    }

    public void setEastBoundary(String eastBoundary) {
        this.eastBoundary = eastBoundary;
    }

    public String getWestBoundary() {
        return this.westBoundary;
    }

    public void setWestBoundary(String westBoundary) {
        this.westBoundary = westBoundary;
    }

    public Long getMutationId() {
        return this.mutationId;
    }

    public void setMutationId(Long mutationId) {
        this.mutationId = mutationId;
    }

    public Map<String, String> getPropTypeCategoryMap() {
        return this.propTypeCategoryMap;
    }

    public void setPropTypeCategoryMap(Map<String, String> propTypeCategoryMap) {
        this.propTypeCategoryMap = propTypeCategoryMap;
    }

    public TreeMap<Integer, String> getFloorNoMap() {
        return this.floorNoMap;
    }

    public void setFloorNoMap(TreeMap<Integer, String> floorNoMap) {
        this.floorNoMap = floorNoMap;
    }

    public Map<String, String> getDeviationPercentageMap() {
        return this.deviationPercentageMap;
    }

    public void setDeviationPercentageMap(Map<String, String> deviationPercentageMap) {
        this.deviationPercentageMap = deviationPercentageMap;
    }

    public Map<String, String> getGuardianRelationMap() {
        return this.guardianRelationMap;
    }

    public void setGuardianRelationMap(Map<String, String> guardianRelationMap) {
        this.guardianRelationMap = guardianRelationMap;
    }

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public BasicProperty getBasicProp() {
        return this.basicProp;
    }

    public void setBasicProp(BasicProperty basicProp) {
        this.basicProp = basicProp;
    }

    public PropertyTypeMaster getPropTypeMstr() {
        return this.propTypeMstr;
    }

    public void setPropTypeMstr(PropertyTypeMaster propTypeMstr) {
        this.propTypeMstr = propTypeMstr;
    }

    public PropertyImpl getNewProperty() {
        return this.newProperty;
    }

    public void setNewProperty(PropertyImpl newProperty) {
        this.newProperty = newProperty;
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(Address ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public Date getPropCompletionDate() {
        return this.propCompletionDate;
    }

    public void setPropCompletionDate(Date propCompletionDate) {
        this.propCompletionDate = propCompletionDate;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public String getApplicationSource() {
        return this.applicationSource;
    }

    public void setApplicationSource(String applicationSource) {
        this.applicationSource = applicationSource;
    }
}

