/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.admin;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BoundaryCategory;
import org.egov.ptis.domain.entity.property.Category;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Namespace(value="/admin")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name={"new"}, location="admin/unitRate-new.jsp"), @Result(name={"ack"}, location="admin/unitRate-ack.jsp"), @Result(name={"search"}, location="admin/unitRate-search.jsp"), @Result(name={"view"}, location="admin/unitRate-view.jsp")})
public class UnitRateAction
extends BaseFormAction {
    private Category category = new Category();
    private Long zoneId;
    private Long usageId;
    private Long structureClassId;
    private Long categoryId;
    private String ackMessage;
    private String mode = "";
    private String roleName;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    List<BoundaryCategory> bndryCatList;
    private static final String RESULT_ACK = "ack";
    private static final String RESULT_NEW = "new";
    private static final String SEARCH_FORM = "search";

    @SkipValidation
    public Object getModel() {
        return this.category;
    }

    @SkipValidation
    public void prepare() {
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List usageList = this.getPersistenceService().findAllBy("from PropertyUsage order by usageName", new Object[0]);
        List structureClassificationList = this.getPersistenceService().findAllBy("from StructureClassification order by typeName", new Object[0]);
        this.addDropdownData("ZoneList", zoneList);
        this.addDropdownData("UsageList", usageList);
        this.addDropdownData("StructureClassificationList", structureClassificationList);
        Long userId = (Long)this.session().get("userid");
        if (userId != null) {
            this.setRoleName(this.propertyTaxUtil.getRolesForUserId(userId));
        }
    }

    @SkipValidation
    @Action(value="/unitRate-newForm")
    public String newForm() {
        if (this.roleName.contains("Property Administrator".toUpperCase())) {
            if (this.mode.equals("edit") || this.mode.equals("deactivate")) {
                if (this.categoryId != null && this.categoryId != -1L) {
                    this.category = (Category)this.getPersistenceService().find("from Category where id = ?", new Object[]{this.categoryId});
                    this.setUsageId(this.category.getPropUsage().getId());
                    this.setStructureClassId(this.category.getStructureClass().getId());
                }
                return RESULT_NEW;
            }
            this.mode = RESULT_NEW;
            return RESULT_NEW;
        }
        return SEARCH_FORM;
    }

    @SkipValidation
    @Action(value="/unitRate-searchForm")
    public String searchForm() {
        return SEARCH_FORM;
    }

    @Action(value="/unitRate-create")
    public String create() {
        Date toDate;
        Category existingCategory = (Category)this.getPersistenceService().find("select bc.category from BoundaryCategory bc where bc.bndry.id = ? and bc.category.propUsage.id = ? and bc.category.structureClass.id = ? and bc.category.fromDate = ? and bc.category.isActive = true ", new Object[]{this.zoneId, this.usageId, this.structureClassId, this.category.getFromDate()});
        if (existingCategory != null) {
            this.addActionError(this.getText("unit.rate.exists.for.combination"));
            this.mode = RESULT_NEW;
            return RESULT_NEW;
        }
        PropertyUsage usage = (PropertyUsage)this.getPersistenceService().find("from PropertyUsage where id = ? ", new Object[]{this.usageId});
        StructureClassification structureClass = (StructureClassification)this.getPersistenceService().find("from StructureClassification where id = ? ", new Object[]{this.structureClassId});
        Boundary zone = this.boundaryService.getBoundaryById(this.zoneId);
        this.category.setPropUsage(usage);
        this.category.setStructureClass(structureClass);
        this.category.setIsHistory(Character.valueOf('N'));
        this.category.setIsActive(true);
        Calendar category_toDate = Calendar.getInstance();
        category_toDate.set(5, 31);
        category_toDate.set(2, 3);
        category_toDate.set(1, 2099);
        category_toDate.set(11, 0);
        category_toDate.set(12, 0);
        category_toDate.set(13, 0);
        this.category.setToDate(category_toDate.getTime());
        this.category.setCategoryName(usage.getUsageCode().concat("-").concat(structureClass.getConstrTypeCode()).concat("-").concat(this.category.getCategoryAmount().toString()));
        if (this.zoneId != -1L && this.usageId != -1L && this.structureClassId != -1L && (existingCategory = (Category)this.getPersistenceService().find("select bc.category from BoundaryCategory bc where bc.bndry.id = ? and bc.category.propUsage.id = ? and bc.category.structureClass.id = ? ", new Object[]{this.zoneId, this.usageId, this.structureClassId})) != null && ((toDate = existingCategory.getToDate()) == null || toDate != null && toDate.after(this.category.getFromDate()))) {
            Date newToDate = DateUtils.addDays((Date)this.category.getFromDate(), (int)-1);
            existingCategory.setToDate(newToDate);
        }
        BoundaryCategory boundaryCategory = new BoundaryCategory();
        boundaryCategory.setCategory(this.category);
        boundaryCategory.setBndry(zone);
        boundaryCategory.setFromDate(this.category.getFromDate());
        boundaryCategory.setToDate(this.category.getToDate());
        HashSet<BoundaryCategory> boundaryCategorySet = new HashSet<BoundaryCategory>();
        boundaryCategorySet.add(boundaryCategory);
        this.category.setCatBoundaries(boundaryCategorySet);
        this.getPersistenceService().persist((Object)this.category);
        this.setAckMessage("Unit Rate is saved successfully!");
        return RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/unitRate-search")
    public String search() {
        this.validateSearch();
        if (this.hasErrors()) {
            return SEARCH_FORM;
        }
        StringBuilder mainStr = new StringBuilder(400);
        mainStr.append("From BoundaryCategory bndryCat where bndryCat.bndry.id=:zone ");
        if (this.usageId != null && this.usageId != -1L) {
            mainStr.append(" and bndryCat.category.propUsage.id=:usage");
        }
        if (this.structureClassId != null && this.structureClassId != -1L) {
            mainStr.append(" and bndryCat.category.structureClass.id=:stucture");
        }
        mainStr.append(" and bndryCat.category.IsHistory = 'N' and bndryCat.category.isActive = true ");
        Query query = this.getPersistenceService().getSession().createQuery(mainStr.toString());
        query.setLong("zone", this.zoneId.longValue());
        if (this.usageId != null && this.usageId != -1L) {
            query.setLong("usage", this.usageId.longValue());
        }
        if (this.structureClassId != null && this.structureClassId != -1L) {
            query.setLong("stucture", this.structureClassId.longValue());
        }
        this.bndryCatList = query.list();
        if (this.bndryCatList.isEmpty()) {
            this.addActionError(this.getText("no.unit.rate.exists"));
        }
        return SEARCH_FORM;
    }

    @SkipValidation
    @Action(value="/unitRate-view")
    public String view() {
        if (this.categoryId != null && this.categoryId != -1L) {
            this.category = (Category)this.getPersistenceService().find("from Category where id = ?", new Object[]{this.categoryId});
        }
        this.setUsageId(this.category.getPropUsage().getId());
        this.setStructureClassId(this.category.getStructureClass().getId());
        this.mode = "view";
        return RESULT_NEW;
    }

    @SkipValidation
    @Action(value="/unitRate-update")
    public String update() {
        Category catFromDb = null;
        Category existingCategory = (Category)this.getPersistenceService().find("select bc.category from BoundaryCategory bc where bc.bndry.id = ? and bc.category.propUsage.id = ? and bc.category.structureClass.id = ? and bc.category.fromDate = ? and bc.category.categoryAmount = ? ", new Object[]{this.zoneId, this.usageId, this.structureClassId, this.category.getFromDate(), this.category.getCategoryAmount()});
        if (existingCategory != null) {
            this.addActionError(this.getText("unit.rate.exists.for.combination"));
            this.mode = "edit";
            return RESULT_NEW;
        }
        if (this.category != null && this.category.getId() != null && this.category.getId() != -1L) {
            catFromDb = (Category)this.getPersistenceService().find("from Category where id = ?", new Object[]{this.category.getId()});
        }
        Category categoryObj = new Category();
        categoryObj.setCategoryAmount(this.category.getCategoryAmount());
        categoryObj.setFromDate(this.category.getFromDate());
        PropertyUsage usage = (PropertyUsage)this.getPersistenceService().find("from PropertyUsage where id = ? ", new Object[]{this.usageId});
        StructureClassification structureClass = (StructureClassification)this.getPersistenceService().find("from StructureClassification where id = ? ", new Object[]{this.structureClassId});
        Boundary zone = this.boundaryService.getBoundaryById(this.zoneId);
        categoryObj.setPropUsage(usage);
        categoryObj.setStructureClass(structureClass);
        categoryObj.setIsHistory(Character.valueOf('N'));
        categoryObj.setToDate(catFromDb.getToDate());
        categoryObj.setIsActive(true);
        categoryObj.setCategoryName(usage.getUsageCode().concat("-").concat(structureClass.getConstrTypeCode()).concat("-").concat(categoryObj.getCategoryAmount().toString()));
        BoundaryCategory boundaryCategory = new BoundaryCategory();
        boundaryCategory.setCategory(categoryObj);
        boundaryCategory.setBndry(zone);
        boundaryCategory.setFromDate(categoryObj.getFromDate());
        boundaryCategory.setToDate(categoryObj.getToDate());
        if (catFromDb != null) {
            catFromDb.setIsHistory(Character.valueOf('Y'));
            Date toDate = catFromDb.getToDate();
            if (toDate == null || toDate != null && toDate.after(catFromDb.getFromDate())) {
                Date newToDate = DateUtils.addDays((Date)this.category.getFromDate(), (int)-1);
                catFromDb.setToDate(newToDate);
            }
        }
        HashSet<BoundaryCategory> boundaryCategorySet = new HashSet<BoundaryCategory>();
        boundaryCategorySet.add(boundaryCategory);
        categoryObj.setCatBoundaries(boundaryCategorySet);
        this.getPersistenceService().persist((Object)categoryObj);
        this.getPersistenceService().update((Object)catFromDb);
        this.setAckMessage("Unit Rate is updated successfully!");
        return RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/unitRate-deactivate")
    public String deactivate() {
        if (this.categoryId != null && this.categoryId != -1L) {
            this.category = (Category)this.getPersistenceService().find("from Category where id = ?", new Object[]{this.categoryId});
            this.category.setIsActive(false);
            this.setAckMessage("Unit Rate deactivated successfully!");
            this.getPersistenceService().update((Object)this.category);
        }
        return RESULT_ACK;
    }

    public void validate() {
        if (this.zoneId == null || this.zoneId == -1L) {
            this.addActionError(this.getText("unit.rate.zone.required"));
        }
        if (this.usageId == null || this.usageId == -1L) {
            this.addActionError(this.getText("unit.rate.usage.required"));
        }
        if (this.structureClassId == null || this.structureClassId == -1L) {
            this.addActionError(this.getText("unit.rate.structure.classification.required"));
        }
        if (this.category.getCategoryAmount() == null) {
            this.addActionError(this.getText("unit.rate.category.amount.required"));
        }
        if (this.category.getFromDate() == null) {
            this.addActionError(this.getText("unit.rate.fromDate.required"));
        }
    }

    public void validateSearch() {
        if (this.zoneId == null || this.zoneId == -1L) {
            this.addActionError(this.getText("unit.rate.zone.required"));
        }
    }

    public Long getUsageId() {
        return this.usageId;
    }

    public void setUsageId(Long usageId) {
        this.usageId = usageId;
    }

    public Long getStructureClassId() {
        return this.structureClassId;
    }

    public void setStructureClassId(Long structureClassId) {
        this.structureClassId = structureClassId;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<BoundaryCategory> getBndryCatList() {
        return this.bndryCatList;
    }

    public void setBndryCatList(List<BoundaryCategory> bndryCatList) {
        this.bndryCatList = bndryCatList;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
}

