/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.entity.property.DailyCollectionReportSearchVLT;
import org.egov.ptis.domain.service.report.ReportService;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.elasticsearch.search.sort.SortOrder;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dailyCollectionVLT"})
public class DailyCollectionReportVLTController {
    private static final String DAILY_COLLECTION_FORM = "dailyCollectionVLT-form";
    private static final Logger logger = Logger.getLogger(DailyCollectionReportVLTController.class);
    @Autowired
    private ReportService reportService;
    @Autowired
    private EgwStatusHibernateDAO egwStatushibernateDAO;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SearchService searchService;

    @ModelAttribute
    public void getReportModel(Model model) {
        DailyCollectionReportSearchVLT dailyCollectionReportResutVLT = new DailyCollectionReportSearchVLT();
        model.addAttribute("dailyCollectionReportResutVLT", (Object)dailyCollectionReportResutVLT);
    }

    @ModelAttribute(value="operators")
    public Set<User> loadCollectionOperators() {
        return this.reportService.getCollectionOperators();
    }

    @ModelAttribute(value="status")
    public List<EgwStatus> loadStatus() {
        return this.egwStatushibernateDAO.getStatusByModule("ReceiptHeader");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String seachForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("collectionMode", (Object)Source.values());
        return DAILY_COLLECTION_FORM;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<Document> searchCollection(@ModelAttribute DailyCollectionReportSearchVLT searchRequest) {
        SearchResult propertyIndexSearchResult = null;
        SearchResult collectionIndexSearchResult = null;
        ArrayList consumerCodes = new ArrayList();
        ArrayList<Document> searchResultFomatted = new ArrayList<Document>(0);
        Sort sortByAssessment = Sort.by().field("clauses.revwardname", SortOrder.ASC);
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getRevenueWard())) {
            propertyIndexSearchResult = this.searchService.search(Arrays.asList(Index.APPTIS.toString()), Arrays.asList(IndexType.PTISDETAILS.toString()), searchRequest.searchQuery(), searchRequest.searchProperyForWardFilters(), sortByAssessment, Page.NULL);
            for (Document PTDocument : propertyIndexSearchResult.getDocuments()) {
                Map PTCommonMap = (Map)PTDocument.getResource().get((Object)"common");
                consumerCodes.add(PTCommonMap.get("consumercode"));
            }
            searchRequest.setConsumerCode(consumerCodes);
            collectionIndexSearchResult = this.getCollectionIndex(searchRequest);
        } else {
            collectionIndexSearchResult = this.getCollectionIndex(searchRequest);
        }
        for (Document collectionIndexDocument : collectionIndexSearchResult.getDocuments()) {
            searchResultFomatted.add(collectionIndexDocument);
        }
        return searchResultFomatted;
    }

    private SearchResult getCollectionIndex(DailyCollectionReportSearchVLT searchRequest) {
        Sort sortByReceiptDate = Sort.by().field("searchable.receiptdate", SortOrder.ASC);
        logger.info((Object)("getCollectionIndex, searchRequest fromDate:" + searchRequest.getFromDate() + "|searchRequest toDate:" + searchRequest.getToDate() + "|searchRequest ulbname:" + searchRequest.getUlbName()));
        return this.searchService.search(Arrays.asList(Index.COLLECTION.toString()), Arrays.asList(IndexType.COLLECTION_BIFURCATION.toString()), searchRequest.searchQuery(), searchRequest.searchCollectionFilters(), sortByReceiptDate, Page.NULL);
    }
}

