/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.domain.entity.property.BaseRegisterResult;
import org.egov.ptis.domain.service.report.ReportService;
import org.egov.ptis.web.controller.reports.BaseRegisterResultAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/baseRegister"})
public class BaseRegisterReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ReportService reportService;

    @ModelAttribute
    public void getPropertyModel(Model model) {
        BaseRegisterResult baseRegisterResult = new BaseRegisterResult();
        model.addAttribute("baseRegisterResult", (Object)baseRegisterResult);
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "baseRegister-form";
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String ward, @RequestParam String block, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List propertyList = this.reportService.getPropertyByWardAndBlock(ward, block);
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)propertyList, BaseRegisterResult.class, BaseRegisterResultAdaptor.class) + "}";
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

