/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.woodtype;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.master.service.WoodTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/woodtype"})
public class CreateAndViewWoodTypeController {
    private final WoodTypeService woodTypeService;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public CreateAndViewWoodTypeController(WoodTypeService woodTypeService) {
        this.woodTypeService = woodTypeService;
    }

    @ModelAttribute
    public WoodType WoodTypeModel() {
        return new WoodType();
    }

    @ModelAttribute(value="woodTypes")
    public List<WoodType> listWoodTypes() {
        return this.woodTypeService.getAllWoodTypes();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String showWoodTypes(Model model) {
        String roleName = this.woodTypeService.getRolesForUserId(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("roleName", (Object)roleName);
        return "woodType-search";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create() {
        return "woodType-form";
    }

    @RequestMapping(value={"/view/{name}"}, method={RequestMethod.GET})
    public String view(@PathVariable String name, Model model) {
        WoodType woodType = this.woodTypeService.getWoodTypeByName(name);
        model.addAttribute("woodType", (Object)woodType);
        return "woodType-view";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute WoodType woodType, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "woodType-search";
        }
        this.woodTypeService.createWood(woodType);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.woodtype.create.success");
        return "redirect:/woodtype/create";
    }
}

