/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.taxrates;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.master.service.TaxRatesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/taxrates/view"})
public class ViewTaxRatesController {
    private final TaxRatesService taxRatesService;

    @Autowired
    public ViewTaxRatesController(TaxRatesService taxRatesService) {
        this.taxRatesService = taxRatesService;
    }

    @ModelAttribute
    public AppConfigValues taxRatesModel() {
        return new AppConfigValues();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showTaxRates(Model model) {
        List taxRates = this.taxRatesService.getAllTaxRates();
        HashMap taxRatesMap = new HashMap();
        for (AppConfigValues appConfig : taxRates) {
            String[] rows;
            for (String row : rows = appConfig.getValue().split("\n")) {
                String[] value = row.split("=");
                if (PropertyTaxConstants.TAX_RATES_TEMP.contains(value[0])) continue;
                taxRatesMap.put(PropertyTaxConstants.TAX_RATES.get(value[0]), Double.parseDouble(value[1]));
            }
        }
        LinkedHashMap taxRatesDisplayMap = new LinkedHashMap();
        taxRatesDisplayMap.put("General Tax Residential", taxRatesMap.get("General Tax Residential"));
        taxRatesDisplayMap.put("General Tax Non Residential", taxRatesMap.get("General Tax Non Residential"));
        taxRatesDisplayMap.put("Education Cess", taxRatesMap.get("Education Cess"));
        taxRatesDisplayMap.put("Vacant Land Tax", taxRatesMap.get("Vacant Land Tax"));
        taxRatesDisplayMap.put("Library Cess", taxRatesMap.get("Library Cess"));
        model.addAttribute("taxRates", taxRatesDisplayMap);
        return "taxRates-view";
    }
}

