/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.objection;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Area;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.actions.view.ViewPropertyAction;
import org.egov.ptis.bean.PropertyNoticeInfo;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.dao.property.PropertyStatusValuesDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.objection.Hearing;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.SMSEmailService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Namespace(value="/revPetition")
@ResultPath(value="/WEB-INF/jsp")
@Results(value={@Result(name={"new"}, location="revPetition/revisionPetition-new.jsp"), @Result(name={"message"}, location="revPetition/revisionPetition-message.jsp"), @Result(name={"notice"}, location="revPetition/revisionPetition-notice.jsp"), @Result(name={"view"}, location="revPetition/revisionPetition-view.jsp"), @Result(name={"commonForm"}, location="search/searchProperty-commonForm.jsp"), @Result(name={"digitalSignatureRedirection"}, location="revPetition/revisionPetition-digitalSignatureRedirection.jsp"), @Result(name={"meesevaAck"}, location="common/meesevaAck.jsp"), @Result(name={"error"}, location="common/meeseva-errorPage.jsp")})
public class RevisionPetitionAction
extends PropertyTaxBaseAction {
    protected static final String DIGITAL_SIGNATURE_REDIRECTION = "digitalSignatureRedirection";
    private static final long serialVersionUID = 1L;
    protected static final String COMMON_FORM = "commonForm";
    private final String REJECTED = "Rejected";
    public static final String STRUTS_RESULT_MESSAGE = "message";
    private static final String REVISION_PETITION_CREATED = "CREATED";
    private static final String REVISION_PETITION_HEARINGNOTICEGENERATED = "HEARINGNOTICEGENERATED";
    private static final String REVISION_PETITION_ENDORESEMENTGENERATED = "ENDORESEMTNTGENERATED";
    private static final String PREVIEW = "Preview";
    public static final String NOTICE = "notice";
    public static final String MEESEVA_ERROR = "error";
    public static final String MEESEVA_RESULT_ACK = "meesevaAck";
    private final Logger LOGGER = Logger.getLogger(RevisionPetitionAction.class);
    private ViewPropertyAction viewPropertyAction = new ViewPropertyAction();
    private RevisionPetition objection = new RevisionPetition();
    private String propertyId;
    private Map<String, Object> viewMap;
    private RevisionPetitionService revisionPetitionService;
    protected WorkflowService<RevisionPetition> objectionWorkflowService;
    private String ownerName;
    private String propertyAddress;
    private PersistenceService<Property, Long> propertyImplService;
    private String propTypeObjId;
    final SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy");
    private String[] floorNoStr = new String[100];
    private Boolean loggedUserIsEmployee = Boolean.TRUE;
    private PropertyService propService;
    private PropertyStatusValues propStatVal;
    private String reasonForModify;
    private TreeMap<Integer, String> floorNoMap;
    private Map<String, String> deviationPercentageMap;
    private LinkedHashMap<String, String> hearingTimingMap;
    private String areaOfPlot;
    private List<DocumentType> documentTypes = new ArrayList();
    private List<Hashtable<String, Object>> historyMap = new ArrayList();
    private String northBoundary;
    private String southBoundary;
    private String eastBoundary;
    private String westBoundary;
    private Map<String, String> propTypeCategoryMap;
    private String reportId;
    private Long taxExemptedReason;
    @Autowired
    private PropertyStatusValuesDAO propertyStatusValuesDAO;
    @Autowired
    private ReportService reportService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService;
    private boolean isShowAckMessage;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    PositionMasterService positionMasterService;
    @Autowired
    DesignationService designationService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    private SMSEmailService sMSEmailService;
    private String actionType;
    private String fileStoreIds;
    private String ulbCode;
    private Map<String, Object> wfPropTaxDetailsMap;
    private boolean digitalSignEnabled;
    private Boolean isMeesevaUser = Boolean.FALSE;
    private String meesevaApplicationNumber;

    public RevisionPetitionAction() {
        this.addRelatedEntity("basicProperty", BasicPropertyImpl.class);
        this.addRelatedEntity("property.propertyDetail.propertyTypeMaster", PropertyTypeMaster.class);
        this.addRelatedEntity("property.propertyDetail.sitalArea", Area.class);
        this.addRelatedEntity("property", PropertyImpl.class);
        this.addRelatedEntity("property.propertyDetail.floorType", FloorType.class);
        this.addRelatedEntity("property.propertyDetail.roofType", RoofType.class);
        this.addRelatedEntity("property.propertyDetail.wallType", WallType.class);
        this.addRelatedEntity("property.propertyDetail.woodType", WoodType.class);
        this.addRelatedEntity("structureClassification", StructureClassification.class);
        this.addRelatedEntity("property.propertyDetail.apartment", Apartment.class);
    }

    public RevisionPetition getModel() {
        return this.objection;
    }

    public void prepare() {
        User user = null;
        if (this.objection.getId() != null) {
            this.objection = (RevisionPetition)this.revisionPetitionService.findById((Serializable)this.objection.getId(), false);
        }
        if (this.objection != null && this.objection.getId() == null) {
            this.objection.setRecievedOn(new Date());
            user = this.securityUtils.getCurrentUser();
            if (user != null) {
                this.objection.setRecievedBy(user.getUsername());
            }
        }
        if (null != this.objection && null != this.objection.getState()) {
            this.historyMap = this.propService.populateHistory((StateAware)this.objection);
        }
        this.loggedUserIsEmployee = this.propService.isEmployee(this.securityUtils.getCurrentUser());
        super.prepare();
        this.setUserInfo();
        this.documentTypes = this.propService.getDocumentTypesForTransactionType(TransactionType.MODIFY);
        List wallTypes = this.getPersistenceService().findAllBy("from WallType order by name", new Object[0]);
        List woodTypes = this.getPersistenceService().findAllBy("from WoodType order by name", new Object[0]);
        List propTypeList = this.getPersistenceService().findAllBy("from PropertyTypeMaster where type != 'EWSHS' order by orderNo", new Object[0]);
        List propMutList = this.getPersistenceService().findAllBy("from PropertyMutationMaster where type = 'MODIFY' and code in('OBJ')", new Object[0]);
        List StructureList = this.getPersistenceService().findAllBy("from StructureClassification", new Object[0]);
        List usageList = this.getPersistenceService().findAllBy("from PropertyUsage order by usageName", new Object[0]);
        List propOccList = this.getPersistenceService().findAllBy("from PropertyOccupation", new Object[0]);
        List ageFacList = this.getPersistenceService().findAllBy("from DepreciationMaster", new Object[0]);
        this.setFloorNoMap(PropertyTaxConstants.FLOOR_MAP);
        this.addDropdownData("floorType", this.getPersistenceService().findAllBy("from FloorType order by name", new Object[0]));
        this.addDropdownData("roofType", this.getPersistenceService().findAllBy("from RoofType order by name", new Object[0]));
        List apartmentsList = this.getPersistenceService().findAllBy("from Apartment order by name", new Object[0]);
        List taxExemptionReasonList = this.getPersistenceService().findAllBy("from TaxExeptionReason order by name", new Object[0]);
        this.addDropdownData("wallType", wallTypes);
        this.addDropdownData("woodType", woodTypes);
        this.addDropdownData("PropTypeMaster", propTypeList);
        this.addDropdownData("OccupancyList", propOccList);
        this.addDropdownData("UsageList", usageList);
        this.addDropdownData("MutationList", propMutList);
        this.addDropdownData("StructureList", StructureList);
        this.addDropdownData("AgeFactorList", ageFacList);
        this.addDropdownData("apartments", apartmentsList);
        this.addDropdownData("taxExemptionReasonList", taxExemptionReasonList);
        this.populatePropertyTypeCategory();
        this.setDeviationPercentageMap((Map)PropertyTaxConstants.DEVIATION_PERCENTAGE);
        this.setHearingTimingMap(PropertyTaxConstants.HEARING_TIMINGS);
        this.digitalSignEnabled = this.propertyTaxCommonUtils.isDigitalSignatureEnabled();
    }

    @SkipValidation
    @Action(value="/revPetition-newForm")
    public String newForm() {
        BasicProperty basicProperty;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into newForm");
        }
        if ((basicProperty = this.basicPropertyDAO.getBasicPropertyByIndexNumAndParcelID(this.propertyId, null)).getProperty().getStatus().equals(PropertyTaxConstants.STATUS_ISACTIVE)) {
            this.addActionError(this.getText("revPetition.demandActive"));
            return COMMON_FORM;
        }
        this.getPropertyView(this.propertyId);
        if (this.objection != null && this.objection.getBasicProperty() != null && this.objection.getBasicProperty().isUnderWorkflow()) {
            this.addActionMessage(this.getText("property.state.objected", new String[]{this.objection.getBasicProperty().getUpicNo()}));
            return STRUTS_RESULT_MESSAGE;
        }
        this.isMeesevaUser = this.propService.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (this.isMeesevaUser.booleanValue()) {
            if (this.getMeesevaApplicationNumber() == null) {
                this.addActionMessage(this.getText("MEESEVA.005"));
                return MEESEVA_ERROR;
            }
            this.objection.setMeesevaApplicationNumber(this.getMeesevaApplicationNumber());
        }
        this.setFloorDetails(this.objection.getBasicProperty().getProperty());
        return "new";
    }

    @Action(value="/revPetition")
    public String create() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | Create | start " + this.objection));
        }
        if (this.objection != null && this.objection.getBasicProperty() != null && this.objection.getState() == null && this.objection.getBasicProperty().isUnderWorkflow()) {
            this.addActionMessage(this.getText("property.state.objected", new String[]{this.objection.getBasicProperty().getUpicNo()}));
            return STRUTS_RESULT_MESSAGE;
        }
        if (this.objection.getRecievedOn() == null) {
            this.addActionMessage(this.getText("mandatory.fieldvalue.receivedOn"));
            return "new";
        }
        this.isMeesevaUser = this.propService.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (this.isMeesevaUser.booleanValue() && this.getMeesevaApplicationNumber() != null) {
            this.objection.setObjectionNumber(this.objection.getMeesevaApplicationNumber());
        } else {
            this.objection.setObjectionNumber(this.applicationNumberGenerator.generate());
        }
        this.objection.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("OBJECTED"));
        this.objection.getBasicProperty().setUnderWorkflow(Boolean.TRUE.booleanValue());
        this.updateStateAndStatus(this.objection);
        this.addActionMessage(this.getText("objection.success") + this.objection.getObjectionNumber());
        this.revisionPetitionService.applyAuditing((AbstractAuditable)this.objection.getState());
        if (!this.isMeesevaUser.booleanValue()) {
            this.revisionPetitionService.createRevisionPetition(this.objection);
        } else {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("ADMISSIONFEE", "0");
            meesevaParams.put("APPLICATIONNUMBER", this.objection.getMeesevaApplicationNumber());
            this.objection.getBasicProperty().setSource(PropertyTaxConstants.SOURCEOFDATA_MEESEWA);
            this.objection.setApplicationNo(this.objection.getMeesevaApplicationNumber());
            this.revisionPetitionService.createRevisionPetition(this.objection, meesevaParams);
        }
        this.sendEmailandSms(this.objection, REVISION_PETITION_CREATED);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | Create | End " + this.objection));
        }
        return this.isMeesevaUser != false ? MEESEVA_RESULT_ACK : STRUTS_RESULT_MESSAGE;
    }

    @Action(value="/revPetition-addHearingDate")
    public String addHearingDate() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | addHearingDate | start " + this.objection));
        }
        ByteArrayInputStream hearingNoticePdf = null;
        ReportOutput reportOutput = new ReportOutput();
        this.updateStateAndStatus(this.objection);
        reportOutput = this.createHearingNoticeReport(reportOutput, this.objection);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            hearingNoticePdf = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        if (hearingNoticePdf != null) {
            this.noticeService.saveNotice(this.objection.getObjectionNumber(), this.objection.getObjectionNumber(), "Revision Petition Hearing Notice", this.objection.getBasicProperty(), (InputStream)hearingNoticePdf);
        }
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        this.sendEmailandSms(this.objection, REVISION_PETITION_HEARINGNOTICEGENERATED);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | addHearingDate | End " + this.objection));
        }
        return STRUTS_RESULT_MESSAGE;
    }

    private ReportOutput createHearingNoticeReport(ReportOutput reportOutput, RevisionPetition objection) {
        reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportRequest = null;
        if (objection != null) {
            HttpServletRequest request = ServletActionContext.getRequest();
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            Boolean isCorporation = cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            reportParams.put("isCorporation", isCorporation);
            reportParams.put("cityName", cityName);
            reportParams.put("recievedBy", objection.getBasicProperty().getFullOwnerName());
            if (objection.getHearings() != null && objection.getHearings().size() > 0 && ((Hearing)objection.getHearings().get(objection.getHearings().size() - 1)).getPlannedHearingDt() != null) {
                reportParams.put("hearingNoticeDate", this.dateformat.format(((Hearing)objection.getHearings().get(objection.getHearings().size() - 1)).getPlannedHearingDt()));
            } else {
                reportParams.put("hearingNoticeDate", "");
            }
            reportParams.put("currentDate", this.dateformat.format(new Date()));
            reportParams.put("recievedOn", this.dateformat.format(objection.getRecievedOn()));
            reportParams.put("docNumberObjection", objection.getObjectionNumber());
            reportParams.put("houseNo", objection.getBasicProperty().getAddress().getHouseNoBldgApt());
            reportParams.put("locality", objection.getBasicProperty().getPropertyID().getLocality().getName());
            reportParams.put("assessmentNo", objection.getBasicProperty().getUpicNo());
            reportParams.put("hearingTime", ((Hearing)objection.getHearings().get(objection.getHearings().size() - 1)).getHearingTime());
            reportParams.put("hearingVenue", ((Hearing)objection.getHearings().get(objection.getHearings().size() - 1)).getHearingVenue());
            reportRequest = new ReportRequest("mainHearingNotice", (Object)objection, reportParams);
            reportOutput = this.reportService.createReport(reportRequest);
        }
        return reportOutput;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-generateHearingNotice")
    public String generateHearingNotice() {
        this.objection.setGenerateSpecialNotice(Boolean.TRUE);
        this.updateStateAndStatus(this.objection);
        PropertyImpl refNewProperty = this.propService.creteNewPropertyForObjectionWorkflow(this.objection.getBasicProperty(), this.objection.getObjectionNumber(), this.objection.getRecievedOn(), this.objection.getCreatedBy(), null, "OBJ");
        this.propertyImplService.getSession().flush();
        this.objection.setProperty(refNewProperty);
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        return STRUTS_RESULT_MESSAGE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-printHearingNotice")
    public String printHearingNotice() {
        this.objection = (RevisionPetition)this.revisionPetitionService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("objectionId"))[0]), false);
        ReportOutput reportOutput = new ReportOutput();
        if (this.objection != null && this.objection.getObjectionNumber() != null) {
            byte[] bFile;
            PtNotice ptNotice = this.noticeService.getPtNoticeByNoticeNumberAndNoticeType(this.objection.getObjectionNumber(), "Revision Petition Hearing Notice");
            FileStoreMapper fsm = ptNotice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating Hearing Notcie : " + e);
            }
            reportOutput.setReportOutputData(bFile);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        } else {
            this.addActionMessage(this.getText("objection.nohearingNotice"));
        }
        return NOTICE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-recordHearingDetails")
    public String recordHearingDetails() throws TaxCalculatorExeption {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | recordHearingDetails | start " + this.objection.getHearings().get(this.objection.getHearings().size() - 1)));
        }
        this.vaidatePropertyDetails();
        if (this.hasErrors()) {
            return "view";
        }
        if (null == ((Hearing)this.objection.getHearings().get(this.objection.getHearings().size() - 1)).getHearingNumber()) {
            String hearingNumber = this.applicationNumberGenerator.generate();
            ((Hearing)this.objection.getHearings().get(this.objection.getHearings().size() - 1)).setHearingNumber(hearingNumber);
            this.addActionMessage(this.getText("hearingNum") + " " + hearingNumber);
        }
        this.updateStateAndStatus(this.objection);
        this.modifyBasicProp();
        this.propertyImplService.merge((Object)this.objection.getProperty());
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | recordHearingDetails | End " + this.objection.getHearings().get(this.objection.getHearings().size() - 1)));
        }
        return STRUTS_RESULT_MESSAGE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-recordInspectionDetails")
    public String recordInspectionDetails() throws TaxCalculatorExeption {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | recordInspectionDetails | start " + this.objection.getInspections().get(this.objection.getInspections().size() - 1)));
        }
        this.vaidatePropertyDetails();
        if (this.hasErrors()) {
            return "view";
        }
        this.updateStateAndStatus(this.objection);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | recordInspectionDetails | End " + this.objection.getInspections().get(this.objection.getInspections().size() - 1)));
        }
        this.modifyBasicProp();
        this.propertyImplService.merge((Object)this.objection.getProperty());
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        return STRUTS_RESULT_MESSAGE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-validateInspectionDetails")
    public String validateInspectionDetails() {
        this.updateStateAndStatus(this.objection);
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        return STRUTS_RESULT_MESSAGE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-rejectInspectionDetails")
    public String rejectInspectionDetails() {
        this.updateStateAndStatus(this.objection);
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        return STRUTS_RESULT_MESSAGE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-recordObjectionOutcome")
    public String recordObjectionOutcome() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | recordObjectionOutcome | start " + this.objection));
        }
        if (this.hasErrors()) {
            return "view";
        }
        if ("Approve".equalsIgnoreCase(this.workFlowAction)) {
            this.objection.setEgwStatus(this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", "OBJECTION ACCEPTED"));
            this.objection.getBasicProperty().getProperty().setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            this.objection.getProperty().setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.objection.getBasicProperty().addPropertyStatusValues(this.propService.createPropStatVal(this.objection.getBasicProperty(), "RP", null, null, null, null, null));
            this.propService.setWFPropStatValActive(this.objection.getBasicProperty());
        }
        this.updateStateAndStatus(this.objection);
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        this.sendEmailandSms(this.objection, REVISION_PETITION_ENDORESEMENTGENERATED);
        this.addActionMessage(this.getText("objection.outcome.success"));
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | recordObjectionOutcome | End " + this.objection));
        }
        return STRUTS_RESULT_MESSAGE;
    }

    private ReportOutput createEndoresement(ReportOutput reportOutput, RevisionPetition objection) {
        reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportRequest = null;
        if (objection != null) {
            Map currentDemand = this.ptDemandDAO.getDemandCollMap((Property)objection.getProperty());
            Map earlierDemand = this.ptDemandDAO.getDemandCollMap(objection.getBasicProperty().getProperty());
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            reportParams.put("logoPath", cityLogo);
            reportParams.put("cityName", cityName);
            reportParams.put("recievedBy", objection.getBasicProperty().getFullOwnerName());
            reportParams.put("docNumberObjection", objection.getObjectionNumber());
            reportParams.put("currentDate", this.dateformat.format(new Date()));
            reportParams.put("receivedOn", this.dateformat.format(objection.getRecievedOn()));
            reportParams.put("HouseNo", objection.getBasicProperty().getUpicNo());
            reportParams.put("wardNumber", objection.getBasicProperty().getBoundary() != null ? objection.getBasicProperty().getBoundary().getName() : "");
            reportParams.put("HalfYearPropertyTaxTo", ((BigDecimal)currentDemand.get("CURR_SECONDHALF_DMD")).divide(BigDecimal.valueOf(2L)).setScale(2));
            reportParams.put("HalfYearPropertyTaxFrom", ((BigDecimal)earlierDemand.get("CURR_SECONDHALF_DMD")).divide(BigDecimal.valueOf(2L)).setScale(2));
            reportParams.put("AnnualPropertyTaxTo", ((BigDecimal)currentDemand.get("CURR_SECONDHALF_DMD")).setScale(2).toString());
            reportParams.put("AnnualPropertyTaxFrom", ((BigDecimal)earlierDemand.get("CURR_SECONDHALF_DMD")).setScale(2).toString());
            reportRequest = new ReportRequest("revPetitionEndorsement", (Object)objection, reportParams);
            reportOutput = this.reportService.createReport(reportRequest);
        }
        return reportOutput;
    }

    public void generateSpecialNotice(PropertyImpl property, BasicPropertyImpl basicProperty) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        PropertyNoticeInfo propertyNotice = null;
        ByteArrayInputStream specialNoticePdf = null;
        String noticeNo = null;
        PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("Proceedings", this.objection.getObjectionNumber());
        List users = this.eisCommonService.getAllActiveUsersByGivenDesig(this.designationService.getDesignationByName("Commissioner").getId());
        reportParams.put("userId", !users.isEmpty() ? ((User)users.get(0)).getId() : 0L);
        reportParams.put("userSignature", !users.isEmpty() && ((User)users.get(0)).getSignature() != null ? new ByteArrayInputStream(((User)users.get(0)).getSignature()) : null);
        ReportOutput reportOutput = new ReportOutput();
        if ("Print Special Notice".equalsIgnoreCase(this.actionType) && notice != null) {
            byte[] bFile;
            FileStoreMapper fsm = notice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating Special Notcie : " + e);
            }
            reportOutput.setReportOutputData(bFile);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        } else {
            if ("Sign".equals(this.actionType) && notice == null) {
                noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber("Special Notice");
            }
            propertyNotice = new PropertyNoticeInfo(property, noticeNo);
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            String imagePath = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            Boolean isCorporation = cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            reportParams.put("isCorporation", isCorporation);
            reportParams.put("cityName", cityName);
            reportParams.put("logoPath", imagePath);
            reportParams.put("mode", "create");
            this.setNoticeInfo(property, propertyNotice, basicProperty);
            List floorDetails = this.getFloorDetailsForNotice(property);
            propertyNotice.setFloorDetailsForNotice(floorDetails);
            reportInput = new ReportRequest("mainRPSpecialNotice", (Object)propertyNotice, reportParams);
            reportInput.setPrintDialogOnOpenReport(true);
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            reportOutput = this.reportService.createReport(reportInput);
            if (reportOutput != null && reportOutput.getReportOutputData() != null) {
                specialNoticePdf = new ByteArrayInputStream(reportOutput.getReportOutputData());
            }
            if ("Sign".equals(this.actionType)) {
                if (notice == null) {
                    PtNotice savedNotice = this.noticeService.saveNotice(this.objection.getObjectionNumber(), this.objection.getObjectionNumber().concat("PROCEEDINGS"), "Proceedings", this.objection.getBasicProperty(), (InputStream)specialNoticePdf);
                    this.setFileStoreIds(savedNotice.getFileStore().getFileStoreId());
                } else {
                    PtNotice savedNotice = this.noticeService.updateNotice(notice, (InputStream)specialNoticePdf);
                    this.setFileStoreIds(savedNotice.getFileStore().getFileStoreId());
                }
                this.noticeService.getSession().flush();
            } else {
                this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
            }
        }
    }

    private List<PropertyAckNoticeInfo> getFloorDetailsForNotice(PropertyImpl property) {
        ArrayList<PropertyAckNoticeInfo> floorDetailsList = new ArrayList<PropertyAckNoticeInfo>();
        PropertyDetail detail = property.getPropertyDetail();
        PropertyAckNoticeInfo floorInfo = null;
        for (Floor floor : detail.getFloorDetails()) {
            floorInfo = new PropertyAckNoticeInfo();
            floorInfo.setBuildingClassification(floor.getStructureClassification().getTypeName());
            floorInfo.setNatureOfUsage(floor.getPropertyUsage().getUsageName());
            floorInfo.setPlinthArea(new BigDecimal(floor.getBuiltUpArea().getArea().floatValue()));
            floorInfo.setBuildingAge(floor.getDepreciationMaster().getDepreciationName());
            floorInfo.setMonthlyRentalValue(BigDecimal.ZERO);
            floorInfo.setYearlyRentalValue(BigDecimal.ZERO);
            floorInfo.setBldngFloorNo((String)PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()));
            floorInfo.setTaxPayableForNewRates(BigDecimal.ZERO);
            floorDetailsList.add(floorInfo);
        }
        return floorDetailsList;
    }

    private void setNoticeInfo(PropertyImpl property, PropertyNoticeInfo propertyNotice, BasicPropertyImpl basicProperty) {
        PropertyAckNoticeInfo infoBean = new PropertyAckNoticeInfo();
        PropertyAddress ownerAddress = basicProperty.getAddress();
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal propertyTax = BigDecimal.ZERO;
        if (basicProperty.getPropertyOwnerInfo().size() > 1) {
            infoBean.setOwnerName(basicProperty.getFullOwnerName().concat(" and others"));
        } else {
            infoBean.setOwnerName(basicProperty.getFullOwnerName());
        }
        infoBean.setOwnerAddress(basicProperty.getAddress().toString());
        infoBean.setApplicationNo(property.getApplicationNo());
        infoBean.setDoorNo(ownerAddress.getHouseNoBldgApt());
        if (StringUtils.isNotBlank((String)ownerAddress.getLandmark())) {
            infoBean.setStreetName(ownerAddress.getLandmark());
        } else {
            infoBean.setStreetName("N/A");
        }
        SimpleDateFormat formatNowYear = new SimpleDateFormat("yyyy");
        String occupancyYear = formatNowYear.format(basicProperty.getPropOccupationDate());
        infoBean.setInstallmentYear(occupancyYear);
        infoBean.setAssessmentNo(basicProperty.getUpicNo());
        infoBean.setAssessmentDate(this.dateformat.format(basicProperty.getAssessmentdate()).toString());
        Ptdemand currDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)property);
        this.prepareTaxInfoForProperty(infoBean, totalTax, propertyTax, currDemand, "current");
        if (currDemand.getDmdCalculations() != null && currDemand.getDmdCalculations().getAlv() != null) {
            infoBean.setNew_rev_ARV(currDemand.getDmdCalculations().getAlv());
        }
        PropertyImpl historyProperty = this.propService.getLatestHistoryProperty(basicProperty.getUpicNo());
        Ptdemand historyDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)historyProperty);
        if (historyProperty != null && historyDemand != null) {
            totalTax = BigDecimal.ZERO;
            propertyTax = BigDecimal.ZERO;
            this.prepareTaxInfoForProperty(infoBean, totalTax, propertyTax, historyDemand, "history");
            if (historyDemand.getDmdCalculations() != null && historyDemand.getDmdCalculations().getAlv() != null) {
                infoBean.setExistingARV(historyDemand.getDmdCalculations().getAlv());
            }
        }
        PropertyID propertyId = basicProperty.getPropertyID();
        infoBean.setZoneName(propertyId.getZone().getName());
        infoBean.setWardName(propertyId.getWard().getName());
        infoBean.setAreaName(propertyId.getArea().getName());
        infoBean.setLocalityName(propertyId.getLocality().getName());
        infoBean.setNoticeDate(new Date());
        infoBean.setApplicationDate(DateUtils.getFormattedDate((Date)this.objection.getCreatedDate(), (String)"dd/MM/yyyy"));
        infoBean.setHearingDate(DateUtils.getFormattedDate((Date)((Hearing)this.objection.getHearings().get(0)).getPlannedHearingDt(), (String)"dd/MM/yyyy"));
        User approver = this.userService.getUserById(ApplicationThreadLocals.getUserId());
        infoBean.setApproverName(approver.getName());
        BigDecimal revTax = currDemand.getBaseDemand();
        infoBean.setNewTotalTax(revTax);
        if (property.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_MEESEWA)) {
            infoBean.setMeesevaNo(property.getApplicationNo());
        }
        propertyNotice.setOwnerInfo(infoBean);
    }

    private void prepareTaxInfoForProperty(PropertyAckNoticeInfo infoBean, BigDecimal totalTax, BigDecimal propertyTax, Ptdemand currDemand, String propertyType) {
        for (EgDemandDetails demandDetail : currDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgInstallmentMaster().equals((Object)this.propertyTaxCommonUtils.getCurrentPeriodInstallment())) continue;
            totalTax = totalTax.add(demandDetail.getAmount());
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("EDU_CESS")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("LIB_CESS")) {
                if (propertyType.equalsIgnoreCase("current")) {
                    infoBean.setRevLibraryCess(demandDetail.getAmount());
                }
                if (propertyType.equalsIgnoreCase("history")) {
                    infoBean.setExistingLibraryCess(demandDetail.getAmount());
                }
            }
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("GEN_TAX") || demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("VAC_LAND_TAX")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("UNAUTH_PENALTY")) continue;
            if (propertyType.equalsIgnoreCase("current")) {
                infoBean.setRevUCPenalty(demandDetail.getAmount());
            }
            if (!propertyType.equalsIgnoreCase("history")) continue;
            infoBean.setExistingUCPenalty(demandDetail.getAmount());
        }
        if (propertyType.equalsIgnoreCase("current")) {
            infoBean.setRevTotalTax(totalTax);
            infoBean.setRevPropertyTax(propertyTax);
        }
        if (propertyType.equalsIgnoreCase("history")) {
            infoBean.setExistingTotalTax(totalTax);
            infoBean.setExistingPropertyTax(propertyTax);
        }
    }

    @Action(value="/revPetition-printEnodresementNotice")
    public String printEnodresementNotice() {
        this.objection = (RevisionPetition)this.revisionPetitionService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("objectionId"))[0]), false);
        ReportOutput reportOutput = new ReportOutput();
        if (this.objection != null && this.objection.getObjectionNumber() != null) {
            PtNotice ptNotice = this.noticeService.getPtNoticeByNoticeNumberAndNoticeType(this.objection.getObjectionNumber().concat("ENDORSEMENT"), "Revision Petition Endorsement");
            if (ptNotice != null) {
                byte[] bFile;
                FileStoreMapper fsm = ptNotice.getFileStore();
                File file = this.fileStoreService.fetch(fsm, "PTIS");
                try {
                    bFile = FileUtils.readFileToByteArray((File)file);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException("Exception while generating Hearing Notcie : " + e);
                }
                reportOutput.setReportOutputData(bFile);
                reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
                this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
            }
        } else {
            this.addActionMessage(this.getText("objection.noendoresementNotice"));
        }
        return NOTICE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-generateEnodresementNotice")
    public String generateEnodresementNotice() {
        PtNotice ptNotice;
        ReportOutput reportOutput = new ReportOutput();
        ByteArrayInputStream endoresementPdf = null;
        Position position = null;
        User user = null;
        position = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        user = this.userService.getUserById(ApplicationThreadLocals.getUserId());
        if (this.objection.getGenerateSpecialNotice() != null && !this.objection.getGenerateSpecialNotice().booleanValue()) {
            this.objection.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("ASSESSED"));
            this.objection.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
            this.objection.end().withStateValue("END").withOwner(position).withOwner(user).withComments(this.approverComments);
        } else {
            this.updateStateAndStatus(this.objection);
        }
        reportOutput = this.createEndoresement(reportOutput, this.objection);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            endoresementPdf = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        this.noticeService.saveNotice(this.objection.getObjectionNumber(), this.objection.getObjectionNumber().concat("ENDORSEMENT"), "Revision Petition Endorsement", this.objection.getBasicProperty(), (InputStream)endoresementPdf);
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        this.addActionMessage(this.getText("objection.endoresementNotice.success"));
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("ObjectionAction | generateEnodresementNotice | End " + this.objection));
        }
        if (this.objection != null && this.objection.getObjectionNumber() != null && (ptNotice = this.noticeService.getPtNoticeByNoticeNumberAndNoticeType(this.objection.getObjectionNumber().concat("ENDORSEMENT"), "Revision Petition Endorsement")) != null) {
            byte[] bFile;
            FileStoreMapper fsm = ptNotice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating Hearing Notcie : " + e);
            }
            reportOutput.setReportOutputData(bFile);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        }
        return NOTICE;
    }

    @ValidationErrorPage(value="view")
    @Action(value="/revPetition-generateSpecialNotice")
    public String generateSpecialNotice() {
        PtNotice ptNotice;
        this.setUlbCode(ApplicationThreadLocals.getCityCode());
        if (PREVIEW.equalsIgnoreCase(this.actionType) || "Sign".equalsIgnoreCase(this.actionType)) {
            this.objection = (RevisionPetition)this.revisionPetitionService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("objectionId"))[0]), false);
        }
        Position position = null;
        User user = null;
        position = this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId());
        user = this.securityUtils.getCurrentUser();
        if (this.objection.getGenerateSpecialNotice() != null && this.objection.getGenerateSpecialNotice().booleanValue() && !PREVIEW.equals(this.actionType)) {
            if ("Print Special Notice".equals(this.actionType)) {
                this.objection.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("ASSESSED"));
                this.objection.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
                this.objection.end().withStateValue("END").withOwner(position).withOwner(user).withComments(this.approverComments);
            } else if (!"Sign".equals(this.actionType)) {
                this.updateStateAndStatus(this.objection);
            }
        }
        this.generateSpecialNotice(this.objection.getProperty(), (BasicPropertyImpl)this.objection.getBasicProperty());
        if (!"Sign".equals(this.actionType)) {
            this.revisionPetitionService.updateRevisionPetition(this.objection);
        }
        ReportOutput reportOutput = new ReportOutput();
        if (this.objection != null && this.objection.getObjectionNumber() != null && (ptNotice = this.noticeService.getPtNoticeByNoticeNumberAndNoticeType(this.objection.getObjectionNumber().concat("SPECIALNOTICE"), "Special Notice")) != null) {
            byte[] bFile;
            FileStoreMapper fsm = ptNotice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating Hearing Notcie : " + e);
            }
            reportOutput.setReportOutputData(bFile);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            if (!"Sign".equals(this.actionType)) {
                this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
            }
        }
        return "Sign".equals(this.actionType) ? DIGITAL_SIGNATURE_REDIRECTION : NOTICE;
    }

    public void sendEmailandSms(RevisionPetition objection, String applicationType) {
        for (PropertyOwnerInfo ownerInfo : objection.getBasicProperty().getPropertyOwnerInfo()) {
            this.sendEmailAndSms(objection, ownerInfo.getOwner(), applicationType);
        }
    }

    private void sendEmailAndSms(RevisionPetition objection, User user, String applicationType) {
        if (objection != null) {
            String mobileNumber = user.getMobileNumber();
            String emailid = user.getEmailId();
            String applicantName = user.getName();
            ArrayList<String> args = new ArrayList<String>();
            args.add(applicantName);
            String smsMsg = "";
            String emailSubject = "";
            String emailBody = "";
            if (applicationType.equalsIgnoreCase(REVISION_PETITION_CREATED)) {
                args.add(objection.getObjectionNumber());
                args.add(this.sMSEmailService.getCityName());
                if (mobileNumber != null) {
                    smsMsg = this.getText("msg.revPetitioncreate.sms", args);
                }
                if (emailid != null) {
                    emailSubject = this.getText("msg.revPetitioncreate.email.subject");
                    emailBody = this.getText("msg.revPetitioncreate.email", args);
                }
            } else if (applicationType.equalsIgnoreCase(REVISION_PETITION_HEARINGNOTICEGENERATED)) {
                if (objection.getHearings() != null && objection.getHearings().size() > 0) {
                    args.add(DateUtils.getFormattedDate((Date)((Hearing)objection.getHearings().get(0)).getPlannedHearingDt(), (String)"dd/MM/yyyy"));
                    args.add(((Hearing)objection.getHearings().get(0)).getHearingVenue());
                    args.add(((Hearing)objection.getHearings().get(0)).getHearingTime());
                    args.add(this.sMSEmailService.getCityName());
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.revPetitionHearingNotice.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.revPetitionHearingNotice.email.subject");
                        emailBody = this.getText("msg.revPetitionHearingNotice.email", args);
                    }
                }
            } else if (applicationType.equalsIgnoreCase(REVISION_PETITION_ENDORESEMENTGENERATED)) {
                args.add(this.sMSEmailService.getCityName());
                if (mobileNumber != null) {
                    smsMsg = this.getText("msg.revPetitionEndoresement.sms", args);
                }
                if (emailid != null) {
                    emailSubject = this.getText("msg.revPetitionHearingNotice.email.subject");
                    emailBody = this.getText("msg.revPetitionEndoresement.email", args);
                }
            }
            if (StringUtils.isNotBlank((String)mobileNumber)) {
                this.messagingService.sendSMS(mobileNumber, smsMsg);
            }
            if (StringUtils.isNotBlank((String)emailid)) {
                this.messagingService.sendEmail(emailid, emailSubject, emailBody);
            }
        }
    }

    private void setFloorDetails(Property property) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into setFloorDetails, Property: " + property));
        }
        List floors = property.getPropertyDetail().getFloorDetails();
        this.objection.getBasicProperty().getProperty().getPropertyDetail().setFloorDetails(floors);
        if (null != this.objection.getProperty()) {
            this.objection.getProperty().getPropertyDetail().setFloorDetailsProxy(floors);
        }
        int i = 0;
        for (Floor flr : floors) {
            this.floorNoStr[i] = (String)PropertyTaxConstants.FLOOR_MAP.get(flr.getFloorNo());
            ++i;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exiting from setFloorDetails: ");
        }
    }

    @Action(value="/revPetition-view")
    public String view() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | view | Start");
        }
        this.objection = (RevisionPetition)this.revisionPetitionService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("objectionId"))[0]), false);
        this.getPropertyView(this.objection.getBasicProperty().getUpicNo());
        if (this.objection != null && this.objection.getBasicProperty() != null && this.objection.getBasicProperty().getPropertyID() != null) {
            PropertyID propertyID = this.objection.getBasicProperty().getPropertyID();
            this.northBoundary = propertyID.getNorthBoundary();
            this.southBoundary = propertyID.getSouthBoundary();
            this.eastBoundary = propertyID.getEastBoundary();
            this.westBoundary = propertyID.getWestBoundary();
        }
        this.populatePropertyTypeCategory();
        if (this.objection != null && this.objection.getProperty() != null) {
            this.setReasonForModify(this.objection.getProperty().getPropertyDetail().getPropertyMutationMaster().getCode());
            if (this.objection.getProperty().getPropertyDetail().getSitalArea() != null) {
                this.setAreaOfPlot(this.objection.getProperty().getPropertyDetail().getSitalArea().getArea().toString());
            }
            if (this.objection.getProperty().getPropertyDetail().getFloorDetails().size() > 0) {
                this.setFloorDetails((Property)this.objection.getProperty());
            }
            if (this.objection.getProperty().getPropertyDetail().getPropertyTypeMaster() != null) {
                this.propTypeObjId = this.objection.getProperty().getPropertyDetail().getPropertyTypeMaster().getId().toString();
            }
        }
        this.setOwnerName(this.objection.getBasicProperty().getProperty());
        this.setPropertyAddress((Address)this.objection.getBasicProperty().getAddress());
        this.propStatVal = this.propertyStatusValuesDAO.getLatestPropertyStatusValuesByPropertyIdAndreferenceNo(this.objection.getBasicProperty().getUpicNo(), this.objection.getObjectionNumber());
        if (this.objection != null && this.objection.getState() != null) {
            if (!this.objection.getState().getHistory().isEmpty()) {
                this.setUpWorkFlowHistory(this.objection.getState().getId());
            }
            this.historyMap = this.propService.populateHistory((StateAware)this.objection);
        }
        this.setOwnerName(this.objection.getBasicProperty().getProperty());
        this.setPropertyAddress((Address)this.objection.getBasicProperty().getAddress());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | view | End");
        }
        return "view";
    }

    public String viewObjectionDetails() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | viewObjectionDetails | Start");
        }
        this.objection = (RevisionPetition)this.revisionPetitionService.find("from Objection where objectionNumber like ?", new Object[]{this.objection.getObjectionNumber()});
        this.setOwnerName(this.objection.getBasicProperty().getProperty());
        this.setPropertyAddress((Address)this.objection.getBasicProperty().getAddress());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | viewObjectionDetails | End");
        }
        return "viewDetails";
    }

    @Action(value="/revPetition-reject")
    public String rejectRevisionPetition() {
        this.updateStateAndStatus(this.objection);
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        return STRUTS_RESULT_MESSAGE;
    }

    public String updateRecordObjection() {
        this.revisionPetitionService.updateRevisionPetition(this.objection);
        this.updateStateAndStatus(this.objection);
        return STRUTS_RESULT_MESSAGE;
    }

    private void updateStateAndStatus(RevisionPetition revPetition) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | updateStateAndStatus | Start");
        }
        Position position = null;
        User user = null;
        User loggedInUser = null;
        WorkFlowMatrix wfmatrix = null;
        loggedInUser = user = this.securityUtils.getCurrentUser();
        Assignment wfInitiator = this.objection.getId() != null ? this.revisionPetitionService.getWorkflowInitiator(this.objection) : this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        wfmatrix = null == this.objection.getState() ? (this.loggedUserIsEmployee.booleanValue() ? this.revisionPetitionWorkFlowService.getWfMatrix(this.objection.getStateType(), null, null, this.getAdditionalRule(), "Revision Petition:Registered", null) : this.revisionPetitionWorkFlowService.getWfMatrix(this.objection.getStateType(), null, null, this.getAdditionalRule(), "Revision Petition:CREATED", null)) : this.revisionPetitionWorkFlowService.getWfMatrix(this.objection.getStateType(), null, null, this.getAdditionalRule(), this.objection.getCurrentState().getValue(), null);
        if (this.approverPositionId != null && this.approverPositionId != -1L) {
            position = this.positionMasterService.getPositionById(this.approverPositionId);
        }
        if (revPetition.getState() == null) {
            Assignment assignment;
            if (position == null && (this.approverPositionId == null || this.approverPositionId != -1L) && (assignment = this.propService.getUserPositionByZone(this.objection.getBasicProperty(), false)) != null) {
                position = assignment.getPosition();
            }
            this.updateRevisionPetitionStatus(wfmatrix, this.objection, REVISION_PETITION_CREATED);
            if (position != null) {
                user = this.eisCommonService.getUserForPosition(position.getId(), new Date());
            }
            this.objection.start().withNextAction(wfmatrix.getPendingActions()).withStateValue(wfmatrix.getCurrentState()).withDateInfo(new DateTime().toDate()).withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withOwner(user).withComments(this.approverComments).withNextAction("Revision Petition").withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
            if (this.loggedUserIsEmployee.booleanValue() && user != null) {
                this.addActionMessage(this.getText("objection.forward", new String[]{user.getName().concat("~").concat(position.getName())}));
            }
            this.propService.updateIndexes((StateAware)this.objection, "Revision_Petition");
        } else if (this.workFlowAction != null && !"".equals(this.workFlowAction) && !"Save".equalsIgnoreCase(this.workFlowAction)) {
            if ("Reject".equalsIgnoreCase(this.workFlowAction) || this.workFlowAction.equalsIgnoreCase("cancel unconsidered")) {
                wfmatrix = this.revisionPetitionWorkFlowService.getPreviousStateFromWfMatrix(this.objection.getStateType(), null, null, this.getAdditionalRule(), this.objection.getCurrentState().getValue(), this.objection.getCurrentState().getNextAction());
                if (this.approverPositionId == null || this.approverPositionId != -1L) {
                    position = this.objection.getCurrentState().getOwnerPosition();
                }
            }
            if ("Sign".equalsIgnoreCase(this.workFlowAction)) {
                position = this.propService.isEmployee(this.objection.getCreatedBy()).booleanValue() ? this.assignmentService.getPrimaryAssignmentForUser(this.objection.getCreatedBy().getId()).getPosition() : (!this.objection.getStateHistory().isEmpty() ? this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)this.objection.getStateHistory().get(0)).getOwnerPosition().getId()).getPosition() : this.objection.getState().getOwnerPosition());
            } else if (position == null) {
                position = this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId());
            }
            if (wfmatrix != null) {
                this.workFlowTransition(this.objection, this.workFlowAction, this.approverComments, wfmatrix, position, loggedInUser);
            }
            this.propService.updateIndexes((StateAware)this.objection, "Revision_Petition");
        } else if (this.workFlowAction != null && !"".equals(this.workFlowAction) && "Save".equalsIgnoreCase(this.workFlowAction)) {
            this.addActionMessage(this.getText("file.save"));
        }
    }

    public void workFlowTransition(RevisionPetition objection, String workFlowAction, String comments, WorkFlowMatrix wfmatrix, Position position, User loggedInUser) {
        boolean positionFoundInHistory = false;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"revisionpetitionaction ||Starting workFlowTransition method for objection");
        }
        Assignment wfInitiator = this.revisionPetitionService.getWorkflowInitiator(objection);
        if (workFlowAction.equalsIgnoreCase("forward") || workFlowAction.equalsIgnoreCase("approve objection") || workFlowAction.equalsIgnoreCase("forward to approver")) {
            if (wfmatrix != null && (wfmatrix.getNextStatus() != null && wfmatrix.getNextStatus().equalsIgnoreCase("HEARING DATE FIXED") || wfmatrix.getCurrentState().equalsIgnoreCase("Revision Petition:Inspection verified") || wfmatrix.getCurrentState().equalsIgnoreCase("Revision Petition:Registered"))) {
                for (StateHistory stateHistoryObj : objection.getState().getHistory()) {
                    if (stateHistoryObj.getValue().equalsIgnoreCase("Revision Petition:CREATED")) {
                        position = stateHistoryObj.getOwnerPosition();
                        User sender = this.eisCommonService.getUserForPosition(position.getId(), new Date());
                        if (sender != null) {
                            this.addActionMessage(this.getText("objection.forward", new String[]{sender.getName().concat("~").concat(position.getName())}));
                        }
                        positionFoundInHistory = true;
                        break;
                    }
                    if (!stateHistoryObj.getValue().equalsIgnoreCase("Revision Petition:Registered")) continue;
                    position = wfInitiator.getPosition();
                    this.addActionMessage(this.getText("objection.forward", new String[]{wfInitiator.getEmployee().getName().concat("~").concat(wfInitiator.getPosition().getName())}));
                    if (objection.getEgwStatus() != null && objection.getEgwStatus().getCode().equalsIgnoreCase(REVISION_PETITION_CREATED)) {
                        this.updateRevisionPetitionStatus(wfmatrix, objection, "HEARING DATE FIXED");
                    }
                    positionFoundInHistory = true;
                    break;
                }
                if (!positionFoundInHistory && objection.getState() != null && (objection.getState().getValue().equalsIgnoreCase("Revision Petition:CREATED") || objection.getState().getValue().equalsIgnoreCase("Revision Petition:Registered"))) {
                    positionFoundInHistory = true;
                    this.updateRevisionPetitionStatus(wfmatrix, objection, "HEARING DATE FIXED");
                    position = wfInitiator.getPosition();
                    this.addActionMessage(this.getText("objection.forward", new String[]{wfInitiator.getEmployee().getName().concat("~").concat(wfInitiator.getPosition().getName())}));
                }
            }
            objection.transition(true).withStateValue(wfmatrix.getNextState()).withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withDateInfo(new DateTime().toDate()).withNextAction(wfmatrix.getNextAction()).withComments(this.approverComments);
            if (wfmatrix.getNextAction() != null && wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                objection.end().withStateValue(wfmatrix.getNextState()).withOwner(objection.getCurrentState().getOwnerPosition()).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withNextAction(wfmatrix.getNextAction()).withDateInfo(new DateTime().toDate()).withComments(this.approverComments);
            }
            if (wfmatrix.getNextStatus() != null) {
                this.updateRevisionPetitionStatus(wfmatrix, objection, null);
            }
            if (this.approverName != null && !this.approverName.isEmpty() && !this.approverName.equalsIgnoreCase("----Choose----")) {
                this.addActionMessage(this.getText("objection.forward", new String[]{this.approverName.concat("~").concat(position.getName())}));
            } else if (loggedInUser != null && !positionFoundInHistory) {
                this.addActionMessage(this.getText("objection.forward", new String[]{loggedInUser.getName().concat("~").concat(position.getName())}));
            }
        } else if (workFlowAction.equalsIgnoreCase("Reject Inspection")) {
            List stateHistoryList = objection.getStateHistory();
            for (StateHistory stateHistoryObj : stateHistoryList) {
                if (!stateHistoryObj.getValue().equalsIgnoreCase("Revision Petition:Hearing completed")) continue;
                position = stateHistoryObj.getOwnerPosition();
                break;
            }
            wfmatrix = this.revisionPetitionWorkFlowService.getWfMatrix(objection.getStateType(), null, null, this.getAdditionalRule(), "Rejected", null);
            objection.setEgwStatus(this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", "HEARING COMPLETED"));
            if (position != null) {
                objection.transition(true).withNextAction(wfmatrix.getNextAction()).withStateValue("Rejected").withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withDateInfo(new DateTime().toDate()).withComments(this.approverComments);
                String actionMessage = this.propertyTaxUtil.getApproverUserName(position.getId());
                if (actionMessage != null) {
                    this.addActionMessage(this.getText("objection.forward", new String[]{actionMessage}));
                }
            }
        } else if (workFlowAction.equalsIgnoreCase("Reject") || workFlowAction.equalsIgnoreCase("reject")) {
            List stateHistoryList = objection.getStateHistory();
            for (StateHistory stateHistoryObj : stateHistoryList) {
                if (!stateHistoryObj.getValue().equalsIgnoreCase(objection.getCurrentState().getValue())) continue;
                position = stateHistoryObj.getOwnerPosition();
                break;
            }
            if (objection.getCurrentState() != null && (objection.getCurrentState().getValue().equalsIgnoreCase("Rejected") || objection.getCurrentState().getValue().equalsIgnoreCase("Revision Petition:CREATED"))) {
                objection.end().withStateValue(wfmatrix.getNextState()).withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withNextAction(wfmatrix.getNextAction()).withDateInfo(new DateTime().toDate()).withComments(this.approverComments);
                this.updateRevisionPetitionStatus(wfmatrix, objection, "Rejected");
            } else {
                objection.transition(true).withStateValue(wfmatrix.getCurrentState()).withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withDateInfo(new DateTime().toDate()).withNextAction(wfmatrix.getPendingActions()).withComments(this.approverComments);
                if (workFlowAction.equalsIgnoreCase("Reject")) {
                    this.updateRevisionPetitionStatus(wfmatrix, objection, null);
                }
            }
            if (this.approverName != null && !this.approverName.isEmpty() && !this.approverName.equalsIgnoreCase("----Choose----")) {
                this.addActionMessage(this.getText("objection.forward", new String[]{this.approverName.concat("~").concat(position.getName())}));
            } else if (loggedInUser != null) {
                this.addActionMessage(this.getText("objection.forward", new String[]{loggedInUser.getName().concat("~").concat(position.getName())}));
            }
        } else if (workFlowAction.equalsIgnoreCase("Print Endoresement")) {
            objection.transition(true).withStateValue(wfmatrix.getNextState()).withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withDateInfo(new DateTime().toDate()).withNextAction(wfmatrix.getNextAction()).withComments(this.approverComments);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)"revisionpetitionaction ||ended  workflow for objection");
            }
        } else if ("Sign".equalsIgnoreCase(workFlowAction) || workFlowAction.equalsIgnoreCase("approve")) {
            objection.transition(true).withStateValue(wfmatrix.getNextState()).withOwner(position).withSenderName(loggedInUser.getUsername() + "::" + loggedInUser.getName()).withDateInfo(new DateTime().toDate()).withNextAction(wfmatrix.getNextAction()).withComments(this.approverComments);
        }
        this.revisionPetitionService.applyAuditing((AbstractAuditable)objection.getState());
    }

    private void updateRevisionPetitionStatus(WorkFlowMatrix wfmatrix, RevisionPetition objection, String status) {
        EgwStatus egwStatus = null;
        if (status != null && !"".equals(status)) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", status);
        } else if (wfmatrix != null && wfmatrix.getNextStatus() != null && objection != null) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", wfmatrix.getNextStatus());
        }
        if (egwStatus != null) {
            objection.setEgwStatus(egwStatus);
        }
    }

    private void modifyBasicProp() throws TaxCalculatorExeption {
        PropertyTypeMaster propTypeMstr;
        Date propCompletionDate = null;
        Long oldPropTypeId = this.objection.getProperty().getPropertyDetail().getPropertyTypeMaster().getId();
        if (this.propTypeObjId != null && !this.propTypeObjId.trim().isEmpty() && !this.propTypeObjId.equals("-1")) {
            propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(this.propTypeObjId)});
            propCompletionDate = !propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.objection.getProperty().getPropertyDetail().getFloorDetailsProxy()) : this.objection.getProperty().getPropertyDetail().getDateOfCompletion();
        }
        if (propCompletionDate != null) {
            this.objection.getBasicProperty().setPropOccupationDate(propCompletionDate);
            this.objection.getProperty().setEffectiveDate(propCompletionDate);
        }
        this.propService.createProperty(this.objection.getProperty(), this.getAreaOfPlot() != null ? this.getAreaOfPlot() : "", this.reasonForModify, this.propTypeObjId != null ? this.propTypeObjId : null, this.objection.getProperty().getPropertyDetail().getPropertyUsage() != null ? this.objection.getProperty().getPropertyDetail().getPropertyUsage().getId().toString() : null, this.objection.getProperty().getPropertyDetail().getPropertyOccupation() != null ? this.objection.getProperty().getPropertyDetail().getPropertyOccupation().getId().toString() : null, PropertyTaxConstants.STATUS_WORKFLOW, this.objection.getProperty().getDocNumber(), "", this.objection.getProperty().getPropertyDetail().getFloorType() != null ? this.objection.getProperty().getPropertyDetail().getFloorType().getId() : null, this.objection.getProperty().getPropertyDetail().getRoofType() != null ? this.objection.getProperty().getPropertyDetail().getRoofType().getId() : null, this.objection.getProperty().getPropertyDetail().getWallType() != null ? this.objection.getProperty().getPropertyDetail().getWallType().getId() : null, this.objection.getProperty().getPropertyDetail().getWoodType() != null ? this.objection.getProperty().getPropertyDetail().getWoodType().getId() : null, this.taxExemptedReason);
        this.updatePropertyID(this.objection.getBasicProperty());
        propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.code = ?", new Object[]{"VAC_LAND"});
        if (oldPropTypeId == propTypeMstr.getId() && Long.parseLong(this.propTypeObjId) != propTypeMstr.getId() || oldPropTypeId != propTypeMstr.getId() && Long.parseLong(this.propTypeObjId) == propTypeMstr.getId()) {
            if (propTypeMstr != null && StringUtils.equals((String)propTypeMstr.getId().toString(), (String)this.propTypeObjId)) {
                this.propService.changePropertyDetail(this.objection.getProperty(), (PropertyDetail)new VacantProperty(), Integer.valueOf(0));
            } else {
                this.propService.changePropertyDetail(this.objection.getProperty(), (PropertyDetail)new BuiltUpProperty(), Integer.valueOf(this.objection.getProperty().getPropertyDetail().getFloorDetails().size()));
            }
        }
        this.propService.modifyDemand(this.objection.getProperty(), (PropertyImpl)this.objection.getBasicProperty().getProperty());
    }

    private void getPropertyView(String propertyId) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | getPropertyView | Start");
        }
        this.viewPropertyAction.setPersistenceService(this.persistenceService);
        this.viewPropertyAction.setBasicPropertyDAO(this.basicPropertyDAO);
        this.viewPropertyAction.setPtDemandDAO(this.ptDemandDAO);
        this.viewPropertyAction.setPropertyId(propertyId);
        this.viewPropertyAction.setPropertyTaxUtil(this.propertyTaxUtil);
        this.viewPropertyAction.setPropertyTaxCommonUtils(this.propertyTaxCommonUtils);
        this.viewPropertyAction.setUserService(this.userService);
        this.viewPropertyAction.setSession(this.getSession());
        this.viewPropertyAction.viewForm();
        this.objection.setBasicProperty(this.viewPropertyAction.getBasicProperty());
        this.viewMap = this.viewPropertyAction.getViewMap();
        if (this.objection.getEgwStatus() != null && (this.objection.getEgwStatus().getCode().equalsIgnoreCase("INSPECTION COMPLETED") || this.objection.getEgwStatus().getCode().equalsIgnoreCase("INSPECTION VERIFY"))) {
            this.wfPropTaxDetailsMap = this.propertyTaxCommonUtils.getTaxDetailsForWorkflowProperty(this.viewPropertyAction.getBasicProperty());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"ObjectionAction | getPropertyView | End");
        }
    }

    public void vaidatePropertyDetails() {
        if (this.reasonForModify == null || this.reasonForModify.equals("-1")) {
            this.addActionError(this.getText("mandatory.rsnForMdfy"));
        }
        this.validateProperty((Property)this.objection.getProperty(), this.getAreaOfPlot() != null ? this.getAreaOfPlot() : "", this.objection.getProperty().getPropertyDetail().getDateOfCompletion() != null ? this.dateformat.format(this.objection.getProperty().getPropertyDetail().getDateOfCompletion()).toString() : "", this.eastBoundary, this.westBoundary, this.southBoundary, this.northBoundary, this.propTypeObjId != null ? this.propTypeObjId : null, this.ownerName, this.ownerName, this.objection.getProperty().getPropertyDetail().getFloorType() != null ? this.objection.getProperty().getPropertyDetail().getFloorType().getId() : null, this.objection.getProperty().getPropertyDetail().getRoofType() != null ? this.objection.getProperty().getPropertyDetail().getRoofType().getId() : null, this.objection.getProperty().getPropertyDetail().getWallType() != null ? this.objection.getProperty().getPropertyDetail().getWallType().getId() : null, this.objection.getProperty().getPropertyDetail().getWoodType() != null ? this.objection.getProperty().getPropertyDetail().getWoodType().getId() : null, null, null);
    }

    private void populatePropertyTypeCategory() {
        PropertyTypeMaster propTypeMstr = null;
        if (this.propTypeObjId != null && !this.propTypeObjId.trim().isEmpty() && !this.propTypeObjId.equals("-1")) {
            propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(this.propTypeObjId)});
        } else if (this.objection != null && this.objection.getProperty() != null && this.objection.getProperty().getPropertyDetail() != null && this.objection.getProperty().getPropertyDetail().getPropertyTypeMaster() != null && !this.objection.getProperty().getPropertyDetail().getPropertyTypeMaster().getId().equals(-1)) {
            propTypeMstr = this.objection.getProperty().getPropertyDetail().getPropertyTypeMaster();
        } else if (this.objection.getBasicProperty() != null) {
            propTypeMstr = this.objection.getBasicProperty().getProperty().getPropertyDetail().getPropertyTypeMaster();
        }
        if (propTypeMstr != null) {
            if (propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
        } else {
            this.setPropTypeCategoryMap(Collections.emptyMap());
        }
    }

    public List<Floor> getFloorDetails() {
        return new ArrayList<Floor>(this.objection.getBasicProperty().getProperty().getPropertyDetail().getFloorDetails());
    }

    public Map<String, String> getPropTypeCategoryMap() {
        return this.propTypeCategoryMap;
    }

    public void setPropTypeCategoryMap(Map<String, String> propTypeCategoryMap) {
        this.propTypeCategoryMap = propTypeCategoryMap;
    }

    public RevisionPetition getObjection() {
        return this.objection;
    }

    public void setObjection(RevisionPetition objection) {
        this.objection = objection;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public Map<String, Object> getViewMap() {
        return this.viewMap;
    }

    public RevisionPetitionService getRevisionPetitionService() {
        return this.revisionPetitionService;
    }

    private void updatePropertyID(BasicProperty basicProperty) {
        PropertyID propertyId = basicProperty.getPropertyID();
        if (propertyId != null) {
            propertyId.setEastBoundary(this.getEastBoundary());
            propertyId.setWestBoundary(this.getWestBoundary());
            propertyId.setNorthBoundary(this.getNorthBoundary());
            propertyId.setSouthBoundary(this.getSouthBoundary());
        }
    }

    public void setRevisionPetitionService(RevisionPetitionService revisionPetitionService) {
        this.revisionPetitionService = revisionPetitionService;
    }

    public PersistenceService<Property, Long> getPropertyImplService() {
        return this.propertyImplService;
    }

    public void setPropertyImplService(PersistenceService<Property, Long> propertyImplService) {
        this.propertyImplService = propertyImplService;
    }

    public void setViewPropertyAction(ViewPropertyAction viewPropertyAction) {
        this.viewPropertyAction = viewPropertyAction;
    }

    public void setObjectionWorkflowService(WorkflowService<RevisionPetition> objectionWorkflowService) {
        this.objectionWorkflowService = objectionWorkflowService;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(Property property) {
        if (property != null) {
            this.ownerName = property.getBasicProperty().getFullOwnerName();
        }
    }

    public String getPropertyAddress() {
        return this.propertyAddress;
    }

    public void setPropertyAddress(Address address) {
        if (address != null) {
            this.propertyAddress = address.toString();
        }
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public boolean getIsShowAckMessage() {
        return this.isShowAckMessage;
    }

    public void setIsShowAckMessage(boolean isShowAckMessage) {
        this.isShowAckMessage = isShowAckMessage;
    }

    public void setBasicPropertyDAO(BasicPropertyDAO basicPropertyDAO) {
        this.basicPropertyDAO = basicPropertyDAO;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public PropertyStatusValues getPropStatVal() {
        return this.propStatVal;
    }

    public void setPropStatVal(PropertyStatusValues propStatVal) {
        this.propStatVal = propStatVal;
    }

    public String getReasonForModify() {
        return this.reasonForModify;
    }

    public void setReasonForModify(String reasonForModify) {
        this.reasonForModify = reasonForModify;
    }

    public TreeMap<Integer, String> getFloorNoMap() {
        return this.floorNoMap;
    }

    public void setFloorNoMap(TreeMap<Integer, String> floorNoMap) {
        this.floorNoMap = floorNoMap;
    }

    public String getPropTypeObjId() {
        return this.propTypeObjId;
    }

    public void setPropTypeObjId(String propTypeObjId) {
        this.propTypeObjId = propTypeObjId;
    }

    public String getReportId() {
        return this.reportId;
    }

    public Map<String, String> getDeviationPercentageMap() {
        return this.deviationPercentageMap;
    }

    public void setDeviationPercentageMap(Map<String, String> deviationPercentageMap) {
        this.deviationPercentageMap = deviationPercentageMap;
    }

    public String[] getFloorNoStr() {
        return this.floorNoStr;
    }

    public void setFloorNoStr(String[] floorNoStr) {
        this.floorNoStr = floorNoStr;
    }

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public LinkedHashMap<String, String> getHearingTimingMap() {
        return this.hearingTimingMap;
    }

    public void setHearingTimingMap(LinkedHashMap<String, String> hearingTimingMap) {
        this.hearingTimingMap = hearingTimingMap;
    }

    public String getNorthBoundary() {
        return this.northBoundary;
    }

    public void setNorthBoundary(String northBoundary) {
        this.northBoundary = northBoundary;
    }

    public String getSouthBoundary() {
        return this.southBoundary;
    }

    public void setSouthBoundary(String southBoundary) {
        this.southBoundary = southBoundary;
    }

    public String getEastBoundary() {
        return this.eastBoundary;
    }

    public void setEastBoundary(String eastBoundary) {
        this.eastBoundary = eastBoundary;
    }

    public String getWestBoundary() {
        return this.westBoundary;
    }

    public void setWestBoundary(String westBoundary) {
        this.westBoundary = westBoundary;
    }

    public SimpleWorkflowService<RevisionPetition> getRevisionPetitionWorkFlowService() {
        return this.revisionPetitionWorkFlowService;
    }

    public void setRevisionPetitionWorkFlowService(SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService) {
        this.revisionPetitionWorkFlowService = revisionPetitionWorkFlowService;
    }

    public PropertyTaxNumberGenerator getPropertyTaxNumberGenerator() {
        return this.propertyTaxNumberGenerator;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public SMSEmailService getsMSEmailService() {
        return this.sMSEmailService;
    }

    public void setsMSEmailService(SMSEmailService sMSEmailService) {
        this.sMSEmailService = sMSEmailService;
    }

    public Long getTaxExemptedReason() {
        return this.taxExemptedReason;
    }

    public void setTaxExemptedReason(Long taxExemptedReason) {
        this.taxExemptedReason = taxExemptedReason;
    }

    public Boolean getLoggedUserIsEmployee() {
        return this.loggedUserIsEmployee;
    }

    public void setLoggedUserIsEmployee(Boolean loggedUserIsEmployee) {
        this.loggedUserIsEmployee = loggedUserIsEmployee;
    }

    public String getAreaOfPlot() {
        return this.areaOfPlot;
    }

    public void setAreaOfPlot(String areaOfPlot) {
        this.areaOfPlot = areaOfPlot;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getFileStoreIds() {
        return this.fileStoreIds;
    }

    public void setFileStoreIds(String fileStoreIds) {
        this.fileStoreIds = fileStoreIds;
    }

    public String getUlbCode() {
        return this.ulbCode;
    }

    public void setUlbCode(String ulbCode) {
        this.ulbCode = ulbCode;
    }

    public List<Hashtable<String, Object>> getHistoryMap() {
        return this.historyMap;
    }

    public void setHistoryMap(List<Hashtable<String, Object>> historyMap) {
        this.historyMap = historyMap;
    }

    public Map<String, Object> getWfPropTaxDetailsMap() {
        return this.wfPropTaxDetailsMap;
    }

    public boolean isDigitalSignEnabled() {
        return this.digitalSignEnabled;
    }

    public void setDigitalSignEnabled(boolean digitalSignEnabled) {
        this.digitalSignEnabled = digitalSignEnabled;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }
}

