/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.exemption;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.TaxExeptionReason;
import org.egov.ptis.domain.service.exemption.TaxExemptionService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/exemption"})
public class TaxExemptionController
extends GenericWorkFlowController {
    protected static final String TAX_EXEMPTION_FORM = "taxExemption-form";
    protected static final String TAX_EXEMPTION_SUCCESS = "taxExemption-success";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private TaxExemptionService taxExemptionService;
    private Boolean loggedUserIsMeesevaUser = Boolean.FALSE;
    private Boolean isExempted = Boolean.FALSE;
    private Boolean isAlert = Boolean.FALSE;
    private PropertyImpl property;
    @Autowired
    private SecurityUtils securityUtils;
    BasicProperty basicProperty;
    PropertyImpl propertyImpl = new PropertyImpl();
    PropertyImpl oldProperty;

    @ModelAttribute
    public Property propertyModel(@PathVariable String assessmentNo) {
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (null != this.basicProperty) {
            this.oldProperty = this.basicProperty.getActiveProperty();
            this.propertyImpl = (PropertyImpl)this.basicProperty.getActiveProperty().createPropertyclone();
        }
        return this.propertyImpl;
    }

    @ModelAttribute(value="taxExemptionReasons")
    public List<TaxExeptionReason> getTaxExemptionReasons() {
        return this.taxExemptionService.getSession().createQuery("from TaxExeptionReason order by name").list();
    }

    @RequestMapping(value={"/form/{assessmentNo}"}, method={RequestMethod.GET})
    public String exemptionForm(HttpServletRequest request, Model model, @RequestParam(required=false) String meesevaApplicationNumber, @PathVariable(value="assessmentNo") String assessmentNo) {
        this.isExempted = this.oldProperty.getIsExemptedFromTax();
        this.isAlert = true;
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (this.basicProperty != null) {
            this.property = (PropertyImpl)this.basicProperty.getProperty();
            Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)this.property);
            if (ptDemand == null || ptDemand != null && ptDemand.getEgDemandDetails() == null) {
                model.addAttribute("errorMsg", (Object)"There is no tax for this property");
                return "propertyValidation";
            }
            if (this.basicProperty.isUnderWorkflow()) {
                model.addAttribute("wfPendingMsg", (Object)"Could not do Tax exemption now, property is undergoing some work flow.");
                return "workFlowError";
            }
            if (!this.isExempted.booleanValue()) {
                Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicProperty.getActiveProperty());
                BigDecimal currentPropertyTax = BigDecimal.ZERO;
                BigDecimal currentPropertyTaxDue = BigDecimal.ZERO;
                BigDecimal arrearPropertyTaxDue = BigDecimal.ZERO;
                Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
                if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                    currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
                    currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
                } else {
                    currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
                    currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
                }
                arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
                BigDecimal currentWaterTaxDue = this.propertyService.getWaterTaxDues(this.basicProperty.getUpicNo(), request);
                model.addAttribute("currentPropertyTax", (Object)currentPropertyTax);
                model.addAttribute("currentPropertyTaxDue", (Object)currentPropertyTaxDue);
                model.addAttribute("arrearPropertyTaxDue", (Object)arrearPropertyTaxDue);
                model.addAttribute("currentWaterTaxDue", (Object)currentWaterTaxDue);
                if (currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L) {
                    model.addAttribute("taxDuesErrorMsg", (Object)"Above tax dues must be payed before initiating Tax_Exemption");
                    return "taxdues";
                }
                boolean hasChildPropertyUnderWorkflow = this.propertyTaxUtil.checkForParentUsedInBifurcation(this.basicProperty.getUpicNo());
                if (hasChildPropertyUnderWorkflow) {
                    model.addAttribute("errorMsg", (Object)"Cannot proceed as this property is used in Bifurcation, which is under workflow");
                    return "propertyValidation";
                }
            }
        }
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            if (meesevaApplicationNumber == null) {
                throw new ApplicationRuntimeException("MEESEVA.005");
            }
            this.propertyImpl.setMeesevaApplicationNumber(meesevaApplicationNumber);
        }
        model.addAttribute("stateType", (Object)this.propertyImpl.getClass().getSimpleName());
        model.addAttribute("isExempted", (Object)this.isExempted);
        model.addAttribute("isAlert", (Object)this.isAlert);
        this.taxExemptionService.addModelAttributes(model, this.basicProperty);
        this.prepareWorkflow(model, (StateAware)this.propertyImpl, new WorkflowContainer());
        return TAX_EXEMPTION_FORM;
    }

    @Transactional
    @RequestMapping(value={"/form/{assessmentNo}"}, method={RequestMethod.POST})
    public String exemptionFormSubmit(@ModelAttribute Property property, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request, @RequestParam String workFlowAction) {
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        Long approvalPosition = 0L;
        String approvalComent = "";
        String taxExemptedReason = "";
        Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
        String target = "";
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.securityUtils.getCurrentUser());
        if ((!propertyByEmployee.booleanValue() || this.loggedUserIsMeesevaUser.booleanValue()) && null == this.propertyService.getUserPositionByZone(property.getBasicProperty(), false)) {
            model.addAttribute("errorMsg", (Object)"No Senior or Junior assistants exists,Please check");
            model.addAttribute("stateType", (Object)this.propertyImpl.getClass().getSimpleName());
            this.taxExemptionService.addModelAttributes(model, this.basicProperty);
            this.prepareWorkflow(model, (StateAware)this.propertyImpl, new WorkflowContainer());
            target = TAX_EXEMPTION_FORM;
        } else {
            if (request.getParameter("taxExemptedReason") != null) {
                taxExemptedReason = request.getParameter("taxExemptedReason");
            }
            if (request.getParameter("approvalComent") != null) {
                approvalComent = request.getParameter("approvalComent");
            }
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
            }
            if (this.loggedUserIsMeesevaUser.booleanValue()) {
                HashMap<String, String> meesevaParams = new HashMap<String, String>();
                meesevaParams.put("APPLICATIONNUMBER", ((PropertyImpl)property).getMeesevaApplicationNumber());
                if (StringUtils.isBlank((CharSequence)property.getApplicationNo())) {
                    property.setApplicationNo(((PropertyImpl)property).getMeesevaApplicationNumber());
                    property.setSource(PropertyTaxConstants.SOURCEOFDATA_MEESEWA);
                }
                this.taxExemptionService.saveProperty(property, (Property)this.oldProperty, status, approvalComent, workFlowAction, approvalPosition, taxExemptedReason, propertyByEmployee, "EXEMPTION", meesevaParams);
            } else {
                this.taxExemptionService.saveProperty(property, (Property)this.oldProperty, status, approvalComent, workFlowAction, approvalPosition, taxExemptedReason, propertyByEmployee, "EXEMPTION");
            }
            model.addAttribute("successMessage", (Object)("Property exemption data saved successfully in the system and forwarded to " + this.propertyTaxUtil.getApproverUserName(((PropertyImpl)property).getState().getOwnerPosition().getId()) + " with application number " + property.getApplicationNo()));
            target = this.loggedUserIsMeesevaUser != false ? "redirect:/exemption/generate-meesevareceipt/" + ((PropertyImpl)property).getBasicProperty().getUpicNo() + "?transactionServiceNumber=" + ((PropertyImpl)property).getApplicationNo() : TAX_EXEMPTION_SUCCESS;
        }
        return target;
    }

    @RequestMapping(value={"/generate-meesevareceipt/{assessmentNo}"}, method={RequestMethod.GET})
    public RedirectView generateMeesevaReceipt(HttpServletRequest request, Model model) {
        String keyNameArray = request.getParameter("transactionServiceNumber");
        RedirectView redirect = new RedirectView("/meeseva/generatereceipt?transactionServiceNumber=" + keyNameArray, false);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
        }
        return redirect;
    }
}

