/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.digitalsignature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/digitalSignature"})
public class DigitalSignatureWorkflowController {
    private static final String DIGISIGN_SUCCESS_MESSAGE = "Digitally Signed Successfully";
    private static final String NOTICE_SUCCESS_MESSAGE = "Notice Generated Successfully";
    private static final String STR_DEMOLITION = "Demolition";
    private static final String BIFURCATE = "Bifurcate";
    private static final String ALTER = "Alter";
    private static final String CREATE = "Create";
    private static final String GRP = "GRP";
    private static final String DIGITAL_SIGNATURE_SUCCESS = "digitalSignature-success";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyMutation> transferWorkflowService;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;

    @RequestMapping(value={"/propertyTax/transitionWorkflow"})
    public String transitionWorkflow(HttpServletRequest request, Model model) {
        String[] fileStoreId;
        String fileStoreIds = request.getParameter("fileStoreId");
        String isDigiEnabled = request.getParameter("isDigiEnabled");
        for (String id : fileStoreId = fileStoreIds.split(",")) {
            String applicationNumber = (String)this.getCurrentSession().createQuery("select notice.applicationNumber from PtNotice notice where notice.fileStore.fileStoreId = :id").setParameter("id", (Object)id).uniqueResult();
            PropertyImpl property = (PropertyImpl)this.getCurrentSession().createQuery("from PropertyImpl where applicationNo = :applicationNo").setParameter("applicationNo", (Object)applicationNumber).uniqueResult();
            if (property != null) {
                BasicProperty basicProperty = property.getBasicProperty();
                String applicationType = this.transitionWorkFlow(property);
                this.propertyService.updateIndexes((StateAware)property, this.getTypeForUpdateIndexes(applicationType));
                this.basicPropertyService.update((Object)basicProperty);
                continue;
            }
            RevisionPetition revisionPetition = (RevisionPetition)this.getCurrentSession().createQuery("from RevisionPetition where objectionNumber = :applicationNo").setParameter("applicationNo", (Object)applicationNumber).uniqueResult();
            if (revisionPetition != null) {
                this.transitionWorkFlow(revisionPetition);
                this.propertyService.updateIndexes((StateAware)revisionPetition, "Revision_Petition");
                this.revisionPetitionService.updateRevisionPetition(revisionPetition);
                continue;
            }
            PropertyMutation propertyMutation = (PropertyMutation)this.getCurrentSession().createQuery("from PropertyMutation where applicationNo = :applicationNo").setParameter("applicationNo", (Object)applicationNumber).uniqueResult();
            if (propertyMutation == null) continue;
            BasicProperty basicProperty = propertyMutation.getBasicProperty();
            this.transitionWorkFlow(propertyMutation);
            this.propertyService.updateIndexes((StateAware)propertyMutation, "Transfer_of_Ownership");
            this.basicPropertyService.persist((Object)basicProperty);
        }
        if (isDigiEnabled != null && isDigiEnabled.equals("false")) {
            model.addAttribute("successMessage", (Object)NOTICE_SUCCESS_MESSAGE);
        } else {
            model.addAttribute("successMessage", (Object)DIGISIGN_SUCCESS_MESSAGE);
        }
        model.addAttribute("fileStoreId", (Object)(fileStoreId.length == 1 ? fileStoreId[0] : ""));
        return DIGITAL_SIGNATURE_SUCCESS;
    }

    private String getTypeForUpdateIndexes(String applicationType) {
        return applicationType.equals("NEW ASSESSMENT") ? "New_Assessment" : (applicationType.equals("ALTER ASSESSMENT") ? "Alter_Assessment" : (applicationType.equals("BIFURCATE ASSESSMENT") ? "Bifuracate_Assessment" : (applicationType.equals("DEMOLITION") ? STR_DEMOLITION : (applicationType.equals("GENERAL REVISION PETITION") ? "General_Revision_Petition" : null))));
    }

    private String transitionWorkFlow(PropertyImpl property) {
        String applicationType;
        String string = property.getCurrentState().getValue().startsWith(CREATE) ? "NEW ASSESSMENT" : (property.getCurrentState().getValue().startsWith(ALTER) ? "ALTER ASSESSMENT" : (property.getCurrentState().getValue().startsWith(BIFURCATE) ? "BIFURCATE ASSESSMENT" : (property.getCurrentState().getValue().startsWith(STR_DEMOLITION) ? "DEMOLITION" : (applicationType = property.getCurrentState().getValue().startsWith(GRP) ? "GENERAL REVISION PETITION" : null))));
        if (this.propertyService.isMeesevaUser(property.getCreatedBy()).booleanValue()) {
            property.transition().end();
            property.getBasicProperty().setUnderWorkflow(false);
        } else {
            User user = this.securityUtils.getCurrentUser();
            DateTime currentDate = new DateTime();
            Position pos = this.getWorkflowInitiator((StateAware)property, property.getBasicProperty()).getPosition();
            WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, applicationType, property.getCurrentState().getValue(), null);
            property.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(property.getCurrentState().getInitiatorPosition() != null ? property.getCurrentState().getInitiatorPosition() : pos).withNextAction(wfmatrix.getNextAction());
        }
        return applicationType;
    }

    private void transitionWorkFlow(RevisionPetition revPetition) {
        if (this.propertyService.isMeesevaUser(revPetition.getCreatedBy()).booleanValue()) {
            revPetition.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("ASSESSED"));
            revPetition.getBasicProperty().getProperty().setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            revPetition.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
            revPetition.getProperty().setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            revPetition.transition().end();
        } else {
            User user = this.securityUtils.getCurrentUser();
            Position pos = this.getWorkflowInitiator((StateAware)revPetition, revPetition.getBasicProperty()).getPosition();
            WorkFlowMatrix wfmatrix = this.revisionPetitionWorkFlowService.getWfMatrix(revPetition.getStateType(), null, null, null, revPetition.getCurrentState().getValue(), null);
            revPetition.transition(true).withStateValue(wfmatrix.getNextState()).withOwner(revPetition.getCurrentState().getInitiatorPosition() != null ? revPetition.getCurrentState().getInitiatorPosition() : pos).withSenderName(user.getUsername() + "::" + user.getName()).withDateInfo(new DateTime().toDate()).withNextAction(wfmatrix.getNextAction());
        }
    }

    public void transitionWorkFlow(PropertyMutation propertyMutation) {
        if (this.propertyService.isMeesevaUser(propertyMutation.getCreatedBy()).booleanValue()) {
            propertyMutation.transition().end();
            propertyMutation.getBasicProperty().setUnderWorkflow(false);
        } else {
            DateTime currentDate = new DateTime();
            User user = this.securityUtils.getCurrentUser();
            Assignment wfInitiator = this.getWorkflowInitiator((StateAware)propertyMutation, propertyMutation.getBasicProperty());
            Position pos = wfInitiator.getPosition();
            WorkFlowMatrix wfmatrix = this.transferWorkflowService.getWfMatrix(propertyMutation.getStateType(), null, null, propertyMutation.getType(), propertyMutation.getCurrentState().getValue(), null);
            propertyMutation.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(propertyMutation.getCurrentState().getInitiatorPosition() != null ? propertyMutation.getCurrentState().getInitiatorPosition() : pos).withNextAction(wfmatrix.getNextAction());
        }
    }

    private Assignment getWorkflowInitiator(StateAware state, BasicProperty basicProperty) {
        Assignment wfInitiator = null;
        if (basicProperty.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_ONLINE)) {
            if (!state.getStateHistory().isEmpty()) {
                wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)state.getStateHistory().get(0)).getOwnerPosition().getId());
            }
        } else {
            wfInitiator = this.propertyService.isEmployee(state.getCreatedBy()) != false ? this.assignmentService.getPrimaryAssignmentForUser(state.getCreatedBy().getId()) : (!state.getStateHistory().isEmpty() ? (Assignment)this.assignmentService.getAssignmentsForPosition(((StateHistory)state.getStateHistory().get(0)).getOwnerPosition().getId(), new Date()).get(0) : (Assignment)this.assignmentService.getAssignmentsForPosition(state.getState().getOwnerPosition().getId(), new Date()).get(0));
        }
        return wfInitiator;
    }

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @RequestMapping(value={"/propertyTax/downloadSignedNotice"})
    public void downloadSignedNotice(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        File file = this.fileStoreService.fetch(signedFileStoreId, "PTIS");
        FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
        response.setContentType("application/pdf");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; filename=\"" + fileStoreMapper.getFileName() + "\"");
        try (FileInputStream inStream = new FileInputStream(file);){
            ServletOutputStream outStream = response.getOutputStream();
            int bytesRead = -1;
            byte[] buffer = FileUtils.readFileToByteArray((File)file);
            while ((bytesRead = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (FileNotFoundException fileNotFoundExcep) {
            throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
        }
        catch (IOException ioExcep) {
            throw new ApplicationRuntimeException("Exception while downloading notice : " + ioExcep);
        }
    }
}

