/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.ptis.domain.entity.property.DailyCollectionReportSearch;
import org.egov.ptis.domain.service.report.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/report/dailyCollection"})
public class DailyCollectionReportController {
    private static final String DAILY_COLLECTION_FORM = "dailyCollection-form";
    @Autowired
    private ReportService reportService;
    @Autowired
    private EgwStatusHibernateDAO egwStatushibernateDAO;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute
    public void getReportModel(Model model) {
        DailyCollectionReportSearch dailyCollectionReportResut = new DailyCollectionReportSearch();
        model.addAttribute("dailyCollectionReportResut", (Object)dailyCollectionReportResut);
    }

    @ModelAttribute(value="operators")
    public Set<User> loadCollectionOperators() {
        return this.reportService.getCollectionOperators();
    }

    @ModelAttribute(value="status")
    public List<EgwStatus> loadStatus() {
        return this.egwStatushibernateDAO.getStatusByModule("ReceiptHeader");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String seachForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("collectionMode", (Object)Source.values());
        return DAILY_COLLECTION_FORM;
    }
}

