/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.floor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.master.service.FloorTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/floortype"})
public class CreateAndViewFloorTypeController {
    private final FloorTypeService floorTypeService;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public CreateAndViewFloorTypeController(FloorTypeService floorTypeService) {
        this.floorTypeService = floorTypeService;
    }

    @ModelAttribute
    public FloorType FloorTypeModel() {
        return new FloorType();
    }

    @ModelAttribute(value="floortypes")
    public List<FloorType> listFloorTypes() {
        return this.floorTypeService.getAllFloors();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String showFloorTypes(Model model) {
        String roleName = this.floorTypeService.getRolesForUserId(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("roleName", (Object)roleName);
        return "floorType-main";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("floortype", (Object)this.FloorTypeModel());
        return "floorType-form";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable Long id, Model model) {
        FloorType floorType = this.floorTypeService.getFloorTypeById(id);
        model.addAttribute("floorType", (Object)floorType);
        return "floorType-view";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute FloorType floorType, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        if (errors.hasErrors()) {
            return "floorType-main";
        }
        this.floorTypeService.create(floorType);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.floortype.create.success");
        return "redirect:/floortype/create";
    }
}

