/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.dashboard;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.ptis.bean.dashboard.CollReceiptDetails;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.PropertyTaxDefaultersRequest;
import org.egov.ptis.bean.dashboard.StateCityInfo;
import org.egov.ptis.bean.dashboard.TaxDefaulters;
import org.egov.ptis.bean.dashboard.TaxPayerResponseDetails;
import org.egov.ptis.bean.dashboard.TotalCollectionStats;
import org.egov.ptis.service.dashboard.PropTaxDashboardService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/dashboard", "/dashboard"})
public class CMDashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMDashboardController.class);
    @Autowired
    private PropTaxDashboardService propTaxDashboardService;

    @RequestMapping(value={"/statecityinfo"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<StateCityInfo> getStateCityInformation() throws IOException {
        Long startTime = System.currentTimeMillis();
        List stateDetails = this.propTaxDashboardService.getStateCityDetails();
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve statecityinfo is : " + timeTaken + " (millisecs)");
        return stateDetails;
    }

    @RequestMapping(value={"/collectionstats"}, method={RequestMethod.POST}, produces={"application/json"})
    public TotalCollectionStats getConsolidatedCollDetails(HttpServletRequest request) throws IOException {
        Long startTime = System.currentTimeMillis();
        TotalCollectionStats consolidatedCollectionDetails = this.propTaxDashboardService.getTotalCollectionStats(request);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve collectionstats is : " + timeTaken + " (millisecs)");
        return consolidatedCollectionDetails;
    }

    @RequestMapping(value={"/collectiondashboard"}, method={RequestMethod.POST}, produces={"application/json"})
    public CollectionDetails getCollectionDetails(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        CollectionDetails collectionDetails = this.propTaxDashboardService.getCollectionIndexDetails(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve collectiondashboard is : " + timeTaken + " (millisecs)");
        return collectionDetails;
    }

    @RequestMapping(value={"/receipttransactions"}, method={RequestMethod.POST}, produces={"application/json"})
    public CollReceiptDetails getReceiptTransactions(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        CollReceiptDetails collReceiptDetails = this.propTaxDashboardService.getReceiptDetails(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve receipttransactions is : " + timeTaken + " (millisecs)");
        return collReceiptDetails;
    }

    @RequestMapping(value={"/toptentaxers"}, method={RequestMethod.POST}, produces={"application/json"})
    public TaxPayerResponseDetails getTopTenTaxProducers(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        TaxPayerResponseDetails taxPayerDetails = this.propTaxDashboardService.getTopTenTaxProducers(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve toptentaxers is : " + timeTaken + " (millisecs)");
        return taxPayerDetails;
    }

    @RequestMapping(value={"/bottomtentaxers"}, method={RequestMethod.POST}, produces={"application/json"})
    public TaxPayerResponseDetails getBottomTenTaxProducers(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        TaxPayerResponseDetails taxPayerDetails = this.propTaxDashboardService.getBottomTenTaxProducers(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve bottomtentaxers is : " + timeTaken + " (millisecs)");
        return taxPayerDetails;
    }

    @RequestMapping(value={"/topdefaulters"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<TaxDefaulters> getTopTaxDefaulters(@RequestBody PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        LOGGER.debug("PropertyTaxDefaultersRequest input : regionName = " + propertyTaxDefaultersRequest.getRegionName() + ", districtName = " + propertyTaxDefaultersRequest.getDistrictName() + ", type = " + propertyTaxDefaultersRequest.getType() + ", ulbCode = " + propertyTaxDefaultersRequest.getUlbCode() + ", wardName = " + propertyTaxDefaultersRequest.getWardName());
        List taxDefaulters = this.propTaxDashboardService.getTaxDefaulters(propertyTaxDefaultersRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken to serve topdefaulters is : " + timeTaken + " (millisecs)");
        return taxDefaulters;
    }
}

