/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.transfer;

import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyMutationTransferee;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"new"}, location="transfer/transferProperty-new.jsp"), @Result(name={"edit"}, location="transfer/transferProperty-edit.jsp"), @Result(name={"view"}, location="transfer/transferProperty-view.jsp"), @Result(name={"redirect"}, location="transfer/transferProperty-redirect.jsp"), @Result(name={"workFlowError"}, location="workflow/workflow-error.jsp"), @Result(name={"ack"}, location="transfer/transferProperty-ack.jsp"), @Result(name={"balance"}, location="transfer/transferProperty-balance.jsp"), @Result(name={"printAck"}, location="transfer/transferProperty-printAck.jsp"), @Result(name={"printNotice"}, location="transfer/transferProperty-printNotice.jsp"), @Result(name={"search"}, location="transfer/transferProperty-search.jsp"), @Result(name={"error"}, location="common/meeseva-errorPage.jsp"), @Result(name={"meesevaAck"}, location="common/meesevaAck.jsp"), @Result(name={"collect-fee"}, location="collection/collectPropertyTax-view.jsp"), @Result(name={"redirect-success"}, location="redirect-success", type="redirectAction", params={"assessmentNo", "${assessmentNo}", "mutationId", "${mutationId}"}), @Result(name={"commonForm"}, location="search/searchProperty-commonForm.jsp"), @Result(name={"digitalSignatureRedirection"}, location="transfer/transferProperty-digitalSignatureRedirection.jsp")})
@Namespace(value="/property/transfer")
public class PropertyTransferAction
extends GenericWorkFlowAction {
    protected static final String COMMON_FORM = "commonForm";
    protected static final String REDIRECT = "redirect";
    protected static final String DIGITAL_SIGNATURE_REDIRECTION = "digitalSignatureRedirection";
    private static final String PROPERTY_TRANSFER = "property transfer";
    private static final long serialVersionUID = 1L;
    public static final String ACK = "ack";
    public static final String ERROR = "error";
    public static final String SEARCH = "search";
    public static final String REJECT_ON_TAXDUE = "balance";
    public static final String PRINTACK = "printAck";
    public static final String PRINTNOTICE = "printNotice";
    public static final String REDIRECT_SUCCESS = "redirect-success";
    public static final String COLLECT_FEE = "collect-fee";
    public static final String MEESEVA_RESULT_ACK = "meesevaAck";
    private PropertyMutation propertyMutation = new PropertyMutation();
    @Autowired
    @Qualifier(value="transferOwnerService")
    private PropertyTransferService transferOwnerService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyMutation> transferWorkflowService;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    private Long mutationId;
    private String assessmentNo;
    private String wfErrorMsg;
    private BigDecimal currentPropertyTax;
    private BigDecimal currentPropertyTaxFirstHalf;
    private BigDecimal currentPropertyTaxSecondHalf;
    private BigDecimal currentPropertyTaxDue;
    private BigDecimal currentWaterTaxDue;
    private BigDecimal arrearPropertyTaxDue;
    private List<DocumentType> documentTypes = new ArrayList();
    private BasicProperty basicproperty;
    private String reportId;
    private Long transfereeId;
    private double marketValue;
    private String transferReason;
    private String collectXML;
    private String applicationNo;
    private String ackMessage;
    private String mode;
    private String mutationInitiatedBy;
    private String assessmentNoMessage;
    private String taxDueErrorMsg;
    private Boolean propertyByEmployee = Boolean.TRUE;
    private String userDesignationList;
    private Boolean loggedUserIsMeesevaUser = Boolean.FALSE;
    private String meesevaApplicationNumber;
    private String meesevaServiceCode;
    private String applicationType;
    private String fileStoreIds;
    private String ulbCode;
    private boolean enableApproverDetails = Boolean.FALSE;
    private Map<String, String> guardianRelationMap;
    private List<Hashtable<String, Object>> historyMap = new ArrayList();
    private String actionType;
    private boolean digitalSignEnabled;
    private boolean mutationFeePaid = Boolean.FALSE;
    private boolean receiptCanceled = Boolean.FALSE;

    public PropertyTransferAction() {
        this.addRelatedEntity("mutationReason", PropertyMutationMaster.class);
    }

    @SkipValidation
    @Action(value="/redirect")
    public String redirect() {
        return REDIRECT;
    }

    @SkipValidation
    @Action(value="/new")
    public String showNewTransferForm() {
        if (this.basicproperty.getProperty().getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE)) {
            this.addActionError(this.getText("error.msg.demandInactive"));
            return COMMON_FORM;
        }
        if (this.basicproperty.isUnderWorkflow()) {
            ArrayList<String> msgParams = new ArrayList<String>();
            msgParams.add("Transfer of Ownership");
            this.wfErrorMsg = this.getText("wf.pending.msg", msgParams);
            return "workFlowError";
        }
        PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
        propertyTaxUtil.setPersistenceService(this.persistenceService);
        boolean hasChildPropertyUnderWorkflow = propertyTaxUtil.checkForParentUsedInBifurcation(this.basicproperty.getUpicNo());
        if (hasChildPropertyUnderWorkflow) {
            this.wfErrorMsg = this.getText("error.msg.child.underworkflow");
            return "workFlowError";
        }
        Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicproperty.getActiveProperty());
        Map currentTaxAndDue = this.propertyService.getCurrentTaxAndBalance(propertyTaxDetails, new Date());
        this.currentPropertyTax = (BigDecimal)currentTaxAndDue.get("CURR_DMD");
        this.currentPropertyTaxDue = (BigDecimal)currentTaxAndDue.get("CURR_BAL");
        this.arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
        this.currentWaterTaxDue = this.propertyService.getWaterTaxDues(this.assessmentNo);
        if (this.currentWaterTaxDue.add(this.currentPropertyTaxDue).add(this.arrearPropertyTaxDue).longValue() > 0L) {
            this.setTaxDueErrorMsg(this.getText("taxdues.error.msg", new String[]{PROPERTY_TRANSFER}));
            return REJECT_ON_TAXDUE;
        }
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.transferOwnerService.getLoggedInUser());
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            if (this.getMeesevaApplicationNumber() == null) {
                this.addActionMessage(this.getText("MEESEVA.005"));
                return ERROR;
            }
            this.propertyMutation.setMeesevaApplicationNumber(this.getMeesevaApplicationNumber());
        }
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/save")
    public String save() {
        this.transitionWorkFlow(this.propertyMutation);
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.transferOwnerService.getLoggedInUser());
        if (!this.loggedUserIsMeesevaUser.booleanValue()) {
            this.transferOwnerService.initiatePropertyTransfer(this.basicproperty, this.propertyMutation);
        } else {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("APPLICATIONNUMBER", this.propertyMutation.getMeesevaApplicationNumber());
            this.propertyMutation.setSource(PropertyTaxConstants.SOURCEOFDATA_MEESEWA);
            this.propertyMutation.setApplicationNo(this.propertyMutation.getMeesevaApplicationNumber());
            this.transferOwnerService.initiatePropertyTransfer(this.basicproperty, this.propertyMutation, meesevaParams);
        }
        this.buildSMS(this.propertyMutation);
        this.buildEmail(this.propertyMutation);
        this.setAckMessage("Transfer of ownership data saved successfully in the system and forwarded to : ");
        this.setAssessmentNoMessage(" with assessment number : ");
        if (!this.loggedUserIsMeesevaUser.booleanValue()) {
            return ACK;
        }
        return MEESEVA_RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/view")
    public String view() {
        String currState = this.propertyMutation.getState().getValue();
        String nextAction = this.propertyMutation.getState().getNextAction();
        this.propertyMutation.getTransfereeInfosProxy().addAll(this.propertyMutation.getTransfereeInfos());
        this.mode = currState.endsWith("Rejected") || nextAction != null && nextAction.equalsIgnoreCase("UD Revenue Inspector Approval Pending") || currState.equals("NEW") ? "edit" : "view";
        return this.mode;
    }

    @SkipValidation
    @Action(value="/search")
    public String search() {
        return SEARCH;
    }

    @SkipValidation
    @Action(value="/collect-fee")
    public String collectFee() {
        String target = "";
        if (StringUtils.isNotBlank((String)this.assessmentNo)) {
            this.propertyMutation = this.transferOwnerService.getCurrentPropertyMutationByAssessmentNo(this.assessmentNo);
        } else if (StringUtils.isNotBlank((String)this.applicationNo)) {
            this.propertyMutation = this.transferOwnerService.getPropertyMutationByApplicationNo(this.applicationNo);
        } else {
            this.addActionError(this.getText("mandatory.assessmentno.applicationno"));
            target = SEARCH;
        }
        if (null == this.propertyMutation || null == this.propertyMutation.getId()) {
            this.addActionError(this.getText("mutation.notexists"));
            target = SEARCH;
        } else if (null != this.propertyMutation && null != this.propertyMutation.getReceiptDate()) {
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            this.addActionError(this.getText("mutationpayment.done", new String[]{df.format(this.propertyMutation.getReceiptDate())}));
            target = SEARCH;
        } else if (null != this.propertyMutation && null == this.propertyMutation.getMutationFee()) {
            this.addActionError(this.getText("mutationfee.notexists"));
            target = SEARCH;
        } else {
            this.collectXML = this.transferOwnerService.generateReceipt(this.propertyMutation);
            target = COLLECT_FEE;
        }
        return target;
    }

    @SkipValidation
    @Action(value="/forward")
    public String forward() {
        if (this.mode.equals("edit")) {
            this.validate();
            if (this.hasErrors()) {
                this.mode = "edit";
                return "edit";
            }
            this.transitionWorkFlow(this.propertyMutation);
            this.transferOwnerService.updatePropertyTransfer(this.basicproperty, this.propertyMutation);
        } else {
            this.transitionWorkFlow(this.propertyMutation);
            this.transferOwnerService.viewPropertyTransfer(this.basicproperty, this.propertyMutation);
        }
        this.buildSMS(this.propertyMutation);
        this.buildEmail(this.propertyMutation);
        this.setAssessmentNoMessage(" with assessment number : ");
        return ACK;
    }

    @SkipValidation
    @Action(value="/reject")
    public String reject() {
        Assignment assignment;
        if ((this.propertyMutation.getState().getValue().equals("Rejected") || this.propertyMutation.getType().equalsIgnoreCase("FULL TRANSFER")) && this.propertyMutation.getReceiptNum() != null && !this.receiptCanceled) {
            this.addActionError(this.getText("error.mutation.reject.notallowed"));
            if (this.propertyMutation.getType().equalsIgnoreCase("FULL TRANSFER")) {
                return "view";
            }
            return "edit";
        }
        this.transitionWorkFlow(this.propertyMutation);
        this.transferOwnerService.viewPropertyTransfer(this.basicproperty, this.propertyMutation);
        this.buildSMS(this.propertyMutation);
        this.buildEmail(this.propertyMutation);
        this.approverName = "";
        if (this.propertyService.isEmployee(this.propertyMutation.getCreatedBy()).booleanValue()) {
            assignment = this.assignmentService.getPrimaryAssignmentForUser(this.propertyMutation.getCreatedBy().getId());
            this.mutationInitiatedBy = this.propertyMutation.getCreatedBy().getName().concat("~").concat(assignment.getPosition().getName());
        } else {
            assignment = this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)this.propertyMutation.getStateHistory().get(0)).getOwnerPosition().getId());
            this.mutationInitiatedBy = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
        }
        if (this.propertyMutation.getState().getValue().equals("Closed")) {
            assignment = this.assignmentService.getPrimaryAssignmentForUser(this.transferOwnerService.getLoggedInUser().getId());
            this.mutationInitiatedBy = this.transferOwnerService.getLoggedInUser().getName().concat("~").concat(assignment.getPosition().getName());
            this.setAckMessage("Transfer of ownership data rejected successfuly By ");
        } else {
            this.setAckMessage("Transfer of ownership data rejected successfuly and forwarded to initiator : ");
        }
        this.setAssessmentNoMessage(" with assessment number : ");
        return ACK;
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/approve")
    public String approve() {
        this.transitionWorkFlow(this.propertyMutation);
        this.transferOwnerService.approvePropertyTransfer(this.basicproperty, this.propertyMutation);
        this.transferOwnerService.viewPropertyTransfer(this.basicproperty, this.propertyMutation);
        this.approverName = "";
        Assignment assignment = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
        this.mutationInitiatedBy = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
        this.propertyTaxCommonUtils.makeExistingDemandBillInactive(this.basicproperty.getUpicNo());
        this.mutationInitiatedBy = this.propertyTaxUtil.getApproverUserName(this.approverPositionId);
        this.buildSMS(this.propertyMutation);
        this.buildEmail(this.propertyMutation);
        this.setAckMessage("Transfer of ownership is created successfully in the system and forwarded to : " + this.mutationInitiatedBy);
        this.setAssessmentNoMessage(" for Digital Signature for the property : ");
        return ACK;
    }

    @SkipValidation
    @Action(value="/printAck")
    public String printAck() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.transferOwnerService.generateAcknowledgement(this.basicproperty, this.propertyMutation, cityName, cityLogo));
        return PRINTACK;
    }

    @SkipValidation
    @Action(value="/printNotice")
    public String printNotice() {
        this.setUlbCode(ApplicationThreadLocals.getCityCode());
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
        Boolean isCorporation = cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        ReportOutput reportOutput = this.transferOwnerService.generateTransferNotice(this.basicproperty, this.propertyMutation, cityName, cityLogo, this.actionType, isCorporation.booleanValue());
        if ("Sign".equalsIgnoreCase(this.actionType)) {
            PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("Mutation Certificate", this.propertyMutation.getApplicationNo());
            this.setFileStoreIds(notice.getFileStore().getFileStoreId());
            return DIGITAL_SIGNATURE_REDIRECTION;
        }
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return PRINTNOTICE;
    }

    @SkipValidation
    @Action(value="/delete-transferee")
    public void deleteTransferee() throws IOException {
        if (this.transfereeId != null) {
            this.transferOwnerService.deleteTransferee(this.propertyMutation, this.transfereeId);
            ServletActionContext.getResponse().getWriter().write("true");
        } else {
            ServletActionContext.getResponse().getWriter().write("false");
        }
    }

    @SkipValidation
    @Action(value="/calculate-mutationfee")
    public void calculateMutationFee() throws IOException {
        if (this.marketValue > 0.0) {
            ServletActionContext.getResponse().getWriter().write(String.valueOf(this.transferOwnerService.calculateMutationFee(this.marketValue, this.transferReason, this.propertyMutation)));
        } else {
            ServletActionContext.getResponse().getWriter().write("0");
        }
    }

    @SkipValidation
    @Action(value="/redirect-success")
    public String redirectSuccess() {
        this.getAckMessage();
        return ACK;
    }

    public void prepare() {
        super.prepare();
        Long userId = this.securityUtils.getCurrentUser().getId();
        this.userDesignationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(userId);
        this.propertyByEmployee = this.propertyService.isEmployee(this.transferOwnerService.getLoggedInUser());
        String actionInvoked = ActionContext.getContext().getActionInvocation().getProxy().getMethod();
        if (!actionInvoked.equals(SEARCH) && !actionInvoked.equals("collectFee")) {
            if (StringUtils.isNotBlank((String)this.assessmentNo) && this.mutationId == null) {
                this.basicproperty = this.transferOwnerService.getBasicPropertyByUpicNo(this.assessmentNo);
            }
            if (this.mutationId != null) {
                this.propertyMutation = (PropertyMutation)this.persistenceService.find("From PropertyMutation where id = ? ", new Object[]{this.mutationId});
                this.basicproperty = this.propertyMutation.getBasicProperty();
                this.historyMap = this.propertyService.populateHistory((StateAware)this.propertyMutation);
            }
            Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicproperty.getActiveProperty());
            Map currentTaxAndDue = this.propertyService.getCurrentTaxAndBalance(propertyTaxDetails, new Date());
            this.currentPropertyTax = (BigDecimal)currentTaxAndDue.get("CURR_DMD");
            this.currentPropertyTaxFirstHalf = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
            this.currentPropertyTaxSecondHalf = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
            this.documentTypes = this.transferOwnerService.getPropertyTransferDocumentTypes();
            this.addDropdownData("MutationReason", this.transferOwnerService.getPropertyTransferReasons());
            this.setGuardianRelationMap((Map)PropertyTaxConstants.GUARDIAN_RELATION);
            if (this.propertyMutation.getReceiptNum() != null) {
                boolean isCanceled = this.propertyTaxCommonUtils.isReceiptCanceled(this.propertyMutation.getReceiptNum());
                this.setReceiptCanceled(isCanceled);
                if (isCanceled) {
                    this.setMutationFeePaid(Boolean.FALSE.booleanValue());
                } else {
                    this.setMutationFeePaid(Boolean.TRUE.booleanValue());
                }
            }
        }
        this.digitalSignEnabled = this.propertyTaxCommonUtils.isDigitalSignatureEnabled();
    }

    public void validate() {
        if ("REGISTERED TRANSFER".equalsIgnoreCase(this.propertyMutation.getType())) {
            if (this.propertyMutation.getMutationReason() == null || this.propertyMutation.getMutationReason().getId() == -1L) {
                this.addActionError(this.getText("mandatory.trRsnId"));
            } else if (this.propertyMutation.getMutationReason().getMutationName().equals("Sale Deed") && StringUtils.isBlank((String)this.propertyMutation.getSaleDetail())) {
                this.addActionError(this.getText("mandatory.saleDtl"));
            }
            if (this.propertyMutation.getDeedDate() == null) {
                this.addActionError("Registration Document Date should not be empty");
            }
            if (StringUtils.isBlank((String)this.propertyMutation.getDeedNo())) {
                this.addActionError("Registration Document Number should not be empty");
            }
        }
        if (this.propertyMutation.getPartyValue() == null || this.propertyMutation.getPartyValue().equals("")) {
            this.addActionError(this.getText("mandatory.party.value"));
        }
        if (this.propertyMutation.getDepartmentValue() == null || this.propertyMutation.getDepartmentValue().equals("")) {
            this.addActionError(this.getText("mandatory.department.value"));
        }
        boolean anyDocIsMandatory = false;
        for (DocumentType docTypes : this.documentTypes) {
            if (!docTypes.isMandatory()) continue;
            anyDocIsMandatory = true;
            break;
        }
        if (anyDocIsMandatory) {
            if (this.propertyMutation.getDocuments().isEmpty()) {
                this.addActionError("Please attach the mandatory documents.");
            } else {
                for (Document document : this.propertyMutation.getDocuments()) {
                    if (!document.isEnclosed() || !document.getFiles().isEmpty()) continue;
                    this.addActionError(document.getType() + " document marked as enclosed, please add the relavent documents.");
                }
            }
        }
        if (this.propertyMutation.getState() != null && this.propertyMutation.getState().getValue() != null && (this.propertyMutation.getState().getValue().equalsIgnoreCase("Revenue officer Approved") || this.propertyMutation.getState().getValue().equalsIgnoreCase("Registration Completed") || this.propertyMutation.getState().getNextAction().equalsIgnoreCase("Commissioner Approval Pending"))) {
            this.propertyMutation.getTransfereeInfosProxy().addAll(this.propertyMutation.getTransfereeInfos());
        }
        if (this.propertyMutation.getTransfereeInfosProxy().isEmpty()) {
            this.addActionError("Transfree info is mandatory, add atleast one transferee info.");
        } else {
            for (PropertyMutationTransferee propOwnerInfo : this.propertyMutation.getTransfereeInfosProxy()) {
                if (StringUtils.isBlank((String)propOwnerInfo.getTransferee().getName())) {
                    this.addActionError(this.getText("mandatory.ownerName"));
                }
                if (StringUtils.isBlank((String)propOwnerInfo.getTransferee().getMobileNumber())) {
                    this.addActionError(this.getText("mandatory.mobilenumber"));
                }
                if (propOwnerInfo.getTransferee().getGender() == null) {
                    this.addActionError(this.getText("mandatory.gender"));
                }
                if (StringUtils.isBlank((String)propOwnerInfo.getTransferee().getGuardianRelation())) {
                    this.addActionError(this.getText("mandatory.guardianrelation"));
                }
                if (!StringUtils.isBlank((String)propOwnerInfo.getTransferee().getGuardian())) continue;
                this.addActionError(this.getText("mandatory.guardian"));
            }
            int count = this.propertyMutation.getTransfereeInfosProxy().size();
            for (int i = 0; i < count; ++i) {
                PropertyMutationTransferee owner = (PropertyMutationTransferee)this.propertyMutation.getTransfereeInfosProxy().get(i);
                for (int j = i + 1; j <= count - 1; ++j) {
                    PropertyMutationTransferee owner1 = (PropertyMutationTransferee)this.propertyMutation.getTransfereeInfosProxy().get(j);
                    if (!owner.getTransferee().getMobileNumber().equalsIgnoreCase(owner1.getTransferee().getMobileNumber()) || !owner.getTransferee().getName().equalsIgnoreCase(owner1.getTransferee().getName())) continue;
                    this.addActionError(this.getText("error.transferee.duplicateMobileNo", "", owner.getTransferee().getMobileNumber().concat(",").concat(owner.getTransferee().getName())));
                }
            }
        }
        if ((this.loggedUserIsMeesevaUser.booleanValue() || !this.propertyByEmployee.booleanValue()) && null != this.basicproperty && null == this.propertyService.getUserPositionByZone(this.basicproperty, false)) {
            this.addActionError(this.getText("notexists.position"));
        }
        super.validate();
    }

    public void transitionWorkFlow(PropertyMutation propertyMutation) {
        String approvalmesg;
        DateTime currentDate = new DateTime();
        User user = this.transferOwnerService.getLoggedInUser();
        Position pos = null;
        Assignment wfInitiator = null;
        if (!this.propertyByEmployee.booleanValue()) {
            this.currentState = "Created";
            Assignment assignment = this.propertyService.getUserPositionByZone(this.basicproperty, false);
            this.approverPositionId = assignment.getPosition().getId();
            this.approverName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
        } else {
            this.currentState = null;
        }
        wfInitiator = propertyMutation.getId() != null ? this.transferOwnerService.getWorkflowInitiator(propertyMutation) : this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        if ("Reject".equalsIgnoreCase(this.workFlowAction)) {
            if (wfInitiator.getPosition().equals((Object)propertyMutation.getState().getOwnerPosition()) || propertyMutation.getType().equalsIgnoreCase("FULL TRANSFER")) {
                propertyMutation.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withDateInfo(currentDate.toDate());
                propertyMutation.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
            } else {
                String stateValue = "Rejected";
                propertyMutation.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null ? wfInitiator.getPosition() : null).withNextAction("Assistant Approval Pending");
            }
        } else {
            WorkFlowMatrix wfmatrix;
            pos = null != this.approverPositionId && this.approverPositionId != -1L ? (Position)this.persistenceService.find("from Position where id=?", new Object[]{this.approverPositionId}) : ("Approve".equalsIgnoreCase(this.workFlowAction) ? this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId()) : wfInitiator.getPosition());
            if (null == propertyMutation.getState()) {
                wfmatrix = this.transferWorkflowService.getWfMatrix(propertyMutation.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                propertyMutation.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(this.getNatureOfTask()).withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
            } else if (propertyMutation.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                propertyMutation.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withDateInfo(currentDate.toDate());
            } else {
                wfmatrix = null;
                if (propertyMutation.getState().getValue().equals("Bill Collector Approved") && null != propertyMutation.getMutationFee() && null != propertyMutation.getReceiptDate() && StringUtils.isNotBlank((String)propertyMutation.getReceiptNum())) {
                    propertyMutation.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(propertyMutation.getType().equalsIgnoreCase("FULL TRANSFER") ? "Transfer Fee Collected" : "UD Revenue Inspector Approved").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("Revenue Officer Approval Pending");
                } else {
                    wfmatrix = this.transferWorkflowService.getWfMatrix(propertyMutation.getStateType(), null, null, this.getAdditionalRule(), propertyMutation.getCurrentState().getValue(), null);
                    propertyMutation.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
                }
            }
        }
        if (this.approverName != null && !this.approverName.isEmpty() && !this.approverName.equalsIgnoreCase("----Choose----")) {
            approvalmesg = " Succesfully Forwarded to : ";
            this.ackMessage = this.ackMessage == null ? " Succesfully Forwarded to : " : this.ackMessage + " Succesfully Forwarded to : ";
        } else if (this.workFlowAction != null && this.workFlowAction.equalsIgnoreCase("cancel")) {
            approvalmesg = " Succesfully Cancelled.";
            this.ackMessage = this.ackMessage == null ? " Succesfully Cancelled." : this.ackMessage + " Succesfully Cancelled.";
        }
    }

    public void buildSMS(PropertyMutation propertyMutation) {
        ArrayList<String> argsForTransferor = new ArrayList<String>();
        ArrayList<String> argsForTransferee = new ArrayList<String>();
        String smsMsgForTransferor = "";
        String smsMsgForTransferee = "";
        if (null != propertyMutation && null != propertyMutation.getState()) {
            State mutationState = propertyMutation.getState();
            if (mutationState.getValue().equals("Assistant Approved")) {
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getBasicProperty().getUpicNo());
                if (propertyMutation.getPartyValue().compareTo(propertyMutation.getDepartmentValue()) > 0) {
                    argsForTransferee.add(propertyMutation.getPartyValue().toString());
                } else {
                    argsForTransferee.add(propertyMutation.getDepartmentValue().toString());
                }
                argsForTransferee.add(propertyMutation.getMutationFee() != null ? propertyMutation.getMutationFee().toString() : "N/A");
                smsMsgForTransferor = this.getText("msg.createtransferproperty.sms", argsForTransferor);
                smsMsgForTransferee = this.getText("msg.createtransferproperty.sms", argsForTransferee);
            } else if (mutationState.getValue().equals("Rejected")) {
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferor.add(this.transferOwnerService.getCityName());
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferee.add(this.transferOwnerService.getCityName());
                smsMsgForTransferor = this.getText("msg.rejecttransferproperty.sms", argsForTransferor);
                smsMsgForTransferee = this.getText("msg.rejecttransferproperty.sms", argsForTransferee);
            } else if (mutationState.getValue().equals("Commissioner Approved")) {
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getFullTranfereeName());
                argsForTransferor.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferor.add(this.transferOwnerService.getCityName());
                smsMsgForTransferor = this.getText("msg.approvetransferproperty.sms", argsForTransferor);
                argsForTransferee.add(propertyMutation.getFullTranferorName());
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferee.add(this.transferOwnerService.getCityName());
                smsMsgForTransferee = this.getText("msg.approvetransferproperty.sms", argsForTransferee);
            }
        }
        for (User transferor : propertyMutation.getTransferorInfos()) {
            if (!StringUtils.isNotBlank((String)transferor.getMobileNumber()) || !StringUtils.isNotBlank((String)smsMsgForTransferor)) continue;
            this.messagingService.sendSMS(transferor.getMobileNumber(), smsMsgForTransferor);
        }
        for (PropertyMutationTransferee transferee : propertyMutation.getTransfereeInfos()) {
            if (!StringUtils.isNotBlank((String)transferee.getTransferee().getMobileNumber()) || !StringUtils.isNotBlank((String)smsMsgForTransferee)) continue;
            this.messagingService.sendSMS(transferee.getTransferee().getMobileNumber(), smsMsgForTransferee);
        }
    }

    public void buildEmail(PropertyMutation propertyMutation) {
        String emailBodyTransferor = "";
        String emailBodyTransferee = "";
        String subject = "";
        ArrayList<String> argsForTransferor = new ArrayList<String>();
        ArrayList<String> argsForTransferee = new ArrayList<String>();
        if (null != propertyMutation && null != propertyMutation.getState()) {
            State mutationState = propertyMutation.getState();
            if (mutationState.getValue().equals("Assistant Approved")) {
                subject = this.getText("subject.createtransferproperty", new String[]{propertyMutation.getBasicProperty().getUpicNo()});
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferor.add(this.transferOwnerService.getCityName());
                emailBodyTransferor = this.getText("body.createtransferproperty", argsForTransferor);
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferee.add(this.transferOwnerService.getCityName());
                if (propertyMutation.getPartyValue().compareTo(propertyMutation.getDepartmentValue()) > 0) {
                    argsForTransferee.add(propertyMutation.getPartyValue().toString());
                } else {
                    argsForTransferee.add(propertyMutation.getDepartmentValue().toString());
                }
                argsForTransferee.add(propertyMutation.getMutationFee() != null ? propertyMutation.getMutationFee().toString() : "N/A");
                emailBodyTransferee = this.getText("body.createtransferproperty", argsForTransferee);
            } else if (mutationState.getValue().equals("Rejected")) {
                subject = this.getText("subject.rejecttransferproperty");
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferor.add(this.transferOwnerService.getCityName());
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferee.add(this.transferOwnerService.getCityName());
                emailBodyTransferor = this.getText("body.rejecttransferproperty", argsForTransferor);
                emailBodyTransferee = this.getText("body.rejecttransferproperty", argsForTransferee);
            } else if (mutationState.getValue().equals("Commissioner Approved")) {
                subject = this.getText("subject.approvetransferproperty");
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getFullTranferorName());
                argsForTransferor.add(propertyMutation.getFullTranfereeName());
                argsForTransferor.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferor.add(this.transferOwnerService.getUserDesigantion().getName());
                argsForTransferor.add(this.transferOwnerService.getCityName());
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getFullTranferorName());
                argsForTransferee.add(propertyMutation.getFullTranfereeName());
                argsForTransferee.add(propertyMutation.getBasicProperty().getUpicNo());
                argsForTransferee.add(this.transferOwnerService.getUserDesigantion().getName());
                argsForTransferee.add(this.transferOwnerService.getCityName());
                emailBodyTransferor = this.getText("body.approvetransferproperty", argsForTransferor);
                emailBodyTransferee = this.getText("body.approvetransferproperty", argsForTransferee);
            }
        }
        for (User transferor : propertyMutation.getTransferorInfos()) {
            if (!StringUtils.isNotBlank((String)transferor.getEmailId()) || !StringUtils.isNotBlank((String)subject) || !StringUtils.isNotBlank((String)emailBodyTransferor)) continue;
            this.messagingService.sendEmail(transferor.getEmailId(), subject, emailBodyTransferor);
        }
        for (PropertyMutationTransferee transferee : propertyMutation.getTransfereeInfos()) {
            if (!StringUtils.isNotBlank((String)transferee.getTransferee().getEmailId()) || !StringUtils.isNotBlank((String)subject) || !StringUtils.isNotBlank((String)emailBodyTransferee)) continue;
            this.messagingService.sendEmail(transferee.getTransferee().getEmailId(), subject, emailBodyTransferee);
        }
    }

    private String getNatureOfTask() {
        String nature = "REGISTERED TRANSFER".equals(this.getAdditionalRule()) ? "Registered Transfer" : ("FULL TRANSFER".equals(this.getAdditionalRule()) ? "Full Transfer" : ("PARTIAL TRANSFER".equals(this.getAdditionalRule()) ? "Partial Transfer" : "PropertyMutation"));
        return nature;
    }

    public BigDecimal getCurrentPropertyTax() {
        return this.currentPropertyTax;
    }

    public BigDecimal getCurrentPropertyTaxFirstHalf() {
        return this.currentPropertyTaxFirstHalf;
    }

    public BigDecimal getCurrentPropertyTaxSecondHalf() {
        return this.currentPropertyTaxSecondHalf;
    }

    public BigDecimal getCurrentPropertyTaxDue() {
        return this.currentPropertyTaxDue;
    }

    public BigDecimal getCurrentWaterTaxDue() {
        return this.currentWaterTaxDue;
    }

    public StateAware getModel() {
        return this.propertyMutation;
    }

    public String getWfErrorMsg() {
        return this.wfErrorMsg;
    }

    public String getAssessmentNo() {
        return this.assessmentNo;
    }

    public void setAssessmentNo(String assessmentNo) {
        this.assessmentNo = assessmentNo;
    }

    public BasicProperty getBasicproperty() {
        return this.basicproperty;
    }

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public Long getMutationId() {
        return this.mutationId;
    }

    public void setMutationId(Long mutationId) {
        this.mutationId = mutationId;
    }

    public BigDecimal getArrearPropertyTaxDue() {
        return this.arrearPropertyTaxDue;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setTransfereeId(Long transfereeId) {
        this.transfereeId = transfereeId;
    }

    public void setMarketValue(double marketValue) {
        this.marketValue = marketValue;
    }

    public void setTransferReason(String transferReason) {
        this.transferReason = transferReason;
    }

    public String getCollectXML() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.collectXML, "utf-8");
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMutationInitiatedBy() {
        return this.mutationInitiatedBy;
    }

    public void setMutationInitiatedBy(String mutationInitiatedBy) {
        this.mutationInitiatedBy = mutationInitiatedBy;
    }

    public String getAssessmentNoMessage() {
        return this.assessmentNoMessage;
    }

    public void setAssessmentNoMessage(String assessmentNoMessage) {
        this.assessmentNoMessage = assessmentNoMessage;
    }

    public String getTaxDueErrorMsg() {
        return this.taxDueErrorMsg;
    }

    public void setTaxDueErrorMsg(String taxDueErrorMsg) {
        this.taxDueErrorMsg = taxDueErrorMsg;
    }

    public Map<String, String> getGuardianRelationMap() {
        return this.guardianRelationMap;
    }

    public void setGuardianRelationMap(Map<String, String> guardianRelationMap) {
        this.guardianRelationMap = guardianRelationMap;
    }

    public Boolean getPropertyByEmployee() {
        return this.propertyByEmployee;
    }

    public void setPropertyByEmployee(Boolean propertyByEmployee) {
        this.propertyByEmployee = propertyByEmployee;
    }

    public String getUserDesignationList() {
        return this.userDesignationList;
    }

    public void setUserDesignationList(String userDesignationList) {
        this.userDesignationList = userDesignationList;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public String getMeesevaServiceCode() {
        return this.meesevaServiceCode;
    }

    public void setMeesevaServiceCode(String meesevaServiceCode) {
        this.meesevaServiceCode = meesevaServiceCode;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getFileStoreIds() {
        return this.fileStoreIds;
    }

    public void setFileStoreIds(String fileStoreIds) {
        this.fileStoreIds = fileStoreIds;
    }

    public String getUlbCode() {
        return this.ulbCode;
    }

    public void setUlbCode(String ulbCode) {
        this.ulbCode = ulbCode;
    }

    public List<Hashtable<String, Object>> getHistoryMap() {
        return this.historyMap;
    }

    public void setHistoryMap(List<Hashtable<String, Object>> historyMap) {
        this.historyMap = historyMap;
    }

    public boolean isEnableApproverDetails() {
        return this.enableApproverDetails;
    }

    public void setEnableApproverDetails(boolean enableApproverDetails) {
        this.enableApproverDetails = enableApproverDetails;
    }

    public boolean isDigitalSignEnabled() {
        return this.digitalSignEnabled;
    }

    public void setDigitalSignEnabled(boolean digitalSignEnabled) {
        this.digitalSignEnabled = digitalSignEnabled;
    }

    public String getAdditionalRule() {
        return this.propertyMutation.getType();
    }

    public boolean isMutationFeePaid() {
        return this.mutationFeePaid;
    }

    public void setMutationFeePaid(boolean mutationFeePaid) {
        this.mutationFeePaid = mutationFeePaid;
    }

    public boolean getReceiptCanceled() {
        return this.receiptCanceled;
    }

    public void setReceiptCanceled(boolean receiptCanceled) {
        this.receiptCanceled = receiptCanceled;
    }
}

