/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.bills;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgBill;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.bean.ReportInfo;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.bill.BillService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.service.DemandBill.DemandBillService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"bill"}, location="billGeneration-bill.jsp"), @Result(name={"billsGenStatus"}, location="billGeneration-billsGenStatus.jsp"), @Result(name={"ack"}, location="billGeneration-ack.jsp"), @Result(name={"commonForm"}, location="searchProperty-commonForm.jsp")})
public class BillGenerationAction
extends PropertyTaxBaseAction {
    private static final long serialVersionUID = -6600897692089941070L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    protected static final String COMMON_FORM = "commonForm";
    public static final String BILL = "bill";
    public static final String STATUS_BILLGEN = "billsGenStatus";
    private static final String STATUS_BILLGEN_BY_PARTNO = "statusByPartNo";
    public static final String ACK = "ack";
    private ReportService reportService;
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private PersistenceService<Property, Long> propertyImplService;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private PTBillServiceImpl ptBillServiceImpl;
    private PropertyService propService;
    private BillService billService;
    private String indexNumber;
    private String ackMessage;
    private String reportId;
    private String billNo;
    private BasicProperty basicProperty;
    private PropertyImpl property;
    private Map<String, Map<String, BigDecimal>> reasonwiseDues;
    private List<ReportInfo> reportInfos = new ArrayList();
    InputStream billPDF;
    private String wardNum;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentDao installmentDAO;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public StateAware getModel() {
        return null;
    }

    @Action(value="/bills/billGeneration-generateBill")
    public String generateBill() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into generateBill, Index Number :" + this.indexNumber));
        }
        try {
            if (this.basicPropertyDAO != null) {
                this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.indexNumber);
            }
            if (this.basicProperty.getProperty().getIsExemptedFromTax().booleanValue()) {
                this.addActionError(this.getText("error.msg.taxExempted"));
                return COMMON_FORM;
            }
            this.property = (PropertyImpl)this.basicProperty.getProperty();
            EgBill egBill = (EgBill)this.persistenceService.find("FROM EgBill WHERE module = ? AND egBillType.code = ? AND consumerId = ? AND is_history = 'N'", new Object[]{this.moduleDao.getModuleByName("Property Tax"), "MANUAL", this.basicProperty.getUpicNo()});
            ReportOutput reportOutput = null;
            if (egBill == null) {
                reportOutput = this.getBillService().generateBill(this.basicProperty, Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
            } else {
                String query = "SELECT notice FROM EgBill bill, PtNotice notice left join notice.basicProperty bp WHERE bill.is_History = 'N' AND bill.egBillType.code = ? AND bill.billNo = notice.noticeNo AND notice.noticeType = ? AND bp = ?";
                PtNotice ptNotice = (PtNotice)this.persistenceService.find("SELECT notice FROM EgBill bill, PtNotice notice left join notice.basicProperty bp WHERE bill.is_History = 'N' AND bill.egBillType.code = ? AND bill.billNo = notice.noticeNo AND notice.noticeType = ? AND bp = ?", new Object[]{"MANUAL", "Bill", this.basicProperty});
                reportOutput = new ReportOutput();
                if (ptNotice != null && ptNotice.getFileStore() != null) {
                    FileStoreMapper fsm = ptNotice.getFileStore();
                    File file = this.fileStoreService.fetch(fsm, "PTIS");
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    reportOutput.setReportOutputData(bFile);
                    reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
                }
            }
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("generateBill: ReportId: " + this.reportId));
                this.LOGGER.debug((Object)"Exit from generateBill");
            }
            if (this.property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE)) {
                this.property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
                this.propertyImplService.persist((Object)this.property);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Bill Generation Exception : " + e);
        }
        return BILL;
    }

    @Action(value="/bills/billGeneration-generateDemandBill")
    public String generateDemandBill() {
        String clientSpecificDmdBill = this.propertyTaxCommonUtils.getAppConfigValue("IS_CLIENT_SPECIFIC_DEMANDBILL", "Property Tax");
        if ("Y".equalsIgnoreCase(clientSpecificDmdBill)) {
            DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean("demandBillService");
            ReportOutput reportOutput = demandBillService.generateDemandBill(this.indexNumber);
            this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        } else {
            this.generateBill();
        }
        return BILL;
    }

    @Action(value="/bills/billGeneration-billsGenStatus")
    public String billsGenStatus() {
        Integer totalProps = 0;
        Integer totalBillsGen = 0;
        Installment currInst = this.installmentDAO.getInsatllmentByModuleForGivenDate(this.ptBillServiceImpl.getModule(), new Date());
        StringBuilder propQueryString = new StringBuilder();
        propQueryString.append("select bndry.boundaryNum,bndry.name, count(bndry.boundaryNum) ").append("from Boundary bndry, PropertyID pid left join pid.basicProperty bp where bp.upicNo is not null and bp.active = true and ").append("bp.source = 'M' and pid.ward.id = bndry.id ").append("and bp.id not in (select basicProperty from PropertyStatusValues group by basicProperty having count(basicProperty) > 0 ) ").append(" and bp.id in (select basicProperty from PropertyImpl where status = 'A' and isExemptedFromTax = false ) ").append("group by bndry.name, bndry.boundaryNum ").append("order by bndry.boundaryNum, bndry.name");
        Query billQuery = this.getPersistenceService().getSession().getNamedQuery("demandBillstatus");
        billQuery.setDate("FromDate", currInst.getFromDate());
        billQuery.setDate("ToDate", currInst.getToDate());
        List billList = billQuery.list();
        this.LOGGER.info((Object)("billList : " + billList));
        Query propQuery = this.getPersistenceService().getSession().createQuery(propQueryString.toString());
        List propList = propQuery.list();
        this.LOGGER.info((Object)("propList : " + propList));
        for (Object props : propList) {
            ReportInfo reportInfo = new ReportInfo();
            Object[] propObj = (Object[])props;
            reportInfo.setWardNo(String.valueOf(propObj[0]) + '-' + String.valueOf(propObj[1]));
            reportInfo.setTotalNoProps(Integer.valueOf(((Long)propObj[2]).toString()));
            reportInfo.setTotalGenBills(Integer.valueOf(0));
            String propWardNo = String.valueOf(propObj[0]);
            for (Object bills : billList) {
                Object[] billObj = (Object[])bills;
                String wardNo = String.valueOf(billObj[0]);
                if (!propWardNo.equals(wardNo)) continue;
                reportInfo.setTotalGenBills(Integer.valueOf(((Long)billObj[1]).toString()));
                break;
            }
            totalProps = totalProps + reportInfo.getTotalNoProps();
            totalBillsGen = totalBillsGen + reportInfo.getTotalGenBills();
            this.getReportInfos().add(reportInfo);
        }
        ReportInfo reportInfoCount = new ReportInfo();
        reportInfoCount.setWardNo("Total :");
        reportInfoCount.setTotalNoProps(totalProps);
        reportInfoCount.setTotalGenBills(totalBillsGen);
        this.getReportInfos().add(reportInfoCount);
        return STATUS_BILLGEN;
    }

    @Action(value="/bills/billGeneration-billGenStatusByPartNo")
    public String billGenStatusByPartNo() {
        this.LOGGER.debug((Object)("Entered into billGenStatusByPartNo, wardNum=" + this.wardNum));
        Integer totalProps = 0;
        Integer totalBillsGen = 0;
        Installment currInst = this.propertyTaxCommonUtils.getCurrentInstallment();
        StringBuilder billQueryString = new StringBuilder();
        StringBuilder propQueryString = new StringBuilder();
        billQueryString.append("select bp.partNo, count(bp.partNo) ").append("from EgBill bill, Boundary bndry, PtNotice notice left join notice.basicProperty bp ").append("where bp.propertyID.ward.id=bndry.id ").append("and bndry.boundaryNum = :bndryNum ").append("and bill.is_History = 'N' ").append("and :FromDate <= bill.issueDate ").append("and :ToDate >= bill.issueDate ").append("and bill.egBillType.code = :BillType ").append("and bill.billNo = notice.noticeNo ").append("and notice.noticeType = 'Bill' ").append("and notice.fileStore is not null ").append("group by bp.partNo ").append("order by bp.partNo");
        propQueryString.append("select bp.partNo, count(bp.partNo) ").append("from Boundary bndry, PropertyID pid left join pid.basicProperty bp ").append("where bp.active = true and pid.ward.id = bndry.id ").append("and bndry.boundaryNum = :bndryNum ").append("group by bp.partNo ").append("order by bp.partNo");
        Query billQuery = this.getPersistenceService().getSession().createQuery(billQueryString.toString());
        billQuery.setBigInteger("bndryNum", new BigInteger(this.wardNum));
        billQuery.setDate("FromDate", currInst.getFromDate());
        billQuery.setDate("ToDate", currInst.getToDate());
        billQuery.setString("BillType", "MANUAL");
        List billList = billQuery.list();
        Query propQuery = this.getPersistenceService().getSession().createQuery(propQueryString.toString());
        propQuery.setBigInteger("bndryNum", new BigInteger(this.wardNum));
        List propList = propQuery.list();
        for (Object props : propList) {
            ReportInfo reportInfo = new ReportInfo();
            Object[] propObj = (Object[])props;
            reportInfo.setPartNo(String.valueOf(propObj[0]));
            reportInfo.setTotalNoProps(Integer.valueOf(((Long)propObj[1]).toString()));
            reportInfo.setTotalGenBills(Integer.valueOf(0));
            for (Object bills : billList) {
                Object[] billObj = (Object[])bills;
                String partNo = String.valueOf(billObj[0]);
                if (!reportInfo.getPartNo().equals(partNo)) continue;
                reportInfo.setTotalGenBills(Integer.valueOf(((Long)billObj[1]).toString()));
                break;
            }
            totalProps = totalProps + reportInfo.getTotalNoProps();
            totalBillsGen = totalBillsGen + reportInfo.getTotalGenBills();
            this.getReportInfos().add(reportInfo);
        }
        ReportInfo reportInfoCount = new ReportInfo();
        reportInfoCount.setPartNo("Total :");
        reportInfoCount.setTotalNoProps(totalProps);
        reportInfoCount.setTotalGenBills(totalBillsGen);
        this.getReportInfos().add(reportInfoCount);
        this.LOGGER.debug((Object)"Exiting from billGenStatusByPartNo");
        return STATUS_BILLGEN_BY_PARTNO;
    }

    @Action(value="/bills/billGeneration-cancelBill")
    public String cancelBill() {
        EgBill egBill = (EgBill)this.persistenceService.find("FROM EgBill WHERE module = ? AND egBillType.code = ? AND SUBSTRING(consumerId, 1, (LOCATE('(', consumerId)-1)) = ? AND is_history = 'N'", new Object[]{this.moduleDao.getModuleByName("Property Tax"), "MANUAL", this.indexNumber});
        if (egBill == null) {
            this.setAckMessage("There is no active Bill exist for index no : " + this.indexNumber);
            return ACK;
        }
        egBill.setIs_History("Y");
        egBill.setIs_Cancelled("Y");
        egBill.setModifiedDate(new Date());
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.indexNumber);
        basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_NOTCREATED);
        basicProperty.setBillCrtError(PropertyTaxConstants.STRING_EMPTY);
        this.basicPropertyService.update((Object)basicProperty);
        this.setAckMessage("Bill successfully cancelled for index no : " + this.indexNumber);
        return ACK;
    }

    public String getReportId() {
        return this.reportId;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public void setIndexNumber(String indexNumber) {
        this.indexNumber = indexNumber;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public PropertyTaxNumberGenerator getPropertyTaxNumberGenerator() {
        return this.propertyTaxNumberGenerator;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public Map<String, Map<String, BigDecimal>> getReasonwiseDues() {
        return this.reasonwiseDues;
    }

    public void setReasonwiseDues(Map<String, Map<String, BigDecimal>> reasonwiseDues) {
        this.reasonwiseDues = reasonwiseDues;
    }

    public PersistenceService<BasicProperty, Long> getBasicPropertyService() {
        return this.basicPropertyService;
    }

    public void setPropertyImplService(PersistenceService<Property, Long> propertyImplService) {
        this.propertyImplService = propertyImplService;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public void setPropertyWorkflowService(WorkflowService<PropertyImpl> propertyWorkflowService) {
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public BillService getBillService() {
        return this.billService;
    }

    public void setBillService(BillService billService) {
        this.billService = billService;
    }

    public List<ReportInfo> getReportInfos() {
        return this.reportInfos;
    }

    public void setReportInfos(List<ReportInfo> reportInfos) {
        this.reportInfos = reportInfos;
    }

    public String getWardNum() {
        return this.wardNum;
    }

    public void setWardNum(String wardNum) {
        this.wardNum = wardNum;
    }

    public PTBillServiceImpl getPtBillServiceImpl() {
        return this.ptBillServiceImpl;
    }

    public void setPtBillServiceImpl(PTBillServiceImpl ptBillServiceImpl) {
        this.ptBillServiceImpl = ptBillServiceImpl;
    }
}

