/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.digitalSignature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/digitalSignature"})
public class DigitalSignatureReportController {
    private static final String DIGITAL_SIGNATURE_REPORT_FORM = "digitalSignatureReport-form";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @RequestMapping(value={"/digitalSignatureReport-form"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        List resultList = this.getRecordsForDigitalSignature();
        model.addAttribute("digitalSignatureReportList", (Object)resultList);
        model.addAttribute("noticeType", (Object)"Special Notice");
        return DIGITAL_SIGNATURE_REPORT_FORM;
    }

    public List<HashMap<String, Object>> getRecordsForDigitalSignature() {
        ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        List stateAwareList = this.fetchItems();
        if (null != stateAwareList && !stateAwareList.isEmpty()) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            WorkflowTypes workflowTypes = null;
            List workflowTypesList = new ArrayList();
            for (StateAware record : stateAwareList) {
                if (record == null || record.getState() == null || record.getState().getNextAction() == null || !record.getState().getNextAction().equalsIgnoreCase("Digital Signature Pending")) continue;
                tempMap = new HashMap();
                workflowTypesList = this.getCurrentSession().getNamedQuery("WF_TYPE_BY_TYPE_AND_RENDER_Y").setString(0, record.getStateType()).list();
                workflowTypes = workflowTypesList != null && !workflowTypesList.isEmpty() ? (WorkflowTypes)workflowTypesList.get(0) : null;
                if (!"Property Tax".equalsIgnoreCase(workflowTypes.getModule().getName())) continue;
                if (record.getState().getValue().startsWith("Create") || record.getState().getValue().startsWith("Alter") || record.getState().getValue().startsWith("Bifurcate") || record.getState().getValue().startsWith("Demolition")) {
                    tempMap.put("objectId", ((PropertyImpl)record).getBasicProperty().getId());
                } else {
                    tempMap.put("objectId", record.getId());
                }
                tempMap.put("type", record.getState().getNatureOfTask());
                tempMap.put("module", workflowTypes != null ? workflowTypes.getModule().getDisplayName() : null);
                tempMap.put("details", record.getStateDetails());
                tempMap.put("status", record.getCurrentState().getValue());
                resultList.add(tempMap);
            }
        }
        return resultList;
    }

    public List<StateAware> fetchItems() {
        ArrayList<StateAware> digitalSignWFItems = new ArrayList<StateAware>();
        digitalSignWFItems.addAll(this.inboxRenderServiceDeligate.getInboxItems(this.securityUtils.getCurrentUser().getId()));
        return digitalSignWFItems;
    }
}

